/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.OLAP;

import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.xmla.XMLA_Cell;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.jpivot.xmla.XMLA_Result;
import com.tonbeller.jpivot.xmla.XMLA_SOAP;
import java.util.List;
import quadbase.common.util.IOLAPResultSet;
import quadbase.common.util.internal.DataType;

public class XMLAResultSet
implements IOLAPResultSet {
    private XMLA_Result result;
    private List cells;

    public XMLAResultSet(String uri, String datasource, String catalog, String MDXQuery) throws OlapException {
        XMLA_Model model = new XMLA_Model();
        model.setCatalog(catalog);
        model.setUri(uri);
        model.setDataSource(datasource);
        model.setMdxQuery(MDXQuery);
        model.initialize();
        XMLA_SOAP soap = new XMLA_SOAP(uri, "", "");
        this.result = new XMLA_Result(model, soap, catalog, MDXQuery);
        if (this.result.getAxes().length < 2) {
            throw new IllegalArgumentException("The query has to have columns as well as rows!");
        }
        this.cells = this.result.getCells();
    }

    @Override
    public int getColumnCount() {
        return this.getAxisMemberCount(0);
    }

    @Override
    public int getColumnBreakCount() {
        return this.getAxisMemberLength(0);
    }

    @Override
    public Object[] getColumnLabel(int index) {
        return this.getAxisNames(0, index);
    }

    @Override
    public int getRowCount() {
        return this.getAxisMemberCount(1);
    }

    @Override
    public int getRowBreakCount() {
        return this.getAxisMemberLength(1);
    }

    @Override
    public Object[] getRowLabel(int index) {
        return this.getAxisNames(1, index);
    }

    @Override
    public Object getCell(int column, int row) {
        XMLA_Cell cell = (XMLA_Cell)this.cells.get(this.getColumnCount() * row + column);
        return cell.isNull() ? null : cell.getValue();
    }

    @Override
    public int getColumnLabelDataType() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            Object[] tmp = this.getColumnLabel(i);
            for (int j = 0; j < tmp.length; ++j) {
                if (tmp[j] == null) continue;
                return DataType.findType(tmp[j]);
            }
        }
        return 12;
    }

    @Override
    public int getRowLabelDataType() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Object[] tmp = this.getRowLabel(i);
            for (int j = 0; j < tmp.length; ++j) {
                if (tmp[j] == null) continue;
                return DataType.findType(tmp[j]);
            }
        }
        return 12;
    }

    @Override
    public int getCellDataType() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            for (int j = 0; j < this.getRowCount(); ++j) {
                Object tmp = this.getCell(i, j);
                if (tmp == null) continue;
                return DataType.findType(tmp);
            }
        }
        return 8;
    }

    @Override
    public String[] getRowBreakColumnHeader() {
        return null;
    }

    private int getAxisMemberCount(int index) {
        return this.result.getAxes()[index].getPositions().size();
    }

    private int getAxisMemberLength(int index) {
        Position pos = (Position)this.result.getAxes()[index].getPositions().get(0);
        return pos.getMembers().length;
    }

    private Object[] getAxisNames(int axis, int index) {
        Position pos = (Position)this.result.getAxes()[axis].getPositions().get(index);
        XMLA_Member[] members = (XMLA_Member[])pos.getMembers();
        Object[] names = new Object[members.length];
        for (int i = 0; i < members.length; ++i) {
            String tmp;
            int idx;
            names[i] = members[i].getUniqueName();
            if (names[i] == null || !(names[i] instanceof String) || (idx = (tmp = (String)names[i]).lastIndexOf(".[")) <= 0 || tmp.charAt(tmp.length() - 1) != ']') continue;
            tmp = tmp.substring(idx + 2);
            tmp = tmp.substring(0, tmp.length() - 1);
            names[i] = tmp;
        }
        return names;
    }
}

