/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.awt;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import quadbase.awt.SpinBox;
import quadbase.common.awt.QbCalendar;
import quadbase.common.util.internal.LanguageEncoder;

public class CalendarDialog
extends Dialog
implements ActionListener {
    QbCalendar calendar;
    TimePanel timePanel;
    private int sqlType;
    private Button okButton;
    private Button cancelButton;
    private boolean isCancel = true;

    public CalendarDialog(Frame frame, int sqlType) {
        super(frame, LanguageEncoder.getText("Calendar"), true);
        this.sqlType = sqlType;
        this.init();
    }

    public CalendarDialog(Dialog dialog, int sqlType) {
        super(dialog, LanguageEncoder.getText("Calendar"), true);
        this.sqlType = sqlType;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        if (this.sqlType == 91) {
            this.calendar = new QbCalendar();
            this.add("Center", this.calendar);
        } else if (this.sqlType == 92) {
            this.timePanel = new TimePanel();
            this.add("Center", this.timePanel);
        } else if (this.sqlType == 93) {
            this.calendar = new QbCalendar();
            this.add("North", this.calendar);
            this.timePanel = new TimePanel();
            this.add("Center", this.timePanel);
        }
        Panel butPanel = new Panel();
        butPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.okButton = new Button("Ok");
        butPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        butPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.add("South", butPanel);
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        int width = this.getSize().width;
        int height = this.getSize().height;
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width, height);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CalendarDialog.this.setVisible(false);
                CalendarDialog.this.dispose();
            }
        });
    }

    public void setTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (this.calendar != null) {
            this.calendar.setCalendar(cal);
        }
        if (this.timePanel != null) {
            this.timePanel.setValues(cal);
        }
    }

    public Date getTime() {
        Calendar cal = this.calendar != null ? this.calendar.getCalendar() : Calendar.getInstance();
        if (this.timePanel != null) {
            cal.set(11, this.timePanel.getHour());
            cal.set(12, this.timePanel.getMinute());
            cal.set(13, this.timePanel.getSecond());
            cal.set(14, this.timePanel.getMilliSecond());
        }
        if (this.sqlType == 91) {
            return new java.sql.Date(cal.getTime().getTime());
        }
        if (this.sqlType == 92) {
            return new Time(cal.getTime().getTime());
        }
        if (this.sqlType == 93) {
            return new Timestamp(cal.getTime().getTime());
        }
        return null;
    }

    public boolean isCancelled() {
        return this.isCancel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.isCancel = false;
        }
        this.setVisible(false);
        this.dispose();
    }

    public class TimePanel
    extends Panel {
        SpinBox hour;
        SpinBox min;
        SpinBox sec;
        SpinBox msec;

        public TimePanel() {
            this.setLayout(new GridLayout(1, 8, 5, 5));
            this.hour = new SpinBox(0, 23, 1, 2);
            this.hour.setValue(0);
            this.add(this.hour);
            this.add(new Label(LanguageEncoder.getText("HRS")));
            this.min = new SpinBox(0, 59, 1, 2);
            this.min.setValue(0);
            this.add(this.min);
            this.add(new Label(LanguageEncoder.getText("MINS")));
            this.sec = new SpinBox(0, 59, 1, 2);
            this.sec.setValue(0);
            this.add(this.sec);
            this.add(new Label(LanguageEncoder.getText("SECS")));
            this.msec = new SpinBox(0, 59, 1, 2);
            this.msec.setValue(0);
            this.add(this.msec);
            this.add(new Label(LanguageEncoder.getText("MSECS")));
        }

        public int getHour() {
            return this.hour.getValue();
        }

        public int getMinute() {
            return this.min.getValue();
        }

        public int getSecond() {
            return this.sec.getValue();
        }

        public int getMilliSecond() {
            return this.msec.getValue();
        }

        public void setValues(Calendar cal) {
            this.hour.setValue(cal.get(11));
            this.min.setValue(cal.get(12));
            this.sec.setValue(cal.get(13));
            this.msec.setValue(cal.get(14));
        }

        @Override
        public void setEnabled(boolean b) {
            this.hour.setEnabled(b);
            this.min.setEnabled(b);
            this.sec.setEnabled(b);
            this.msec.setEnabled(b);
        }
    }
}

