/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.awt;

import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import quadbase.common.awt.QbDialog;
import quadbase.common.awt.TextParagraph;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;

public class MessageDialog
extends QbDialog {
    TextParagraph ta;
    private boolean useOnce = false;
    private String lastActionCommand = "";

    public MessageDialog(Frame f, String title, boolean modal, boolean once, String button) {
        super(f, title, modal);
        if (button == null) {
            this.init("OK");
        } else {
            this.init(button);
        }
        this.useOnce = once;
    }

    public MessageDialog(Frame f, String title, boolean modal) {
        this(f, title, modal, false, null);
    }

    public MessageDialog(Frame f, boolean once) {
        this(f, "", true, once, null);
    }

    public MessageDialog(Frame f) {
        this(f, "", true, false, null);
    }

    public MessageDialog(Frame f, String title) {
        this(f, title, true, false, null);
    }

    public MessageDialog(Frame f, String title, String button) {
        this(f, title, true, true, button);
    }

    public static void showError(Frame f, boolean modal, String msg) {
        new MessageDialog(f, LanguageEncoder.getText("Error"), modal, true, null).show(msg);
    }

    protected void init(String str) {
        this.setBackground(Color.lightGray);
        this.setFont(new Font("dummy", 0, 14));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.ta = new TextParagraph(8, 40);
        this.ta.setEditable(false);
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout(2));
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String label = st.nextToken();
            Button but = new Button(label);
            buttonPanel.add(but);
            but.addActionListener(this);
            but.setActionCommand(label);
        }
        gbl = new GridBagLayout();
        this.setLayout(gbl);
        QbUtil.add(this, this.ta, gbl, gbc, 0, 0, 1, 1);
        QbUtil.add(this, buttonPanel, gbl, gbc, 0, 1, 1, 1);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
    }

    public TextArea getTextArea() {
        return this.ta;
    }

    public void show(String s) {
        this.ta.setText(s);
        this.setVisible(true);
    }

    public void show(String s, Frame f) {
        this.ta.setText(s);
        this.display(f);
    }

    public void onClose() {
        if (this.useOnce) {
            this.dispose();
        } else {
            this.setVisible(false);
        }
    }

    public String getLastActionCommand() {
        return this.lastActionCommand;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.onClose();
        this.lastActionCommand = e.getActionCommand();
        this.fireEvent(this, 0, e.getActionCommand());
    }
}

