/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class QbDialog
extends Dialog
implements WindowListener,
ActionListener,
ItemListener {
    protected Frame frame;
    private transient ActionListener listener;

    public QbDialog(Frame f, String title, boolean modal) {
        super(f, title, modal);
        this.frame = f;
        this.setSize(280, 200);
        this.addWindowListener(this);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.getParent() != null) {
            this.getParent().setEnabled(true);
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    public static final Frame findFrame(Component c) {
        while (c != null) {
            if (c instanceof Frame) {
                return (Frame)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public void display(Frame f) {
        Dimension d;
        Point p;
        if (this.isShowing()) {
            return;
        }
        Dimension s = this.getToolkit().getScreenSize();
        if (f != null && !f.getClass().getName().equals("netscape.applet.EmbeddedAppletFrame") && !f.getClass().getName().equals("com.ms.applet.BrowserAppletFrame")) {
            p = f.getLocation();
            d = f.getSize();
        } else {
            p = new Point(0, 0);
            d = s;
        }
        int w = this.getSize().width;
        int h = this.getSize().height;
        int rx = p.x + (d.width - w) / 2;
        int ry = p.y + (d.height - h) / 2;
        if (rx > s.width - w / 2 || ry > s.height - h / 2) {
            rx = (s.width - w) / 2;
            ry = (s.height - h) / 2;
        }
        this.setLocation(Math.max(0, rx), Math.max(0, ry));
        super.setVisible(true);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.add(this.listener, l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected final void fireEvent(Component c, int id) {
        this.fireEvent(c, id, "");
    }

    protected final void fireEvent(Component c, int id, String cmd) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(c, id, cmd));
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.display(this.frame);
        } else {
            super.setVisible(false);
        }
    }
}

