/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.client;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Vector;
import quadbase.common.client.ReadDatabase;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.parser.ConditionNode;
import quadbase.common.paramquery.parser.GenericParser;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IJNDIDatabaseInfo;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;

public class ReadDBdistinct {
    public static final String IS_NULL = "IS NULL";

    public static Vector getDistinct(IDatabaseInfo dbInfo, String tableName, String columnName) throws Exception {
        return ReadDBdistinct.getDistinct(dbInfo, tableName, columnName, -1);
    }

    public static Vector getDistinct(IDatabaseInfo dbInfo, String tableName, String columnName, int order) throws Exception {
        dbInfo = ReadDBdistinct.modifyQuery(dbInfo, order, tableName, columnName);
        IConnection socket = ServerMessage.createConnection();
        ReadDBdistinct.sendMessage(socket, dbInfo, tableName, columnName);
        return ReadDBdistinct.receiveReply(socket);
    }

    public static Vector getDistinct(IJNDIDatabaseInfo dbInfo, String tableName, String columnName) throws Exception {
        return ReadDBdistinct.getDistinct(dbInfo, tableName, columnName, -1);
    }

    public static Vector getDistinct(IJNDIDatabaseInfo dbInfo, String tableName, String columnName, int order) throws Exception {
        dbInfo = ReadDBdistinct.modifyQuery(dbInfo, order, tableName, columnName);
        IConnection socket = ServerMessage.createConnection();
        ReadDBdistinct.sendMessage(socket, dbInfo, tableName, columnName);
        return ReadDBdistinct.receiveReply(socket);
    }

    public static Vector executeSqlSelect(IDatabaseInfo dbInfo, String query, int useDefaultValue) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadDBdistinct.sendMessage(socket, dbInfo, query, useDefaultValue);
        return ReadDBdistinct.receiveReply_sqlSelect(socket, useDefaultValue);
    }

    public static Vector executeSqlSelect(IJNDIDatabaseInfo dbInfo, String query) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadDBdistinct.sendMessage(socket, dbInfo, query);
        return ReadDBdistinct.receiveReply_sqlSelect(socket);
    }

    public static String testSqlSelect(IDatabaseInfo dbInfo, String query, boolean isDefaultSQL) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadDBdistinct.sendMessage(socket, dbInfo, query, isDefaultSQL);
        return ReadDBdistinct.receiveReply_testSql(socket);
    }

    private static void sendMessage(IConnection socket, IDatabaseInfo dbInfo, String query, boolean isDefaultSQL) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(16791);
        new DBInfoBasic(dbInfo).write(dout);
        IOUtil.writeLongString(dout, Coder.encode(query));
        dout.writeBoolean(isDefaultSQL);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static void sendMessage(IConnection socket, IDatabaseInfo dbInfo, String query, int defaultValue) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(16790);
        new DBInfoBasic(dbInfo).write(dout);
        IOUtil.writeLongString(dout, Coder.encode(query));
        dout.writeInt(defaultValue);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static void sendMessage(IConnection socket, IDatabaseInfo dbInfo, String tableName, String columnName) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(16789);
        new DBInfoBasic(dbInfo).write(dout);
        IOUtil.writeString(dout, Coder.encode(tableName));
        IOUtil.writeString(dout, Coder.encode(columnName));
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static void sendMessage(IConnection socket, IJNDIDatabaseInfo dbInfo, String query) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(16790);
        new DBInfoBasic(dbInfo).write(dout);
        IOUtil.writeLongString(dout, Coder.encode(query));
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static void sendMessage(IConnection socket, IJNDIDatabaseInfo dbInfo, String tableName, String columnName) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(16789);
        new DBInfoBasic(dbInfo).write(dout);
        IOUtil.writeString(dout, Coder.encode(tableName));
        IOUtil.writeString(dout, Coder.encode(columnName));
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static String receiveReply_testSql(IConnection socket) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new Exception(IOUtil.readString(dstream, true));
            }
            String status = IOUtil.readString(dstream, true);
            dstream.close();
            socket.close();
            return status;
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }

    private static Vector receiveReply(IConnection socket) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int sqlType = dstream.readInt();
            int nDistinctValue = dstream.readInt();
            dstream.readBoolean();
            Vector<Object> output = new Vector<Object>();
            for (int i = 0; i < nDistinctValue; ++i) {
                Object value = DataType.read(dstream, sqlType, ServerMessage.getVersion(), true);
                output.addElement(value);
            }
            dstream.close();
            socket.close();
            return output;
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }

    private static Vector receiveReply_sqlSelect(IConnection socket) throws Exception {
        return ReadDBdistinct.receiveReply_sqlSelect(socket, 0);
    }

    private static Vector receiveReply_sqlSelect(IConnection socket, int defaultValue) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int sqlType = dstream.readInt();
            int nDistinctValue = dstream.readInt();
            boolean b = dstream.readBoolean();
            Vector result = new Vector();
            Vector<Object> output = new Vector<Object>();
            Vector<Object> output2 = null;
            if (b) {
                output2 = new Vector<Object>();
                for (int i = 0; i < nDistinctValue; ++i) {
                    String valueString = IOUtil.readString(dstream, true);
                    output.addElement(valueString);
                    Object value = DataType.read(dstream, sqlType, ServerMessage.getVersion(), true);
                    output2.addElement(value);
                }
            } else {
                for (int i = 0; i < nDistinctValue; ++i) {
                    Object value = DataType.read(dstream, sqlType, ServerMessage.getVersion(), true);
                    output.addElement(value);
                }
            }
            if (defaultValue == 2) {
                output.addElement(sqlType);
            }
            result.addElement(output);
            if (output2 != null) {
                result.addElement(output2);
            }
            dstream.close();
            socket.close();
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }

    private static IDatabaseInfo modifyQuery(IDatabaseInfo dbInfo, int order, String tableName, String columnName) {
        if (dbInfo instanceof QueryFileInfo && order > 0) {
            String originalQuery = dbInfo.getQuery();
            originalQuery = QueryParser.removeComments(originalQuery);
            String tableAlias = null;
            String[] tablenames = QueryParser.getAllTableNames(originalQuery, false, true, false);
            String[] aliasnames = QueryParser.getAllTableNames(originalQuery, false, false, false);
            if (tablenames != null && aliasnames != null && tablenames.length == aliasnames.length) {
                for (int i = 0; i < tablenames.length; ++i) {
                    if (!tableName.equals(tablenames[i])) continue;
                    tableAlias = aliasnames[i];
                    break;
                }
            }
            Vector<QueryInParam> params = new Vector<QueryInParam>();
            QueryInParam[][] paramInSequence = ((QueryFileInfo)dbInfo).getInSet().getParameterInPromptSequence();
            for (int i = 0; i < order; ++i) {
                for (int j = 0; j < paramInSequence[i].length; ++j) {
                    if (paramInSequence[i][j] == null) continue;
                    params.add(paramInSequence[i][j]);
                }
            }
            Object[][] paramValue = new Object[params.size()][2];
            try {
                for (int i = 0; i < params.size(); ++i) {
                    paramValue[i][0] = ((QueryInParam)params.elementAt(i)).getParamName();
                    if (params.elementAt(i) instanceof IQueryMultiValueInParam) {
                        Vector<Object> vec = ((IQueryMultiValueInParam)params.elementAt(i)).getValues();
                        Vector<String> stringVec = new Vector<String>();
                        if (vec != null) {
                            for (int j = 0; j < vec.size(); ++j) {
                                Object value = vec.elementAt(j);
                                String valueString = IS_NULL;
                                if (value != null) {
                                    valueString = value.toString();
                                }
                                ReadDatabase readDB = new ReadDatabase(dbInfo.getURLString(), dbInfo.getDriverName(), dbInfo.getUserID(), dbInfo.getPassword());
                                String DBName = readDB.getProductName();
                                if (value instanceof String) {
                                    valueString = "'" + value + "'";
                                } else if (value instanceof Timestamp) {
                                    valueString = DBName.equalsIgnoreCase("ACCESS") ? "#" + value.toString().substring(0, 19) + "#" : "'" + value + "'";
                                } else if (value instanceof Date) {
                                    valueString = DBName.equalsIgnoreCase("ACCESS") ? "#" + value + "#" : "'" + value + "'";
                                }
                                stringVec.addElement(valueString);
                            }
                        } else {
                            stringVec.addElement(IS_NULL);
                        }
                        paramValue[i][1] = stringVec;
                        continue;
                    }
                    Object value = ((QueryInParam)params.elementAt(i)).getValue();
                    String valueString = IS_NULL;
                    if (value != null) {
                        valueString = value.toString();
                    }
                    if (order >= 1) {
                        QueryInParam qip = (QueryInParam)params.get(i);
                        if (((QueryFileInfo)dbInfo).getInSet().getParameterOrder(qip.getParamName()) == 0 && value != null && value.equals(qip.getAllOptionLabel())) {
                            paramValue[i][1] = null;
                            continue;
                        }
                    }
                    ReadDatabase readDB = new ReadDatabase(dbInfo.getURLString(), dbInfo.getDriverName(), dbInfo.getUserID(), dbInfo.getPassword());
                    String DBName = readDB.getProductName();
                    if (value instanceof String) {
                        valueString = "'" + value + "'";
                    } else if (value instanceof Timestamp) {
                        valueString = DBName.equalsIgnoreCase("ACCESS") ? "#" + value.toString().substring(0, 19) + "#" : "'" + value + "'";
                    } else if (value instanceof Date) {
                        valueString = DBName.equalsIgnoreCase("ACCESS") ? "#" + value + "#" : "'" + value + "'";
                    }
                    paramValue[i][1] = valueString;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String modifiedQuery = QueryParser.substituteParameters(originalQuery, paramValue);
            ConditionNode node = GenericParser.getConditionTree(modifiedQuery);
            if (node != null) {
                node = GenericParser.removeParameterConditions(node);
                if ((node = GenericParser.removeCondition(node, columnName)) != null) {
                    modifiedQuery = "Select Distinct " + (tableAlias == null ? columnName : tableAlias + "." + columnName) + " From " + GenericParser.getQueryPart(originalQuery, 2) + " Where " + node.toString();
                }
            }
            dbInfo = new DBInfoBasic(dbInfo);
            ((DBInfoBasic)dbInfo).setQuery(modifiedQuery);
        } else if (dbInfo instanceof QueryFileInfo && order <= 0) {
            String modifiedQuery = dbInfo.getQuery();
            modifiedQuery = QueryParser.removeComments(modifiedQuery);
            dbInfo = new DBInfoBasic(dbInfo);
            ((DBInfoBasic)dbInfo).setQuery(modifiedQuery);
        }
        return dbInfo;
    }

    private static IJNDIDatabaseInfo modifyQuery(IJNDIDatabaseInfo dbInfo, int order, String tableName, String columnName) {
        if (dbInfo instanceof QueryFileInfo && order > 0) {
            String originalQuery = dbInfo.getQuery();
            String tableAlias = null;
            String[] tablenames = QueryParser.getAllTableNames(originalQuery, false, true, false);
            String[] aliasnames = QueryParser.getAllTableNames(originalQuery, false, false, false);
            if (tablenames != null && aliasnames != null && tablenames.length == aliasnames.length) {
                for (int i = 0; i < tablenames.length; ++i) {
                    if (!tableName.equals(tablenames[i])) continue;
                    tableAlias = aliasnames[i];
                    break;
                }
            }
            Vector<QueryInParam> params = new Vector<QueryInParam>();
            QueryInParam[][] paramInSequence = ((QueryFileInfo)dbInfo).getInSet().getParameterInPromptSequence();
            for (int i = 0; i < order; ++i) {
                for (int j = 0; j < paramInSequence[i].length; ++j) {
                    if (paramInSequence[i][j] == null) continue;
                    params.add(paramInSequence[i][j]);
                }
            }
            Object[][] paramValue = new String[params.size()][2];
            for (int i = 0; i < params.size(); ++i) {
                paramValue[i][0] = ((QueryInParam)params.elementAt(i)).getParamName();
                Object value = ((QueryInParam)params.elementAt(i)).getValue();
                String valueString = IS_NULL;
                if (value != null) {
                    valueString = value.toString();
                }
                if (value instanceof String) {
                    valueString = "'" + value + "'";
                }
                paramValue[i][1] = valueString;
            }
            String modifiedQuery = QueryParser.substituteParameters(originalQuery, paramValue);
            ConditionNode node = GenericParser.getConditionTree(modifiedQuery);
            if (node != null) {
                node = GenericParser.removeParameterConditions(node);
                node = GenericParser.removeCondition(node, columnName);
                modifiedQuery = "Select Distinct " + (tableAlias == null ? columnName : tableAlias + "." + columnName) + " From " + GenericParser.getQueryPart(originalQuery, 2) + " Where " + node.toString();
            }
            dbInfo = new DBInfoBasic(dbInfo);
            ((DBInfoBasic)dbInfo).setQuery(modifiedQuery);
        }
        return dbInfo;
    }
}

