/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.client;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IJNDIDatabaseInfo;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;

public class ReadDBparamFunctionMeta {
    public static int getMeta(IDatabaseInfo dbInfo, String function, String tableNames) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadDBparamFunctionMeta.sendMessage(socket, dbInfo, function, tableNames);
        return ReadDBparamFunctionMeta.receiveReply(socket);
    }

    public static int getMeta(IJNDIDatabaseInfo dbInfo, String function, String tableNames) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadDBparamFunctionMeta.sendMessage(socket, dbInfo, function, tableNames);
        return ReadDBparamFunctionMeta.receiveReply(socket);
    }

    private static void sendMessage(IConnection socket, IDatabaseInfo dbInfo, String function, String tableNames) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(18658);
        new DBInfoBasic(dbInfo).write(dout);
        IOUtil.writeString(dout, Coder.encode(function));
        IOUtil.writeString(dout, Coder.encode(tableNames));
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static void sendMessage(IConnection socket, IJNDIDatabaseInfo dbInfo, String function, String tableNames) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(18658);
        new DBInfoBasic(dbInfo).write(dout);
        IOUtil.writeString(dout, Coder.encode(function));
        IOUtil.writeString(dout, Coder.encode(tableNames));
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static int receiveReply(IConnection socket) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int sqlType = dstream.readInt();
            dstream.close();
            socket.close();
            return sqlType;
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }
}

