/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.client;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.IOUtil;

public class ReadURL {
    public static String[] getFilename(String urlString, String[] validExtension) throws Exception {
        return ReadURL.getFilename(urlString, validExtension, "", true);
    }

    public static String[] getFilename(String urlString, String[] validExtension, String defaultDir, boolean isGoUpEnabled) throws Exception {
        return ReadURL.getFilename(urlString, validExtension, defaultDir, isGoUpEnabled, true);
    }

    public static String[] getFilename(String urlString, String[] validExtension, String defaultDir, boolean isGoUpEnabled, boolean includeDir) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadURL.sendMessage(socket, urlString, validExtension, defaultDir, isGoUpEnabled, false, includeDir);
        return (String[])ReadURL.receiveReply(socket, false)[0];
    }

    public static Object[] getFilenameAndTime(String urlString, String[] validExtension) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadURL.sendMessage(socket, urlString, validExtension, "", false, true, true);
        return ReadURL.receiveReply(socket, true);
    }

    private static void sendMessage(IConnection socket, String urlString, String[] validExtension, String defaultDir, boolean isGoUpEnabled, boolean includeTime, boolean includeDir) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(30158);
        IOUtil.writeString(dout, urlString);
        dout.writeBoolean(includeTime);
        dout.writeBoolean(includeDir);
        dout.writeBoolean(isGoUpEnabled);
        if (!isGoUpEnabled) {
            IOUtil.writeString(dout, defaultDir);
        }
        int nExtension = validExtension.length;
        dout.writeInt(nExtension);
        for (int i = 0; i < nExtension; ++i) {
            IOUtil.writeString(dout, validExtension[i]);
        }
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            throw ex;
        }
    }

    private static Object[] receiveReply(IConnection socket, boolean includeTime) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int nFile = dstream.readInt();
            String[] filenameList = new String[nFile];
            long[] lastModified = null;
            if (includeTime) {
                lastModified = new long[nFile];
            }
            for (int i = 0; i < nFile; ++i) {
                filenameList[i] = IOUtil.readString(dstream, true);
                if (!includeTime) continue;
                lastModified[i] = dstream.readLong();
            }
            dstream.close();
            socket.close();
            Object[] obj = new Object[]{filenameList, lastModified};
            return obj;
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(err.getMessage());
        }
    }
}

