/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.client;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.Vector;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import quadbase.common.network.HttpConnection;
import quadbase.common.network.HttpConnectionFactory;
import quadbase.common.network.IConnection;
import quadbase.common.network.IConnectionFactory;
import quadbase.common.network.ServletConnection;
import quadbase.common.network.ServletConnectionFactory;
import quadbase.common.network.SocketConnectionFactory;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.PatchReader;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.output.PageSize;
import quadbase.common.util.output.Rectangle;

public final class ServerMessage {
    public static final int CHART_VERSION = 6612;
    public static final int REPORT_VERSION = 7004;
    public static final int STYLE_VERSION = 1;
    public static final int COMMON_VERSION = 6602;
    public static final String PRODUCT_VERSION = "7.0";
    public static final int SCHEDULER_VERSION = 148;
    public static final String CHART_NAME = "EspressChart";
    public static final String REPORT_NAME = "EspressReport";
    public static final String UPDATE_VERSION = "13";
    public static final int SOURCE_BACKUP_DATA = 14;
    public static final int SOURCENONE = 0;
    public static final int SOURCEDB = 1;
    public static final int SOURCEFILE = 2;
    public static final int SOURCEMULTI = 3;
    public static final int SOURCEXML = 4;
    public static final int SOURCEXMLFILEQUERY = 7;
    public static final int SOURCEXMLDBQUERY = 8;
    public static final int SOURCEEJB = 5;
    public static final int SOURCECLASS = 6;
    public static final int SOURCESOAPOLD = 9;
    public static final int SOURCEOLAP = 10;
    public static final int SOURCESALESFORCE = 11;
    public static final int SOURCESOAP = 12;
    public static final int SOURCEEXCEL = 13;
    public static final byte CHT = 0;
    public static final byte BMP = 1;
    public static final byte GIF = 2;
    public static final byte JPEG = 4;
    public static final byte TPL = 5;
    public static final byte GIF_C = 6;
    public static final int CHARTVIEWER = 0;
    public static final int MINIVIEWER = 1;
    public static final int MICROVIEWER = 2;
    public static final int SUCCESS = 0;
    public static final int DBERROR = 1;
    public static final int OUTOFMEMORY = 2;
    public static final int IOERROR = 3;
    public static final int OUTOFUSER = 4;
    public static final int DENIED = 5;
    public static final int FAILURE = 6;
    public static final int EJBERROR = 7;
    public static final int HEARTBEAT = 8;
    public static final int UNKNOWN_ERROR = -1;
    public static final int UNKNOWN_EXCEPTION = -2;
    public static final int DEFAULT_FILES_SLAVE = 10004;
    public static final int EXPORTSLAVE = 1076;
    public static final int PAGEVIEWERHTMLSLAVE = 20088;
    public static final int LOADVIEWPAGESLAVE = 20880;
    public static final int LOADVIEWPAGEEXPORTSLAVE = 20881;
    public static final int CHARTEXPORTSLAVE = 22071;
    public static final int CREATE_CHART_SLAVE = 22111;
    public static final int SQLSLAVE = 24097;
    public static final int FILTER_PPSQLSLAVE = 27587;
    public static final int STREAM_SLAVE = 20876;
    public static final int STREAM_READONLY_SLAVE = 28931;
    public static final int PAGEVIEWER_STREAM_SLAVE = 20877;
    public static final int XMLCHART_SLAVE = 24578;
    public static final int XMLTEMPLATE_SLAVE = 27678;
    public static final int XMLREPORT_SLAVE = 25578;
    public static final int XMLREPORTDATA_SLAVE = 25993;
    public static final int XMLDATAPARSER_SLAVE = 24327;
    public static final int XMLGLOBALFORMAT_SLAVE = 25579;
    public static final int XMLFONTMAPPING_SLAVE = 25588;
    public static final int DATAFILE_SLAVE = 32415;
    public static final int EJBACCESS_SLAVE = 32416;
    public static final int EJBMETADATA_SLAVE = 32417;
    public static final int EJBHOMEMETHODACCESS_SLAVE = 32418;
    public static final int XMLVERIFY_SLAVE = 32419;
    public static final int XMLDATASHEET_SLAVE = 32420;
    public static final int FILTER_DATAFILE_SLAVE = 28816;
    public static final int IMGEXPORTSLAVE = 29203;
    public static final int CHTEXPORTSLAVE = 29302;
    public static final int DELETESLAVE = 25330;
    public static final int DELETETEMPFILESLAVE = 25331;
    public static final int USERLANGUAGESLAVE = 25332;
    public static final int GETOSNAMESLAVE = 25335;
    public static final int CLASSFILE_SLAVE = 25333;
    public static final int GET_SOAP_XML_SLAVE = 25502;
    public static final int PARSE_WSDL_SLAVE = 25503;
    public static final int RELEASEFILE_SLAVE = 26000;
    public static final int COPYFILE_SLAVE = 26001;
    public static final int WORKINGDIRECTORY_SLAVE = 26002;
    public static final int RELEASEFILEBYMACHINE_SLAVE = 26003;
    public static final int FILELOCK_SLAVE = 26004;
    public static final int CREATE_PAK_SLAVE = 27001;
    public static final int UNPAK_SLAVE = 27002;
    public static final int DESIGNERSLAVE = 30831;
    public static final int URL_SLAVE = 30158;
    public static final int FILEINFO_SLAVE = 29370;
    public static final int PAGEVIEWER_FILEINFO_SLAVE = 29371;
    public static final int FILEINFO_ROOT_SLAVE = 29399;
    public static final int SERVERDIRECTORY_SLAVE = 30500;
    public static final int DBDISTINCT_SLAVE = 16789;
    public static final int DBFIRSTVALUE_SLAVE = 15765;
    public static final int DBPARAMMETA_SLAVE = 18657;
    public static final int DBPARAMFUNCTIONMETA_SLAVE = 18658;
    public static final int DATAFILEMETA_SLAVE = 25367;
    public static final int DBQUERYMETA_SLAVE = 23612;
    public static final int DBPARAMTYPE_SLAVE = 25679;
    public static final int SQL_SELECT_SLAVE = 16790;
    public static final int PREPARE_SQL_SLAVE = 16791;
    public static final int RENAME_SLAVE = 23868;
    public static final int REPLACE_SLAVE = 23866;
    public static final int DATAREGISTRY_SLAVE = 23801;
    public static final int QBPRODUCTNAME_SLAVE = 28321;
    public static final int QBTABLELIST_SLAVE = 28771;
    public static final int QBNUMERICFUNC_SLAVE = 28762;
    public static final int QBSTRINGFUNC_SLAVE = 28356;
    public static final int QBTIMEDATEFUNC_SLAVE = 28963;
    public static final int QBSYSTEMFUNC_SLAVE = 28648;
    public static final int QBTABLEINFO_SLAVE = 28232;
    public static final int QBSQL_SLAVE = 28928;
    public static final int QBFOREIGNKEY_SLAVE = 28950;
    public static final int SCHSCHEDULELIST_SLAVE = 31001;
    public static final int SCHMODSCHEDULE_SLAVE = 31002;
    public static final int SCHADDSCHEDULE_SLAVE = 31003;
    public static final int SCHDELSCHEDULE_SLAVE = 31004;
    public static final int SCHSAVESCHEDULE_SLAVE = 31005;
    public static final int LICENSEINFO_SLAVE = 31010;
    public static final int EXPORTBARCODE_SLAVE = 28929;
    public static final int SHUTDOWNSERVER_SLAVE = 28930;
    public static final int OUTPUTSTREAM_SLAVE_INITIALIZE = 10001;
    public static final int OUTPUTSTREAM_SLAVE_WRITE = 10002;
    public static final int OUTPUTSTREAM_SLAVE_CLOSE = 10003;
    public static final int DEFAULTPORTNO = 22071;
    public static final int TEST_DB_CONNECTION = 32000;
    public static final int TEST_SF_CONNECTION = 11001;
    public static final int SF_QUERY_SLAVE = 11002;
    public static final int SFPARAMMETA_SLAVE = 11003;
    public static final int EXCEL_SLAVE = 12001;
    public static final int EXCEL_SLAVE_GET_DATA = 12002;
    public static final int EXCEL_SLAVE_GET_SHEET_NAMES = 12003;
    public static final String[] extension = new String[]{"cht", "bmp", "gif", "wrl", "jpg", "tpl", "gif"};
    public static final String BROWSER_IMAGES_PATH = "browserimages/";
    public static final String USER_FILES_PATH = "UserFiles/";
    public static final String GAUGES_PATH = "gauges/";
    public static final int ESPRESSCHART = 0;
    public static final int ESPRESSREPORT = 1;
    public static final String SERVER_CFG = "espressmanager.cfg";
    public static final String SERVLET_CFG = "servlet.cfg";
    public static final short LETTER_PAPERSIZE = 1;
    public static final short A4_PAPERSIZE = 9;
    private static final String QUADBASE_DIR = "QuadbaseDirectory.cfg";
    public static String reportImagesPath = "reportimages/";
    public static String imagesPath = "images/";
    public static String backgroundImagesPath = "backgroundImages/";
    public static boolean useSysResourceImages = false;
    public static String tempPath = "temp/";
    public static Applet parentApplet = null;
    public static Frame parentFrame = null;
    public static Component parentComp = null;
    public static int product = 0;
    public static boolean useServer = true;
    public static boolean isWebApp = false;
    public static String xmlEncoding = "UTF-8";
    public static String protocol = "http://";
    public static String serverHost = "";
    public static int portNumber = 8080;
    public static boolean isLoadBalancer = true;
    public static boolean useLoadBalancer = false;
    public static Vector clusterMembers = new Vector();
    public static boolean isBackupServer = false;
    public static String backupServer = "";
    public static int backupPort = 8080;
    public static long downTime;
    public static String eresDir;
    private static boolean checkMachineName;
    private static int portno;
    private static InetAddress address;
    private static InetAddress customAddress;
    private static Vector<String> hostName;
    private static boolean isInitialized;
    private static SocketConnectionFactory mySockFact;
    private static HttpConnectionFactory myHttpFact;
    private static ServletConnectionFactory myServletFact;
    private static IConnectionFactory myFact;
    private static URL connectURL;
    private static String connectServlet;
    private static String servletContext;
    private static String mainPath;
    private static int recordLimit;
    private static boolean isServletServer;
    private static String defaultGlobalFormatXml;
    private static String defaultFontMappingXml;
    private static String exportEncoding;
    private static int pagingThreshold;
    private static int pageBufferSize;
    private static int maxFieldSize;
    private static int totalMaxPageBufferMem;
    private static boolean useSingleTableForDistinctParamValue;
    private static boolean enableDataViewInQuickDesigner;
    private static boolean enableSaveQueryInQuickDesigner;
    private static Rectangle pageSize;
    private static String orgUserName;
    private static String orgUserToken;
    private static boolean showViewPrivilege;
    private static Vector hideReportMenuItems;
    private static boolean QdResizeToFitContentDefault;
    private static String QdNullValueHandler;
    private static boolean dashboardReportSinglePage;
    private static boolean dashboardUseOrigSize;
    private static boolean dashboardUseOrigMargin;
    private static boolean dashboardFlashChart;
    private static boolean dashboardAnimFlashChart;
    private static boolean dashboardAutoRefresh;
    private static int dashboardRefreshInterval;
    private static boolean isAdmin;
    private static boolean saas;
    private static String forcedSaveDirectory;
    private static Boolean isJnlp;
    private static BasicService basicService;
    private static String extraHeaderName;
    private static String extraHeaderValue;

    public static String getOrgUserName() {
        return orgUserName;
    }

    public static void setOrgUserName(String name) {
        orgUserName = name;
    }

    public static final boolean isCheckMachineName() {
        return checkMachineName;
    }

    public static final void setCheckMachineName(boolean b) {
        checkMachineName = b;
    }

    public static final boolean isEvalVersion() {
        if (product == 1) {
            return LCKey.isReport() && LCKey.isDownload();
        }
        return LCKey.isChart() && LCKey.isDownload();
    }

    public static final boolean isReleaseVersion() {
        if (product == 1) {
            return LCKey.isReport() && !LCKey.isDownload();
        }
        return LCKey.isChart() && !LCKey.isDownload();
    }

    public static final int getVersion() {
        if (product == 1) {
            return 7004;
        }
        return 6612;
    }

    public static final String getUpdateVersion() {
        return UPDATE_VERSION;
    }

    public static void resetPagingBuffer() {
        pagingThreshold = -1;
        pageBufferSize = 20;
        maxFieldSize = 500;
        totalMaxPageBufferMem = 256;
    }

    public static final String getProductName() {
        if (product == 1) {
            return REPORT_NAME;
        }
        return CHART_NAME;
    }

    private static void getDefaultHost(Applet applet) {
        String host = null;
        try {
            host = IOUtil.getHostName(applet);
            if (customAddress == null) {
                address = InetAddress.getByName(host);
            }
        }
        catch (Exception ex2) {
            try {
                if (customAddress == null) {
                    address = InetAddress.getLocalHost();
                }
                if (host == null) {
                    host = InetAddress.getByName(address.getHostAddress()).getHostName();
                }
            }
            catch (Exception ex3) {
                try {
                    if (customAddress == null) {
                        address = InetAddress.getByName("127.0.0.1");
                    }
                    if (host == null) {
                        host = InetAddress.getByName(address.getHostAddress()).getHostName();
                    }
                }
                catch (Exception ex4) {
                    System.out.println(ex4 + "");
                }
            }
        }
        hostName.addElement(host);
    }

    public static void startServletServer() {
        isServletServer = true;
    }

    public static void stopServletServer() {
        isServletServer = false;
    }

    public static boolean isServletServer() {
        return isServletServer;
    }

    public static final synchronized void init(Applet applet) {
        block26: {
            if (isInitialized) {
                return;
            }
            if (hostName == null) {
                hostName = new Vector();
            }
            BufferedReader instream = null;
            parentApplet = applet;
            if (useServer && connectServlet == null && ServerMessage.isServlet()) {
                try {
                    ServerMessage.setServletUrl(applet);
                }
                catch (Exception ex2) {
                    System.out.println(ex2 + " - Failed to establish servlet connection.");
                }
            } else if (useServer && connectURL == null && connectServlet == null) {
                try {
                    if (customAddress == null) {
                        instream = ServerMessage.getInputReader(applet);
                        try {
                            String tmp = instream.readLine().trim();
                            address = InetAddress.getByName(tmp);
                        }
                        catch (Exception ex2) {
                            System.out.println(ex2 + " - use default host.");
                            if (applet != null) {
                                ServerMessage.getDefaultHost(applet);
                            }
                        }
                    } else {
                        address = customAddress;
                    }
                    if (portno == 22071) {
                        if (instream == null) {
                            instream = ServerMessage.getInputReader(applet);
                            instream.readLine();
                        }
                        try {
                            portno = Integer.valueOf(instream.readLine());
                        }
                        catch (Exception ex) {
                            System.out.println("Failed to read port no. Using default value 22071\n");
                        }
                    }
                    if (instream == null) {
                        instream = ServerMessage.getInputReader(applet);
                        instream.readLine();
                        instream.readLine();
                    }
                    String host = "temp";
                    while (host != null) {
                        try {
                            host = instream.readLine();
                            if (host == null || host.trim().equals("")) continue;
                            hostName.addElement(host);
                        }
                        catch (Exception ex) {
                            host = null;
                        }
                    }
                    instream.close();
                    try {
                        host = IOUtil.getHostName(applet);
                        if (host != null && !host.trim().equals("")) {
                            hostName.addElement(host);
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception ex) {
                    if (customAddress == null) {
                        System.out.println("Failed to read espressmanager.cfg. Use default host  and port no. " + portno + ".");
                    }
                    if (applet == null) break block26;
                    ServerMessage.getDefaultHost(applet);
                }
            }
        }
        isInitialized = true;
    }

    private static BufferedReader getInputReader(Applet applet) throws IOException {
        return ServerMessage.getInputReader(applet, SERVER_CFG);
    }

    private static BufferedReader getInputReader(Applet applet, String fileName) throws IOException {
        if (applet != null) {
            return new BufferedReader(new InputStreamReader(new URL(IOUtil.getCodeBase(applet) + fileName).openStream()));
        }
        if (ServerMessage.isJnlp()) {
            return new BufferedReader(new InputStreamReader(new URL(ServerMessage.getBasicService().getCodeBase() + fileName).openStream()));
        }
        return new BufferedReader(new FileReader(fileName));
    }

    public static final Object getParent() {
        return parentApplet != null ? parentApplet : parentFrame;
    }

    public static final void setParent(Object parent) {
        if (parent instanceof Applet) {
            ServerMessage.setApplet((Applet)parent);
        } else if (parent instanceof Frame) {
            ServerMessage.setFrame((Frame)parent);
        } else {
            ServerMessage.setApplet(parentApplet);
        }
    }

    public static final Frame getFrame() {
        return parentFrame;
    }

    public static final void setFrame(Frame parent) {
        parentFrame = parent;
        ServerMessage.setApplet(parentApplet);
    }

    public static final Applet getApplet() {
        return parentApplet;
    }

    public static final void setApplet(Applet applet) {
        isInitialized = false;
        ServerMessage.init(applet);
    }

    public static final Component getComponent() {
        Frame result;
        Component component = parentFrame != null ? parentFrame : (result = parentApplet != null ? parentApplet : parentComp);
        if (result == null) {
            Component comp;
            try {
                comp = new Frame();
            }
            catch (Exception e) {
                comp = new Canvas();
            }
            ServerMessage.setComponent(comp);
            return comp;
        }
        return result;
    }

    public static final void setComponent(Component comp) {
        parentComp = comp;
    }

    public static void useHttp() {
        myFact = myHttpFact;
    }

    public static void useServlet() {
        myFact = myServletFact;
    }

    public static boolean isServlet() {
        return connectServlet != null || myFact instanceof ServletConnectionFactory;
    }

    public static void useSocket() {
        myFact = mySockFact;
    }

    public static void setConnectURL(String url) {
        try {
            connectURL = new URL(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getConnectServlet() {
        return connectServlet;
    }

    public static void setConnectServlet(String url) {
        connectServlet = url;
    }

    public static String getServletContext() {
        return servletContext;
    }

    public static void setServletContext(String tmp) {
        servletContext = tmp;
    }

    public static String getContext() {
        return servletContext.substring(0, servletContext.length() - 7);
    }

    public static IConnection createConnection() throws IOException {
        IConnection tmp;
        ServerMessage.init(null);
        if (connectURL != null) {
            return new HttpConnection(connectURL);
        }
        if (connectServlet != null) {
            myFact = myServletFact;
            return new ServletConnection(connectServlet);
        }
        try {
            tmp = myFact.createConnection(address, portno, hostName);
        }
        catch (Exception ex) {
            if (myFact instanceof SocketConnectionFactory) {
                System.out.println("Fail to use SOCKET:  Try to use HTTP Connection!");
                myFact = myHttpFact;
                tmp = myFact.createConnection(address, portno, hostName);
            }
            throw new IOException(ex.toString());
        }
        return tmp;
    }

    public static String getServerInfo() {
        if (connectURL != null) {
            return connectURL.toString();
        }
        if (connectServlet != null) {
            return connectServlet;
        }
        return address + ":" + portno;
    }

    public static String getAddress() {
        if (connectURL != null) {
            return connectURL.toString();
        }
        return address.toString();
    }

    public static void setAddress(String ad) throws UnknownHostException {
        customAddress = InetAddress.getByName(ad);
    }

    public static final String getHostAddress() {
        String ipaddress = null;
        try {
            ipaddress = InetAddress.getLocalHost().getHostAddress();
            if (ipaddress != null) {
                return ipaddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ipaddress = InetAddress.getLocalHost().getHostAddress();
            if (ipaddress != null) {
                return ipaddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static int getRecordLimit() {
        return recordLimit;
    }

    public static void setRecordLimit(int limit) {
        recordLimit = limit;
    }

    public static boolean exceedLimit(int rowCt) {
        if (recordLimit < 0) {
            return false;
        }
        return rowCt >= recordLimit;
    }

    public static void setXMLEncoding(String enc) {
        xmlEncoding = enc;
    }

    public static void setPortNumber(int pn) {
        portno = pn;
    }

    public static void setHosts(Vector<String> host) {
        hostName = host;
    }

    public static String getTempDirectory() {
        return tempPath;
    }

    public static void setTempDirectory(String str) {
        tempPath = str;
    }

    public static int getPagingThreshold() {
        return pagingThreshold;
    }

    public static void setPagingThreshold(int r) {
        pagingThreshold = r;
    }

    public static int getPageBufferSize() {
        return pageBufferSize;
    }

    public static void setPageBufferSize(int r) throws Exception {
        if (r < 0) {
            throw new Exception("Invalid page buffer size!");
        }
        pageBufferSize = r;
    }

    public static int getMaxFieldSize() {
        return maxFieldSize;
    }

    public static void setMaxFieldSize(int r) throws Exception {
        if (r < 0 || r > 5000) {
            throw new Exception("Invalid max char for record file: value must be between 0 and 5000!");
        }
        maxFieldSize = r;
    }

    public static int getTotalPageBufferSize() {
        return totalMaxPageBufferMem;
    }

    public static void setTotalPageBufferSize(int r) throws Exception {
        if (r < 2 * ServerMessage.getPageBufferSize()) {
            System.out.println("Total Paging Buffer Size is too small, resetting value to double the Page Buffer Size: " + 2 * ServerMessage.getPageBufferSize() + "MB");
            totalMaxPageBufferMem = 2 * ServerMessage.getPageBufferSize();
        } else {
            totalMaxPageBufferMem = r;
        }
    }

    public static boolean performOptimizeMemory(boolean optimizeMem) {
        if (optimizeMem && ServerMessage.getPagingThreshold() < 0) {
            return true;
        }
        if (optimizeMem && ServerMessage.getPagingThreshold() > -1) {
            System.out.println("Record file is ON: reset optimize memory to false");
        }
        return false;
    }

    public static String getMainPath() {
        return mainPath;
    }

    public static String getWorkingDirectory() {
        String configtxt;
        URL url;
        if (mainPath != null) {
            return mainPath;
        }
        if (ServerMessage.isServlet() && !LCKey.isERES() && !LCKey.isDashboard() && (url = ServerMessage.class.getResource(configtxt = "/userdb/config.txt")) != null) {
            try {
                File inFile = Paths.get(url.toURI()).toFile();
                if (inFile.getPath().contains("WEB-INF")) {
                    mainPath = inFile.getPath().substring(0, inFile.getPath().indexOf("WEB-INF"));
                } else {
                    configtxt = configtxt.replace('/', '\\');
                    mainPath = inFile.getPath().substring(0, inFile.getPath().indexOf(configtxt));
                }
                return mainPath;
            }
            catch (URISyntaxException inFile) {
                // empty catch block
            }
        }
        FileInputStream fstream = null;
        try {
            File fFile = new File(QUADBASE_DIR);
            fFile = new File(fFile.getAbsolutePath());
            fstream = new FileInputStream(fFile);
            BufferedReader din = new BufferedReader(new InputStreamReader(fstream));
            String line = din.readLine();
            if (line != null) {
                mainPath = new File(line).getAbsolutePath();
            }
        }
        catch (Exception fFile) {
            // empty catch block
        }
        if (fstream != null) {
            try {
                fstream.close();
            }
            catch (Exception fFile) {
                // empty catch block
            }
        }
        if (mainPath != null) {
            return mainPath;
        }
        try {
            mainPath = System.getProperty("user.dir");
        }
        catch (Exception ex) {
            mainPath = new File("").getAbsolutePath();
        }
        return mainPath;
    }

    public static String getSaveFileLink(String savePath) {
        return savePath;
    }

    public static String getPath(String path) {
        if (path.toUpperCase().startsWith("HTTP")) {
            return path;
        }
        if (path.toUpperCase().startsWith("HTTPS")) {
            return path;
        }
        if (new File(path = path.replace('\\', '/')).isAbsolute()) {
            return path;
        }
        if (ServerMessage.getApplet() != null) {
            return IOUtil.getCodeBase(ServerMessage.getApplet()) + path;
        }
        if (ServerMessage.isJnlp()) {
            return ServerMessage.getBasicService().getCodeBase() + path;
        }
        if (mainPath == null) {
            ServerMessage.getWorkingDirectory();
        }
        String tmp = mainPath + "/" + path;
        tmp = new File(tmp).getAbsolutePath();
        tmp = tmp.replace('\\', '/');
        return tmp;
    }

    public static BasicService getBasicService() {
        if (ServerMessage.isJnlp()) {
            if (basicService == null) {
                try {
                    basicService = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return basicService;
        }
        return null;
    }

    public static synchronized boolean isJnlp() {
        if (isJnlp == null) {
            if (!IOUtil.isClassAvailable("javax.jnlp.ServiceManager")) {
                isJnlp = false;
            } else {
                try {
                    ServiceManager.lookup((String)"javax.jnlp.BasicService");
                    isJnlp = true;
                }
                catch (Exception e) {
                    isJnlp = false;
                }
            }
        }
        return isJnlp;
    }

    public static String getPath(String path, String pakFileName) {
        if (pakFileName == null) {
            return ServerMessage.getPath(path);
        }
        if (!pakFileName.toLowerCase().startsWith("zip:")) {
            pakFileName = "zip:" + ServerMessage.getPath(pakFileName);
        }
        return pakFileName + '?' + path;
    }

    public static String getPath(String path, String pakFileName, String prefix) {
        if (pakFileName == null) {
            return ServerMessage.getPath(path);
        }
        if (!pakFileName.toLowerCase().startsWith("zip:")) {
            pakFileName = "zip:" + ServerMessage.getPath(pakFileName);
        }
        if (prefix == null) {
            prefix = "";
        }
        return pakFileName + '?' + prefix + QbUtil.getFileNameForPak(path);
    }

    public static void setInstallDir(String dir) {
        if (dir != null) {
            mainPath = dir;
        }
    }

    public static String getDatabaseURL(String url) {
        String url2 = url.toLowerCase();
        if (url2.startsWith("jdbc:hsqldb:hsql:")) {
            return url;
        }
        if (url2.startsWith("jdbc:hsqldb:")) {
            try {
                url2 = ServerMessage.getPath(url.substring(12));
                File file = new File(url2 + ".script");
                file = new File(file.getAbsolutePath());
                if (file.exists()) {
                    return "jdbc:hsqldb:" + url2;
                }
                return url;
            }
            catch (Exception e) {
                return url;
            }
        }
        return url;
    }

    public static void setServletUrl(Applet applet) throws Exception {
        BufferedReader instream = ServerMessage.getInputReader(applet, SERVLET_CFG);
        String address = instream.readLine().trim();
        instream.close();
        String servletBaseStr = ServerMessage.getServletBaseString(address);
        String servletContext = ServerMessage.getServletContext(address);
        ServerMessage.setConnectServlet(servletBaseStr);
        ServerMessage.setServletContext(servletContext);
    }

    public static String getServletBaseString(String servletURL) {
        URL tmp = null;
        try {
            tmp = new URL(servletURL);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        String protocol = tmp.getProtocol();
        String host = tmp.getHost();
        int port = tmp.getPort();
        if (port > 0) {
            return protocol + "://" + host + ":" + port;
        }
        return protocol + "://" + host;
    }

    public static String getServletContext(String servletURL) {
        String servletBaseStr = ServerMessage.getServletBaseString(servletURL);
        int len = servletBaseStr.length();
        if (len < servletURL.length()) {
            return servletURL.substring(len);
        }
        return servletContext;
    }

    public static String getDefaultGlobalFormat() throws IOException {
        if (!useServer) {
            return defaultGlobalFormatXml;
        }
        return ServerMessage.getDefaultFile("globalFormat");
    }

    public static void setDefaultGlobalFormat(String xmlPath) {
        defaultGlobalFormatXml = xmlPath;
    }

    public static String getDefaultFontMapping() throws IOException {
        if (!useServer) {
            return defaultFontMappingXml;
        }
        return ServerMessage.getDefaultFile("fontMapping");
    }

    public static void setExportEncoding(String encoding) {
        exportEncoding = encoding;
    }

    public static String getExportEncoding() {
        String result;
        if (!useServer) {
            result = exportEncoding;
        } else {
            try {
                result = ServerMessage.getDefaultFile("exportEncoding");
            }
            catch (IOException e) {
                e.printStackTrace();
                result = null;
            }
        }
        if (result == null && "".equals(result)) {
            return "UTF-8";
        }
        return result;
    }

    public static void setDefaultFontMapping(String xmlPath) {
        defaultFontMappingXml = xmlPath;
    }

    public static int getDefaultHtmlDpi() throws IOException {
        if (!useServer) {
            return -1;
        }
        String str = ServerMessage.getDefaultFile("htmlDpi");
        return Integer.parseInt(str);
    }

    private static String getDefaultFile(String filename) throws IOException {
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(10004);
        IOUtil.writeString(dout, filename);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (IOException e) {
            socket.close();
            throw e;
        }
        DataInputStream din = new DataInputStream(socket.getInputStream());
        boolean isNull = din.readBoolean();
        if (isNull) {
            return null;
        }
        String filepath = IOUtil.readString(din, true);
        return filepath;
    }

    public static boolean useSingleTableForDistinctParamValue() {
        return useSingleTableForDistinctParamValue;
    }

    public static void setUseSingleTableForDistinctParamValue(boolean state) {
        useSingleTableForDistinctParamValue = state;
    }

    public static void setEnableDataViewInQuickDesigner(boolean enable) {
        enableDataViewInQuickDesigner = enable;
    }

    public static boolean isDataViewInQuickDesignerEnabled() {
        return enableDataViewInQuickDesigner;
    }

    public static void setEnableSaveQueryInQuickDesigner(boolean enable) {
        enableSaveQueryInQuickDesigner = enable;
    }

    public static boolean isSaveQueryInQuickDesignerEnabled() {
        return enableSaveQueryInQuickDesigner;
    }

    public static String getPaperSizeStr() {
        ServerMessage.getPageSize();
        if (pageSize.equals(PageSize.A4)) {
            return "A4";
        }
        return "LETTER";
    }

    public static Rectangle getPageSize() {
        if (pageSize == null) {
            if (useServer) {
                try {
                    String s = ServerMessage.getDefaultFile("paperSize");
                    ServerMessage.setPaperSize(s);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                pageSize = PageSize.LETTER;
            }
        }
        return pageSize;
    }

    public static short getPaperSize() {
        ServerMessage.getPageSize();
        if (pageSize.equals(PageSize.A4)) {
            return 9;
        }
        return 1;
    }

    public static void setPaperSize(String paperSize) {
        pageSize = paperSize.equals("A4") ? PageSize.A4 : PageSize.LETTER;
    }

    public static double getPageWidth() {
        ServerMessage.getPaperSize();
        return QbUtil.pointsToInch(pageSize.width());
    }

    public static double getPageHeight() {
        ServerMessage.getPaperSize();
        return QbUtil.pointsToInch(pageSize.height());
    }

    public static boolean isDHTMLFormatTransitionalLoose(String userAgent) {
        if (userAgent == null) {
            return true;
        }
        int idx = -1;
        idx = userAgent.toLowerCase().indexOf("msie ");
        if (idx != -1) {
            int version = Integer.parseInt(userAgent.charAt(idx + 5) + "");
            return version >= 6;
        }
        return true;
    }

    public static boolean isShowViewPrivilege() {
        return showViewPrivilege;
    }

    public static void setShowViewPrivilege(boolean b) {
        showViewPrivilege = b;
    }

    public static Vector getHideReportMenuItems() {
        return hideReportMenuItems;
    }

    public static void setHideReportMenuItems(Vector v) {
        hideReportMenuItems = v;
    }

    public static String getOrgUserToken() {
        return orgUserToken;
    }

    public static void setOrgUserToken(String token) {
        orgUserToken = token;
    }

    public static boolean getQdResizeDefault() {
        return QdResizeToFitContentDefault;
    }

    public static void setQdResizeDefault(boolean b) {
        QdResizeToFitContentDefault = b;
    }

    public static String getQdNullValueHandler() {
        return QdNullValueHandler;
    }

    public static void setQdNullValueHandler(String s) {
        QdNullValueHandler = s;
    }

    public static boolean isDashboardReportSinglePage() {
        return dashboardReportSinglePage;
    }

    public static void setDashboardReportSinglePage(boolean dashboardReportSinglePage) {
        ServerMessage.dashboardReportSinglePage = dashboardReportSinglePage;
    }

    public static boolean isDashboardUseOrigSize() {
        return dashboardUseOrigSize;
    }

    public static void setDashboardUseOrigSize(boolean dashboardUseOrigSize) {
        ServerMessage.dashboardUseOrigSize = dashboardUseOrigSize;
    }

    public static boolean isDashboardUseOrigMargin() {
        return dashboardUseOrigMargin;
    }

    public static void setDashboardUseOrigMargin(boolean dashboardUseOrigMargin) {
        ServerMessage.dashboardUseOrigMargin = dashboardUseOrigMargin;
    }

    public static boolean isDashboardFlashChart() {
        return dashboardFlashChart;
    }

    public static void setDashboardFlashChart(boolean dashboardFlashChart) {
        ServerMessage.dashboardFlashChart = dashboardFlashChart;
    }

    public static boolean isDashboardAnimFlashChart() {
        return dashboardAnimFlashChart;
    }

    public static void setDashboardAnimFlashChart(boolean dashboardAnimFlashChart) {
        ServerMessage.dashboardAnimFlashChart = dashboardAnimFlashChart;
    }

    public static boolean isDashboardAutoRefresh() {
        return dashboardAutoRefresh;
    }

    public static void setDashboardAutoRefresh(boolean dashboardAutoRefresh) {
        ServerMessage.dashboardAutoRefresh = dashboardAutoRefresh;
    }

    public static int getDashboardRefreshInterval() {
        return dashboardRefreshInterval;
    }

    public static void setDashboardRefreshInterval(int dashboardRefreshInterval) {
        ServerMessage.dashboardRefreshInterval = dashboardRefreshInterval;
    }

    public static String getProductVersion() {
        return PRODUCT_VERSION;
    }

    public static String getForcedSaveDirectory() {
        return forcedSaveDirectory;
    }

    public static void setForcedSaveDirectory(String forcedSaveDirectory) {
        ServerMessage.forcedSaveDirectory = forcedSaveDirectory;
    }

    public static boolean isAdmin() {
        return orgUserName != null && isAdmin;
    }

    public static void setAdmin(boolean isAdmin) {
        ServerMessage.isAdmin = isAdmin;
    }

    public static boolean isSaas() {
        return saas;
    }

    public static void setSaas(boolean saas) {
        ServerMessage.saas = saas;
    }

    public static void setExtraServletHeader(String headerName, String headerValue) {
        extraHeaderName = headerName;
        extraHeaderValue = headerValue;
    }

    public static String getExtraHeaderName() {
        return extraHeaderName;
    }

    public static String getExtraHeaderValue() {
        return extraHeaderValue;
    }

    static {
        checkMachineName = true;
        portno = 22071;
        address = null;
        customAddress = null;
        hostName = new Vector();
        isInitialized = false;
        mySockFact = new SocketConnectionFactory();
        myHttpFact = new HttpConnectionFactory();
        myServletFact = new ServletConnectionFactory();
        myFact = mySockFact;
        connectURL = null;
        connectServlet = null;
        servletContext = "/servlet";
        recordLimit = -1;
        isServletServer = false;
        defaultGlobalFormatXml = null;
        defaultFontMappingXml = null;
        exportEncoding = "UTF-8";
        pagingThreshold = -1;
        pageBufferSize = 20;
        maxFieldSize = 500;
        totalMaxPageBufferMem = 256;
        useSingleTableForDistinctParamValue = false;
        enableDataViewInQuickDesigner = true;
        enableSaveQueryInQuickDesigner = true;
        orgUserName = null;
        orgUserToken = null;
        showViewPrivilege = true;
        hideReportMenuItems = null;
        QdResizeToFitContentDefault = false;
        QdNullValueHandler = "Null";
        dashboardReportSinglePage = true;
        dashboardUseOrigSize = true;
        dashboardUseOrigMargin = true;
        dashboardFlashChart = false;
        dashboardAnimFlashChart = false;
        dashboardAutoRefresh = false;
        dashboardRefreshInterval = 60;
        isAdmin = false;
        saas = false;
        try {
            address = InetAddress.getByName("127.0.0.1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        PatchReader.readPatch();
    }
}

