/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.formula;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import quadbase.common.formula.Constant;
import quadbase.common.formula.DateFormulaParserConstants;
import quadbase.common.formula.DateFormulaParserTokenManager;
import quadbase.common.formula.DateFunction;
import quadbase.common.formula.Function;
import quadbase.common.formula.Operand;
import quadbase.common.formula.ParseException;
import quadbase.common.formula.SimpleCharStream;
import quadbase.common.formula.Token;

public class DateFormulaParser
implements DateFormulaParserConstants {
    public DateFormulaParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[5];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public Operand parse() throws ParseException {
        return this.parseDateFormula();
    }

    public final Operand parseDateFormula() throws ParseException {
        Operand op;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                op = this.calculateDateFunction();
                break;
            }
            case 10: {
                op = this.additiveDateFormula();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(0);
        return op;
    }

    public final Operand calculateDateFunction() throws ParseException {
        Token dateFunction = this.jj_consume_token(13);
        Token op = this.jj_consume_token(11);
        Operand calOp = this.additiveDateFormula();
        Token cp = this.jj_consume_token(12);
        Vector<Operand> arg = new Vector<Operand>();
        arg.addElement(calOp);
        Operand operand = new DateFunction(dateFunction.image, arg);
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    operator = this.jj_consume_token(8);
                    break;
                }
                case 9: {
                    operator = this.jj_consume_token(9);
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Token number = this.jj_consume_token(7);
            Token calendarField = this.jj_consume_token(6);
            Vector<Operand> args = new Vector<Operand>();
            args.addElement(operand);
            args.addElement(new Constant(6, calendarField.image, new String(calendarField.image)));
            if (operator.image.equals("+")) {
                args.addElement(new Constant(0, number.image, Double.valueOf(number.image)));
            } else {
                args.addElement(new Constant(0, number.image, Double.valueOf("-" + number.image)));
            }
            operand = new Function(new String("addTime"), args);
        }
        return operand;
    }

    public final Operand additiveDateFormula() throws ParseException {
        Token now = this.jj_consume_token(10);
        Function op = new Function(now.image, null);
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    operator = this.jj_consume_token(8);
                    break;
                }
                case 9: {
                    operator = this.jj_consume_token(9);
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Token number = this.jj_consume_token(7);
            Token calendarField = this.jj_consume_token(6);
            Vector<Operand> args = new Vector<Operand>();
            args.addElement(op);
            args.addElement(new Constant(6, calendarField.image, new String(calendarField.image)));
            if (operator.image.equals("+")) {
                args.addElement(new Constant(0, number.image, Double.valueOf(number.image)));
            } else {
                args.addElement(new Constant(0, number.image, Double.valueOf("-" + number.image)));
            }
            op = new Function(new String("addTime"), args);
        }
        return op;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{9216, 768, 768, 768, 768};
    }

    public DateFormulaParser(InputStream stream) {
        this(stream, null);
    }

    public DateFormulaParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new DateFormulaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DateFormulaParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new DateFormulaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public DateFormulaParser(DateFormulaParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(DateFormulaParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[14];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 5; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 14; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        DateFormulaParser.jj_la1_init_0();
    }
}

