/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.formula;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import quadbase.common.formula.Operand;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.IFunctionConstants;

public class DateFunction
extends Operand
implements IFunctionConstants {
    String functionName;
    Vector args = new Vector();

    public DateFunction(String name, Vector args) {
        this.functionName = name;
        this.args = args;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String name) {
        this.functionName = name;
    }

    public Vector getArgs() {
        return this.args;
    }

    public void setArgs(Vector args) {
        this.args = args;
    }

    @Override
    public Object getValue() throws Exception {
        this.checkNumberOfArgs(1);
        Operand operand = (Operand)this.args.elementAt(0);
        Object object = operand.getValue();
        Calendar cal = Calendar.getInstance();
        this.dataType = operand.getDataType();
        if (this.dataType == 3) {
            cal.setTime((Date)object);
        } else if (this.dataType == 5) {
            cal.setTime((Timestamp)object);
        } else if (this.dataType == 4) {
            cal.setTime((Time)object);
        }
        if (this.functionName.equalsIgnoreCase("FIRSTOFYEAR")) {
            cal.set(2, 0);
            cal.set(5, 1);
        } else if (this.functionName.equalsIgnoreCase("LASTOFYEAR")) {
            cal.set(2, 11);
            cal.set(5, 31);
        } else if (this.functionName.equalsIgnoreCase("FIRSTOFQUARTER")) {
            this.firstOfQuarter(cal);
        } else if (this.functionName.equalsIgnoreCase("LASTOFQUARTER")) {
            cal.add(2, 3);
            this.firstOfQuarter(cal);
            cal.add(5, -1);
        } else if (this.functionName.equalsIgnoreCase("FIRSTOFMONTH")) {
            cal.set(5, 1);
        } else if (this.functionName.equalsIgnoreCase("LASTOFMONTH")) {
            cal.add(2, 1);
            cal.set(5, 1);
            cal.add(5, -1);
        } else if (this.functionName.equalsIgnoreCase("FIRSTOFWEEK")) {
            this.firstOfWeek(cal);
        } else if (this.functionName.equalsIgnoreCase("LASTOFWEEK")) {
            cal.add(5, 7);
            this.firstOfWeek(cal);
            cal.add(5, -1);
        } else if (this.functionName.equalsIgnoreCase("STARTOFDAY")) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else if (this.functionName.equalsIgnoreCase("ENDOFDAY")) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(6, 1);
            cal.add(14, -1);
        }
        if (this.dataType == 3) {
            Date date = new Date(cal.getTimeInMillis());
            return date;
        }
        if (this.dataType == 5) {
            Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
            return timestamp;
        }
        if (this.dataType == 4) {
            Time time = new Time(cal.getTimeInMillis());
            return time;
        }
        return null;
    }

    private void firstOfWeek(Calendar cal) {
        int dayOfWeek = cal.get(7);
        cal.add(5, -1 * (dayOfWeek - 1));
    }

    private void firstOfQuarter(Calendar cal) {
        int month = cal.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                cal.set(2, 0);
                cal.set(5, 1);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                cal.set(2, 3);
                cal.set(5, 1);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                cal.set(2, 6);
                cal.set(5, 1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                cal.set(2, 9);
                cal.set(5, 1);
            }
        }
    }

    @Override
    public int getDataType() {
        if (this.dataType == -1) {
            try {
                this.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dataType;
    }

    private void checkNumberOfArgs(int number) throws Exception {
        if (this.args == null || this.args.size() != number) {
            throw new Exception(LanguageEncoder.getText(this.functionName + " has wrong number of arguments"));
        }
    }
}

