/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.formula;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import quadbase.common.formula.Operand;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.IFunctionConstants;

public class Function
extends Operand
implements IFunctionConstants {
    String functionName;
    Vector args = new Vector();

    public Function(String name, Vector args) {
        this.functionName = name;
        this.args = args;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String name) {
        this.functionName = name;
    }

    public Vector getArgs() {
        return this.args;
    }

    public void setArgs(Vector args) {
        this.args = args;
    }

    @Override
    public Object getValue() throws Exception {
        if (this.functionName.equalsIgnoreCase("getCurrentDate") || this.functionName.equalsIgnoreCase("currentDate")) {
            this.dataType = 3;
            return new Date(System.currentTimeMillis());
        }
        if (this.functionName.equalsIgnoreCase("getCurrentDateTime") || this.functionName.equalsIgnoreCase("currentDateTime")) {
            this.dataType = 5;
            return new Timestamp(System.currentTimeMillis());
        }
        if (this.functionName.equalsIgnoreCase("getCurrentTime") || this.functionName.equalsIgnoreCase("currentTime")) {
            this.dataType = 4;
            return new Time(System.currentTimeMillis());
        }
        if (this.functionName.equalsIgnoreCase("addTime")) {
            this.checkNumberOfArgs(3);
            Operand operand = (Operand)this.args.elementAt(0);
            Object object = operand.getValue();
            Calendar cal = Calendar.getInstance();
            this.dataType = operand.getDataType();
            if (this.dataType == 3) {
                cal.setTime((Date)object);
                cal.add(this.getCalendarField(this.args.elementAt(1)), this.getDouble(this.args.elementAt(2)).intValue());
                Date date = new Date(cal.getTimeInMillis());
                return date;
            }
            if (this.dataType == 5) {
                cal.setTime((Timestamp)object);
                cal.add(this.getCalendarField(this.args.elementAt(1)), this.getDouble(this.args.elementAt(2)).intValue());
                Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
                return timestamp;
            }
            if (this.dataType == 4) {
                cal.setTime((Time)object);
                cal.add(this.getCalendarField(this.args.elementAt(1)), this.getDouble(this.args.elementAt(2)).intValue());
                Time time = new Time(cal.getTimeInMillis());
                return time;
            }
        }
        return null;
    }

    @Override
    public int getDataType() {
        if (this.dataType == -1) {
            try {
                this.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dataType;
    }

    private void checkNumberOfArgs(int number) throws Exception {
        if (this.args == null || this.args.size() != number) {
            throw new Exception(LanguageEncoder.getText(this.functionName + " has wrong number of arguments"));
        }
    }

    private Double getDouble(Object arg) throws Exception {
        Operand operand = (Operand)arg;
        Object object = operand.getValue();
        int type = operand.getDataType();
        if (type == 0) {
            if (object == null) {
                return 0.0;
            }
            return (Double)object;
        }
        throw new Exception(LanguageEncoder.getText(arg.toString() + " is of wrong datatype, NUMBER expected"));
    }

    private int getCalendarField(Object arg) throws Exception {
        Operand operand = (Operand)arg;
        Object object = operand.getValue();
        int type = operand.getDataType();
        if (type == 6) {
            String s = (String)object;
            for (int i = 0; i < CALENDAR_CONST.length; ++i) {
                if (!s.equalsIgnoreCase(CALENDAR_CONST[i])) continue;
                return i;
            }
            return 0;
        }
        throw new Exception(LanguageEncoder.getText(arg.toString() + " is of wrong datatype, CALENDARFIELD expected"));
    }
}

