/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.network;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeartBeatServer
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(HeartBeatServer.class.getName());
    private static final int DELAY = 1000;
    private final DataOutputStream out;
    private ConnectionClosedListener connectionClosedListener;
    private boolean close;
    private boolean canceled;

    public HeartBeatServer(OutputStream outputStream) {
        this.out = new DataOutputStream(outputStream);
    }

    @Override
    public void run() {
        while (!this.close && !this.canceled) {
            try {
                HeartBeatServer.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.close) continue;
            try {
                this.out.writeInt(8);
                this.out.flush();
                LOGGER.finest("Heartbeat sent");
            }
            catch (IOException e) {
                LOGGER.log(Level.FINEST, "Heartbeat interrupted", e);
                this.canceled = true;
                if (this.connectionClosedListener == null) continue;
                this.connectionClosedListener.onConnectionClosed();
            }
        }
    }

    public void setConnectionClosedListener(ConnectionClosedListener connectionClosedListener) {
        this.connectionClosedListener = connectionClosedListener;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void close() {
        this.close = true;
        this.interrupt();
    }

    public static interface ConnectionClosedListener {
        public void onConnectionClosed();
    }
}

