/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.network;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import quadbase.common.network.IConnection;
import quadbase.common.network.http.HttpRequestHeader;
import quadbase.common.network.http.HttpResponseHeader;
import quadbase.common.network.http.HttpUtil;

public class HttpServerConnection
implements IConnection {
    HttpRequestHeader req;
    HttpResponseHeader res;
    Socket sock;
    InputStream in;
    OutputStream out;
    String addr;
    String host;
    boolean bHeaderSent = false;

    public HttpServerConnection(Socket sock, InputStream i) throws IOException {
        this.sock = sock;
        this.req = HttpUtil.readHeaders(i);
        this.res = new HttpResponseHeader();
        this.res.setHeader("Pragma", "no-cache");
        this.in = i;
        this.out = new WrappedOutputStream(sock.getOutputStream());
        this.addr = sock.getInetAddress().getHostAddress();
        this.host = sock.getInetAddress().getHostName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public void close() throws IOException {
        this.sock.close();
    }

    @Override
    public String getPeerAddress() {
        return this.addr;
    }

    @Override
    public String getPeerHost() {
        return this.host;
    }

    private boolean isHeaderSent() {
        return this.bHeaderSent;
    }

    @Override
    public void setContentLength(int i) {
    }

    class WrappedOutputStream
    extends OutputStream {
        private OutputStream output;

        WrappedOutputStream(OutputStream o) {
            this.output = o;
        }

        @Override
        public void write(int b) throws IOException {
            if (!HttpServerConnection.this.isHeaderSent()) {
                this.writeHeaders();
            }
            this.output.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (!HttpServerConnection.this.isHeaderSent()) {
                this.writeHeaders();
            }
            this.output.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (!HttpServerConnection.this.isHeaderSent()) {
                this.writeHeaders();
            }
            this.output.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            if (!HttpServerConnection.this.isHeaderSent()) {
                this.writeHeaders();
            }
            this.output.flush();
        }

        @Override
        public void close() throws IOException {
            if (!HttpServerConnection.this.isHeaderSent()) {
                this.writeHeaders();
            }
            this.output.close();
        }

        void writeHeaders() throws IOException {
            DataOutputStream dout = new DataOutputStream(this.output);
            dout.writeBytes(HttpServerConnection.this.res.getHeader());
            dout.writeBytes("\r\n");
            dout.flush();
            HttpServerConnection.this.bHeaderSent = true;
        }
    }
}

