/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.network;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.IOUtil;

public class ServletServerConnection
implements IConnection {
    InputStream in;
    OutputStream out;
    String address;
    String host;
    String orgUserName = null;
    String clientAddress = null;

    public ServletServerConnection(InputStream in, OutputStream out, String address, String host) throws IOException {
        this.in = in;
        this.out = out;
        this.address = address;
        this.host = host;
        DataInputStream din = new DataInputStream(in);
        this.orgUserName = IOUtil.readString(din, true);
        this.clientAddress = IOUtil.readString(din, true);
    }

    public String getUserName() {
        return this.orgUserName;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getPeerAddress() {
        if (this.clientAddress == null) {
            return this.address;
        }
        Hashtable kvPair = this.parseClientAddress();
        String ipAddress = (String)kvPair.get("IPAddress");
        String userToken = (String)kvPair.get("OrgUserToken");
        if (ipAddress.equals("127.0.0.1") || ipAddress.equals("localhost")) {
            return this.address + "?OrgUserName=" + this.orgUserName + "&OrgUserToken=" + userToken;
        }
        return this.clientAddress;
    }

    @Override
    public String getPeerHost() {
        return this.host;
    }

    @Override
    public void setContentLength(int i) {
    }

    private Hashtable parseClientAddress() {
        Hashtable<String, String> kvPair = new Hashtable<String, String>();
        int loc = this.clientAddress.indexOf(63);
        if (loc < 0) {
            kvPair.put("IPAddress", this.clientAddress);
            return kvPair;
        }
        kvPair.put("IPAddress", this.clientAddress.substring(0, loc));
        String kvStr = this.clientAddress.substring(loc + 1);
        StringTokenizer st = new StringTokenizer(kvStr, "&");
        while (st.hasMoreTokens()) {
            String pairStr = st.nextToken();
            loc = pairStr.indexOf(61);
            String key = pairStr.substring(0, loc);
            String val = pairStr.substring(loc + 1);
            kvPair.put(key, val);
        }
        return kvPair;
    }
}

