/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import quadbase.common.network.IConnection;

public class SocketConnection
implements IConnection {
    Socket sock;
    InputStream in;

    public SocketConnection(Socket sock) {
        this.sock = sock;
    }

    public SocketConnection(Socket sock, InputStream in) {
        this.sock = sock;
        this.in = in;
    }

    public SocketConnection(InetAddress addr, int port) throws IOException {
        this.sock = new Socket(addr, port);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.in != null) {
            return this.in;
        }
        return this.sock.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.sock.getOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.sock.close();
    }

    @Override
    public String getPeerAddress() {
        return this.sock.getInetAddress().getHostAddress();
    }

    @Override
    public String getPeerHost() {
        return this.sock.getInetAddress().getHostName();
    }

    @Override
    public void setContentLength(int i) {
    }
}

