/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.network.http;

import java.util.Enumeration;
import quadbase.common.network.http.HashTable;
import quadbase.common.network.http.Pair;

public abstract class HttpHeader {
    protected HashTable m_headers = new HashTable();
    protected String m_version = "HTTP/1.0";

    abstract String getHeader();

    public void setVersion(String version) {
        this.m_version = version;
    }

    public String getVersion() {
        return this.m_version;
    }

    public int getContentLength() {
        String len = this.getHeader("Content-Length");
        if (len != null) {
            return Integer.parseInt(len);
        }
        return -1;
    }

    public void addHeader(String line) {
        int i = line.indexOf(58);
        if (i >= 0) {
            String key = line.substring(0, i);
            String values = line.substring(i + 1);
            this.addHeader(key, values);
        }
    }

    public void setHeader(String key, String value) {
        String k = HttpHeader.normalize(key);
        this.m_headers.put(k, new Pair(key, value.trim()));
    }

    public void addHeader(String key, String value) {
        String k = HttpHeader.normalize(key);
        this.m_headers.add(k, new Pair(key, value.trim()));
    }

    public String getHeader(String key) {
        Pair p = (Pair)this.m_headers.get(HttpHeader.normalize(key));
        if (p != null) {
            return (String)p.second;
        }
        return null;
    }

    public int countHeader(String key) {
        return this.m_headers.count(HttpHeader.normalize(key));
    }

    public Enumeration getHeaderValues(String key) {
        return new HeaderValueEnum(this.m_headers.values(HttpHeader.normalize(key)));
    }

    public boolean containsHeader(String key) {
        return this.m_headers.count(HttpHeader.normalize(key)) > 0;
    }

    public Enumeration getHeaderNames() {
        return new HeaderKeyEnum(this.m_headers.elements());
    }

    void appendHeaders(StringBuffer sb) {
        Enumeration enum1 = this.m_headers.elements();
        while (enum1.hasMoreElements()) {
            Pair p = (Pair)enum1.nextElement();
            String key = (String)p.first;
            String value = (String)p.second;
            sb.append(key).append(": ").append(value).append("\r\n");
        }
    }

    private static final String normalize(String key) {
        return key.trim().toLowerCase();
    }

    public static String urlEncode(String decoded) {
        int len = decoded.length();
        StringBuffer result = new StringBuffer(len);
        result.setLength(0);
        for (int i = 0; i < len; ++i) {
            char c = decoded.charAt(i);
            if (c == ' ') {
                result.append('+');
                continue;
            }
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '-' || c == '@' || c == '.') {
                result.append(c);
                continue;
            }
            result.append("%" + Integer.toString(c, 16));
        }
        return result.toString();
    }

    public static String escape(String decoded) {
        int len = decoded.length();
        StringBuffer result = new StringBuffer(len);
        result.setLength(0);
        for (int i = 0; i < len; ++i) {
            char c = decoded.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '-' || c == '@' || c == '.') {
                result.append(c);
                continue;
            }
            result.append("&#").append(Integer.toString(c));
        }
        return result.toString();
    }

    public static String urlDecode(String encoded) {
        int len = encoded.length();
        StringBuffer result = new StringBuffer(len);
        result.setLength(0);
        for (int i = 0; i < len; ++i) {
            char c = encoded.charAt(i);
            if (c == '+') {
                result.append(' ');
                continue;
            }
            if (c == '%') {
                if (encoded.charAt(i + 1) == '%') {
                    result.append('%');
                    continue;
                }
                i += 2;
                try {
                    c = (char)Integer.parseInt(encoded.substring(i - 1, i + 1), 16);
                    result.append(c);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    class HeaderValueEnum
    implements Enumeration {
        Enumeration e;

        HeaderValueEnum(Enumeration e) {
            this.e = e;
        }

        @Override
        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            return ((Pair)this.e.nextElement()).second;
        }
    }

    class HeaderKeyEnum
    implements Enumeration {
        Enumeration e;

        HeaderKeyEnum(Enumeration e) {
            this.e = e;
        }

        @Override
        public boolean hasMoreElements() {
            return this.e.hasMoreElements();
        }

        public Object nextElement() {
            return ((Pair)this.e.nextElement()).first;
        }
    }
}

