/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.network.http;

import java.util.Enumeration;
import java.util.StringTokenizer;
import quadbase.common.network.http.HashTable;
import quadbase.common.network.http.HttpHeader;

public class HttpRequestHeader
extends HttpHeader {
    private String m_method;
    private String m_uri;
    private HashTable m_params;

    public HttpRequestHeader() {
    }

    public HttpRequestHeader(String line) {
        StringTokenizer st = new StringTokenizer(line, " ");
        if (st.hasMoreTokens()) {
            this.m_method = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this.m_uri = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this.m_version = st.nextToken();
        }
    }

    public void setMethod(String method) {
        this.m_method = method;
    }

    public String getMethod() {
        return this.m_method;
    }

    public void setURI(String uri) {
        this.m_uri = uri;
    }

    public String getURI() {
        return this.m_uri;
    }

    @Override
    public String getHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_method).append(" ").append(this.m_uri).append(" ");
        sb.append(this.m_version).append("\r\n");
        this.appendHeaders(sb);
        return sb.toString();
    }

    private HashTable getParameters() {
        if (this.m_params == null) {
            this.m_params = this.parseParams();
        }
        return this.m_params;
    }

    public String getParameter(String key) {
        return (String)this.getParameters().get(key);
    }

    public Enumeration getParameterNames() {
        return this.getParameters().keys();
    }

    public Enumeration getParameterValues(String key) {
        return this.getParameters().values(key);
    }

    public int countParameterValues(String key) {
        return this.getParameters().count(key);
    }

    private void parseParams(HashTable hash, String params) {
        StringTokenizer st = new StringTokenizer(HttpRequestHeader.urlDecode(params), "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int j = token.indexOf(61);
            if (j < 0) continue;
            hash.add(token.substring(0, j), token.substring(j + 1));
        }
    }

    public HashTable parseParams() {
        HashTable hash = new HashTable();
        int i = this.m_uri.indexOf(63);
        if (i >= 0) {
            String pString = this.m_uri.substring(i + 1);
            this.parseParams(hash, pString);
        }
        return hash;
    }

    public static void main(String[] arg) {
        HttpRequestHeader req = new HttpRequestHeader("GET /socket?action=req&uid=12344555 HTTP/1.1");
        System.out.println(req.getMethod());
        System.out.println(req.getURI());
        System.out.println(req.getVersion());
        System.out.println(req.getParameter("action"));
        System.out.println(req.getParameter("uid"));
    }
}

