/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.pak;

import java.applet.Applet;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.ChartAPI.QbChart;
import quadbase.common.client.ServerMessage;
import quadbase.common.pak.FilePacker;
import quadbase.common.pak.FilePackerFactory;
import quadbase.common.pak.PakEntry;
import quadbase.common.pak.PakFileWriter;
import quadbase.common.pak.PakUtil;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.reportdesigner.ReportAPI.QbReport;

public abstract class AbstractFilePacker
implements FilePacker {
    private static final Logger LOGGER = Logger.getLogger(AbstractFilePacker.class.getName());
    protected int PAK_TYPE;
    protected String mainFilePath;
    protected String username;
    protected Vector templateNames;
    protected Vector templatePaths;
    protected Vector templateOrganizerNames = null;
    protected Vector templateOrganizerPaths = null;
    protected Vector otherFilePaths;
    protected Vector otherFileNames;
    protected Vector diskPathChangeAllowedList;
    protected boolean diskPathChangeAllowedMainFile = true;

    public AbstractFilePacker(String mainFilePath, String username) {
        this.mainFilePath = mainFilePath;
        this.username = username;
    }

    protected abstract void readAllPaths() throws Exception;

    @Override
    public void writePak(String filePath) throws Exception {
        FileOutputStream out = new FileOutputStream(filePath);
        try {
            this.writePak(out);
        }
        catch (Exception e) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            File f = new File(filePath);
            if (f.exists()) {
                f.delete();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePak(OutputStream out) throws Exception {
        this.readAllPaths();
        try (PakFileWriter writer = new PakFileWriter(out);){
            int i;
            PakEntry mainFileEntry = new PakEntry(QbUtil.getFileNameForPak(this.mainFilePath), this.createRelativePath(this.mainFilePath), true, this.diskPathChangeAllowedMainFile);
            writer.addMainFile(mainFileEntry);
            for (i = 0; this.templatePaths != null && i < this.templatePaths.size(); ++i) {
                String organizerPath = this.getValueOrNull(this.templateOrganizerPaths, i);
                String organizerName = this.getValueOrNull(this.templateOrganizerNames, i);
                PakEntry pakEntry = new PakEntry((String)this.templateNames.get(i), this.createRelativePath((String)this.templatePaths.get(i)), organizerPath, organizerName);
                this.writeTemplate(writer, pakEntry);
            }
            for (i = 0; this.otherFilePaths != null && i < this.otherFilePaths.size(); ++i) {
                boolean diskPathChangeAllowed = true;
                if (this.diskPathChangeAllowedList != null && i < this.diskPathChangeAllowedList.size()) {
                    diskPathChangeAllowed = (Boolean)this.diskPathChangeAllowedList.get(i);
                }
                PakEntry pakEntry = new PakEntry((String)this.otherFileNames.get(i), this.createRelativePath((String)this.otherFilePaths.get(i)), false, diskPathChangeAllowed);
                try {
                    writer.addFile(pakEntry);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, this.otherFilePaths.get(i) + " not found. It will not be included in packed file.", e);
                }
            }
        }
    }

    private String createRelativePath(String absolutePath) {
        String result = QbUtil.createRelativePath(absolutePath, ServerMessage.getWorkingDirectory());
        return result != null ? result : absolutePath;
    }

    private String getValueOrNull(Vector vector, int i) {
        if (vector == null || i >= vector.size()) {
            return null;
        }
        return (String)vector.get(i);
    }

    private void writeTemplate(PakFileWriter writer, PakEntry pakEntry) throws Exception {
        OutputStream out;
        File f;
        String templatePath = ServerMessage.getPath(pakEntry.getFullDiskPath());
        if (!templatePath.toLowerCase().startsWith("http") && !(f = new File(templatePath)).canRead()) {
            throw new Exception("Cannot read file: " + templatePath);
        }
        if (PakUtil.isGoogleMap(templatePath)) {
            pakEntry.entryName = QbUtil.getFileNameWithoutExtension(pakEntry.entryName) + ".gpak";
            pakEntry.diskName = QbUtil.getFileNameWithoutExtension(pakEntry.diskName) + ".gpak";
            out = writer.getOutputStream(pakEntry);
            FilePacker mapPacker = FilePackerFactory.getMapPacker(templatePath, this.username);
            mapPacker.writePak(out);
            out.close();
        } else if (PakUtil.isSvgMap(templatePath)) {
            pakEntry.entryName = QbUtil.getFileNameWithoutExtension(pakEntry.entryName) + ".spak";
            pakEntry.diskName = QbUtil.getFileNameWithoutExtension(pakEntry.diskName) + ".spak";
            out = writer.getOutputStream(pakEntry);
            FilePacker mapPacker = FilePackerFactory.getMapPacker(templatePath, this.username);
            mapPacker.writePak(out);
            out.close();
        } else if (PakUtil.isReport(templatePath)) {
            pakEntry.entryName = QbUtil.getFileNameWithoutExtension(pakEntry.entryName) + ".pak";
            pakEntry.diskName = QbUtil.getFileName(templatePath);
            out = writer.getOutputStream(pakEntry);
            QbReport report = new QbReport(null, templatePath, false, false, false, true, false);
            report.export(10, out);
            out.close();
        } else if (PakUtil.isQDReport(templatePath) || PakUtil.isQDChart(templatePath)) {
            pakEntry.entryName = QbUtil.getFileName(pakEntry.entryName);
            pakEntry.diskName = QbUtil.getFileName(templatePath);
            out = writer.getOutputStream(pakEntry);
            DataInputStream dis = new ReadDataFile().getInputStream(QbUtil.fixUrlString(templatePath));
            IOUtil.copyStream(dis, out);
            out.close();
        } else if (PakUtil.isChart(templatePath)) {
            pakEntry.entryName = QbUtil.getFileNameWithoutExtension(pakEntry.entryName) + ".pac";
            pakEntry.diskName = QbUtil.getFileNameWithoutExtension(pakEntry.diskName) + ".pac";
            out = writer.getOutputStream(pakEntry);
            Properties props = new Properties();
            props.put("use backup data", "true");
            props.put("prompt parameter", "false");
            boolean oldState = QbChart.isForExportOnly();
            QbChart.setForExportOnly(true);
            QbChart chart = new QbChart((Applet)null, templatePath, null, props);
            chart.export(16, out);
            QbChart.setForExportOnly(oldState);
            out.close();
        } else if (PakUtil.isDashboard(templatePath)) {
            pakEntry.entryName = QbUtil.getFileNameWithoutExtension(pakEntry.entryName) + ".dpak";
            pakEntry.diskName = QbUtil.getFileNameWithoutExtension(pakEntry.diskName) + ".dpak";
            out = writer.getOutputStream(pakEntry);
            FilePacker dsbPacker = FilePackerFactory.getDashboardPacker(templatePath, this.username);
            dsbPacker.writePak(out);
            out.close();
        } else {
            throw new Exception("Unknown template type: " + templatePath);
        }
    }
}

