/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.pak;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import quadbase.common.client.ServerMessage;
import quadbase.common.pak.FileUnpacker;
import quadbase.common.pak.FileUnpackerFactory;
import quadbase.common.pak.PakEntry;
import quadbase.common.pak.PakFile;
import quadbase.common.pak.PakFileReader;
import quadbase.common.pak.PakUtil;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.dashboard3.pak.DashboardReferencesUpdater;
import quadbase.datasourcemanager.pak.RegistryReferencesUpdater;
import quadbase.maps.pak.MapReferencesUpdater;

public abstract class AbstractFileUnpacker
implements FileUnpacker {
    protected String pakFileName;

    @Override
    public PakEntry[] getPakEntries() throws Exception {
        DataInputStream is = new ReadDataFile().getInputStream(this.pakFileName, false, true);
        Vector pakEntries = PakFileReader.getPakEntries(is);
        Vector<PakEntry> result = new Vector<PakEntry>();
        for (PakEntry pakEntry : pakEntries) {
            String lowerCase = pakEntry.entryName.toLowerCase();
            if (lowerCase.endsWith(".dpak") || lowerCase.endsWith(".gpak") || lowerCase.endsWith(".spak") || lowerCase.endsWith(".rpak")) {
                String zippedUrl = ServerMessage.getPath(pakEntry.entryName, this.pakFileName);
                FileUnpacker unpacker = lowerCase.endsWith(".dpak") ? FileUnpackerFactory.getDashboardUnpacker(zippedUrl) : (lowerCase.endsWith(".rpak") ? FileUnpackerFactory.getRegistryUnpacker(zippedUrl) : FileUnpackerFactory.getMapUnpacker(zippedUrl));
                PakEntry[] internalEntries = unpacker.getPakEntries();
                internalEntries[0].organizerName = pakEntry.organizerName;
                internalEntries[0].organizerPath = pakEntry.organizerPath;
                for (int i = 0; i < internalEntries.length; ++i) {
                    internalEntries[i].entryName = pakEntry.entryName + '?' + internalEntries[i].entryName;
                    result.add(internalEntries[i]);
                }
                continue;
            }
            result.add(pakEntry);
        }
        return result.toArray(new PakEntry[result.size()]);
    }

    @Override
    public void unpackFiles(PakEntry[] pakEntries) throws Exception {
        for (int i = 0; i < pakEntries.length; ++i) {
            if (!pakEntries[i].unpackFile) continue;
            this.createDirectory(pakEntries[i].diskPath);
            PakFile pakFile = new PakFile(ServerMessage.getPath(pakEntries[i].entryName, this.pakFileName));
            InputStream in = pakFile.getInputStream();
            String path = ServerMessage.getPath(pakEntries[i].getFullDiskPath());
            FileOutputStream out = new FileOutputStream(path);
            IOUtil.copyStream(in, out);
        }
    }

    @Override
    public void updateReferences(PakEntry[] pakEntries) throws Exception {
        PakEntry[] originalPakEntries = this.getPakEntries();
        for (int i = 0; i < pakEntries.length; ++i) {
            if (!pakEntries[i].unpackFile) continue;
            String path = pakEntries[i].getFullDiskPath();
            if (PakUtil.isDashboard(path)) {
                new DashboardReferencesUpdater(pakEntries[i]).updateReferences(originalPakEntries, pakEntries);
                continue;
            }
            if (PakUtil.isGoogleMap(path) || PakUtil.isSvgMap(path)) {
                new MapReferencesUpdater(pakEntries[i]).updateReferences(originalPakEntries, pakEntries);
                continue;
            }
            if (!PakUtil.isRegistry(path)) continue;
            new RegistryReferencesUpdater(pakEntries[i]).updateReferences(originalPakEntries, pakEntries);
            break;
        }
    }

    protected void createDirectory(String path) throws IOException {
        File f = new File(ServerMessage.getPath(path));
        if (f.exists() && f.isDirectory()) {
            return;
        }
        if (!f.mkdirs()) {
            throw new IOException(LanguageEncoder.getText("Cannot create directory:") + path);
        }
    }
}

