/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.pak;

import java.lang.reflect.Constructor;
import quadbase.common.pak.FilePacker;

public class FilePackerFactory {
    public static FilePacker getDashboardPacker(String dsbFilePath, String username) throws ClassNotFoundException {
        try {
            Class<?> packer = Class.forName("quadbase.dashboard3.pak.DashboardPacker");
            Constructor<?> constr = packer.getConstructor(String.class, String.class);
            return (FilePacker)constr.newInstance(dsbFilePath, username);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClassNotFoundException("DashboardPacker class not found.");
        }
    }

    public static FilePacker getMapPacker(String mapFilePath, String username) throws ClassNotFoundException {
        try {
            Class<?> packer = Class.forName("quadbase.maps.pak.MapPacker");
            Constructor<?> constr = packer.getConstructor(String.class, String.class);
            return (FilePacker)constr.newInstance(mapFilePath, username);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClassNotFoundException("MapPacker class not found.");
        }
    }

    public static FilePacker getRegistryPacker(String regFilePath, String username) throws ClassNotFoundException {
        try {
            Class<?> packer = Class.forName("quadbase.datasourcemanager.pak.RegistryPacker");
            Constructor<?> constr = packer.getConstructor(String.class, String.class);
            return (FilePacker)constr.newInstance(regFilePath, username);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClassNotFoundException("RegistryPacker class not found.");
        }
    }
}

