/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.pak;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.VersioningDataOutput;

public class PakEntry {
    private static final short VERSION = 1;
    private static final short FIRST_VERSION = 1;
    public String entryName = null;
    public String diskPath;
    public String diskName;
    public String organizerPath;
    public String organizerName;
    public String url = null;
    public boolean insertToOrganizer = true;
    public boolean unpackFile = true;
    public boolean diskPathChangeAllowed = true;
    public int nodeID = -1;
    public int itemID = -1;

    private PakEntry() {
    }

    public PakEntry(String entryName, String fullDiskPath, String organizerPath, String organizerName) {
        this.entryName = entryName;
        this.diskName = QbUtil.getFileName(fullDiskPath);
        this.diskPath = fullDiskPath.substring(0, fullDiskPath.length() - this.diskName.length());
        this.organizerPath = organizerPath;
        this.organizerName = organizerName;
    }

    public PakEntry(String entryName, String fullDiskPath, boolean insertToOrganizer, boolean diskPathChangeAllowed) {
        this(entryName, fullDiskPath, null, null);
        this.insertToOrganizer = insertToOrganizer;
        this.diskPathChangeAllowed = diskPathChangeAllowed;
    }

    public static PakEntry readPakEntry(InputStream in) throws IOException {
        return PakEntry.readPakEntry(new DataInputStream(in));
    }

    public static PakEntry readPakEntry(DataInputStream din) throws IOException {
        PakEntry pakEntry = new PakEntry();
        VersioningDataInput vin = new VersioningDataInput(din, 1);
        vin.readShort();
        pakEntry.entryName = vin.readStr();
        pakEntry.diskPath = vin.readStr();
        pakEntry.diskName = vin.readStr();
        pakEntry.organizerPath = vin.readStr();
        pakEntry.organizerName = vin.readStr();
        pakEntry.url = vin.readStr();
        pakEntry.insertToOrganizer = vin.readBoolean();
        pakEntry.diskPathChangeAllowed = vin.readBoolean();
        pakEntry.unpackFile = vin.readBoolean();
        pakEntry.nodeID = vin.readInt();
        pakEntry.itemID = vin.readInt();
        return pakEntry;
    }

    public static PakEntry readFromByteArray(byte[] barray) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(barray);
        return PakEntry.readPakEntry(in);
    }

    public void write(OutputStream out) throws IOException {
        this.write(new DataOutputStream(out));
    }

    public void write(DataOutputStream dout) throws IOException {
        VersioningDataOutput vout = new VersioningDataOutput(dout);
        vout.writeShort(1);
        vout.writeStr(this.entryName, (short)1);
        vout.writeStr(this.diskPath, (short)1);
        vout.writeStr(this.diskName, (short)1);
        vout.writeStr(this.organizerPath, (short)1);
        vout.writeStr(this.organizerName, (short)1);
        vout.writeStr(this.url, (short)1);
        vout.writeBoolean(this.insertToOrganizer, (short)1);
        vout.writeBoolean(this.diskPathChangeAllowed, (short)1);
        vout.writeBoolean(this.unpackFile, (short)1);
        vout.writeInt(this.nodeID);
        vout.writeInt(this.itemID);
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        this.write(bout);
        byte[] data = bout.toByteArray();
        return data;
    }

    public String getFullDiskPath() {
        String path = this.diskPath.replace('\\', '/');
        path = path.replaceFirst("/*$", "");
        return path + "/" + this.diskName;
    }

    public boolean isSameFile(PakEntry pakEntry) {
        return PakEntry.nullSafeEquals(this.diskPath, pakEntry.diskPath) && PakEntry.nullSafeEquals(this.diskName, pakEntry.diskName) && PakEntry.nullSafeEquals(this.organizerPath, pakEntry.organizerPath) && PakEntry.nullSafeEquals(this.organizerName, pakEntry.organizerName);
    }

    public String toString() {
        return this.entryName;
    }

    private static boolean nullSafeEquals(String s1, String s2) {
        return !(s1 != null ? !s1.equals(s2) : s2 != null);
    }
}

