/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.pak;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.ReadDataFile;

public class PakFile {
    private String zippedUrl;
    private String mainFilePath;
    private String zipPath;

    public PakFile(String zippedUrl) throws MalformedURLException {
        if (zippedUrl == null) {
            throw new NullPointerException("zippedUrl cannot be null");
        }
        if (!zippedUrl.startsWith("zip:")) {
            throw new MalformedURLException("ZippedUrl must start with 'zip:' protocol");
        }
        int index = zippedUrl.indexOf(63);
        if (index < 0) {
            this.mainFilePath = zippedUrl.substring(4);
            this.zipPath = null;
        } else {
            this.mainFilePath = zippedUrl.substring(4, index);
            this.zipPath = zippedUrl.substring(index);
        }
        this.mainFilePath = ServerMessage.getPath(this.mainFilePath);
        this.zippedUrl = zippedUrl;
    }

    public String getFileName() {
        return this.zipPath.substring(this.zipPath.lastIndexOf(63) + 1);
    }

    public String getMainFilePath() {
        return this.mainFilePath;
    }

    public String getZipPath() {
        return this.zipPath.substring(1);
    }

    public String getPath() {
        return this.zippedUrl.substring(0, this.zippedUrl.lastIndexOf(63));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        InputStream in = null;
        try {
            in = this.getInputStream();
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory() throws Exception {
        InputStream in = this.zipPath == null ? new FileInputStream(this.mainFilePath) : this.getInputStream();
        ZipInputStream zin = new ZipInputStream(in);
        try {
            if (zin.getNextEntry() == null) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public InputStream getInputStream() throws Exception {
        if (this.zipPath == null) {
            throw new IOException("Cannot call getInputStream() on zipped directory " + this.zippedUrl);
        }
        String path = this.zipPath.substring(1);
        FilterInputStream in = new ReadDataFile().getInputStream(this.mainFilePath);
        do {
            ZipEntry zipEntry;
            String name;
            int index;
            if ((index = path.indexOf(63)) < 0) {
                name = path;
                path = null;
            } else {
                name = path.substring(0, index);
                path = path.substring(index + 1);
            }
            ZipInputStream zin = new ZipInputStream(in);
            boolean found = false;
            while ((zipEntry = zin.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(name) && !QbUtil.urlDecode(zipEntry.getName()).equals(name)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new FileNotFoundException(name + " not found in " + this.zippedUrl);
            }
            in = zin;
        } while (path != null);
        return in;
    }

    public OutputStream getOutputStream() throws Exception {
        if (this.isDirectory()) {
            throw new IOException("Cannot call getOutputStream() on zipped directory " + this.zippedUrl);
        }
        return new ZippedFileOutputStream();
    }

    private class ZippedFileOutputStream
    extends ByteArrayOutputStream {
        private byte[] buf = new byte[1024];

        private ZippedFileOutputStream() {
        }

        @Override
        public void close() throws IOException {
            super.close();
            File file = new File(PakFile.this.mainFilePath);
            File tempFile = File.createTempFile(PakFile.this.getFileName(), null, new File(file.getParent()));
            tempFile.delete();
            if (!file.renameTo(tempFile)) {
                throw new IOException("Failed copying " + file.getAbsolutePath() + " to temporary file " + tempFile.getAbsolutePath());
            }
            FileInputStream in = null;
            OutputStream out = null;
            try {
                in = new FileInputStream(tempFile);
                out = new FileOutputStream(file);
                this.writeOneFile(in, out, PakFile.this.zipPath.substring(1), this.toByteArray());
                out.flush();
                out.close();
            }
            catch (IOException e) {
                file.delete();
                tempFile.renameTo(file);
                throw e;
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
                tempFile.delete();
            }
        }

        private void writeOneFile(InputStream in, OutputStream out, String path, byte[] barray) throws IOException {
            ByteArrayOutputStream bos;
            ZipEntry zipEntry;
            String name;
            if (path == null) {
                out.write(barray);
                return;
            }
            int index = path.indexOf(63);
            if (index < 0) {
                name = path;
                path = null;
            } else {
                name = path.substring(0, index);
                path = path.substring(index + 1);
            }
            ZipOutputStream zout = new ZipOutputStream(out);
            ZipInputStream zin = new ZipInputStream(in);
            boolean found = false;
            while ((zipEntry = zin.getNextEntry()) != null) {
                int len;
                zout.putNextEntry(zipEntry);
                if (zipEntry.getName().equals(name)) {
                    found = true;
                    bos = new ByteArrayOutputStream();
                    this.writeOneFile(zin, bos, path, barray);
                    zout.write(bos.toByteArray());
                    continue;
                }
                while ((len = zin.read(this.buf)) > 0) {
                    zout.write(this.buf, 0, len);
                }
            }
            if (path == null && !found) {
                zout.putNextEntry(new ZipEntry(name));
                bos = new ByteArrayOutputStream();
                this.writeOneFile(zin, bos, path, barray);
                zout.write(bos.toByteArray());
            }
            zout.close();
        }
    }
}

