/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.pak;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import quadbase.common.pak.PakEntry;

public class PakFileReader {
    private ZipFile zipFile;

    public PakFileReader(String path) throws IOException {
        this.zipFile = new ZipFile(path);
    }

    public InputStream getMainInputStream() throws IOException {
        ZipEntry firstEntry = this.zipFile.entries().nextElement();
        return this.zipFile.getInputStream(firstEntry);
    }

    public InputStream getInputStream(String filename) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(filename);
        if (entry == null) {
            throw new FileNotFoundException("File " + filename + " not found in " + this.zipFile.getName());
        }
        return this.zipFile.getInputStream(entry);
    }

    public Collection getFileList() {
        Vector<String> result = new Vector<String>();
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            result.add(entry.getName());
        }
        return result;
    }

    public Vector getPakEntries() throws IOException {
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        Vector<PakEntry> result = new Vector<PakEntry>();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            byte[] extra = zipEntry.getExtra();
            PakEntry pakEntry = PakEntry.readFromByteArray(extra);
            result.add(pakEntry);
        }
        return result;
    }

    public void close() throws IOException {
        this.zipFile.close();
    }

    public static InputStream getMainInputStream(InputStream in) throws IOException {
        ZipInputStream zin = new ZipInputStream(in);
        zin.getNextEntry();
        return zin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getPakEntries(InputStream in) throws IOException {
        Vector<PakEntry> result = new Vector<PakEntry>();
        try (ZipInputStream zin = new ZipInputStream(in);){
            ZipEntry zipEntry;
            while ((zipEntry = zin.getNextEntry()) != null) {
                byte[] extra = zipEntry.getExtra();
                PakEntry pakEntry = PakEntry.readFromByteArray(extra);
                result.add(pakEntry);
            }
        }
        return result;
    }
}

