/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.pak;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import quadbase.common.pak.PakEntry;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.ReadDataFile;

public class PakFileWriter {
    private ZipOutputStream zout;
    private EntryOutputStream eout = null;
    private boolean mainStreamWritten = false;

    public PakFileWriter(String path) throws IOException {
        this.zout = new ZipOutputStream(new FileOutputStream(path));
    }

    public PakFileWriter(OutputStream out) throws IOException {
        this.zout = new ZipOutputStream(out);
    }

    public OutputStream getMainOutputStream(PakEntry pakEntry) throws IOException {
        if (this.mainStreamWritten) {
            throw new IllegalStateException("Main stream is already written.");
        }
        ZipEntry entry = new ZipEntry(pakEntry.entryName);
        entry.setExtra(pakEntry.toByteArray());
        this.zout.putNextEntry(entry);
        this.eout = new EntryOutputStream();
        return this.eout;
    }

    public void writeMainFile(byte[] content, PakEntry pakEntry) throws IOException {
        OutputStream out = this.getMainOutputStream(pakEntry);
        out.write(content);
        out.close();
    }

    public OutputStream getOutputStream(PakEntry pakEntry) throws IOException {
        if (!this.mainStreamWritten) {
            throw new IllegalStateException("Main stream must be written and closed before calling getOutputStream.");
        }
        if (this.eout != null) {
            throw new IllegalStateException("You must close the previous output stream before getting new one.");
        }
        ZipEntry entry = new ZipEntry(pakEntry.entryName);
        entry.setExtra(pakEntry.toByteArray());
        this.zout.putNextEntry(entry);
        this.eout = new EntryOutputStream();
        return this.eout;
    }

    public void addMainFile(PakEntry pakEntry) throws Exception {
        DataInputStream in = new ReadDataFile().getInputStream(pakEntry.getFullDiskPath());
        OutputStream out = this.getMainOutputStream(pakEntry);
        IOUtil.copyStream(in, out);
    }

    public void addFile(PakEntry pakEntry) throws Exception {
        DataInputStream in = new ReadDataFile().getInputStream(pakEntry.getFullDiskPath());
        OutputStream out = this.getOutputStream(pakEntry);
        IOUtil.copyStream(in, out);
    }

    public void close() throws IOException {
        if (this.eout != null) {
            this.eout.close();
        }
        this.zout.flush();
        this.zout.close();
    }

    private class EntryOutputStream
    extends ByteArrayOutputStream {
        boolean isClosed = false;

        private EntryOutputStream() {
        }

        @Override
        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            PakFileWriter.this.zout.write(this.toByteArray());
            PakFileWriter.this.mainStreamWritten = true;
            PakFileWriter.this.eout = null;
            this.isClosed = true;
        }
    }
}

