/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.pak;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import quadbase.common.client.MessageSender;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportorganizer.data.Util;

public class PakUtil {
    public static boolean isReport(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".RPT") || fileLocation.toUpperCase().endsWith(".QRP") || fileLocation.toUpperCase().endsWith(".PAK") || fileLocation.toUpperCase().endsWith(".XML") && Util.isXMLReport((String)fileLocation);
    }

    public static boolean isQDReport(String fileLocation) {
        return fileLocation != null && fileLocation.toUpperCase().endsWith(".QDR");
    }

    public static boolean isQDChart(String fileLocation) {
        return fileLocation != null && fileLocation.toUpperCase().endsWith(".QCH");
    }

    public static boolean isChart(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return fileLocation.toUpperCase().endsWith(".CHT") || fileLocation.toUpperCase().endsWith(".TPL") || fileLocation.toUpperCase().endsWith(".PAC") || fileLocation.toUpperCase().endsWith(".QCH") || fileLocation.toUpperCase().endsWith(".XML") && Util.isXMLChart((String)fileLocation);
    }

    public static boolean isGoogleMap(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return (fileLocation = fileLocation.toLowerCase()).endsWith(".gxml") || fileLocation.endsWith(".gpak");
    }

    public static boolean isSvgMap(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return (fileLocation = fileLocation.toLowerCase()).endsWith(".sxml") || fileLocation.endsWith(".spak");
    }

    public static boolean isDashboard(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return (fileLocation = fileLocation.toLowerCase()).endsWith(".dsb") || fileLocation.endsWith(".dpak");
    }

    public static boolean isRegistry(String fileLocation) {
        if (fileLocation == null) {
            return false;
        }
        return (fileLocation = fileLocation.toLowerCase()).endsWith(".xml") || fileLocation.endsWith(".rpak");
    }

    public static void writePakOnServer(int pakType, String mainFilePath, String pakFilePath, String username) throws Exception {
        MessageSender ms = new MessageSender(27001);
        DataOutputStream dout = ms.getDataOutput();
        dout.writeInt(pakType);
        IOUtil.writeStr(dout, mainFilePath);
        IOUtil.writeStr(dout, username);
        IOUtil.writeStr(dout, pakFilePath);
        DataInputStream din = ms.sendAndReceive();
        ((InputStream)din).close();
    }
}

