/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.param;

import java.io.Writer;
import java.util.Vector;
import quadbase.common.param.AutoCompleteParam;
import quadbase.common.param.CompleteParamPrompt;
import quadbase.common.param.CssHtmlWriter;
import quadbase.common.param.HtmlParameterPageWriter;
import quadbase.common.param.Param;
import quadbase.common.param.ParameterPage;
import quadbase.common.util.internal.QbUtil;

public class CssHtmlParameterPageWriter
extends HtmlParameterPageWriter {
    private String cssFile;
    private final CssHtmlWriter html = new CssHtmlWriter(this);
    private boolean isEspressMobile;

    public CssHtmlParameterPageWriter(ParameterPage page, Writer out) {
        this(page, out, false);
    }

    public CssHtmlParameterPageWriter(ParameterPage page, Writer out, boolean isEspressMobile) {
        super(page, out);
        this.isEspressMobile = isEspressMobile;
    }

    public void setCssFile(String cssFile) {
        this.cssFile = cssFile;
    }

    public String getCssFile() {
        return this.cssFile;
    }

    @Override
    public void writeHead() {
        this.html.head();
        if (this.cssFile != null) {
            this.html.style(this.cssFile);
        }
        this.html.title();
        if (this.docTitle != null) {
            this.html.println(this.docTitle);
        }
        this.html.titleEnd();
        this.html.headEnd();
    }

    @Override
    public void writeBody() {
        this.html.div("page");
        super.writeBody();
        this.html.divEnd();
    }

    @Override
    public void writeTableTitle() {
        this.html.div("paramTableTitle");
        super.writeTableTitle();
        this.html.divEnd();
    }

    @Override
    protected void writeBodyHeader() {
        if (this.header != null) {
            this.html.div("pageHeader");
            this.println(this.header);
            this.html.divEnd();
        }
    }

    @Override
    protected void writeBodyFooter() {
        if (this.footer != null) {
            this.html.div("pageFooter");
            this.println(this.footer);
            this.html.divEnd();
        }
    }

    @Override
    protected void writeParamTableOpenTag() {
        this.write("<table style=\"width:100%\" class=\"paramTable\" valign=\"middle\"");
        if (this.tableBackgroundColor != null) {
            this.write(" bgcolor=#" + QbUtil.escapeHTML(this.tableBackgroundColor));
        }
        this.write(" border=\"" + this.tableBorderThickness + "\" ");
        if (this.tableBorderColor != null) {
            this.write(" bordercolor=\"#" + QbUtil.escapeHTML(this.tableBorderColor) + "\" ");
        }
        this.write("cellpadding=\"0\" cellspacing=\"3\">\n");
    }

    @Override
    protected void writeParamTableCategory(String paramName, String tdAttributes) {
        this.println("\n\t<td class=\"paramTableCategory\" align=\"right\"" + tdAttributes + " style=\"vertical-align: middle; white-space: nowrap; width: 100px;\" >");
        this.writeParamName(paramName);
        this.html.tableDataEnd();
    }

    @Override
    protected void writeParamTableValues(String name, String selectAttributes, Vector values, String paramValue, String tdAttributes) {
        this.write("\n\t<td class=\"paramTableValues\" " + tdAttributes + " colspan=3 style=\"width:100%\">");
        this.writeParamValues(name, selectAttributes, values, paramValue);
        this.write("</td>\n");
    }

    @Override
    protected void writeParamTableValue(String name, String value, String tdAttributes) {
        this.write("\n\t<td colspan=\"3\" style=\"width:100%\" class=\"paramTableValues\" " + tdAttributes + ">");
        this.writeParamValue(name, value);
        this.write("</td>\n");
    }

    @Override
    protected void writeParamValue(String name, String value) {
        this.write("<input type=\"text\" name=\"" + QbUtil.escapeHTML(name) + "\" class=\"" + "paramValue" + "\" value=\"" + QbUtil.escapeHTML(value) + "\" size=20>");
    }

    @Override
    protected void writeParamValueDate(String name, String value, Param param) {
        this.write("<input type=\"text\" name=\"" + name + "\" class=\"" + "paramValue" + "\" value=\"" + value + "\" size=20>");
        this.write("</td>\n");
        if (!this.dateParameterSelection && param.isUnmapped()) {
            if (this.dateParameterCalendar) {
                this.write("<td style=\"padding-left:2px;\">\n");
                this.printCalendarJavascript(name, param);
                this.write("</td>\n");
            }
            if (this.dateVariable) {
                this.write("<td style=\"padding-left:2px;\">\n");
                this.printDateVariableJavascript(name);
                this.write("</td>\n");
            }
        }
    }

    @Override
    protected void writeParamValues(String name, String attributes, Vector values, String paramValue) {
        if (attributes.contains("MULTIPLE")) {
            int size = 4;
            if (attributes.trim().equals("")) {
                size = 1;
            }
            this.println("<select name=\"" + QbUtil.escapeHTML(name) + "\" id=\"" + QbUtil.escapeHTML(name) + "\"" + attributes + " class=\"" + "paramValue" + "\" size=" + size + ">");
            this.writeParamValuesOptions(values, paramValue);
            this.write("</select>");
        } else {
            CompleteParamPrompt cpp = this.writeParamValuesOptionsYUI(values, paramValue);
            this.println(AutoCompleteParam.getAutocompleteHTML(cpp.getValues(), cpp.getDefaultValue(), name, false));
        }
    }

    @Override
    protected void writeFormButtons() {
        this.html.div("formButtons");
        super.writeFormButtons();
        this.html.divEnd();
    }

    @Override
    protected void writeSubmitButton() {
        this.write("\n<input class=\"submitButton\" type=\"submit\" value=\"Submit\">");
    }

    @Override
    protected void writeResetButton() {
        this.write("\n<input class=\"resetButton\" type=\"reset\" value=\"Reset\">\n");
    }
}

