/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.param;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import quadbase.common.param.AutoCompleteParam;
import quadbase.common.param.ChartParameterPage;
import quadbase.common.param.CompleteParamPrompt;
import quadbase.common.param.HtmlWriter;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.Param;
import quadbase.common.param.ParamPrompt;
import quadbase.common.param.ParamUtil;
import quadbase.common.param.ParameterPage;
import quadbase.common.param.ParameterPageWriter;
import quadbase.common.param.Parameters;
import quadbase.common.param.QueryParam;
import quadbase.common.param.ReportParameterPage;
import quadbase.common.param.RootQueryParam;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbDateFormat;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.util.internal.ReportUtil;
import quadbase.reportorganizer.menuAPI.Util;

public class HtmlParameterPageWriter
extends ParameterPageWriter {
    public static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd hh:mm:ss.s";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private final String openFont;
    private final String closeFont;
    protected String servletName;
    protected String serverName;
    protected String servletDirectory;
    protected int servletRunnerPort;
    protected HtmlWriter html = new HtmlWriter(this);
    private String javaScriptLibPath = "../lib/javascript";
    private boolean[] hiddenParameters;
    private Object[] hiddenParamValues;
    private int order = -1;

    public HtmlParameterPageWriter(ParameterPage page, Writer out) {
        super(page, out);
        this.servletName = page.getServletName();
        int paramCount = page.getDbInfo() instanceof QueryFileInfo ? ((QueryFileInfo)page.getDbInfo()).getInParam().length : 0;
        this.hiddenParameters = new boolean[paramCount];
        for (int i = 0; i < this.hiddenParameters.length; ++i) {
            this.hiddenParameters[i] = false;
        }
        this.hiddenParamValues = new Object[paramCount];
        if (page instanceof ReportParameterPage) {
            this.serverName = ((ReportParameterPage)page).getServerName();
        }
        if (page instanceof ReportParameterPage) {
            this.servletDirectory = ((ReportParameterPage)page).getServletDirectory();
        }
        if (page instanceof ReportParameterPage) {
            this.servletRunnerPort = ((ReportParameterPage)page).getServletRunnerPort();
        }
        if (page instanceof ReportParameterPage) {
            this.order = ((ReportParameterPage)page).getOrder();
        }
        this.openFont = "<FONT COLOR=\"" + this.textColor + "\" FACE=\"" + this.textFont + "\" SIZE = \"" + this.textSize + "\">";
        this.closeFont = "</FONT>";
    }

    @Override
    public void writePage() throws IOException {
        this.html.html();
        this.writeHead();
        String bgColorStr = this.backgroundColor == null ? "" : "bgcolor=\"" + this.backgroundColor + "\"";
        String bgImageStr = this.backgroundImage == null ? "" : "background=\"" + this.backgroundImage + "\"";
        this.html.body(bgColorStr + " " + bgImageStr);
        this.writeBody();
        this.html.bodyEnd();
        this.html.htmlEnd();
    }

    public void writeBody() {
        if (this.dateParameterCalendarDatepicker != null) {
            this.printBodyJavascript();
        }
        switch (this.alignment) {
            case 0: {
                this.println("<CENTER>");
                break;
            }
            case 2: {
                this.println("<P ALIGN=\"RIGHT\">");
                break;
            }
            default: {
                this.println("<LEFT>");
            }
        }
        this.println("<FONT COLOR=\"" + this.textColor + "\" FACE=\"" + this.textFont + "\" SIZE = \"" + this.textSize + "\">");
        if ((this.textStyle & 1) != 0) {
            this.println("<B>");
        }
        if ((this.textStyle & 2) != 0) {
            this.println("<I>");
        }
        this.writeBodyHeader();
        this.writeBodyBody();
        this.writeBodyFooter();
        switch (this.alignment) {
            case 0: {
                this.println("</CENTER>");
                break;
            }
            case 2: {
                this.println("</P>");
                break;
            }
            default: {
                this.println("</LEFT>");
            }
        }
        if ((this.textStyle & 1) != 0) {
            this.println("</B>");
        }
        if ((this.textStyle & 2) != 0) {
            this.println("</I>");
        }
        this.html.fontEnd();
    }

    public void writeBodyBody() {
        this.writeTableTitle();
        String onSubmit = this.page.getOnSubmit() == null ? "return validate();" : "if (!validate()) return false; else {" + this.page.getOnSubmit() + "}";
        this.write("<FORM name=\"runreport\" id=\"runreport\" action = \"" + this.servletName + "\" method=\"post\" onSubmit=\"" + onSubmit + "\">\n");
        this.writeParamTable(true);
        this.html.br();
        if (this.page instanceof ReportParameterPage) {
            if (this.paramPageExportFormats != null && this.paramPageExportFormats.length == 1) {
                this.write("\n<INPUT TYPE=\"hidden\" NAME=\"ExportFormat\" VALUE=\"" + this.paramPageExportFormats[0] + "\">");
            }
            if (this.targetLoc != null) {
                this.write("\n<INPUT TYPE=\"hidden\" NAME=\"ReportFilePath\" VALUE=\"" + this.targetLoc + "\">");
            }
            if (this.format != -1) {
                this.write("\n<INPUT TYPE=\"hidden\" NAME=\"ReportExportFormat\" VALUE=\"" + this.format + "\">");
            }
            if (this.securityLevel != null) {
                this.write("\n<INPUT TYPE=\"hidden\" NAME=\"SecurityLevel\" VALUE=\"" + QbUtil.escapeHTML(this.securityLevel) + "\">");
            }
            if (this.serverName != null) {
                this.write("\n<INPUT TYPE=\"hidden\" NAME=\"ServerName\" VALUE=\"" + this.serverName + "\">");
            }
            this.write("\n<INPUT TYPE=\"hidden\" NAME=\"ServletRunnerPort\" VALUE=\"" + this.servletRunnerPort + "\">");
            this.write("\n<INPUT TYPE=\"hidden\" NAME=\"Order\" VALUE=\"" + this.order + "\">");
            if (this.servletDirectory != null) {
                this.write("\n<INPUT TYPE=\"hidden\" NAME=\"ServletDirectory\" VALUE=\"" + this.servletDirectory + "\">");
            }
        } else if (this.page instanceof ChartParameterPage) {
            if (this.paramPageExportFormats != null && this.paramPageExportFormats.length == 1) {
                this.write("\n<INPUT TYPE=\"hidden\" NAME=\"DisplayType\" VALUE=\"" + this.paramPageExportFormats[0] + "\">");
            }
            if (this.targetLoc != null) {
                this.write("\n<INPUT TYPE=\"hidden\" NAME=\"ChartPath\" VALUE=\"" + this.targetLoc + "\">");
            }
            if (this.format != -1) {
                this.write("\n<INPUT TYPE=\"hidden\" NAME=\"DisplayType\" VALUE=\"" + this.format + "\">");
            }
            if (this.securityLevel != null) {
                this.write("\n<INPUT TYPE=\"hidden\" NAME=\"SecurityLevel\" VALUE=\"" + QbUtil.escapeHTML(this.securityLevel) + "\">");
            }
        }
        this.writeFormButtons();
        this.write("</FORM>");
    }

    public void writeTableTitle() {
        if (this.titleTextColor != null || this.titleTextFont != null || this.titleTextSize != -1) {
            this.println("<FONT");
            if (this.titleTextColor != null) {
                this.println(" COLOR=\"" + this.titleTextColor + "\"");
            }
            if (this.titleTextFont != null) {
                this.println(" \" FACE=\"" + this.titleTextFont + "\"");
            }
            if (this.titleTextSize != -1) {
                this.println(" \" SIZE=\"" + this.titleTextSize + "\"");
            }
            this.println(">");
        }
        if ((this.titleTextStyle & 1) != 0) {
            this.println("<B>");
        }
        if ((this.titleTextStyle & 2) != 0) {
            this.println("<I>");
        }
        if (this.titleText != null) {
            this.println(this.titleText);
        }
        if ((this.titleTextStyle & 1) != 0) {
            this.println("</B>");
        }
        if ((this.titleTextStyle & 2) != 0) {
            this.println("</I>");
        }
        if (this.titleTextColor != null || this.titleTextFont != null || this.titleTextSize != -1) {
            this.println("</FONT>");
        }
    }

    public void writeHead() {
        this.html.head();
        this.html.title();
        if (this.docTitle != null) {
            this.html.println(this.docTitle);
        }
        this.html.titleEnd();
        this.writeHeadJavascript();
        this.html.headEnd();
    }

    public void writeParamTable() {
        this.writeParamTable(true);
    }

    public void writeParamTable(boolean getDistinctValue) {
        String tableDataBorderColorStr;
        this.writeParamTableOpenTag();
        String string = tableDataBorderColorStr = this.tableOuterBorderOnly ? " BORDERCOLOR=#" + QbUtil.escapeHTML(this.tableBackgroundColor) : "";
        if (this.paramPageLayout == 0) {
            this.write("<TR>");
            for (int i = 0; i < this.paramNameArr.length; ++i) {
                if (this.hiddenParameters[i]) continue;
                this.writeParamTableCategory(this.paramNameArr[i], tableDataBorderColorStr);
            }
            if (this.paramPageExportFormats != null && this.paramPageExportFormats.length > 1) {
                this.writeParamTableCategory("ExportFormat", tableDataBorderColorStr);
            }
            this.write("</TR>");
            this.write("<TR>");
        }
        this.writeParamTableMain(tableDataBorderColorStr, getDistinctValue);
        if (this.paramPageLayout == 1 && this.paramPageExportFormats != null && this.paramPageExportFormats.length > 1) {
            this.write("<TR>");
            this.write("\n\t<TD align=\"RIGHT\"" + tableDataBorderColorStr + ">Export Format</TD>");
            this.write("\n\t<TD " + tableDataBorderColorStr + ">");
            this.writePageExportFormats();
            this.write("</TD>");
            this.write("</TR>");
        }
        if (this.paramPageLayout == 0) {
            if (this.paramPageExportFormats != null && this.paramPageExportFormats.length > 1) {
                this.write("\n\t<TD " + tableDataBorderColorStr + ">");
                this.writePageExportFormats();
                this.write("</TD>");
            }
            this.write("</TR>");
        }
        this.write("<INPUT TYPE=\"hidden\" NAME=\"paramSetSize\" VALUE=\"" + this.paramNameArr.length + "\">");
        this.write(this.extraFormContent);
        this.writeParamTableCloseTag();
    }

    protected void writeParamTableMain(String tableDataBorderColorStr, boolean getDistinctValue) {
        Parameters params = this.page.getParameters();
        QueryInParam[] qip = null;
        if (this.page.getDbInfo() instanceof QueryFileInfo) {
            qip = (QueryInParam[])((QueryFileInfo)this.page.getDbInfo()).getInParam();
        }
        int size = params.size();
        boolean hasHiddenParam = false;
        QueryInParam[][] paramInPromptSequence = new QueryInParam[size][size];
        QueryInParam[] queryInParam = null;
        for (int i = 0; i < size && i < this.hiddenParameters.length; ++i) {
            int orderedIdx;
            Param p = null;
            for (orderedIdx = 0; orderedIdx < params.size(); ++orderedIdx) {
                if (!(params.get(orderedIdx) instanceof RootQueryParam) || qip == null || !params.get(orderedIdx).name().equals(qip[i].getParamName())) continue;
                p = params.get(orderedIdx);
                p.setSqlSelect(qip[i].getSqlSelect());
                p.setDefaultSql(qip[i].getDefaultSql());
                break;
            }
            if (!this.hiddenParameters[i]) continue;
            hasHiddenParam = true;
            String value = this.paramValueArr[i];
            queryInParam = (QueryInParam[])((QueryFileInfo)p.getQueryFileInfo()).getInParam();
            if (this.hiddenParamValues[i] != null) {
                if (this.hiddenParamValues[i] instanceof Vector) {
                    Vector vec = (Vector)this.hiddenParamValues[i];
                    for (int j = 0; j < vec.size(); ++j) {
                        value = j == 0 ? DataType.toString(vec.elementAt(j), this.paramDateFormat[i]) : value + ", " + DataType.toString(vec.elementAt(j), this.paramDateFormat[i]);
                    }
                } else {
                    value = DataType.toString(this.hiddenParamValues[i], this.paramDateFormat[i]);
                }
            }
            this.writeHiddenParamValue("paramValue_" + orderedIdx, value);
            p.setValue(value);
        }
        if (queryInParam != null) {
            new ParamUtil().setupParamInPromptSequence(queryInParam, (OrderedParameterSet)params, paramInPromptSequence);
        }
        String srvletContext = this.servletDirectory;
        try {
            srvletContext = Util.getServletContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int loc = srvletContext.lastIndexOf(47);
        String rootPath = srvletContext.substring(0, loc);
        int mainReportParamCt = 0;
        for (int i = 0; i < size; ++i) {
            QueryInParam qip2;
            int orderIndex = -1;
            if (params instanceof OrderedParameterSet && ((OrderedParameterSet)params).getOrderCount() > 1) {
                orderIndex = ((OrderedParameterSet)params).getOrder(i) + 1;
            }
            Param p = params.get(i);
            String paramID = "paramValue_" + i;
            if (p.multiValue()) {
                this.write("<tr><td colspan=\"4\" height=\"20\" align=\"right\" style=\"font-size:11px\">\n");
                this.write("<img src=\"" + rootPath + "/images/selectAll.png\" style=\"position:relative; top:1px; margin-top:0px; cursor:pointer;\" title=\"Select All\" onclick=\"selectAllItemsForReport('" + paramID + "',true,'" + p.name() + "'," + orderIndex + ");\"/>");
                this.write("<img src=\"" + rootPath + "/images/unselectAll.png\" style=\"position:relative; top:1px; margin-top:0px; cursor:pointer;\" title=\"Select None\" onclick=\"selectAllItemsForReport('" + paramID + "',false,'" + p.name() + "'," + orderIndex + ");\"/>");
                String paramAll = paramID + "_SelectAll";
                this.write("<INPUT TYPE=\"hidden\" NAME=\"" + paramAll + "\" VALUE=\"false\"/>");
                this.write("</td></tr>\n");
            }
            if (p instanceof RootQueryParam && mainReportParamCt < this.hiddenParameters.length) {
                int pIndexInOriginalSeq = -1;
                for (int j = 0; j < qip.length; ++j) {
                    if (!p.name().equals(qip[j].getParamName())) continue;
                    pIndexInOriginalSeq = j;
                    break;
                }
                if (pIndexInOriginalSeq > -1) {
                    if (this.hiddenParameters[pIndexInOriginalSeq]) {
                        ++mainReportParamCt;
                        continue;
                    }
                    ++mainReportParamCt;
                    if (hasHiddenParam) {
                        this.order = 1;
                        ((QueryFileInfo)p.getQueryFileInfo()).getInSet().setParameterInPromptSequence(paramInPromptSequence);
                    }
                }
            }
            if (this.paramPageLayout == 1) {
                this.html.tableRow();
                this.writeParamTableCategory(this.paramNameArr[i], tableDataBorderColorStr);
            }
            Vector<String> distinctValue = null;
            boolean isMultiValue = p.multiValue();
            if (getDistinctValue) {
                try {
                    if (p.getSqlSelect() != null && p.getSqlSelect().length() > 0 && !p.getSqlSelect().equalsIgnoreCase("null")) {
                        distinctValue = QueryParser.executeSQLSelect((IDatabaseInfo)p.getQueryFileInfo(), p.getSqlSelect().replace("<br>", ""), params, false);
                        if (p instanceof QueryParam && (qip2 = ((QueryParam)p).findParam()).isAllOptionEnabled() && qip2.getAllOptionLabel() != null) {
                            distinctValue.add(0, qip2.getAllOptionLabel());
                        }
                    } else if (p.getSelectionChoices() != null) {
                        distinctValue = p.getSelectionChoices();
                    } else if (p.isMapToColumn()) {
                        QueryInParam qip22;
                        Vector actualVals = null;
                        actualVals = p.getQueryFileInfo() instanceof QueryXMLFileInfo ? QueryParser.getDistinctValues(((QueryXMLFileInfo)p.getQueryFileInfo()).getXMLFileQueryInfo(), p.getColumnName(), this.order) : (ReportUtil.getParamInSequence(p.getQueryFileInfo()) != null ? QueryParser.getDistinctValues((QueryFileInfo)p.getQueryFileInfo(), p.getTableName(), p.getColumnName(), this.order) : QueryParser.getDistinctValues((QueryFileInfo)p.getQueryFileInfo(), p.getTableName(), p.getColumnName()));
                        if (p instanceof QueryParam && (qip22 = ((QueryParam)p).findParam()).isAllOptionEnabled() && qip22.getAllOptionLabel() != null) {
                            actualVals.add(0, qip22.getAllOptionLabel());
                        }
                        if (p.isCustomDateFormat()) {
                            Vector<String> promptVals = new Vector<String>();
                            for (int j = 0; j < actualVals.size(); ++j) {
                                if (actualVals.get(j) instanceof Date) {
                                    promptVals.add(QbDateFormat.getFormattedDateTime((Date)actualVals.get(j), p.getDateFormat()));
                                    continue;
                                }
                                promptVals.add((String)actualVals.get(j));
                            }
                            distinctValue = new Vector<String>();
                            distinctValue.add((String)((Object)promptVals));
                            distinctValue.add((String)((Object)actualVals));
                        } else {
                            distinctValue = actualVals;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (distinctValue != null) {
                String showMultiple = isMultiValue ? " MULTIPLE" : "";
                this.writeParamTableValues("paramValue_" + i, showMultiple, distinctValue, this.paramValueArr[i], tableDataBorderColorStr);
            } else {
                if (this.dateParameterSelection || this.dateParameterCalendar || this.dateVariable) {
                    this.writeParamTableValue("paramValue_" + i, this.paramValueArr[i], tableDataBorderColorStr, p);
                } else {
                    this.writeParamTableValue("paramValue_" + i, this.paramValueArr[i], tableDataBorderColorStr);
                }
                this.write("<input type=\"hidden\" name=\"paramType_" + i + "\" value=\"" + p.getSqlType() + "\"> \n");
                this.write("<input type=\"hidden\" name=\"paramDateFormat_" + i + "\" value=\"" + p.getDateFormat() + "\"> \n");
                if (p instanceof QueryParam && (qip2 = ((QueryParam)p).findParam()).isAllOptionEnabled() && qip2.getAllOptionLabel() != null) {
                    this.write("<input type=\"hidden\" name=\"paramAllOption_" + i + "\" value=\"" + qip2.getAllOptionLabel() + "\"> \n");
                }
            }
            if (this.paramPageLayout != 1) continue;
            this.write("</TR>");
        }
    }

    protected void writeBodyHeader() {
        if (this.header != null) {
            this.html.div();
            this.println(this.header);
            this.html.divEnd();
        }
    }

    protected void writeBodyFooter() {
        if (this.footer != null) {
            this.html.div();
            this.println(this.footer);
            this.html.divEnd();
        }
    }

    protected void writeParamTableOpenTag() {
        this.write("<TABLE id=\"paramTable\" valign=\"MIDDLE\"");
        if (this.tableBackgroundColor != null) {
            this.write(" bgcolor=#" + QbUtil.escapeHTML(this.tableBackgroundColor));
        }
        this.write(" border=\"" + this.tableBorderThickness + "\" ");
        if (this.tableBorderColor != null) {
            this.write(" bordercolor=\"#" + QbUtil.escapeHTML(this.tableBorderColor) + "\" ");
        }
        this.write("cellpadding=\"4\" cellspacing=\"0\">\n");
    }

    protected void writeParamTableCloseTag() {
        this.write("\n</TABLE>");
    }

    protected void writeParamTableCategory(String paramName, String tdAttributes) {
        this.println("\n\t<TD style=\"white-space:nowrap;\"align=\"CENTER\"" + tdAttributes + ">");
        this.writeParamName(paramName);
        this.html.tableDataEnd();
    }

    protected void writeParamName(String paramName) {
        if (this.textColor != null || this.textFont != null || this.textSize != -1) {
            this.println("<FONT COLOR=\"" + this.textColor + "\" FACE=\"" + this.textFont + "\" SIZE = \"" + this.textSize + "\">");
        }
        if ((this.textStyle & 1) != 0) {
            this.println("<B>");
        }
        if ((this.textStyle & 2) != 0) {
            this.println("<I>");
        }
        this.write(paramName);
        if ((this.textStyle & 1) != 0) {
            this.println("</B>");
        }
        if ((this.textStyle & 2) != 0) {
            this.println("</I>");
        }
        if (this.textColor != null || this.textFont != null || this.textSize != -1) {
            this.html.fontEnd();
        }
    }

    protected void writeParamTableValues(String name, String selectAttributes, Vector values, String paramValue, String tdAttributes) {
        this.write("\n\t<TD style=\"width:100%\" " + tdAttributes + "align=\"LEFT\">");
        this.writeParamValues(name, selectAttributes, values, paramValue);
        this.write("</TD>\n");
    }

    protected void writeParamTableValue(String name, String value, String tdAttributes) {
        this.write("\n\t<TD style=\"width:100%\" " + tdAttributes + "align=\"LEFT\">" + this.openFont);
        this.writeParamValue(name, value);
        this.write(this.closeFont + "</TD>\n");
    }

    protected void writeParamTableValue(String name, String value, String tdAttributes, Param param) {
        this.write("\n\t<td style=\"width:100%\" nowrap " + tdAttributes + "align=\"LEFT\">");
        this.writeParamValue(name, value, param);
        this.write("</td>\n");
    }

    protected void writeParamValue(String name, String value) {
        this.write("<INPUT TYPE=\"text\" ID=\"" + name + "\"  NAME=\"" + name + "\" VALUE=\"" + value + "\" SIZE=20 onClick='selectText(this);'>");
    }

    protected void writeHiddenParamValue(String name, String value) {
        this.write("<INPUT TYPE=\"hidden\" NAME=\"" + name + "\" VALUE=\"" + value + "\">");
    }

    protected void writeParamValueDate(String name, String value, Param param) {
        this.writeParamValue(name, value);
        if (!this.dateParameterSelection && param.isUnmapped()) {
            if (this.dateParameterCalendar && param.getSqlType() != 92) {
                this.printCalendarJavascript(name, param);
            }
            if (this.dateVariable) {
                this.printDateVariableJavascript(name);
            }
        }
    }

    protected void writeParamValue(String name, String value, Param param) {
        switch (param.getSqlType()) {
            case 91: 
            case 92: 
            case 93: {
                if (this.dateParameterSelection) {
                    this.printMonthSelection(name);
                    this.printDaySelection(name);
                    this.print(" / ");
                    this.print(" / ");
                    this.printYearSelection(name);
                    break;
                }
                this.writeParamValueDate(name, value, param);
                break;
            }
            default: {
                this.writeParamValue(name, value);
            }
        }
    }

    protected void writeParamValues(String name, String attributes, Vector values, String paramValue) {
        if (attributes.contains("MULTIPLE")) {
            this.println("<select id=\"" + name + "\" name=\"" + name + "\"" + attributes + ">");
            this.writeParamValuesOptions(values, paramValue);
            this.write("</select>");
        } else {
            CompleteParamPrompt cpp = this.writeParamValuesOptionsYUI(values, paramValue);
            this.println(AutoCompleteParam.getAutocompleteHTML(cpp.getValues(), cpp.getDefaultValue(), name, false));
        }
    }

    protected void writeParamValuesOptions(Vector values, String paramValue) {
        if (values.elementAt(0) instanceof Vector) {
            Vector promptValues = (Vector)values.elementAt(0);
            Vector sqlConditionValues = null;
            if (values.size() > 1) {
                sqlConditionValues = (Vector)values.elementAt(1);
            }
            for (int i = 0; i < promptValues.size(); ++i) {
                String promptValue;
                String sqlConditionValue = promptValue = promptValues.elementAt(i).toString();
                if (sqlConditionValues != null) {
                    sqlConditionValue = sqlConditionValues.elementAt(i).toString();
                }
                boolean dateMatch = false;
                if (this.contains(sqlConditionValue, paramValue) && values.size() > 1 && ((Vector)values.get(1)).get(i) instanceof Date && paramValue.equals(promptValues.get(i))) {
                    dateMatch = true;
                }
                if (this.contains(sqlConditionValue, paramValue) || dateMatch) {
                    this.write("\t\t<OPTION VALUE=\"" + QbUtil.escapeHTML(sqlConditionValue) + "\" SELECTED>" + QbUtil.escapeHTML(promptValue) + "</OPTION>\n");
                    continue;
                }
                this.write("\t\t<OPTION VALUE=\"" + QbUtil.escapeHTML(sqlConditionValue) + "\">" + QbUtil.escapeHTML(promptValue) + "</OPTION>\n");
            }
            return;
        }
        for (int j = 0; j < values.size(); ++j) {
            String distinctStrValue = values.elementAt(j).toString();
            String distinctString = values.elementAt(j).toString();
            if (this.contains(distinctStrValue, paramValue)) {
                this.write("\t\t<OPTION VALUE=\"" + QbUtil.escapeHTML(distinctString) + "\" SELECTED>" + QbUtil.escapeHTML(distinctString) + "</OPTION>\n");
                continue;
            }
            this.write("\t\t<OPTION VALUE=\"" + QbUtil.escapeHTML(distinctString) + "\">" + QbUtil.escapeHTML(distinctString) + "</OPTION>\n");
        }
    }

    protected CompleteParamPrompt writeParamValuesOptionsYUI(Vector values, String paramValue) {
        ParamPrompt defaultValue = new ParamPrompt("", "");
        ArrayList<ParamPrompt> vals = new ArrayList<ParamPrompt>();
        if (values.size() > 0 && values.elementAt(0) instanceof Vector) {
            Vector promptValues = (Vector)values.elementAt(0);
            Vector sqlConditionValues = null;
            if (values.size() > 1) {
                sqlConditionValues = (Vector)values.elementAt(1);
            }
            for (int i = 0; i < promptValues.size(); ++i) {
                String promptValue;
                String sqlConditionValue = promptValue = promptValues.elementAt(i).toString();
                if (sqlConditionValues != null) {
                    sqlConditionValue = sqlConditionValues.elementAt(i).toString();
                }
                boolean dateMatch = false;
                if (this.contains(sqlConditionValue, paramValue) && values.size() > 1 && ((Vector)values.get(1)).get(i) instanceof Date && paramValue.equals(promptValues.get(i))) {
                    dateMatch = true;
                }
                if (this.contains(sqlConditionValue, paramValue) || dateMatch) {
                    vals.add(new ParamPrompt(promptValue, sqlConditionValue));
                    defaultValue = new ParamPrompt(promptValue, sqlConditionValue);
                    continue;
                }
                vals.add(new ParamPrompt(promptValue, sqlConditionValue));
            }
            return new CompleteParamPrompt(vals, defaultValue);
        }
        for (int j = 0; j < values.size(); ++j) {
            String distinctStrValue = values.elementAt(j).toString();
            String distinctString = values.elementAt(j).toString();
            if (this.contains(distinctStrValue, paramValue)) {
                vals.add(new ParamPrompt(distinctString, distinctString));
                defaultValue = new ParamPrompt(distinctString, distinctString);
                continue;
            }
            vals.add(new ParamPrompt(distinctString, distinctString));
        }
        return new CompleteParamPrompt(vals, defaultValue);
    }

    private boolean contains(String key, String valuesList) {
        if (key.equalsIgnoreCase(valuesList)) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(valuesList, ",");
        while (st.hasMoreTokens()) {
            String value = st.nextToken().trim();
            if (!value.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    protected void writePageExportFormats() {
        this.write("<SELECT NAME=\"ExportFormat\">");
        this.write("\n\t<OPTION VALUE=\"" + this.paramPageExportFormats[0] + "\" SELECTED>" + this.paramPageExportFormats[0]);
        for (int i = 1; i < this.paramPageExportFormats.length; ++i) {
            this.write("\n\t<OPTION VALUE=\"" + this.paramPageExportFormats[i] + "\">" + this.paramPageExportFormats[i]);
        }
        this.write("\n\t</SELECT>");
    }

    protected void writeFormButtons() {
        this.writeSubmitButton();
        if (this.paramPageResetEnabled) {
            this.writeResetButton();
        }
    }

    protected void writeSubmitButton() {
        this.write("\n<INPUT TYPE=\"submit\" NAME=\"Submit\" VALUE=\"" + this.page.getSubmitDisplayName() + "\">");
    }

    protected void writeResetButton() {
        this.write("\n<INPUT TYPE=\"reset\" VALUE=\"" + this.page.getResetDisplayName() + "\">\n");
    }

    private void printMonthSelection(String name) {
        this.println("<SELECT name=\"" + QbUtil.escapeHTML(name) + "\">");
        for (int i = 0; i < MONTHS.length; ++i) {
            String value = i < 9 ? "0" + (i + 1) : String.valueOf(i + 1);
            this.println("<OPTION value=\"" + QbUtil.escapeHTML(value) + "\">" + MONTHS[i]);
        }
        this.println("</SELECT>");
    }

    private void printDaySelection(String name) {
        this.println("<SELECT name=\"" + QbUtil.escapeHTML(name) + "\">");
        for (int i = 0; i < 31; ++i) {
            String value = i < 9 ? "0" + (i + 1) : String.valueOf(i + 1);
            this.println("<OPTION value=\"" + QbUtil.escapeHTML(value) + "\">" + (i + 1));
        }
        this.println("</SELECT>");
    }

    private void printYearSelection(String name) {
        this.println("<INPUT name=\"" + QbUtil.escapeHTML(name) + "\" type=\"text\" size=\"4\" maxlength=\"4\">");
    }

    protected void printDateVariableJavascript(String name) {
        String dateVariableIcon = this.dateVariableDatepicker.endsWith("/") ? this.dateVariableDatepicker + "DateVariable.gif" : this.dateVariableDatepicker + "/DateVariable.gif";
        String title = "Set Date Variable";
        this.println("<img alt=\"" + title + "\" title = \"" + title + "\" src=\"" + dateVariableIcon + "\"  border=0 style=\"position:relative; left:2px;\" onclick=\"window.open('" + (this.dateVariableDatepicker.startsWith("..") ? "../" : "") + "DateVariableDialog.jsp?" + name + "', 'DateVariable', 'top=30, left=30, toolbar=no, directories=no, location=no, status=no, menubar=no, resizable=yes, scrollbars=yes, width=550, height=320');\" onmouseover=\"this.style.cursor='pointer';\">");
    }

    protected void printCalendarJavascript(String name, Param param) {
        String tempDateFormat;
        String dateFormat;
        String string = dateFormat = param.getSqlType() == 93 ? DEFAULT_TIMESTAMP_FORMAT : DEFAULT_DATE_FORMAT;
        if (param.isCustomDateFormat() && (tempDateFormat = param.getDateFormat()) != null) {
            dateFormat = tempDateFormat;
        }
        String datepickIcon = this.dateParameterCalendarDatepicker.endsWith("/") ? this.dateParameterCalendarDatepicker + "calendaricon.gif" : this.dateParameterCalendarDatepicker + "/calendaricon.gif";
        dateFormat = dateFormat.replace('h', '0');
        dateFormat = dateFormat.replace('H', '0');
        dateFormat = dateFormat.replace('m', '0');
        dateFormat = dateFormat.replace('s', '0');
        dateFormat = dateFormat.replace('S', '0');
        dateFormat = dateFormat.replace('M', 'm');
        String title = "Calendar";
        this.println("<img alt=\"" + title + "\" title = \"" + title + "\" src=\"" + datepickIcon + "\"  border=0 style=\"position:relative; left:2px;\" onclick=\"popUpCalendar(this, " + this.page.getParamFormName() + "." + name + ", '" + dateFormat + "', 0, 0)\" onmouseover=\"this.style.cursor='pointer';\">");
    }

    protected void writeHeadJavascript() {
        this.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.javaScriptLibPath + "/yui/build/fonts/fonts-min.css\" />");
        this.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.javaScriptLibPath + "/yui/build/button/assets/skins/sam/button.css\" />");
        this.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.javaScriptLibPath + "/yui/build/autocomplete/assets/skins/sam/autocomplete.css\" />");
        this.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.javaScriptLibPath + "/Autocomplete/autocomplete-custom-styles.css\" />");
        this.println("<script type=\"text/javascript\" src=\"" + this.javaScriptLibPath + "/yui/build/yahoo-dom-event/yahoo-dom-event.js\"></script>");
        this.println("<script type=\"text/javascript\" src=\"" + this.javaScriptLibPath + "/yui/build/animation/animation-min.js\"></script>");
        this.println("<script type=\"text/javascript\" src=\"" + this.javaScriptLibPath + "/yui/build/element/element-min.js\"></script>");
        this.println("<script type=\"text/javascript\" src=\"" + this.javaScriptLibPath + "/yui/build/button/button-min.js\"></script>");
        this.println("<script type=\"text/javascript\" src=\"" + this.javaScriptLibPath + "/yui/build/datasource/datasource-min.js\"></script>");
        this.println("<script type=\"text/javascript\" src=\"" + this.javaScriptLibPath + "/yui/build/autocomplete/autocomplete-min.js\"></script>");
        this.println("<script type=\"text/javascript\" src=\"" + this.javaScriptLibPath + "/jquery-1.11.2.min.js\"></script>");
        this.println("<script language='javascript' src='" + this.javaScriptLibPath + "/DataTypeValidator.js'></script>");
        this.println("<script language='javascript' src='" + this.javaScriptLibPath + "/selectAllNone.js'></script>");
        this.println("<SCRIPT LANGUAGE=\"javascript\">");
        this.println("  function calpopup(Ink){");
        this.println("    window.open(Ink,\"calendar\",\"height=250,width=250,scrollbars=no\")");
        this.println("  }");
        this.println("function validate() {\n");
        this.println("\tcheckSelectAll(); \n ");
        this.println("\tvar i = 0;\n");
        this.println("\twhile(document.getElementsByName(\"paramValue_\"+i)[0] != null) {");
        this.println("\t\tvar paramElem = document.getElementsByName(\"paramValue_\"+i)[0];");
        this.println("\t\tvar paramType = document.getElementsByName(\"paramType_\"+i)[0];");
        this.println("\t\tif(paramElem.selectedIndex && paramElem.selectedIndex == -1) {");
        this.println("\t\t\talert(\"Please select a value for each parameter\");");
        this.println("\t\t\treturn false;");
        this.println("\t\t} else {");
        this.println("\t\t\tvar validator = new DataTypeValidator();");
        this.println("\t\t\tvar paramDateFormat = document.getElementsByName(\"paramDateFormat_\"+i)[0];");
        this.println("\t\t\tvar paramAllOption = document.getElementsByName(\"paramAllOption_\"+i)[0];");
        this.println("\t\t\tif(paramElem.value != null && paramType != null && paramType.value != null &&");
        this.println("\t\t\t\t(paramElem.tagName == null || paramElem.tagName.toUpperCase() != \"SELECT\")) {");
        this.println("\t\t\t\tvar result = \"\";");
        this.println("\t\t\t\tif(paramAllOption != null && paramElem.value == paramAllOption.value)");
        this.println("\t\t\t\t\tresult = \"\";");
        this.println("\t\t\t\telse if(paramDateFormat != null)");
        this.println("\t\t\t\t\t\tresult = validator.checkType(paramElem.value, paramType.value, paramDateFormat.value);");
        this.println("\t\t\t\telse");
        this.println("\t\t\t\t\t\tresult = validator.checkType(paramElem.value, paramType.value, null);");
        this.println("\t\t\t\tif(result.length > 0) {");
        this.println("\t\t\t\t\talert(result);");
        this.println("\t\t\t\t\treturn false;");
        this.println("\t\t\t\t}");
        this.println("\t\t\t}");
        this.println("\t\t}");
        this.println("\t\ti++;");
        this.println("\t}");
        this.println("\treturn true;");
        this.println("}");
        this.println("function checkSelectAll(){ ");
        this.println("\tvar i = 0;\n");
        this.println("\twhile(document.getElementById(\"paramValue_\"+i) != null) { ");
        this.println("\t\tvar paramAll = \"paramValue_\" + i + \"_SelectAll\"; ");
        this.println("\t\tvar obj = document.getElementsByName(paramAll)[0]; ");
        this.println("\t\tif(obj != null) // only for multi-value parameter ");
        this.println("\t\t{ ");
        this.println("\t\t\tif (isSelectAll(\"paramValue_\"+i)){ ");
        this.println("\t\t\t\tobj.value = \"true\"; ");
        this.println("\t\t\t}else{ \n ");
        this.println("\t\t\t\tobj.value = \"false\";\t");
        this.println("\t\t\t} ");
        this.println("\t\t} ");
        this.println("\t\ti++; ");
        this.println("\t} ");
        this.println("} ");
        this.println("</SCRIPT>");
    }

    private void printBodyJavascript() {
        String datepickJS = this.dateParameterCalendarDatepicker.endsWith("/") ? this.dateParameterCalendarDatepicker + "popcalendar.js" : this.dateParameterCalendarDatepicker + "/popcalendar.js";
        this.println("<script language='javascript' src='" + datepickJS + "'></script>");
    }

    public String[] getParamDisplayNames() {
        return this.paramNameArr;
    }

    public void setParamDisplayNames(String[] names) {
        this.paramNameArr = names;
    }

    public void setJavaScriptLibPath(String javaScriptLibPath) {
        this.javaScriptLibPath = javaScriptLibPath;
    }

    public void setHiddenParameterValues(Object[] val) {
        this.hiddenParamValues = val;
    }

    protected String getServletName() {
        return this.servletName;
    }

    protected HtmlWriter getHtmlWriter() {
        return this.html;
    }

    public boolean[] getHiddenParameters() {
        return this.hiddenParameters;
    }

    public void setHiddenParameters(boolean[] state) {
        this.hiddenParameters = state;
    }
}

