/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.param;

import java.util.Vector;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.RootQueryParam;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;

public class ParamUtil {
    public IQueryInParam findSharedParamsInSubReport(String rptName, Parameter param, Report subreport) {
        Report subr = subreport;
        if (subr == null || subr.dbInfo == null || !(subr.dbInfo instanceof IQueryFileInfo)) {
            return null;
        }
        Vector<Parameter> subparams = subr.getQueryParameters();
        for (int k = 0; k < subparams.size(); ++k) {
            Parameter subparam = subparams.get(k);
            if (subparam == null || subparam.getSharedReportName() == null || subparam.getSharedParamName() == null || !subparam.getSharedReportName().equalsIgnoreCase(rptName) || !subparam.getSharedParamName().equals(param.getName())) continue;
            return this.getQueryInParamFromParameter(subreport, subparam);
        }
        return null;
    }

    public IQueryInParam getQueryInParamFromParameter(Report report, Parameter param) {
        IQueryInParam[] qip;
        if (report.dbInfo == null || !(report.dbInfo instanceof QueryFileInfo)) {
            return null;
        }
        QueryFileInfo qfi = (QueryFileInfo)report.dbInfo;
        for (IQueryInParam element : qip = qfi.getInParam()) {
            if (!element.getParamName().equals(param.getName())) continue;
            return element;
        }
        return null;
    }

    public void setupParamInPromptSequence(QueryInParam[] inParam, OrderedParameterSet allPromptParams, QueryInParam[][] paramInPromptSequence) {
        OrderedParameterSet ops = allPromptParams;
        int order = 0;
        for (int i = 0; i < ops.getOrderCount(); ++i) {
            boolean hasParamAtCurOrder = false;
            for (int j = 0; j < ops.getParamsAt(i).size(); ++j) {
                for (QueryInParam element : inParam) {
                    if (!element.getParamName().equals(ops.get(i, j).name()) || !(ops.get(i, j) instanceof RootQueryParam)) continue;
                    paramInPromptSequence[order][j] = element;
                    paramInPromptSequence[order][j].setValue(ops.get(i, j).getValue());
                    hasParamAtCurOrder = true;
                }
            }
            if (!hasParamAtCurOrder) continue;
            ++order;
        }
    }

    public Parameter getShareMapConflict(Report mainReport) {
        mainReport.setupSubReportParamMap();
        String[] map = null;
        for (int i = 0; mainReport.subReports != null && i < mainReport.subReports.size(); ++i) {
            map = this.getSubReportParameterMap(mainReport, i);
            Parameter conflict = this.checkForConflict(mainReport, i, map);
            if (conflict == null) continue;
            return conflict;
        }
        return null;
    }

    public Parameter checkForConflict(Report mainReport, int subIndex, String[] map) {
        if (map != null) {
            for (int mapI = 0; mapI < map.length; ++mapI) {
                Parameter p;
                if (map[mapI] == null || !this.isParamShared(p = this.getParam(mainReport, subIndex, mapI))) continue;
                return p;
            }
        }
        return null;
    }

    public static QueryInParamSet getQueryParamSet(QueryFileInfo queryFileInfo) {
        QueryInParam[][] pSeqOrig;
        IQueryInParam[] iqip = queryFileInfo.getInParam();
        QueryInParam[] queryInParam = new QueryInParam[iqip.length];
        String queryStr = queryFileInfo.getQuery();
        for (int i = 0; i < iqip.length; ++i) {
            queryInParam[i] = ParamUtil.castParam(iqip[i], queryStr);
        }
        QueryInParamSet paramSetOrig = queryFileInfo.getInSet();
        QueryInParamSet queryParamSet = new QueryInParamSet(queryInParam);
        if (paramSetOrig != null && (pSeqOrig = paramSetOrig.getParameterInPromptSequence()) != null) {
            queryParamSet.setParameterInPromptSequence(pSeqOrig);
        }
        return queryParamSet;
    }

    private static QueryInParam castParam(IQueryInParam iqip, String queryStr) {
        QueryInParam resultParam;
        if (iqip == null) {
            return null;
        }
        if (iqip instanceof IQueryMultiValueInParam) {
            IQueryMultiValueInParam rparam = (IQueryMultiValueInParam)iqip;
            resultParam = new QueryMultiValueInParam(rparam, queryStr);
        } else {
            resultParam = new QueryInParam(iqip, queryStr);
        }
        return resultParam;
    }

    private boolean isParamShared(Parameter p) {
        if (p.isShared() && p.getSharedReportName() != null && p.getSharedParamName() != null) {
            return true;
        }
        return p.getReferenceDegree() > 0;
    }

    private Parameter getParam(Report mainReport, int sub, int paramIndex) {
        Report[] subreports = mainReport.getSubReportArray(true);
        if (sub >= subreports.length || sub < 0) {
            return null;
        }
        Report r = subreports[sub];
        Vector<Parameter> qp = r.getQueryParameters();
        if (paramIndex < 0 || paramIndex >= qp.size()) {
            return null;
        }
        return qp.get(paramIndex);
    }

    private String[] getSubReportParameterMap(Report report, int subIndex) {
        if (report.subReports != null && subIndex > -1 && subIndex < report.subReports.size()) {
            return report.subReports.get(subIndex).getParameterMap();
        }
        return null;
    }
}

