/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.param;

import java.util.Iterator;
import java.util.Vector;
import quadbase.common.param.FormulaParam;
import quadbase.common.param.Param;
import quadbase.common.param.ParameterSet;
import quadbase.common.param.Parameters;
import quadbase.common.param.RootQueryParam;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class ParameterGrabber {
    public static Parameters getParameters(Report report) {
        if (report.getMaxParameterOrder() == 0) {
            return ParameterGrabber.getParameters(report, -1);
        }
        ParameterSet result = new ParameterSet();
        for (int i = 0; i <= report.getMaxParameterOrder(); ++i) {
            Parameters parameters = ParameterGrabber.getParameters(report, i);
            for (int j = 0; j < parameters.size(); ++j) {
                result.add(parameters.get(j));
            }
        }
        return result;
    }

    public static Parameters getParameters(Report report, int order) {
        Vector<Param> subReportParams;
        Vector<Parameter> formulaParams;
        ParameterSet result = new ParameterSet();
        Vector queryParams = ParameterGrabber.getAuthQueryParam(report, order);
        if (queryParams != null) {
            Iterator i = queryParams.iterator();
            while (i.hasNext()) {
                result.add((Param)i.next());
            }
        }
        if ((formulaParams = report.getFormulaParameters()) != null) {
            Iterator<Parameter> i = formulaParams.iterator();
            while (i.hasNext()) {
                FormulaParam param = new FormulaParam("Main_Report", i.next());
                param.setReport(report);
                result.add(param);
            }
        }
        if ((subReportParams = report.getNonSharedAvailableSubReportParamsAsParam(order)) != null) {
            Iterator<Param> i = subReportParams.iterator();
            while (i.hasNext()) {
                result.add(i.next());
            }
        }
        return result;
    }

    public static IQueryInParam[][] getParamInSequence(Report report) {
        int j;
        Vector level;
        int i;
        Report[] sreport;
        IQueryFileInfo queryInfo = (IQueryFileInfo)((Object)report.dbInfo);
        IQueryInParam[][] paramInSequence = ReportUtil.getParamInSequence(queryInfo);
        if (report.subReports == null || report.subReports.size() == 0) {
            return paramInSequence;
        }
        Vector<quadbase.reportdesigner.util.IQueryInParam[][]> vec = new Vector<quadbase.reportdesigner.util.IQueryInParam[][]>();
        for (Report element : sreport = report.getSubReportArray()) {
            vec.addElement(ReportUtil.getParamInSequence(element.dbInfo));
        }
        Vector<Vector> result = new Vector<Vector>();
        int max = 0;
        if (paramInSequence != null) {
            max = paramInSequence.length;
        }
        for (i = 0; i < max; ++i) {
            level = new Vector();
            if (paramInSequence != null && paramInSequence.length >= i) {
                for (j = 0; paramInSequence[i] != null && j < paramInSequence[i].length; ++j) {
                    if (paramInSequence[i][j] == null) continue;
                    level.addElement(paramInSequence[i][j]);
                }
            }
            for (j = 0; j < vec.size(); ++j) {
                IQueryInParam[][] ps = (IQueryInParam[][])vec.elementAt(j);
                if (ps == null && i == 0) {
                    quadbase.reportdesigner.util.IQueryInParam[] p = ReportUtil.getInParam(sreport[i].dbInfo);
                    for (int k = 0; p != null && k < p.length; ++k) {
                        if (p[i] == null) continue;
                        level.addElement(p[i]);
                    }
                }
                if (ps == null || ps.length <= i) continue;
                for (int k = 0; ps[i] != null && k < ps[i].length; ++k) {
                    if (ps[i][k] == null) continue;
                    level.addElement(ps[i][k]);
                }
            }
            result.add(level);
        }
        paramInSequence = new IQueryInParam[result.size()][];
        for (i = 0; i < result.size(); ++i) {
            level = (Vector)result.elementAt(i);
            if (level == null) continue;
            paramInSequence[i] = new IQueryInParam[level.size()];
            for (j = 0; j < level.size(); ++j) {
                paramInSequence[i][j] = (IQueryInParam)level.elementAt(j);
            }
        }
        return paramInSequence;
    }

    public static Parameters getParamsInSequence(Report report) {
        Parameters allPromptParams = ParameterGrabber.getParameters(report);
        IQueryFileInfo queryInfo = (IQueryFileInfo)((Object)report.dbInfo);
        quadbase.reportdesigner.util.IQueryInParam[][] paramInSequence = ReportUtil.getParamInSequence(queryInfo);
        if (paramInSequence == null) {
            return allPromptParams;
        }
        ParameterSet result = new ParameterSet();
        quadbase.reportdesigner.util.IQueryInParam[][] iQueryInParamArray = paramInSequence;
        int n = iQueryInParamArray.length;
        for (int i = 0; i < n; ++i) {
            quadbase.reportdesigner.util.IQueryInParam[] element;
            for (quadbase.reportdesigner.util.IQueryInParam element2 : element = iQueryInParamArray[i]) {
                if (element2 == null) continue;
                Param param = allPromptParams.get(element2.getParamName()).get(0);
                result.add(param);
            }
        }
        return result;
    }

    private static Vector getAuthQueryParam(Report report, int order) {
        if (report.dbInfo == null || !(report.dbInfo instanceof IQueryFileInfo)) {
            return null;
        }
        IQueryFileInfo queryInfo = (IQueryFileInfo)((Object)report.dbInfo);
        IQueryInParam[] queryParamSet = null;
        queryParamSet = queryInfo instanceof QueryFileInfo ? ((QueryFileInfo)queryInfo).getInParam() : ReportUtil.getInParam(queryInfo);
        IQueryInParam[] securityQueryParams = null;
        if (report.getPreviewSecurityLevel() != null && queryParamSet != null && report.getSecurityQueryParameterMap() != null) {
            securityQueryParams = QueryParser.verifyParameters(queryParamSet, (IQueryInParam[])report.getSecurityQueryParameterMap().get(report.getPreviewSecurityLevel()));
        }
        IQueryInParam[] unselectedParams = ReportUtil.getUnSelectedParams(queryParamSet, securityQueryParams, true);
        int queryCt = 0;
        if (queryParamSet != null) {
            queryCt = queryParamSet.length;
        }
        Vector<RootQueryParam> result = new Vector<RootQueryParam>();
        for (int i = 0; i < queryCt; ++i) {
            boolean isNotSelected = ReportUtil.queryParamIsNotSelected(queryParamSet[i], unselectedParams);
            if (!isNotSelected) continue;
            IQueryInParam[][] paramInSequence = ReportUtil.getParamInSequence(queryInfo);
            if (order > -1 && paramInSequence != null && ParameterGrabber.isNotEmpty(paramInSequence)) {
                for (int j = 0; j < paramInSequence[order].length; ++j) {
                    if (paramInSequence[order][j] == null || !paramInSequence[order][j].getParamName().equals(queryParamSet[i].getParamName())) continue;
                    RootQueryParam param = new RootQueryParam("Main_Report", queryParamSet[i]);
                    param.setQueryFileInfo((IQueryFileInfo)((Object)report.dbInfo));
                    param.setReport(report);
                    if (queryParamSet[i] instanceof QueryInParam) {
                        param.setDefaultValueVariable(((QueryInParam)queryParamSet[i]).getDefaultValueVariable());
                        param.setValueVariable(((QueryInParam)queryParamSet[i]).getValueVariable());
                        param.setSqlSelect(((QueryInParam)queryParamSet[i]).getSqlSelect());
                        param.setDefaultSql(((QueryInParam)queryParamSet[i]).getDefaultSql());
                    }
                    result.add(param);
                }
                continue;
            }
            if (order != -1 && order != 0) continue;
            RootQueryParam param = new RootQueryParam("Main_Report", queryParamSet[i]);
            param.setQueryFileInfo((IQueryFileInfo)((Object)report.dbInfo));
            param.setReport(report);
            if (queryParamSet[i] instanceof QueryInParam) {
                param.setDefaultValueVariable(((QueryInParam)queryParamSet[i]).getDefaultValueVariable());
                param.setValueVariable(((QueryInParam)queryParamSet[i]).getValueVariable());
                param.setSqlSelect(((QueryInParam)queryParamSet[i]).getSqlSelect());
                param.setDefaultSql(((QueryInParam)queryParamSet[i]).getDefaultSql());
            }
            result.add(param);
        }
        return result;
    }

    private static boolean isNotEmpty(IQueryInParam[][] paramInSequence) {
        IQueryInParam[][] iQueryInParamArray = paramInSequence;
        int n = iQueryInParamArray.length;
        for (int i = 0; i < n; ++i) {
            IQueryInParam[] element;
            for (IQueryInParam element2 : element = iQueryInParamArray[i]) {
                if (element2 == null) continue;
                return true;
            }
        }
        return false;
    }
}

