/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.param;

import java.awt.Color;
import java.io.IOException;
import java.io.StringWriter;
import quadbase.common.param.CssHtmlParameterPageWriter;
import quadbase.common.param.HtmlParameterPageWriter;
import quadbase.common.param.Parameters;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.internal.LanguageEncoder;

public abstract class ParameterPage {
    public static final int TABLE_LAYOUT_HORIZONTAL = 0;
    public static final int TABLE_LAYOUT_VERTICAL = 1;
    public static final int ALIGNMENT_CENTER = 0;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    protected Parameters params;
    private IQueryFileInfo dbInfo;
    private String servletName;
    private String[] paramPageExportFormats;
    private String targetLoc;
    private int format;
    private String extraFormContent;
    private int alignment;
    private String header;
    private String footer;
    private String tableBackgroundColor;
    private String tableBorderColor;
    private int tableBorderThickness = 1;
    private int paramPageLayout;
    private boolean tableOuterBorderOnly;
    private boolean paramPageResetEnabled;
    private String submitDisplayName = LanguageEncoder.getText("Submit");
    private String resetDisplayName = LanguageEncoder.getText("Reset");
    private String textColor;
    private String textFont;
    private int textSize = -1;
    private int textStyle = 0;
    private String titleText;
    private String titleTextColor;
    private String titleTextFont;
    private int titleTextSize = -1;
    private int titleTextStyle;
    private String backgroundImage;
    private String backgroundColor;
    private String docTitle;
    private String paramFormName;
    private boolean dateParameterSelection;
    private boolean dateParameterCalendar;
    private String dateParameterCalendarDatepicker;
    private boolean dateVariable;
    private String dateVariableDatepicker;
    private String javaScriptLibPath;
    private String onSubmit = null;

    public ParameterPage(Parameters params, IQueryFileInfo dbInfo, String servletName, String[] paramPageExportFormats, String targetLoc, int format, boolean paramPageResetEnabled, int paramPageLayout, String extraFormContent) {
        this.params = params;
        this.dbInfo = dbInfo;
        this.servletName = servletName;
        this.paramPageExportFormats = paramPageExportFormats;
        this.targetLoc = targetLoc;
        this.format = format;
        this.paramPageResetEnabled = paramPageResetEnabled;
        this.paramPageLayout = paramPageLayout;
        this.extraFormContent = extraFormContent;
        this.dateParameterSelection = false;
        this.dateParameterCalendar = false;
        this.dateVariable = false;
        this.paramFormName = "document.runreport";
    }

    public Parameters getParameters() {
        return this.params;
    }

    public IQueryFileInfo getDbInfo() {
        return this.dbInfo;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String[] getParamPageExportFormats() {
        return this.paramPageExportFormats;
    }

    public String getTargetLoc() {
        return this.targetLoc;
    }

    public int getFormat() {
        return this.format;
    }

    public String getExtraFormContent() {
        return this.extraFormContent;
    }

    public String toHtmlString() throws IOException {
        StringWriter str = new StringWriter();
        HtmlParameterPageWriter html = new HtmlParameterPageWriter(this, str);
        if (this.javaScriptLibPath != null) {
            html.setJavaScriptLibPath(this.javaScriptLibPath);
        }
        html.writePage();
        return str.toString();
    }

    public String toCssHtmlString(String cssFile) throws IOException {
        StringWriter str = new StringWriter();
        CssHtmlParameterPageWriter css = new CssHtmlParameterPageWriter(this, str);
        css.setCssFile(cssFile);
        css.writePage();
        return str.toString();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public Color getTableBackgroundColor() {
        return ParameterPage.toColor(this.tableBackgroundColor);
    }

    public void setTableBackgroundColor(Color color) {
        this.tableBackgroundColor = ParameterPage.toHtmlHexColor(color);
    }

    public String getTableBackgroundColorHex() {
        return this.tableBackgroundColor;
    }

    public void setTableBackgroundColor(String htmlHex) {
        this.tableBackgroundColor = htmlHex;
    }

    public Color getTableBorderColor() {
        return ParameterPage.toColor(this.tableBorderColor);
    }

    public void setTableBorderColor(Color color) {
        this.tableBorderColor = ParameterPage.toHtmlHexColor(color);
    }

    public String getTableBorderColorHex() {
        return this.tableBorderColor;
    }

    public void setTableBorderColor(String htmlHex) {
        this.tableBorderColor = htmlHex;
    }

    public int getTableBorderThickness() {
        return this.tableBorderThickness;
    }

    public void setTableBorderThickness(int thickness) {
        this.tableBorderThickness = thickness;
    }

    public int getTableLayout() {
        return this.paramPageLayout;
    }

    public void setTableLayout(int layout) {
        this.paramPageLayout = layout;
    }

    public boolean getTableOuterBorderOnly() {
        return this.tableOuterBorderOnly;
    }

    public void setTableOuterBorderOnly(boolean state) {
        this.tableOuterBorderOnly = state;
    }

    public boolean getResetEnabled() {
        return this.paramPageResetEnabled;
    }

    public void setResetEnabled(boolean state) {
        this.paramPageResetEnabled = state;
    }

    public String getTextColorHex() {
        return this.textColor;
    }

    public void setTextColor(String htmlHex) {
        this.textColor = htmlHex;
    }

    public Color getTextColor() {
        return ParameterPage.toColor(this.textColor);
    }

    public void setTextColor(Color color) {
        this.textColor = ParameterPage.toHtmlHexColor(color);
    }

    public String getTextFont() {
        return this.textFont;
    }

    public void setTextFont(String fontName) {
        this.textFont = fontName;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int size) {
        this.textSize = size;
    }

    public int getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(int style) {
        this.textStyle = style;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String title) {
        this.titleText = title;
    }

    public Color getTitleTextColor() {
        return ParameterPage.toColor(this.titleTextColor);
    }

    public void setTitleTextColor(Color color) {
        this.titleTextColor = ParameterPage.toHtmlHexColor(color);
    }

    public String getTitleTextColorHex() {
        return this.titleTextColor;
    }

    public void setTitleTextColor(String htmlHex) {
        this.titleTextColor = htmlHex;
    }

    public String getTitleTextFont() {
        return this.titleTextFont;
    }

    public void setTitleTextFont(String fontName) {
        this.titleTextFont = fontName;
    }

    public int getTitleTextSize() {
        return this.titleTextSize;
    }

    public void setTitleTextSize(int size) {
        this.titleTextSize = size;
    }

    public int getTitleTextStyle() {
        return this.titleTextStyle;
    }

    public void setTitleTextStyle(int style) {
        this.titleTextStyle = style;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(String imagePath) {
        this.backgroundImage = imagePath;
    }

    public String getBackgroundColorHex() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String htmlHex) {
        this.backgroundColor = htmlHex;
    }

    public Color getBackgroundColor() {
        return ParameterPage.toColor(this.backgroundColor);
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = ParameterPage.toHtmlHexColor(color);
    }

    public String getDocumentTitle() {
        return this.docTitle;
    }

    public void setDocumentTitle(String docTitle) {
        this.docTitle = docTitle;
    }

    private static Color toColor(String hexRgb) {
        return new Color(Integer.parseInt(hexRgb, 16));
    }

    private static String toHtmlHexColor(Color color) {
        String temp = Integer.toHexString(color.getRGB());
        return temp.substring(temp.length() - 6, temp.length());
    }

    public void setDateParameterSelection(boolean state) {
        this.dateParameterSelection = state;
    }

    public boolean getDateParameterSelection() {
        return this.dateParameterSelection;
    }

    public void setJavaScriptLibPath(String javaScriptLibPath) {
        this.javaScriptLibPath = javaScriptLibPath;
    }

    public void setDateParameterCalendar(boolean state, String datepicker) {
        this.dateParameterCalendar = state;
        this.dateParameterCalendarDatepicker = datepicker;
    }

    public boolean getDateParameterCalendar() {
        return this.dateParameterCalendar;
    }

    public String getDateParameterCalendarDatepicker() {
        return this.dateParameterCalendarDatepicker;
    }

    public void setDateVariable(boolean state, String datepicker) {
        this.dateVariable = state;
        this.dateVariableDatepicker = datepicker;
    }

    public boolean getDateVariable() {
        return this.dateVariable;
    }

    public String getDateVariableDatepicker() {
        return this.dateVariableDatepicker;
    }

    public void setSubmitDisplayName(String name) {
        this.submitDisplayName = name;
    }

    public String getSubmitDisplayName() {
        return this.submitDisplayName;
    }

    public void setResetDisplayName(String name) {
        this.resetDisplayName = name;
    }

    public String getResetDisplayName() {
        return this.resetDisplayName;
    }

    public void setParamFormName(String paramFormName) {
        this.paramFormName = paramFormName;
    }

    public String getParamFormName() {
        if (this.paramFormName == null || this.paramFormName.equals("")) {
            return "document.runreport";
        }
        return this.paramFormName;
    }

    public String getOnSubmit() {
        return this.onSubmit;
    }

    public void setOnSubmit(String onSubmit) {
        this.onSubmit = onSubmit;
    }
}

