/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.param;

import java.util.Vector;
import quadbase.common.param.QueryParamObj;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class ReportParamSet {
    Vector<Parameter> formParams;
    Vector<Vector<QueryParamObj>> paramObjs;
    String name;
    QueryParamObj[] paramsInOrigSequence;

    public ReportParamSet(Report report, String name, Object array, String securityLevel) {
        this(report, name, array, securityLevel, null);
    }

    public ReportParamSet(Report report, String name, Object array, String securityLevel, Report mainReport) {
        this.formParams = report.getFormulaParameters();
        this.name = name;
        if (report.dbInfo == null || !(report.dbInfo instanceof IQueryFileInfo)) {
            return;
        }
        IQueryFileInfo queryInfo = (IQueryFileInfo)((Object)report.dbInfo);
        Object paramInSequence = null;
        paramInSequence = queryInfo instanceof QueryFileInfo ? ((QueryFileInfo)queryInfo).getInSet().getParameterInPromptSequence() : ReportUtil.getParamInSequence(queryInfo);
        boolean paramInSeqAllNull = true;
        block0: for (int i = 0; paramInSequence != null && i < ((IQueryInParam[][])paramInSequence).length; ++i) {
            for (int j = 0; paramInSequence[i] != null && j < paramInSequence[i].length; ++j) {
                if (paramInSequence[i][j] == null) continue;
                paramInSeqAllNull = false;
                continue block0;
            }
        }
        if (paramInSequence == null || paramInSeqAllNull) {
            IQueryInParam[] queryParamSet = ((QueryFileInfo)queryInfo).getInParam();
            if (queryParamSet == null) {
                return;
            }
            paramInSequence = new IQueryInParam[1][queryParamSet.length];
            for (int i = 0; i < queryParamSet.length; ++i) {
                paramInSequence[0][i] = queryParamSet[i];
            }
        }
        Vector<Parameter> parameters = null;
        if (mainReport == null) {
            parameters = report.getQueryParameters();
        } else {
            Parameter[] params = mainReport.subQueryParamTable.get(name);
            Vector<Parameter> tmpParams = report.getQueryParameters();
            parameters = new Vector();
            for (int i = 0; i < tmpParams.size(); ++i) {
                boolean found = false;
                for (Parameter param : params) {
                    if (!tmpParams.get(i).getName().equals(param.getName())) continue;
                    parameters.add(param);
                    found = true;
                    break;
                }
                if (found) continue;
                parameters.add(tmpParams.get(i));
            }
        }
        this.setup((IQueryInParam[][])paramInSequence, parameters, name);
        IQueryInParam[] queryParamSet = null;
        queryParamSet = queryInfo instanceof QueryFileInfo ? ((QueryFileInfo)queryInfo).getInParam() : ReportUtil.getInParam(queryInfo);
        IQueryInParam[] securityQueryParams = null;
        if (securityLevel != null && queryParamSet != null && report.getSecurityQueryParameterMap() != null) {
            securityQueryParams = QueryParser.verifyParameters(queryParamSet, (IQueryInParam[])report.getSecurityQueryParameterMap().get(securityLevel));
        }
        IQueryInParam[] unselectedParams = ReportUtil.getUnSelectedParams(queryParamSet, securityQueryParams, true);
        for (int i = 0; i < this.paramsInOrigSequence.length; ++i) {
            String[] srmap;
            boolean selected = true;
            for (int j = 0; unselectedParams != null && j < unselectedParams.length; ++j) {
                if (!this.paramsInOrigSequence[i].getQueryInParam().getParamName().equals(unselectedParams[j].getParamName()) || this.paramsInOrigSequence[i].getQueryInParam().getSqlType() != unselectedParams[j].getSqlType()) continue;
                selected = false;
            }
            if (!selected && array instanceof String[] && i < (srmap = (String[])array).length && srmap[i] != null) {
                selected = true;
            }
            if (!selected) continue;
            this.paramsInOrigSequence[i].setSelected(true);
        }
    }

    public void setup(IQueryInParam[][] queryInParamSet, Vector<Parameter> shareParamVect, String reportName) {
        this.paramObjs = new Vector();
        this.paramsInOrigSequence = new QueryParamObj[shareParamVect.size()];
        for (int i = 0; i < queryInParamSet.length; ++i) {
            Vector<QueryParamObj> innerShareParam = new Vector<QueryParamObj>();
            block1: for (int j = 0; j < queryInParamSet[i].length; ++j) {
                if (queryInParamSet[i][j] == null) continue;
                for (int k = 0; k < shareParamVect.size(); ++k) {
                    Parameter p_k = shareParamVect.get(k);
                    if (!p_k.getName().equals(queryInParamSet[i][j].getParamName()) || p_k.getSQLType() != queryInParamSet[i][j].getSqlType() && queryInParamSet[i][j].getSqlType() != -1) continue;
                    QueryParamObj qPObj = new QueryParamObj(queryInParamSet[i][j], shareParamVect.get(k), reportName, i, j);
                    innerShareParam.add(qPObj);
                    this.paramsInOrigSequence[k] = qPObj;
                    continue block1;
                }
            }
            if (innerShareParam.size() <= 0) continue;
            this.paramObjs.add(innerShareParam);
        }
    }

    public IQueryInParam getQueryInParam(int order, int index) {
        if (this.paramObjs == null || this.paramObjs.size() == 0) {
            return null;
        }
        return this.paramObjs.get(order).get(index).getQueryInParam();
    }

    public Parameter getParameter(int order, int index) {
        if (this.paramObjs == null || this.paramObjs.size() == 0) {
            return null;
        }
        return this.paramObjs.get(order).get(index).getParameter();
    }

    public int getMaxOrder() {
        if (this.paramObjs == null || this.paramObjs.size() == 0) {
            return -1;
        }
        return this.paramObjs.size() - 1;
    }

    public int getOrderCount() {
        if (this.paramObjs == null || this.paramObjs.size() == 0) {
            return 0;
        }
        return this.paramObjs.size();
    }

    public int getParamCountAt(int order) {
        if (this.paramObjs == null || this.paramObjs.get(order) == null) {
            return 0;
        }
        return this.paramObjs.get(order).size();
    }

    public String getReportName() {
        return this.name;
    }

    public QueryParamObj[] getParamsInOrigSequence() {
        return this.paramsInOrigSequence;
    }

    public QueryParamObj getParamObj(int order, int index) {
        if (this.paramObjs == null || this.paramObjs.size() == 0) {
            return null;
        }
        return this.paramObjs.get(order).get(index);
    }

    public Vector<Parameter> getFormulaParams() {
        return this.formParams;
    }
}

