/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import quadbase.common.client.ReadDBparamMeta;
import quadbase.common.client.ReadSFparamMeta;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryParser;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IJNDIDatabaseInfo;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.SalesForceConnection;
import quadbase.querybuilder.query.QueryBuilder;

public class AvailColumn {
    String tableName;
    String columnName;
    int sqlType;
    boolean defaultColumn;

    AvailColumn(String tableName, String columnName, int sqlType, boolean defaultColumn) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.sqlType = sqlType;
        this.defaultColumn = defaultColumn;
    }

    public void write(DataOutputStream dout) throws IOException {
        IOUtil.writeString(dout, Coder.encode(this.tableName));
        IOUtil.writeString(dout, Coder.encode(this.columnName));
        dout.writeInt(this.sqlType);
        dout.writeBoolean(this.defaultColumn);
    }

    public static AvailColumn read(DataInputStream din) throws IOException {
        String tableName = Coder.decode(IOUtil.readString(din, true));
        String columnName = Coder.decode(IOUtil.readString(din, true));
        int sqlType = din.readInt();
        boolean defaultColumn = din.readBoolean();
        return new AvailColumn(tableName, columnName, sqlType, defaultColumn);
    }

    public static Vector makeArray(DBInfoBasic dbInfo, String paramName) throws Exception {
        if (dbInfo.isUseJNDIDataSource()) {
            return AvailColumn.makeArray((IJNDIDatabaseInfo)dbInfo, paramName);
        }
        return AvailColumn.makeArray((IDatabaseInfo)dbInfo, paramName);
    }

    public static Vector makeArray(IJNDIDatabaseInfo dbInfo, String paramName) throws Exception {
        if (ServerMessage.useServer) {
            return ReadDBparamMeta.getMeta(dbInfo, paramName);
        }
        return AvailColumn.makeFromLocal(dbInfo, paramName);
    }

    public static Vector makeArray(IDatabaseInfo dbInfo, String paramName) throws Exception {
        if (ServerMessage.useServer) {
            return ReadDBparamMeta.getMeta(dbInfo, paramName);
        }
        return AvailColumn.makeFromLocal(dbInfo, paramName);
    }

    public static Vector makeArray(SalesForceQueryFileInfo sfQueryInfo, String paramName) throws Exception {
        if (ServerMessage.useServer) {
            return ReadSFparamMeta.getMeta(sfQueryInfo, paramName);
        }
        return AvailColumn.makeFromLocal(sfQueryInfo, paramName);
    }

    public static synchronized Vector makeFromLocal(DBInfoBasic dbInfo, String paramName) throws Exception {
        if (dbInfo.isUseJNDIDataSource()) {
            return AvailColumn.makeFromLocal((IJNDIDatabaseInfo)dbInfo, paramName);
        }
        return AvailColumn.makeFromLocal((IDatabaseInfo)dbInfo, paramName);
    }

    private static synchronized Vector makeFromLocal(IDatabaseInfo dbInfo, String paramName) throws Exception {
        String query = dbInfo.getQuery();
        String[] tableNames = QueryParser.getAllTableNames(query, false);
        if (tableNames == null) {
            return new Vector();
        }
        Vector columnVector = QueryParser.getColumnName(query, paramName);
        Vector<AvailColumn> buffer = new Vector<AvailColumn>();
        Class.forName(dbInfo.getDriverName());
        Connection con = DriverManager.getConnection(dbInfo.getURLString(), dbInfo.getUserID(), dbInfo.getPassword());
        boolean findColumn = false;
        int columnVectorSize = columnVector.size();
        int dbType = QueryBuilder.mapDatabaseType(con.getMetaData().getDatabaseProductName());
        for (String tableName2 : tableNames) {
            Object[][] columnInfo = null;
            try {
                columnInfo = AvailColumn.getMetaDataForTable(tableName2, con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (columnInfo == null || columnInfo.length == 0) continue;
            for (Object[] element : columnInfo) {
                int sqlType = (Integer)element[1];
                String columnName = (String)element[0];
                columnName = QueryBuilder.print(dbType, columnName);
                if (!findColumn) {
                    for (int k = 0; k < columnVectorSize; ++k) {
                        if (!columnName.equalsIgnoreCase((String)columnVector.elementAt(k))) continue;
                        buffer.addElement(new AvailColumn(tableName2, columnName, sqlType, true));
                        findColumn = true;
                        break;
                    }
                    if (findColumn) continue;
                    buffer.addElement(new AvailColumn(tableName2, columnName, sqlType, false));
                    continue;
                }
                buffer.addElement(new AvailColumn(tableName2, columnName, sqlType, false));
            }
        }
        con.close();
        return buffer;
    }

    private static synchronized Vector makeFromLocal(IJNDIDatabaseInfo dbInfo, String paramName) throws Exception {
        String query = dbInfo.getQuery();
        String[] tableNames = QueryParser.getAllTableNames(query, false);
        if (tableNames == null) {
            return new Vector();
        }
        Vector columnVector = QueryParser.getColumnName(query, paramName);
        Vector<AvailColumn> buffer = new Vector<AvailColumn>();
        Connection con = dbInfo.openConnection();
        boolean findColumn = false;
        int columnVectorSize = columnVector.size();
        for (String tableName2 : tableNames) {
            Object[][] columnInfo = null;
            try {
                columnInfo = AvailColumn.getMetaDataForTable(tableName2, con);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (columnInfo == null || columnInfo.length == 0) continue;
            for (Object[] element : columnInfo) {
                int sqlType = (Integer)element[1];
                String columnName = (String)element[0];
                if (!findColumn) {
                    for (int k = 0; k < columnVectorSize; ++k) {
                        if (!columnName.equalsIgnoreCase((String)columnVector.elementAt(k))) continue;
                        buffer.addElement(new AvailColumn(tableName2, columnName, sqlType, true));
                        findColumn = true;
                        break;
                    }
                    if (findColumn) continue;
                    buffer.addElement(new AvailColumn(tableName2, columnName, sqlType, false));
                    continue;
                }
                buffer.addElement(new AvailColumn(tableName2, columnName, sqlType, false));
            }
        }
        con.close();
        return buffer;
    }

    public static synchronized Vector makeFromLocal(SalesForceQueryFileInfo sfQueryInfo, String paramName) throws Exception {
        SalesForceConnection conn = sfQueryInfo.getSalesForceConnection();
        String query = sfQueryInfo.getQuery();
        String[] tableNames = SalesForceQueryParser.getAllTableNames(query, conn);
        boolean findColumn = false;
        String firstMatchingColumn = SalesForceQueryParser.getFirstMatchingColumnName(query, paramName);
        if (firstMatchingColumn.indexOf(46) < 0) {
            firstMatchingColumn = SalesForceQueryParser.getDefaultTableName(query) + "." + firstMatchingColumn;
        }
        Vector<AvailColumn> result = new Vector<AvailColumn>();
        for (String tableName2 : tableNames) {
            String[] columnNames;
            for (String columnName2 : columnNames = conn.getFieldNames(tableName2)) {
                String columnName;
                AvailColumn ac = new AvailColumn(tableName2, columnName2, conn.getColumnDataType(tableName2, columnName2), false);
                if (!findColumn && (columnName = tableName2 + "." + columnName2).equals(firstMatchingColumn)) {
                    findColumn = true;
                    ac.setDefaultColumn(true);
                }
                result.add(ac);
            }
        }
        if (!findColumn) {
            int lastDot = firstMatchingColumn.lastIndexOf(46);
            if (lastDot > -1) {
                firstMatchingColumn = firstMatchingColumn.substring(lastDot + 1);
            }
            for (AvailColumn ac : result) {
                if (!ac.getColumnName().equals(firstMatchingColumn)) continue;
                ac.setDefaultColumn(true);
                break;
            }
        }
        return result;
    }

    public String getCompleteName() {
        return this.tableName + "." + this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String toString() {
        return "tableName:" + this.tableName + ", columnName:" + this.columnName + ", sqlType:" + this.sqlType;
    }

    public boolean isDefaultColumn() {
        return this.defaultColumn;
    }

    public void setDefaultColumn(boolean defaultColumn) {
        this.defaultColumn = defaultColumn;
    }

    private static Object[][] getMetaDataForTable(String tableName, Connection conn) throws Exception {
        block77: {
            Object[][] objectArray;
            Statement stmt = null;
            ResultSet rs = null;
            PreparedStatement ps = null;
            try {
                String query = "SELECT * FROM " + tableName + " WHERE 1=2";
                try {
                    if (conn.getMetaData().getDatabaseProductName().toLowerCase().indexOf("mysql") >= 0) {
                        query = "SELECT * FROM " + tableName + " LIMIT 0, 1";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ResultSetMetaData rsmd = null;
                try {
                    ps = conn.prepareStatement(query);
                    rsmd = ps.getMetaData();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (rsmd == null) {
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(query);
                    rsmd = rs.getMetaData();
                }
                int nColumn = rsmd.getColumnCount();
                Object[][] tempResult = new Object[nColumn][];
                for (int j = 1; j <= nColumn; ++j) {
                    Object[] row = new Object[2];
                    int sqlType = rsmd.getColumnType(j);
                    if (!rsmd.isSigned(j)) {
                        sqlType = DataType.convertUnsigned(sqlType);
                    }
                    row[1] = sqlType;
                    row[0] = rsmd.getColumnName(j);
                    tempResult[j - 1] = row;
                }
                if (ps != null) {
                    ps.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                Object[][] objectArray2 = tempResult;
                return objectArray2;
            }
            catch (SQLException query) {
            }
            catch (OutOfMemoryError query) {
            }
            catch (Exception ex1) {
                throw ex1;
            }
            catch (Error err1) {
                throw err1;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception exception) {}
            }
            try {
                Object[] row;
                DatabaseMetaData metaData = conn.getMetaData();
                rs = metaData.getColumns(null, null, tableName, null);
                Vector<Object[]> tempResult = new Vector<Object[]>();
                while (rs.next()) {
                    row = new Object[]{rs.getString(4), rs.getInt(5)};
                    tempResult.addElement(row);
                }
                if (tempResult.size() == 0) {
                    rs.close();
                    row = null;
                    return row;
                }
                Object[][] result = new Object[tempResult.size()][];
                for (int i = 0; i < tempResult.size(); ++i) {
                    result[i] = (Object[])tempResult.elementAt(i);
                }
                rs.close();
                objectArray = result;
            }
            catch (SQLException metaData) {
                break block77;
            }
            catch (OutOfMemoryError metaData) {
                break block77;
            }
            catch (Exception ex1) {
                throw ex1;
            }
            catch (Error err1) {
                throw err1;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {}
            }
            return objectArray;
        }
        return null;
    }
}

