/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.formula.Formula;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.ICustomParameterDateFormat;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.IQueryParamValuesProvider;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.common.util.internal.XMLUtil;
import quadbase.util.internal.QbUtil;

public class QueryInParam
implements IQueryInParam,
IQueryParamValuesProvider,
ICustomParameterDateFormat,
Cloneable {
    int[] paramIndexMap;
    String paramName;
    String promptName;
    String tableName;
    String columnName;
    Object defaultValue;
    Object value;
    int sqlType;
    boolean mapToColumn;
    boolean mapToFunction = false;
    public static final String XMLTAG = "PARAMETER";
    private Vector selectionValues = null;
    private String sqlSelect = null;
    protected String defaultSql = null;
    private String allOptionLabel = null;
    private boolean allOptionEnabled = false;
    private String dateFormat = null;
    Formula defaultValueVariable;
    Formula valueVariable;

    protected QueryInParam() {
    }

    public QueryInParam(String paramName, String pathStr) {
        this.paramName = paramName;
        this.columnName = pathStr;
    }

    public QueryInParam(int[] paramIndexMap, String paramName, String promptName, boolean mapToColumn, boolean mapToFunction, String tableName, String columnName, int sqlType, Object defaultValue, String defaultSql, boolean allOptionEnabled, String allOptionLabel, Object value) {
        this.paramIndexMap = paramIndexMap;
        this.paramName = paramName;
        this.promptName = promptName;
        this.mapToColumn = mapToColumn;
        this.mapToFunction = mapToFunction;
        this.tableName = tableName;
        this.columnName = columnName;
        this.sqlType = sqlType;
        this.defaultSql = defaultSql;
        this.allOptionEnabled = allOptionEnabled;
        this.allOptionLabel = allOptionLabel;
        if (defaultValue instanceof Formula) {
            this.defaultValueVariable = (Formula)defaultValue;
        } else {
            this.defaultValue = defaultValue;
        }
        if (value instanceof Formula) {
            this.valueVariable = (Formula)value;
        } else {
            this.value = value;
        }
    }

    public QueryInParam(int[] paramIndexMap, String paramName, String promptName, boolean mapToColumn, String tableName, String columnName, int sqlType, Object defaultValue, Object value) {
        this(paramIndexMap, paramName, promptName, mapToColumn, tableName, columnName, sqlType, defaultValue, null, false, null, value);
    }

    public QueryInParam(int[] paramIndexMap, String paramName, String promptName, boolean mapToColumn, String tableName, String columnName, int sqlType, Object defaultValue, String defaultSql, Object value) {
        this(paramIndexMap, paramName, promptName, mapToColumn, tableName, columnName, sqlType, defaultValue, defaultSql, false, null, value);
    }

    public QueryInParam(int[] paramIndexMap, String paramName, String promptName, boolean mapToColumn, String tableName, String columnName, int sqlType, Object defaultValue, String defaultSql, boolean allOptionEnabled, String allOptionLabel, Object value) {
        this.paramIndexMap = paramIndexMap;
        this.paramName = paramName;
        this.promptName = promptName;
        this.mapToColumn = mapToColumn;
        this.mapToFunction = false;
        this.tableName = tableName;
        this.columnName = columnName;
        this.sqlType = sqlType;
        this.defaultSql = defaultSql;
        this.allOptionEnabled = allOptionEnabled;
        this.allOptionLabel = allOptionLabel;
        if (defaultValue instanceof Formula) {
            this.defaultValueVariable = (Formula)defaultValue;
        } else {
            this.defaultValue = defaultValue;
        }
        if (value instanceof Formula) {
            this.valueVariable = (Formula)value;
        } else {
            this.value = value;
        }
    }

    public QueryInParam(IQueryInParam p, String query) {
        this.paramName = p.getParamName();
        this.promptName = p.getPromptName();
        this.mapToColumn = p.isMapToColumn();
        if (p instanceof QueryInParam) {
            this.mapToFunction = ((QueryInParam)p).isMapToFunctionOnly();
            this.sqlSelect = ((QueryInParam)p).getSqlSelect();
            this.defaultSql = ((QueryInParam)p).getDefaultSql();
            this.allOptionEnabled = ((QueryInParam)p).isAllOptionEnabled();
            this.allOptionLabel = ((QueryInParam)p).getAllOptionLabel();
            this.defaultValueVariable = ((QueryInParam)p).getDefaultValueVariable();
        } else if (p instanceof QbUtil.CQueryInParam) {
            this.mapToFunction = ((QbUtil.CQueryInParam)p).isMapToFunctionOnly();
            this.sqlSelect = ((QbUtil.CQueryInParam)p).getSqlSelect();
            this.defaultSql = ((QbUtil.CQueryInParam)p).getDefaultSql();
            this.allOptionEnabled = ((QbUtil.CQueryInParam)p).isAllOptionEnabled();
            this.allOptionLabel = ((QbUtil.CQueryInParam)p).getAllOptionLabel();
            this.defaultValueVariable = ((QbUtil.CQueryInParam)p).getDefaultValueVariable();
        } else if (p instanceof QbUtil.CQueryMultiValueInParam) {
            this.mapToFunction = ((QbUtil.CQueryMultiValueInParam)p).isMapToFunctionOnly();
            this.sqlSelect = ((QbUtil.CQueryMultiValueInParam)p).getSqlSelect();
            this.defaultSql = ((QbUtil.CQueryMultiValueInParam)p).getDefaultSql();
            this.allOptionEnabled = ((QbUtil.CQueryMultiValueInParam)p).isAllOptionEnabled();
            this.allOptionLabel = ((QbUtil.CQueryMultiValueInParam)p).getAllOptionLabel();
            this.defaultValueVariable = ((QbUtil.CQueryMultiValueInParam)p).getDefaultValueVariable();
        } else if (p instanceof quadbase.datasource.util.QueryInParam) {
            quadbase.datasource.util.QueryInParam qip = (quadbase.datasource.util.QueryInParam)p;
            this.sqlSelect = qip.getSqlSelect();
            this.defaultSql = qip.getDefaultSql();
            this.allOptionEnabled = qip.isAllOptionEnabled();
            this.allOptionLabel = qip.getAllOptionLabel();
            this.defaultValueVariable = qip.getDefaultValueVariable();
        } else {
            this.mapToFunction = false;
            this.sqlSelect = null;
            this.defaultSql = null;
            this.defaultValueVariable = null;
        }
        this.tableName = p.getTableName();
        this.columnName = p.getColumnName();
        this.sqlType = p.getSqlType();
        this.defaultValue = p.getDefaultValue();
        this.value = p.getValue();
        if (p instanceof QueryInParam) {
            this.paramIndexMap = ((QueryInParam)p).getParamIndexMap();
        } else {
            String[] names = QueryParser.getAllParameters(query);
            this.paramIndexMap = null;
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (!names[i].equals(this.paramName)) continue;
                    this.paramIndexMap = QueryInParamSet.makeParamMap(query)[i];
                }
            } else {
                this.paramIndexMap = new int[0];
            }
        }
        if (p instanceof IQueryParamValuesProvider) {
            this.selectionValues = ((IQueryParamValuesProvider)((Object)p)).getSelectionChoices();
        }
        if (p instanceof ICustomParameterDateFormat) {
            this.dateFormat = ((ICustomParameterDateFormat)((Object)p)).getDateFormat();
        }
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            System.out.println("QueryInParam: should not happen");
            return null;
        }
    }

    boolean equals(QueryInParam target) {
        if (!this.mapToColumn == target.mapToColumn) {
            return false;
        }
        if (!this.mapToFunction == target.mapToFunction) {
            return false;
        }
        if (!(!this.mapToColumn && !this.mapToFunction || this.tableName.equals(target.tableName) && this.columnName.equals(target.columnName))) {
            return false;
        }
        if (this.value == null && target.value != null) {
            return false;
        }
        if (this.value != null && !this.value.equals(target.value)) {
            return false;
        }
        if (this.valueVariable == null && target.valueVariable != null) {
            return false;
        }
        if (this.valueVariable != null && !this.valueVariable.equals(target.valueVariable)) {
            return false;
        }
        if (this.sqlSelect == null && target.sqlSelect != null) {
            return false;
        }
        if (this.sqlSelect != null && !this.sqlSelect.equals(target.getSqlSelect())) {
            return false;
        }
        if (this.defaultSql == null && target.defaultSql != null) {
            return false;
        }
        if (this.defaultSql != null && !this.defaultSql.equals(target.getDefaultSql())) {
            return false;
        }
        if (this.allOptionEnabled != target.allOptionEnabled) {
            return false;
        }
        if (this.allOptionLabel == null && target.allOptionLabel != null) {
            return false;
        }
        if (this.allOptionLabel != null && !this.allOptionLabel.equals(target.getAllOptionLabel())) {
            return false;
        }
        return this.paramName.equals(target.paramName) && this.sqlType == target.sqlType;
    }

    boolean exactEquals(QueryInParam target) {
        if (!this.equals(target)) {
            return false;
        }
        if (!this.promptName.equals(target.promptName)) {
            return false;
        }
        if (this.defaultValue == null && target.defaultValue != null) {
            return false;
        }
        if (this.defaultValue != null) {
            return this.defaultValue.equals(target.defaultValue);
        }
        if (this.defaultValueVariable == null && target.defaultValueVariable != null) {
            return false;
        }
        if (this.defaultValueVariable != null) {
            return this.defaultValueVariable.equals(target.defaultValueVariable);
        }
        return true;
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeInt(-1);
        dout.writeInt(6602);
        dout.writeInt(0);
        this.writeDetails(dout);
    }

    protected void writeDetails(DataOutput dout) throws IOException {
        int nIndex = this.paramIndexMap.length;
        dout.writeInt(nIndex);
        for (int i = 0; i < nIndex; ++i) {
            dout.writeInt(this.paramIndexMap[i]);
        }
        IOUtil.writeString(dout, this.paramName);
        IOUtil.writeString(dout, this.promptName);
        dout.writeBoolean(this.mapToColumn);
        dout.writeBoolean(this.mapToFunction);
        IOUtil.writeString(dout, this.tableName);
        IOUtil.writeString(dout, this.columnName);
        dout.writeInt(this.sqlType);
        if (this.defaultValue != null) {
            if (dout instanceof VersioningDataOutput) {
                VersioningDataOutput vdo = (VersioningDataOutput)dout;
                vdo.writeBoolean(this.defaultValue.equals(this.allOptionLabel), (short)6602);
            } else {
                dout.writeBoolean(this.defaultValue.equals(this.allOptionLabel));
            }
            if (this.defaultValue.equals(this.allOptionLabel)) {
                DataType.write(dout, this.sqlType, null);
            } else if (this.defaultValue instanceof Vector) {
                DataType.write(dout, this.sqlType, ((Vector)this.defaultValue).get(0));
            } else {
                DataType.write(dout, this.sqlType, this.defaultValue);
            }
        } else {
            if (dout instanceof VersioningDataOutput) {
                VersioningDataOutput vdo = (VersioningDataOutput)dout;
                vdo.writeBoolean(false, (short)6602);
            } else {
                dout.writeBoolean(false);
            }
            DataType.write(dout, this.sqlType, this.defaultValue);
        }
        if (this.value != null) {
            if (dout instanceof VersioningDataOutput) {
                VersioningDataOutput vdo = (VersioningDataOutput)dout;
                vdo.writeBoolean(this.value.equals(this.allOptionLabel), (short)6602);
            } else {
                dout.writeBoolean(this.value.equals(this.allOptionLabel));
            }
            if (this.value.equals(this.allOptionLabel)) {
                DataType.write(dout, this.sqlType, null);
            } else if (this instanceof QueryMultiValueInParam) {
                DataType.write(dout, 1, this.value);
            } else {
                DataType.write(dout, this.sqlType, this.value);
            }
        } else {
            if (dout instanceof VersioningDataOutput) {
                VersioningDataOutput vdo = (VersioningDataOutput)dout;
                vdo.writeBoolean(false, (short)6602);
            } else {
                dout.writeBoolean(false);
            }
            DataType.write(dout, this.sqlType, this.value);
        }
        if (this.defaultValueVariable != null && this.defaultValueVariable.getText() != null) {
            dout.writeBoolean(true);
            this.defaultValueVariable.write(dout);
        } else {
            dout.writeBoolean(false);
        }
        if (this.valueVariable != null && this.valueVariable.getText() != null) {
            dout.writeBoolean(true);
            this.valueVariable.write(dout);
        } else {
            dout.writeBoolean(false);
        }
        if (this.selectionValues == null) {
            dout.writeBoolean(false);
        } else {
            dout.writeBoolean(true);
            dout.writeInt(this.selectionValues.size());
            for (int i = 0; i < this.selectionValues.size(); ++i) {
                DataType.write(dout, this.sqlType, this.selectionValues.elementAt(i));
            }
        }
        IOUtil.writeStr(dout, this.sqlSelect);
        IOUtil.writeStr(dout, this.dateFormat);
        if (dout instanceof VersioningDataOutput) {
            VersioningDataOutput vdo = (VersioningDataOutput)dout;
            IOUtil.writeStr(vdo, this.defaultSql, (short)6600);
        } else {
            IOUtil.writeStr(dout, this.defaultSql);
        }
        if (dout instanceof VersioningDataOutput) {
            VersioningDataOutput vdo = (VersioningDataOutput)dout;
            vdo.writeBoolean(this.allOptionEnabled, (short)6602);
            IOUtil.writeStr(vdo, this.allOptionLabel, (short)6602);
        } else {
            dout.writeBoolean(this.allOptionEnabled);
            IOUtil.writeStr(dout, this.allOptionLabel);
        }
    }

    public static QueryInParam read(DataInput din, int version) throws IOException {
        int control = din.readInt();
        if (control < 0) {
            version = din.readInt();
            int type = din.readInt();
            control = din.readInt();
            if (type == 1) {
                QueryMultiValueInParam param = new QueryMultiValueInParam();
                param.readHelper(din, control, version);
                return param;
            }
        } else {
            version = -1;
        }
        QueryInParam param = new QueryInParam();
        param.readHelper(din, control, version);
        return param;
    }

    protected void readHelper(DataInput din, int nIndex, int version) throws IOException {
        boolean hasValues;
        this.paramIndexMap = new int[nIndex];
        for (int i = 0; i < nIndex; ++i) {
            this.paramIndexMap[i] = din.readInt();
        }
        this.paramName = IOUtil.readString(din, true);
        this.promptName = IOUtil.readString(din, true);
        this.mapToColumn = din.readBoolean();
        this.mapToFunction = version < 54 ? false : din.readBoolean();
        this.tableName = IOUtil.readString(din, true);
        this.columnName = IOUtil.readString(din, true);
        this.sqlType = din.readInt();
        boolean defAll = false;
        if (version >= 6602) {
            defAll = din.readBoolean();
        }
        this.defaultValue = DataType.read(din, this.sqlType, version, true);
        boolean valAll = false;
        if (version >= 6602) {
            valAll = din.readBoolean();
        }
        this.value = this instanceof QueryMultiValueInParam ? DataType.read(din, 1, version, true) : DataType.read(din, this.sqlType, version, true);
        if (version >= 55) {
            if (din.readBoolean()) {
                this.defaultValueVariable = new Formula();
                this.defaultValueVariable.read(din);
            }
            if (din.readBoolean()) {
                this.valueVariable = new Formula();
                this.valueVariable.read(din);
            }
        }
        if (version >= 1 && (hasValues = din.readBoolean())) {
            this.selectionValues = new Vector();
            int count = din.readInt();
            for (int i = 0; i < count; ++i) {
                this.selectionValues.addElement(DataType.read(din, this.sqlType, version, true));
            }
        }
        if (version >= 56) {
            this.sqlSelect = IOUtil.readStr(din);
        }
        if (version >= 42 && version < 50 || version >= 51) {
            this.dateFormat = IOUtil.readStr(din);
        }
        if (version >= 6600) {
            this.defaultSql = IOUtil.readStr(din);
        }
        if (version >= 6602) {
            this.allOptionEnabled = din.readBoolean();
            this.allOptionLabel = IOUtil.readStr(din);
            if (defAll) {
                this.defaultValue = this.allOptionLabel;
            }
            if (valAll) {
                this.value = this.allOptionLabel;
            }
        }
    }

    public void writeXML(Writer out) throws IOException {
        this.writeXML(out, -1);
    }

    public void writeXML(Writer out, int index) throws IOException {
        this.writeXML(out, index, true);
    }

    static void write(Writer dout, String str) throws IOException {
        dout.write(str);
    }

    protected void writeXML(Writer dout, int index, boolean writeEndTag) throws IOException {
        String indexstring = "";
        if (index >= 0) {
            indexstring = " OrderIndex=\"" + index + "\"";
        }
        QueryInParam.write(dout, "<PARAMETER Name=\"" + XMLUtil.encodeXML(this.paramName) + "\" Prompt=\"" + XMLUtil.encodeXML(this.promptName) + "\" MapToColumn=\"" + this.mapToColumn + "\" MapToFunction=\"" + this.mapToFunction + "\" Table=\"" + XMLUtil.encodeXML(this.tableName) + "\" Column=\"" + XMLUtil.encodeXML(this.columnName) + "\" SQLType=\"" + DataType.getTypeName(this.sqlType) + "\" MultiValue=\"" + !writeEndTag + "\" CommonVersion=\"" + 6602 + "\"" + indexstring + ">\n");
        for (int element : this.paramIndexMap) {
            QueryInParam.write(dout, "<INDEXMAP>" + element + "</INDEXMAP>\n");
        }
        if (this.defaultValue instanceof Vector) {
            this.defaultValue = ((Vector)this.defaultValue).get(0);
        }
        QueryInParam.write(dout, "<DEFAULT_VALUE>" + XMLUtil.encodeXML(DataType.write(this.defaultValue)) + "</DEFAULT_VALUE>\n");
        QueryInParam.write(dout, "<ACTUAL_VALUE>" + XMLUtil.encodeXML(DataType.write(this.value)) + "</ACTUAL_VALUE>\n");
        try {
            if (this.defaultValueVariable != null) {
                QueryInParam.write(dout, "<DEFAULT_VALUE_VARIABLE>" + XMLUtil.encodeXML(this.defaultValueVariable.getText()) + "</DEFAULT_VALUE_VARIABLE>\n");
            }
            if (this.valueVariable != null) {
                QueryInParam.write(dout, "<VALUE_VARIABLE>" + XMLUtil.encodeXML(this.valueVariable.getText()) + "</VALUE_VARIABLE>");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.selectionValues != null) {
            QueryInParam.write(dout, "<SELECTION_LIST>\n");
            for (int i = 0; i < this.selectionValues.size(); ++i) {
                QueryInParam.write(dout, "<SELECTION_VALUE>" + XMLUtil.encodeXML(DataType.write(this.selectionValues.elementAt(i))) + "</SELECTION_VALUE>\n");
            }
            QueryInParam.write(dout, "</SELECTION_LIST>\n");
        }
        if (this.dateFormat != null) {
            QueryInParam.write(dout, "<DATE_FORMAT>" + this.dateFormat + "</DATE_FORMAT>\n");
        }
        if (this.sqlSelect != null) {
            QueryInParam.write(dout, "<SQL_SELECT>" + XMLUtil.encodeCDATA(this.sqlSelect) + "</SQL_SELECT>\n");
        }
        if (this.defaultSql != null) {
            QueryInParam.write(dout, "<DEFAULT_SQL>" + XMLUtil.encodeCDATA(this.defaultSql) + "</DEFAULT_SQL>\n");
        }
        QueryInParam.write(dout, "<ALL_ENABLED>" + this.allOptionEnabled + "</ALL_ENABLED>");
        if (this.allOptionLabel != null) {
            QueryInParam.write(dout, "<ALL_LABEL>" + XMLUtil.encodeCDATA(this.allOptionLabel) + "</ALL_LABEL>");
        }
        if (writeEndTag) {
            QueryInParam.write(dout, "</PARAMETER>\n");
        }
    }

    public static QueryInParam readXML(Node node, int version) throws Exception {
        if (node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            NamedNodeMap nodemap = node.getAttributes();
            Node attr = nodemap.getNamedItem("CommonVersion");
            if (attr != null) {
                version = Integer.parseInt(attr.getNodeValue());
            }
            if ((attr = nodemap.getNamedItem("MultiValue")) != null) {
                boolean multiValue = false;
                try {
                    multiValue = Boolean.valueOf(attr.getNodeValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (multiValue) {
                    QueryMultiValueInParam param = new QueryMultiValueInParam();
                    param.readXMLHelper(node, version);
                    return param;
                }
            }
            QueryInParam param = new QueryInParam();
            param.readXMLHelper(node, version);
            return param;
        }
        return null;
    }

    protected void readXMLHelper(Node node, int version) throws Exception {
        if (node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            int i;
            Vector<String> indexmap = new Vector<String>();
            NodeList nodeList = node.getChildNodes();
            for (i = 0; i < nodeList.getLength(); ++i) {
                String dataText;
                Node child = nodeList.item(i);
                if (child.getNodeName().equalsIgnoreCase("INDEXMAP")) {
                    indexmap.addElement(XMLUtil.readText(child));
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("DEFAULT_VALUE")) {
                    dataText = XMLUtil.readCDATA(child);
                    if (dataText.equals("")) {
                        dataText = XMLUtil.readText(child);
                    }
                    this.defaultValue = DataType.read(dataText);
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("ACTUAL_VALUE")) {
                    dataText = XMLUtil.readCDATA(child);
                    if (dataText.equals("")) {
                        dataText = XMLUtil.readText(child);
                    }
                    this.value = DataType.read(dataText);
                    continue;
                }
                if (child.getNodeName().equals("DEFAULT_VALUE_VARIABLE")) {
                    this.defaultValueVariable = new Formula(null, XMLUtil.readCDATA(child));
                    continue;
                }
                if (child.getNodeName().equals("VALUE_VARIABLE")) {
                    this.valueVariable = new Formula(null, XMLUtil.readCDATA(child));
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("DATE_FORMAT")) {
                    this.dateFormat = XMLUtil.readText(child);
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("SQL_SELECT")) {
                    this.sqlSelect = XMLUtil.readCDATA(child);
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("DEFAULT_SQL")) {
                    this.defaultSql = XMLUtil.readCDATA(child);
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("ALL_ENABLED")) {
                    String aOE = XMLUtil.readText(child);
                    if (aOE.trim().equalsIgnoreCase("true")) {
                        this.allOptionEnabled = true;
                        continue;
                    }
                    this.allOptionEnabled = false;
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("ALL_LABEL")) {
                    this.allOptionLabel = XMLUtil.readCDATA(child);
                    continue;
                }
                if (!child.getNodeName().equalsIgnoreCase("SELECTION_LIST")) continue;
                this.selectionValues = new Vector();
                NodeList itemlist = child.getChildNodes();
                for (int j = 0; j < itemlist.getLength(); ++j) {
                    Node item = itemlist.item(j);
                    if (!item.getNodeName().equalsIgnoreCase("SELECTION_VALUE")) continue;
                    this.selectionValues.addElement(DataType.read(XMLUtil.readText(item)));
                }
            }
            if (indexmap.size() <= 0) {
                throw new Exception("Missing 'INDEXMAP' element.");
            }
            this.paramIndexMap = new int[indexmap.size()];
            for (i = 0; i < this.paramIndexMap.length; ++i) {
                this.paramIndexMap[i] = Integer.parseInt((String)indexmap.elementAt(i));
            }
            NamedNodeMap nodemap = node.getAttributes();
            for (int i2 = 0; i2 < nodemap.getLength(); ++i2) {
                Node child = nodemap.item(i2);
                if (child.getNodeName().equalsIgnoreCase("Name")) {
                    this.paramName = child.getNodeValue();
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("Prompt")) {
                    this.promptName = child.getNodeValue();
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("MapToColumn")) {
                    this.mapToColumn = Boolean.valueOf(child.getNodeValue());
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("MapToFunction")) {
                    this.mapToFunction = Boolean.valueOf(child.getNodeValue());
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("Table")) {
                    this.tableName = child.getNodeValue();
                    continue;
                }
                if (child.getNodeName().equalsIgnoreCase("Column")) {
                    this.columnName = child.getNodeValue();
                    continue;
                }
                if (!child.getNodeName().equalsIgnoreCase("SQLType")) continue;
                this.sqlType = DataType.findType(child.getNodeValue());
            }
        }
    }

    public int[] getParamIndexMap() {
        return this.paramIndexMap;
    }

    public void setParamIndexMap(int[] map) {
        this.paramIndexMap = map;
    }

    @Override
    public String getParamName() {
        return this.paramName;
    }

    @Override
    public String getPromptName() {
        return this.promptName;
    }

    @Override
    public void setPromptName(String promptName) {
        this.promptName = promptName;
    }

    public boolean isMapToColumnOnly() {
        return this.mapToColumn;
    }

    @Override
    public boolean isMapToColumn() {
        return this.mapToColumn || this.mapToFunction;
    }

    public boolean isMapToFunctionOnly() {
        return this.mapToFunction;
    }

    public boolean isMapToSqlSelect() {
        return this.sqlSelect != null;
    }

    public void setMapToFunction(boolean mapToFunction) {
        this.mapToFunction = mapToFunction;
    }

    @Override
    public void setMapToColumn(boolean mapToColumn) {
        this.mapToColumn = mapToColumn;
    }

    public String getCompleteName() {
        return this.tableName + "." + this.columnName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getSqlSelect() {
        return this.sqlSelect;
    }

    public void setSqlSelect(String sql) {
        this.sqlSelect = sql;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValueVariable != null) {
            try {
                return this.defaultValueVariable.getValue();
            }
            catch (Exception ex) {
                return this.defaultValue;
            }
        }
        return this.defaultValue;
    }

    public Object getDefaultValue(QueryFileInfo fileInfo) {
        if (this.defaultSql != null && !this.defaultSql.isEmpty()) {
            try {
                Vector result = QueryParser.executeSQLSelect((IDatabaseInfo)fileInfo, this.defaultSql, fileInfo.getInSet().getParameter(), 1);
                if (result != null && result.size() == 1 && result.get(0) != null) {
                    if (((Vector)result.get(0)).get(0) != null) {
                        return ((Vector)result.get(0)).get(0);
                    }
                    return result.get(0);
                }
                return this.defaultValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.defaultValueVariable != null) {
            try {
                return this.defaultValueVariable.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Object getValue() {
        if (this.valueVariable != null) {
            try {
                return this.valueVariable.getValue();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return this.value;
            }
        }
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.valueVariable = null;
        this.value = value != null && value instanceof Vector ? (((Vector)value).size() > 0 ? ((Vector)value).get(0) : null) : value;
    }

    public Formula getDefaultValueVariable() {
        return this.defaultValueVariable;
    }

    public void setDefaultValueVariable(Formula f) {
        this.defaultValueVariable = f;
    }

    public Formula getValueVariable() {
        return this.valueVariable;
    }

    public void setValueVariable(Formula f) {
        this.valueVariable = f;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< QueryInParam >>\n");
        sb.append("paramIndexMap[] = ");
        for (int element : this.paramIndexMap) {
            sb.append(element).append(" ");
        }
        sb.append("\n");
        sb.append("paramName\t = ").append(this.paramName).append("\n");
        sb.append("promptName\t = ").append(this.promptName).append("\n");
        sb.append("mapToColumn\t = ").append(this.mapToColumn).append("\n");
        sb.append("mapToFunction\t = ").append(this.mapToFunction).append("\n");
        sb.append("tableName\t = ").append(this.tableName).append("\n");
        sb.append("columnName\t = ").append(this.columnName).append("\n");
        sb.append("sqlType\t = ").append(this.sqlType).append("\n");
        sb.append("defaultValue\t = ").append(this.defaultValue).append("\n");
        sb.append("value\t = ").append(this.value).append("\n");
        return sb.toString();
    }

    @Override
    public Vector getSelectionChoices() {
        return this.selectionValues;
    }

    public void setSelectionChoices(Vector values) {
        this.selectionValues = values;
    }

    @Override
    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String df) {
        this.dateFormat = df;
    }

    public static QueryInParam create(IQueryInParam param) {
        if (param == null) {
            return null;
        }
        if (param instanceof IQueryMultiValueInParam) {
            return new QueryMultiValueInParam((IQueryMultiValueInParam)param, null);
        }
        return new QueryInParam(param, null);
    }

    public static void copyValue(IQueryInParam des, IQueryInParam source) {
        if (des instanceof IQueryMultiValueInParam && source instanceof IQueryMultiValueInParam) {
            ((IQueryMultiValueInParam)des).setValues(((IQueryMultiValueInParam)source).getValues());
        } else {
            des.setValue(source.getValue());
        }
    }

    @Override
    public String getDefaultSql() {
        return this.defaultSql;
    }

    @Override
    public void setDefaultSql(String defaultSql) {
        this.defaultSql = defaultSql;
    }

    public String getAllOptionLabel() {
        return this.allOptionLabel;
    }

    public void setAllOptionLabel(String allOptionLabel) {
        this.allOptionLabel = allOptionLabel;
    }

    public boolean isAllOptionEnabled() {
        return this.allOptionEnabled;
    }

    public void setAllOptionEnabled(boolean isAllOptionEnabled) {
        this.allOptionEnabled = isAllOptionEnabled;
    }
}

