/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsqlparser.JSQLParserException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.allparser.AllParser;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLUtil;

public class QueryInParamSet
implements Cloneable {
    QueryInParam[] parameter;
    QueryInParam[][] parameterInPromptSequence;
    public static final String XMLTAG = "QUERY_PARAMETER_SET";
    private static final Logger LOGGER = Logger.getLogger(QueryInParamSet.class.getName());

    public QueryInParamSet(QueryInParam[] parameter) {
        this.parameter = parameter;
    }

    public QueryInParamSet(QueryInParam[] parameter, QueryInParam[][] parameterInPromptSequence) {
        this.parameter = parameter;
        this.parameterInPromptSequence = parameterInPromptSequence;
    }

    public QueryInParamSet(QueryInParam[] params, String query) {
        this(params, null, query);
    }

    public QueryInParamSet(QueryInParam[] params, QueryInParam[][] paramsInSequence, String query) {
        this.parameter = params;
        this.parameterInPromptSequence = paramsInSequence;
        query = QueryParser.removeComments(query);
        int[][] indexMap = QueryInParamSet.makeParamMap(query);
        String[] paramNames = QueryParser.getAllParameters(query);
        for (int i = 0; i < paramNames.length; ++i) {
            QueryInParam p = this.getParameter(paramNames[i]);
            if (p == null) continue;
            p.setParamIndexMap(indexMap[i]);
        }
    }

    public synchronized Object clone() {
        int nParam = this.parameter.length;
        QueryInParam[] newParam = new QueryInParam[nParam];
        for (int i = 0; i < nParam; ++i) {
            newParam[i] = (QueryInParam)this.parameter[i].clone();
        }
        QueryInParam[][] newParam2 = new QueryInParam[nParam][nParam];
        if (this.parameterInPromptSequence != null) {
            for (int i = 0; i < nParam; ++i) {
                for (int j = 0; j < nParam; ++j) {
                    if (this.parameterInPromptSequence[i][j] == null) continue;
                    newParam2[i][j] = this.getParameter(this.parameterInPromptSequence[i][j].getParamName());
                }
            }
        }
        return new QueryInParamSet(newParam, newParam2);
    }

    public boolean equals(QueryInParamSet qips) {
        if (qips == null || this.parameter.length != qips.parameter.length) {
            return false;
        }
        for (int i = 0; i < this.parameter.length; ++i) {
            if (this.parameter[i].equals(qips.parameter[i])) continue;
            return false;
        }
        return true;
    }

    public boolean exactEquals(QueryInParamSet qips) {
        if (qips == null || this.parameter.length != qips.parameter.length) {
            return false;
        }
        for (int i = 0; i < this.parameter.length; ++i) {
            if (this.parameter[i].exactEquals(qips.parameter[i])) continue;
            return false;
        }
        return true;
    }

    public static int[][] makeParamMap(String query) {
        String[] uniqueList = QueryParser.getAllParameters(query);
        String[] completeList = QueryParser.getCompleteParam(query);
        int nUnique = 0;
        if (uniqueList != null) {
            nUnique = uniqueList.length;
        }
        Vector[] mapBuffer = new Vector[nUnique];
        for (int i = 0; i < nUnique; ++i) {
            mapBuffer[i] = new Vector();
        }
        int nComplete = 0;
        if (completeList != null) {
            nComplete = completeList.length;
        }
        block1: for (int i = 0; i < nComplete; ++i) {
            for (int j = 0; j < nUnique; ++j) {
                if (!completeList[i].equals(uniqueList[j])) continue;
                mapBuffer[j].addElement(i);
                continue block1;
            }
        }
        int[][] mapArray = new int[nUnique][];
        for (int i = 0; i < nUnique; ++i) {
            int nDuplicate = mapBuffer[i].size();
            mapArray[i] = new int[nDuplicate];
            for (int j = 0; j < nDuplicate; ++j) {
                mapArray[i][j] = (Integer)mapBuffer[i].elementAt(j);
            }
        }
        return mapArray;
    }

    public String convertToJDBCquery(String query) {
        return this.convertToJDBCquery(query, true);
    }

    public String convertToJDBCquery(String query, boolean useValue) {
        query = QueryParser.removeComments(query);
        String[] parameter = QueryParser.getAllParameters(query);
        query = this.modifyQueryForAllParams(query, parameter);
        if (parameter == null) {
            return query;
        }
        for (int i = 0; i < parameter.length; ++i) {
            String max = parameter[i];
            for (int j = i + 1; j < parameter.length; ++j) {
                if (parameter[j].length() <= max.length()) continue;
                String tmp = max;
                max = parameter[j];
                parameter[j] = tmp;
            }
            parameter[i] = max;
        }
        String tempQuery = query;
        for (String element : parameter) {
            int temp;
            int index = 0;
            while ((temp = tempQuery.indexOf(":" + element, index)) > 0) {
                QueryMultiValueInParam mParam;
                String remaining = tempQuery.substring(temp + 1 + element.length());
                tempQuery = tempQuery.substring(0, temp);
                QueryInParam param = this.getParameter(element);
                if (param instanceof QueryMultiValueInParam && (mParam = (QueryMultiValueInParam)param).getValues() != null) {
                    for (int k = 1; k < mParam.getValues().size(); ++k) {
                        tempQuery = tempQuery + "?, ";
                    }
                }
                tempQuery = tempQuery + "?" + remaining;
                index = temp;
            }
        }
        return tempQuery;
    }

    public void setStmtValue(PreparedStatement pStmt) throws SQLException {
        int nDistinctParam = this.parameter.length;
        int nParam = 0;
        for (int i = 0; i < nDistinctParam; ++i) {
            nParam += this.parameter[i].getParamIndexMap().length;
        }
        int[][] map = new int[nDistinctParam][];
        for (int i = 0; i < nDistinctParam; ++i) {
            int[] temp = this.parameter[i].getParamIndexMap();
            map[i] = new int[temp.length];
            for (int j = 0; j < temp.length; ++j) {
                map[i][j] = temp[j];
            }
        }
        int actualInsertIndex = 1;
        for (int i = 0; i < nParam; ++i) {
            block4: for (int j = 0; j < nDistinctParam; ++j) {
                int nMap = map[j].length;
                for (int k = 0; k < nMap; ++k) {
                    Vector<Object> values;
                    if (map[j][k] != i) continue;
                    boolean set = false;
                    if (this.parameter[j] instanceof QueryMultiValueInParam && (values = ((QueryMultiValueInParam)this.parameter[j]).getValues()) != null && values.size() > 0) {
                        for (int m = 0; m < values.size(); ++m) {
                            Object value = values.elementAt(m);
                            if (value == null) {
                                pStmt.setNull(actualInsertIndex, this.parameter[j].getSqlType());
                            } else if (value instanceof String && value.toString().trim().equals("") && DataType.mapType(this.parameter[j].getSqlType()) != 7) {
                                pStmt.setNull(actualInsertIndex, this.parameter[j].getSqlType());
                            } else {
                                pStmt.setObject(actualInsertIndex, value);
                            }
                            ++actualInsertIndex;
                        }
                        set = true;
                    }
                    if (!set) {
                        Object value = this.parameter[j].getValue();
                        if (value == null) {
                            pStmt.setNull(actualInsertIndex, this.parameter[j].getSqlType());
                            ++actualInsertIndex;
                        } else if (value instanceof String && (value.equals(this.parameter[j].getAllOptionLabel()) || value.toString().trim().equals("") && DataType.mapType(this.parameter[j].getSqlType()) != 7)) {
                            pStmt.setNull(actualInsertIndex, this.parameter[j].getSqlType());
                            ++actualInsertIndex;
                        } else {
                            pStmt.setObject(actualInsertIndex, value);
                            ++actualInsertIndex;
                        }
                    }
                    map[j][k] = -1;
                    continue block4;
                }
            }
        }
    }

    public void write(DataOutput dout) throws IOException {
        if (this.parameter == null) {
            dout.writeInt(0);
        } else {
            int size = this.parameter.length;
            dout.writeInt(size);
            for (int i = 0; i < size; ++i) {
                this.parameter[i].write(dout);
            }
            if (this.parameterInPromptSequence != null) {
                dout.writeBoolean(true);
                dout.writeInt(this.parameterInPromptSequence.length);
                for (QueryInParam[] element : this.parameterInPromptSequence) {
                    dout.writeInt(element.length);
                    for (QueryInParam element2 : element) {
                        String paramName = null;
                        if (element2 != null) {
                            paramName = element2.getParamName();
                        }
                        IOUtil.writeString(dout, paramName);
                    }
                }
            } else {
                dout.writeBoolean(false);
            }
        }
    }

    public static QueryInParamSet read(DataInput din, int version) throws IOException {
        QueryInParamSet inset = null;
        int size = din.readInt();
        if (size > 0) {
            QueryInParam[] parameter = new QueryInParam[size];
            for (int i = 0; i < size; ++i) {
                parameter[i] = QueryInParam.read(din, version);
            }
            inset = new QueryInParamSet(parameter);
            if (version >= 361 && din.readBoolean()) {
                int j;
                size = din.readInt();
                String[][] s = new String[size][size];
                for (int i = 0; i < size; ++i) {
                    int count = din.readInt();
                    for (j = 0; j < count; ++j) {
                        s[i][j] = IOUtil.readString(din, true);
                    }
                }
                QueryInParam[][] parameterInPromptSequence = new QueryInParam[size][size];
                for (int i = 0; i < s.length; ++i) {
                    for (j = 0; j < s[i].length; ++j) {
                        if (s[i][j] == null) continue;
                        parameterInPromptSequence[i][j] = inset.getParameter(s[i][j]);
                    }
                }
                inset.setParameterInPromptSequence(parameterInPromptSequence);
            }
        }
        return inset;
    }

    static void write(Writer dout, String str) throws IOException {
        dout.write(str);
    }

    public void writeXML(Writer dout) throws IOException {
        QueryInParamSet.write(dout, "<QUERY_PARAMETER_SET>\n");
        if (this.parameter != null) {
            for (QueryInParam queryInParam : this.parameter) {
                queryInParam.writeXML(dout);
            }
        }
        if (this.parameterInPromptSequence != null) {
            for (QueryInParam queryInParam : this.parameterInPromptSequence) {
                QueryInParamSet.write(dout, "<PARAM_ORDER>\n");
                for (QueryInParam element2 : queryInParam) {
                    if (element2 == null) continue;
                    QueryInParamSet.write(dout, "<PARAM_NAME>" + element2.getParamName() + "</PARAM_NAME>\n");
                }
                QueryInParamSet.write(dout, "</PARAM_ORDER>\n");
            }
        }
        QueryInParamSet.write(dout, "</QUERY_PARAMETER_SET>\n");
    }

    public static QueryInParamSet readXML(Node node, int version) throws Exception {
        try {
            QueryInParamSet inSet = null;
            if (node.getNodeName().equalsIgnoreCase(XMLTAG)) {
                Vector paramName;
                Vector<QueryInParam> vect = new Vector<QueryInParam>();
                Vector<Vector> vect2 = new Vector<Vector>();
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node child = nodeList.item(i);
                    if (child.getNodeName().equalsIgnoreCase("PARAMETER")) {
                        vect.addElement(QueryInParam.readXML(child, version));
                        continue;
                    }
                    if (!child.getNodeName().equalsIgnoreCase("PARAM_ORDER")) continue;
                    paramName = new Vector();
                    NodeList nodeList2 = child.getChildNodes();
                    for (int j = 0; nodeList2 != null && j < nodeList2.getLength(); ++j) {
                        Node child2 = nodeList2.item(j);
                        if (!child2.getNodeName().equalsIgnoreCase("PARAM_NAME")) continue;
                        paramName.addElement(XMLUtil.readText(child2));
                    }
                    vect2.addElement(paramName);
                }
                if (vect.size() > 0) {
                    QueryInParam[] params = new QueryInParam[vect.size()];
                    for (int i = 0; i < vect.size(); ++i) {
                        params[i] = (QueryInParam)vect.elementAt(i);
                    }
                    inSet = new QueryInParamSet(params);
                }
                if (vect2.size() > 0) {
                    QueryInParam[][] paramInSequence = new QueryInParam[vect2.size()][vect2.size()];
                    for (int i = 0; i < vect2.size(); ++i) {
                        paramName = (Vector)vect2.elementAt(i);
                        for (int j = 0; j < paramName.size(); ++j) {
                            paramInSequence[i][j] = inSet.getParameter((String)paramName.elementAt(j));
                        }
                    }
                    inSet.setParameterInPromptSequence(paramInSequence);
                }
            }
            return inSet;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public int getMaxParameterOrder() {
        if (this.parameterInPromptSequence != null) {
            for (int i = this.parameterInPromptSequence.length - 1; i >= 0; --i) {
                for (int j = 0; j < this.parameterInPromptSequence[i].length; ++j) {
                    if (this.parameterInPromptSequence[i][j] == null) continue;
                    return i;
                }
            }
        }
        return 0;
    }

    public QueryInParam[] getParameter() {
        return this.parameter;
    }

    public QueryInParam[] getParameter(int order) {
        if (!this.hasParameterSequence()) {
            return this.parameter;
        }
        if (order >= this.parameterInPromptSequence.length) {
            return null;
        }
        Vector<QueryInParam> vec = new Vector<QueryInParam>();
        if (order == -1) {
            QueryInParam[][] queryInParamArray = this.parameterInPromptSequence;
            int n = queryInParamArray.length;
            for (int i = 0; i < n; ++i) {
                QueryInParam[] element;
                for (QueryInParam element3 : element = queryInParamArray[i]) {
                    for (QueryInParam element2 : this.parameter) {
                        if (element3 == null || !element3.getParamName().equals(element2.getParamName())) continue;
                        vec.addElement(element2);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.parameterInPromptSequence[order].length; ++i) {
                for (QueryInParam element : this.parameter) {
                    if (this.parameterInPromptSequence[order][i] == null || !this.parameterInPromptSequence[order][i].getParamName().equals(element.getParamName())) continue;
                    vec.addElement(element);
                }
            }
        }
        QueryInParam[] inParam = new QueryInParam[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            inParam[i] = (QueryInParam)vec.elementAt(i);
        }
        return inParam;
    }

    public boolean hasParameterSequence() {
        if (this.parameterInPromptSequence == null) {
            return false;
        }
        QueryInParam[][] queryInParamArray = this.parameterInPromptSequence;
        int n = queryInParamArray.length;
        for (int i = 0; i < n; ++i) {
            QueryInParam[] element;
            for (QueryInParam element2 : element = queryInParamArray[i]) {
                if (element2 == null) continue;
                return true;
            }
        }
        return false;
    }

    public QueryInParam getParameter(String paramName) {
        if (this.parameter != null && paramName != null) {
            for (QueryInParam element : this.parameter) {
                if (element == null || !paramName.equals(element.getParamName())) continue;
                return element;
            }
        }
        return null;
    }

    public void setParameter(QueryInParam[] parameter) {
        this.parameter = parameter;
    }

    public QueryInParam[][] getParameterInPromptSequence() {
        return this.parameterInPromptSequence;
    }

    public void setParameterInPromptSequence(QueryInParam[][] p) {
        this.parameterInPromptSequence = p;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< QueryInParamSet >>\n");
        sb.append("size = " + this.parameter.length + "\n");
        for (QueryInParam element : this.parameter) {
            sb.append(element.toString());
        }
        return sb.toString();
    }

    public int getParameterOrder(String paramName) {
        if (this.parameterInPromptSequence == null) {
            return 0;
        }
        for (int i = 0; i < this.parameterInPromptSequence.length; ++i) {
            for (int j = 0; j < this.parameterInPromptSequence[i].length; ++j) {
                if (this.parameterInPromptSequence[i][j] == null || !this.parameterInPromptSequence[i][j].getParamName().equals(paramName)) continue;
                return i;
            }
        }
        return 0;
    }

    private String modifyQueryForAllParams(String query, String[] params) {
        if (params == null) {
            return query;
        }
        for (String p : params) {
            QueryInParam qip = this.getParameter(p);
            if (!qip.isAllOptionEnabled() || qip.value == null || !qip.value.equals(qip.getAllOptionLabel())) continue;
            AllParser ap = new AllParser(query);
            try {
                ap.parse(p);
                query = ap.getModifiedQuery(p);
            }
            catch (JSQLParserException jsqlpe) {
                LOGGER.log(Level.SEVERE, "All Parser Error - cannot modify query for all parameters", jsqlpe);
            }
        }
        return query;
    }
}

