/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLUtil;

public class QueryMultiValueInParam
extends QueryInParam
implements IQueryMultiValueInParam {
    public static final String SELECT_ALL = "SELECT_-_ALL_-_MULTIPLE_-_VALUES";
    public static final String NOT_SELECT_ALL = "NOT_-_SELECT_-_ALL_-_MULTIPLE_-_VALUES";
    Vector values = null;

    protected QueryMultiValueInParam() {
    }

    public QueryMultiValueInParam(String paramName, String pathStr) {
        super(paramName, pathStr);
    }

    public QueryMultiValueInParam(int[] paramIndexMap, String paramName, String promptName, boolean mapToColumn, boolean mapToFunction, String tableName, String columnName, int sqlType, Object defaultValue, String defaultSql, boolean isAllOptionEnabled, String allOptionLabel, Object value, Vector vs) {
        super(paramIndexMap, paramName, promptName, mapToColumn, mapToFunction, tableName, columnName, sqlType, defaultValue, defaultSql, isAllOptionEnabled, allOptionLabel, value);
        this.values = vs;
    }

    public QueryMultiValueInParam(int[] paramIndexMap, String paramName, String promptName, boolean mapToColumn, String tableName, String columnName, int sqlType, Object defaultValue, Object value, Vector vs) {
        this(paramIndexMap, paramName, promptName, mapToColumn, tableName, columnName, sqlType, defaultValue, null, false, null, value, vs);
    }

    public QueryMultiValueInParam(int[] paramIndexMap, String paramName, String promptName, boolean mapToColumn, String tableName, String columnName, int sqlType, Object defaultValue, String defaultSql, Object value, Vector vs) {
        this(paramIndexMap, paramName, promptName, mapToColumn, tableName, columnName, sqlType, defaultValue, defaultSql, false, null, value, vs);
    }

    public QueryMultiValueInParam(int[] paramIndexMap, String paramName, String promptName, boolean mapToColumn, String tableName, String columnName, int sqlType, Object defaultValue, String defaultSql, boolean isAllOptionEnabled, String allOptionLabel, Object value, Vector vs) {
        super(paramIndexMap, paramName, promptName, mapToColumn, tableName, columnName, sqlType, defaultValue, defaultSql, isAllOptionEnabled, allOptionLabel, value);
        this.values = vs;
    }

    public QueryMultiValueInParam(IQueryMultiValueInParam p, String query) {
        super(p, query);
        this.values = p.getValues();
    }

    @Override
    boolean equals(QueryInParam target) {
        if (target == null) {
            return false;
        }
        if (!(target instanceof QueryMultiValueInParam)) {
            return false;
        }
        if (!super.equals(target)) {
            return false;
        }
        if (this.values == null && ((QueryMultiValueInParam)target).getValues() == null) {
            return true;
        }
        if (this.values != null && ((QueryMultiValueInParam)target).getValues() != null) {
            Vector<Object> targetValues = ((QueryMultiValueInParam)target).getValues();
            if (this.values.size() != targetValues.size()) {
                return false;
            }
            for (int i = 0; i < this.values.size(); ++i) {
                if (!(this.values.elementAt(i) != null && targetValues.elementAt(i) != null ? !this.values.elementAt(i).equals(targetValues.elementAt(i)) : this.values.elementAt(i) != null || targetValues.elementAt(i) != null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    boolean exactEquals(QueryInParam target) {
        if (target == null) {
            return false;
        }
        if (!super.exactEquals(target)) {
            return false;
        }
        return this.equals(target);
    }

    @Override
    public void write(DataOutput dout) throws IOException {
        dout.writeInt(-1);
        dout.writeInt(6602);
        dout.writeInt(1);
        this.writeDetails(dout);
        if (this.values == null) {
            dout.writeBoolean(false);
        } else {
            dout.writeBoolean(true);
            dout.writeInt(this.values.size());
            for (int i = 0; i < this.values.size(); ++i) {
                try {
                    DataType.write(dout, this.getSqlType(), this.values.elementAt(i));
                    continue;
                }
                catch (Exception ex) {
                    throw new IOException("Value for parameter does not match the SQL type.\n" + ex.toString());
                }
            }
        }
    }

    @Override
    protected void readHelper(DataInput din, int nIndex, int version) throws IOException {
        super.readHelper(din, nIndex, version);
        if (din.readBoolean()) {
            this.values = new Vector();
            int count = din.readInt();
            for (int i = 0; i < count; ++i) {
                this.values.addElement(DataType.read(din, this.getSqlType(), version, true));
            }
        }
    }

    @Override
    public void writeXML(Writer dout) throws IOException {
        this.writeXML(dout, -1);
    }

    @Override
    public void writeXML(Writer dout, int index) throws IOException {
        super.writeXML(dout, index, false);
        if (this.values != null) {
            QueryMultiValueInParam.write(dout, "<MULTIVALUE_LIST>");
            for (int i = 0; i < this.values.size(); ++i) {
                QueryMultiValueInParam.write(dout, "<MULTIVALUE_VALUE>" + XMLUtil.encodeXML(DataType.write(this.values.elementAt(i))) + "</MULTIVALUE_VALUE>");
            }
            QueryMultiValueInParam.write(dout, "</MULTIVALUE_LIST>");
        }
        QueryMultiValueInParam.write(dout, "</PARAMETER>\n");
    }

    @Override
    protected void readXMLHelper(Node node, int version) throws Exception {
        super.readXMLHelper(node, version);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!child.getNodeName().equalsIgnoreCase("MULTIVALUE_LIST")) continue;
            this.values = new Vector();
            NodeList itemlist = child.getChildNodes();
            for (int j = 0; j < itemlist.getLength(); ++j) {
                Node item = itemlist.item(j);
                if (!item.getNodeName().equalsIgnoreCase("MULTIVALUE_VALUE")) continue;
                this.values.addElement(DataType.read(XMLUtil.readText(item)));
            }
        }
    }

    @Override
    public Object getValue() {
        if (this.value != null) {
            return super.getValue();
        }
        if (this.values != null && this.values.size() > 0) {
            return this.values.elementAt(0);
        }
        return null;
    }

    @Override
    public void setValue(Object v) {
        if (v != null && (v.toString().equals(SELECT_ALL) || v.toString().equals(NOT_SELECT_ALL))) {
            super.setValue(v);
        } else if (v != null && v instanceof Vector) {
            this.setValues((Vector)v);
        } else {
            this.values = new Vector();
            this.values.addElement(v);
            this.value = v;
        }
    }

    @Override
    public Vector<Object> getValues() {
        return this.values;
    }

    @Override
    public void setValues(Vector<Object> vs) {
        this.values = vs;
    }

    @Override
    public Object getDefaultValue(QueryFileInfo fileInfo) {
        if (!QbUtil.isNullOrEmpty(this.defaultSql)) {
            try {
                Vector<Object> result = QueryParser.executeSQLSelect((IDatabaseInfo)fileInfo, this.defaultSql, fileInfo.getInSet().getParameter(), 1);
                if (result != null && result.size() == 1 && (Vector)result.get(0) != null) {
                    return result.get(0);
                }
                result = new Vector<Object>();
                result.add(this.defaultValue);
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.defaultValueVariable != null) {
            try {
                Vector<Object> result = new Vector<Object>();
                result.add(this.defaultValueVariable.getValue());
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.defaultValue instanceof Vector) {
            return this.defaultValue;
        }
        Vector<Object> result = new Vector<Object>();
        result.add(this.defaultValue);
        return result;
    }
}

