/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import quadbase.common.client.ReadDBFirstValue;
import quadbase.common.client.ReadDBdistinct;
import quadbase.common.client.ReadDBparamType;
import quadbase.common.client.ReadDatabase;
import quadbase.common.client.ServerMessage;
import quadbase.common.param.Param;
import quadbase.common.param.Parameters;
import quadbase.common.paramquery.IDistinctValuesProvider;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.parser.ConditionNode;
import quadbase.common.paramquery.parser.GenericParser;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IJNDIDatabaseInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbConnection;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.QbJNDIConnection;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.datasourcemanager.manager.xmlbuilder.ReadXMLData;
import quadbase.reportdesigner.util.IQueryMultiValueInParam;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class QueryParser {
    private static final Logger LOGGER = Logger.getLogger(QueryParser.class.getName());
    public static final String PARAMETER_REGEX = "(^|\\p{Z}|\\p{S}|\\p{C}|[\\p{P}&&[^:]]):((_|(\\p{L}\\p{M}*))((\\p{L}\\p{M}*)|(\\p{N})|_)*)\\b";
    private static final String SEPARATOR1 = " ,()+-*/<>\t\n\r";
    private static final String SEPARATOR2 = " \t\n\r";
    private static final String SEPARATOR3 = " ()\t\n\r.";
    private static final String SEPARATOR4 = "[]'`";
    public static final String LEFT_BRACKET_REPLACEMENT = "<l#E#f#T>";
    public static final String RIGHT_BRACKET_REPLACEMENT = "<R#i#G#h#T>";
    public static final String SELECT_REPLACEMENT = "<s#E#l#E#c#T>";
    public static final String FROM_REPLACEMENT = "<F#r#O#m>";
    public static final String WHERE_REPLACEMENT = "<W#h#e#R#e>";
    private static String storedQuery;
    private static String storedParamName;
    private static int[] functionNameIndices;
    public static final int DEFAULT_VALUE_NO_USE = 0;
    public static final int DEFAULT_VALUE_USE_IF_NO_VALUE = 1;
    public static final int DEFAULT_VALUE_USE = 2;

    public static boolean hasParameters(String query) {
        return QueryParser.getAllParameters(query = QueryParser.removeComments(query)) != null;
    }

    public static boolean isCallableStmt(String query) {
        if ((query = QueryParser.removeComments(query)) == null) {
            return false;
        }
        if ((query = query.trim()).startsWith("{") && query.endsWith("}") || query.toLowerCase().startsWith("begin") && query.toLowerCase().endsWith("end;")) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(query, " \n(");
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (nextToken.equalsIgnoreCase("call")) {
                return true;
            }
            if (!nextToken.equalsIgnoreCase("select")) continue;
            return false;
        }
        return false;
    }

    public static boolean isOracleStoredProcedure(String databaseName, String query) {
        return databaseName.toLowerCase().indexOf("oracle") > -1 && query.toLowerCase().startsWith("begin") && query.toLowerCase().trim().endsWith("end;");
    }

    public static boolean isPreparedStmt(String query) {
        return !QueryParser.isCallableStmt(query) && QueryParser.getAllParameters(query) != null;
    }

    public static boolean isStatement(String query) {
        return !QueryParser.isCallableStmt(query) && !QueryParser.isPreparedStmt(query);
    }

    protected static String[] getCompleteParam(String query) {
        return QueryParser.getNameHelper(false, query);
    }

    public static String[] getAllParameters(String query) {
        return QueryParser.getNameHelper(true, query);
    }

    private static String removeQuote(String query, String quote) {
        String str = query;
        int i = str.indexOf(quote);
        while (i >= 0) {
            int j = str.indexOf(quote, i + 1);
            if (j >= 0) {
                str = str.substring(0, i) + str.substring(j + 1);
                i = str.indexOf(quote);
                continue;
            }
            i = -1;
        }
        return str;
    }

    private static String[] getNameHelper(boolean unique, String originalQuery) {
        if (originalQuery == null) {
            return null;
        }
        String query = originalQuery;
        query = QueryParser.removeComments(query);
        query = QueryParser.removeQuote(query, "\"");
        query = QueryParser.removeQuote(query, "'");
        query = QueryParser.removeQuote(query, "#");
        Vector<String> buffer = new Vector<String>();
        Pattern r = Pattern.compile(PARAMETER_REGEX);
        Matcher m = r.matcher(query);
        while (m.find()) {
            String hit = m.group();
            hit = hit.substring(hit.indexOf(58) + 1);
            if (unique) {
                if (buffer.contains(hit)) continue;
                buffer.add(hit);
                continue;
            }
            buffer.add(hit);
        }
        int size = buffer.size();
        if (size == 0) {
            return null;
        }
        String[] output = new String[size];
        for (int i = 0; i < size; ++i) {
            output[i] = (String)buffer.elementAt(i);
        }
        return output;
    }

    public static String[] getMultiValueParameters(String query) {
        if (query == null) {
            return null;
        }
        boolean unique = true;
        Vector<String> buffer = new Vector<String>();
        query = QueryParser.removeQuote(query, "\"");
        query = QueryParser.removeQuote(query, "'");
        query = QueryParser.removeQuote(query, "#");
        int inIndex = query.toLowerCase().indexOf(" in");
        while (inIndex >= 0) {
            StringTokenizer subTokenizer;
            String subquery = query.substring(inIndex + 3).trim();
            if (subquery.startsWith("(") && !(subquery = subquery.substring(0, subquery.indexOf(41) + 1).trim()).matches("(?si)^\\(.*SELECT.*\\).*") && (subquery = subquery.replaceAll("^\\(\\s*", "")).indexOf(58) >= 0 && subquery.indexOf(58) == subquery.lastIndexOf(58) && (subTokenizer = new StringTokenizer(subquery.substring(subquery.indexOf(58) + 1).trim(), SEPARATOR1)).hasMoreTokens()) {
                String token = subTokenizer.nextToken();
                if (token.endsWith(";")) {
                    token = token.substring(0, token.length() - 1);
                }
                if (!token.startsWith("=")) {
                    StringTokenizer equalTokenizer = new StringTokenizer(token, "=");
                    token = equalTokenizer.nextToken();
                    if (unique) {
                        if (!buffer.contains(token)) {
                            buffer.addElement(token);
                        }
                    } else {
                        buffer.addElement(token);
                    }
                }
            }
            inIndex = query.toLowerCase().indexOf(" in", inIndex + 3);
        }
        int size = buffer.size();
        if (size <= 0) {
            return null;
        }
        String[] output = new String[size];
        for (int i = 0; i < size; ++i) {
            output[i] = (String)buffer.elementAt(i);
        }
        return output;
    }

    public static String[] getAllTableNames(String query) {
        return QueryParser.getAllTableNames(query, true, true);
    }

    public static String[] getAllTableAlias(String query) {
        return QueryParser.getAllTableNames(query, true, false);
    }

    public static String[] getAllTableNames(String query, boolean trimName) {
        return QueryParser.getAllTableNames(query, trimName, true);
    }

    public static String[] getAllTableNames(String query, boolean trimName, boolean getOriginalTableName) {
        return QueryParser.getAllTableNames(query, trimName, getOriginalTableName, true);
    }

    public static String[] getAllTableNames(String query, boolean trimName, boolean getOriginalTableName, boolean unique) {
        Vector<String> buffer = new Vector<String>();
        QueryParser.getAllTableNamesHelper(query, buffer, getOriginalTableName, unique);
        for (int i = buffer.size() - 1; i >= 0; --i) {
            String comp = buffer.get(i);
            if (!comp.matches("(\\p{Z}|\\p{S}|\\p{C}|\\p{P})*")) continue;
            buffer.remove(i);
        }
        int size = buffer.size();
        if (size == 0) {
            return null;
        }
        String[] output = new String[size];
        for (int i = 0; i < size; ++i) {
            output[i] = trimName ? QueryParser.getFieldName(buffer.elementAt(i)) : buffer.elementAt(i);
        }
        return output;
    }

    private static void getAllTableNamesHelper(String query, Vector<String> buffer, boolean getOriginalTableName, boolean unique) {
        Vector<String> label;
        String fromClause = GenericParser.getQueryPart(query, 2);
        if (fromClause == null && query.toLowerCase().matches("(?s).*\\bjoin\\b.*")) {
            fromClause = query;
        } else if (fromClause != null && fromClause.toLowerCase().contains("from")) {
            fromClause = fromClause.substring(fromClause.toLowerCase().lastIndexOf("from") + 4);
        }
        StringTokenizer st1 = new StringTokenizer(fromClause, SEPARATOR2);
        String tname = "";
        boolean joinStat = false;
        while (st1.hasMoreTokens()) {
            StringBuffer sb;
            String token = st1.nextToken();
            if (token.startsWith("(") && joinStat) {
                sb = new StringBuffer();
                int ctOpen = 0;
                while (st1.hasMoreTokens()) {
                    String t1 = st1.nextToken();
                    if (t1.startsWith("(")) {
                        sb.append(t1);
                        sb.append(" ");
                        ++ctOpen;
                        continue;
                    }
                    if (t1.equals(")")) {
                        if (ctOpen <= 0) break;
                        sb.append(t1);
                        sb.append(" ");
                        --ctOpen;
                        continue;
                    }
                    sb.append(t1);
                    sb.append(" ");
                }
                QueryParser.getAllTableNamesHelper(sb.toString(), buffer, getOriginalTableName, unique);
                token = "";
                tname = "";
                joinStat = false;
            } else if (token.startsWith("(")) {
                sb = new StringBuffer();
                sb.append(token);
                String discard = st1.nextToken();
                if (discard.toUpperCase().startsWith("SELECT")) {
                    sb.append(discard);
                    sb.append(" ");
                    int ctOpen = 0;
                    while (st1.hasMoreTokens()) {
                        String t1 = st1.nextToken();
                        if (t1.startsWith("(")) {
                            ++ctOpen;
                            sb.append(t1);
                            sb.append(" ");
                            continue;
                        }
                        if (t1.equals(")")) {
                            sb.append(t1);
                            if (ctOpen <= 0) break;
                            sb.append(" ");
                            --ctOpen;
                            continue;
                        }
                        sb.append(t1);
                        sb.append(" ");
                    }
                    String fromclause = sb.toString();
                    token = "";
                    Pattern p = Pattern.compile("\\bSELECT\\b");
                    Matcher m = p.matcher(fromclause);
                    if (m.find()) {
                        QueryParser.getAllTableNamesHelper(sb.toString(), buffer, getOriginalTableName, unique);
                        tname = "";
                    } else {
                        tname = getOriginalTableName ? fromclause : st1.nextToken();
                        if (unique) {
                            if (!buffer.contains(tname.trim()) && !tname.trim().equals("")) {
                                buffer.addElement(tname.trim());
                            }
                        } else if (!tname.trim().equals("")) {
                            buffer.addElement(tname.trim());
                        }
                        tname = "";
                        try {
                            discard = st1.nextToken();
                            while (!discard.equals(",") && !discard.equalsIgnoreCase("join")) {
                                discard = st1.nextToken();
                            }
                            tname = "";
                            token = "";
                        }
                        catch (NoSuchElementException ex) {
                            break;
                        }
                    }
                }
            }
            if (token.equals(",") || token.equalsIgnoreCase("LEFT") || token.equalsIgnoreCase("RIGHT") || token.equalsIgnoreCase("inner") || token.equalsIgnoreCase("on") || token.equalsIgnoreCase("join") || token.equalsIgnoreCase("outer")) {
                StringTokenizer st00;
                if (token.equalsIgnoreCase("join")) {
                    joinStat = true;
                }
                tname = tname.trim();
                if (getOriginalTableName) {
                    label = new Vector();
                    st00 = new StringTokenizer(tname, SEPARATOR4);
                    while (st00.hasMoreTokens()) {
                        label.addElement(st00.nextToken());
                    }
                    if (label.size() >= 2) {
                        tname = tname.startsWith("[") ? "[" + (String)label.elementAt(0) + "]" : (tname.startsWith("'") ? "'" + (String)label.elementAt(0) + "'" : (String)label.elementAt(0));
                    } else if (tname.lastIndexOf(32) >= 0 && Character.isLetterOrDigit(tname.charAt(tname.length() - 1))) {
                        tname = tname.substring(0, tname.lastIndexOf(32));
                    }
                } else {
                    label = new Vector();
                    st00 = new StringTokenizer(tname, SEPARATOR4);
                    while (st00.hasMoreTokens()) {
                        label.addElement(st00.nextToken());
                    }
                    if (label.size() >= 2) {
                        tname = tname.endsWith("]") ? "[" + (String)label.lastElement() + "]" : (tname.endsWith("'") ? "'" + (String)label.lastElement() + "'" : (String)label.lastElement());
                    } else if (tname.lastIndexOf(32) >= 0 && Character.isLetterOrDigit(tname.charAt(tname.length() - 1))) {
                        tname = tname.substring(tname.lastIndexOf(32));
                    }
                }
                if (unique) {
                    if (!buffer.contains(tname.trim()) && !tname.trim().equals("")) {
                        buffer.addElement(tname.trim());
                    }
                } else if (!tname.trim().equals("")) {
                    buffer.addElement(tname.trim());
                }
                tname = "";
                if (!token.equalsIgnoreCase("on")) continue;
                try {
                    String discard = st1.nextToken();
                    while (!discard.equalsIgnoreCase("join") && !discard.equalsIgnoreCase(",")) {
                        discard = st1.nextToken();
                    }
                    continue;
                }
                catch (NoSuchElementException ex) {
                    break;
                }
            }
            token = token.trim();
            tname = tname + " " + token;
        }
        if (!tname.trim().equals("")) {
            String separator = (tname = tname.trim()).contains("`") ? "`" : (tname.contains("'") ? "'" : (tname.contains("[") ? "[" : null));
            if (getOriginalTableName) {
                label = new Vector<String>();
                if (separator != null) {
                    StringTokenizer st00 = new StringTokenizer(tname, separator);
                    while (st00.hasMoreTokens()) {
                        label.addElement(st00.nextToken());
                    }
                    if (label.size() >= 2) {
                        tname = separator.equals("[") && tname.startsWith("[") ? "[" + (String)label.elementAt(0) + "]" : (tname.startsWith(separator) ? separator + (String)label.elementAt(0) + separator : (String)label.elementAt(0));
                    }
                } else if (tname.lastIndexOf(32) >= 0 && Character.isLetterOrDigit(tname.charAt(tname.length() - 1))) {
                    tname = tname.substring(0, tname.lastIndexOf(32));
                }
            } else {
                label = new Vector();
                if (separator != null) {
                    StringTokenizer st00 = new StringTokenizer(tname, separator);
                    while (st00.hasMoreTokens()) {
                        label.addElement(st00.nextToken());
                    }
                    if (label.size() >= 2) {
                        tname = separator.equals("[") && tname.endsWith("]") ? "[" + (String)label.lastElement() + "]" : (tname.endsWith(separator) ? separator + (String)label.lastElement() + separator : (String)label.lastElement());
                    }
                } else if (tname.lastIndexOf(32) >= 0 && Character.isLetterOrDigit(tname.charAt(tname.length() - 1))) {
                    tname = tname.substring(tname.lastIndexOf(32));
                }
            }
            if (unique) {
                if (!buffer.contains(tname.trim()) && !tname.trim().equals("")) {
                    buffer.addElement(tname.trim());
                }
            } else if (!tname.trim().equals("")) {
                buffer.addElement(tname.trim());
            }
        }
    }

    public static String getFieldName(String str) {
        if (str.indexOf(32) <= 0) {
            return str;
        }
        if (str.startsWith("'") && str.endsWith("'") || str.startsWith("[") && str.endsWith("]")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static String substituteParameters(String query, Object[][] parameters) {
        if (query == null || parameters == null) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            String max = (String)parameters[i][0];
            Object maxValue = parameters[i][1];
            for (int j = i + 1; j < parameters.length; ++j) {
                if (((String)parameters[j][0]).length() <= max.length()) continue;
                String tmp = max;
                Object tmpValue = maxValue;
                max = (String)parameters[j][0];
                maxValue = parameters[j][1];
                parameters[j][0] = tmp;
                parameters[j][1] = tmpValue;
            }
            parameters[i][0] = max;
            parameters[i][1] = maxValue;
        }
        String tempQuery = query;
        for (Object[] parameter : parameters) {
            int temp;
            int index = 0;
            while ((temp = tempQuery.indexOf(":" + parameter[0], index)) >= 0) {
                if (parameter[1] == null) {
                    index = temp + (":" + parameter[0]).length();
                    continue;
                }
                if (parameter[1] instanceof Vector) {
                    if (((Vector)parameter[1]).size() == 0) {
                        return null;
                    }
                    String values = "";
                    Vector param = (Vector)parameter[1];
                    for (int i = 0; i < param.size(); ++i) {
                        values = values + param.get(i);
                        if (i >= param.size() - 1) continue;
                        values = values + ", ";
                    }
                    tempQuery = tempQuery.substring(0, temp) + values + tempQuery.substring(temp + 1 + ((String)parameter[0]).length());
                    index = temp + values.length();
                    continue;
                }
                if (parameter[1].equals("IS NULL")) {
                    int operInd = QueryParser.findComparisonOperator(tempQuery, temp);
                    if (operInd == -1) {
                        tempQuery = tempQuery.substring(0, temp) + " NULL " + tempQuery.substring(temp + 1 + ((String)parameter[0]).length());
                        index = temp + 1 + ((String)parameter[1]).length();
                        continue;
                    }
                    int idx = tempQuery.indexOf((String)parameter[0], operInd) + ((String)parameter[0]).length();
                    tempQuery = tempQuery.substring(0, operInd) + parameter[1] + tempQuery.substring(idx);
                    index = temp + 1 + ((String)parameter[1]).length();
                    continue;
                }
                tempQuery = tempQuery.substring(0, temp) + parameter[1] + tempQuery.substring(temp + 1 + ((String)parameter[0]).length());
                index = temp + ((String)parameter[1]).length();
            }
        }
        return tempQuery;
    }

    public static int findComparisonOperator(String origQuery, int index) {
        int oper;
        Matcher matcher;
        Pattern pattern;
        String[] keywords;
        String query = origQuery.substring(0, index);
        int temp = 0;
        for (String keyword : keywords = new String[]{"select", "from", "where", "order by", "group by", "in", "between", "alter", "update", "having", "group by", "union", "and", "or", "case", "when"}) {
            pattern = Pattern.compile("\\b" + keyword + "\\b(?!.*\\b" + keyword + "\\b)", 96);
            matcher = pattern.matcher(query.toLowerCase());
            if (!matcher.find()) continue;
            query = query.substring(matcher.end());
            temp += matcher.end();
        }
        pattern = Pattern.compile(",(?!.*,)", 96);
        matcher = pattern.matcher(query.toLowerCase());
        if (matcher.find()) {
            query = query.substring(matcher.end());
            temp += matcher.end();
        }
        if ((matcher = (pattern = Pattern.compile("\\((?!.*\\()", 96)).matcher(query.toLowerCase())).find()) {
            query = query.substring(matcher.end());
            temp += matcher.end();
        }
        if ((oper = query.lastIndexOf("<>")) >= 0) {
            return temp + oper;
        }
        oper = query.lastIndexOf(":=");
        if (oper >= 0) {
            return temp + oper;
        }
        oper = query.lastIndexOf("<=");
        if (oper >= 0) {
            return temp + oper;
        }
        oper = query.lastIndexOf(">=");
        if (oper >= 0) {
            return temp + oper;
        }
        oper = query.lastIndexOf(61);
        if (oper >= 0) {
            return temp + oper;
        }
        oper = query.lastIndexOf(60);
        if (oper >= 0) {
            return temp + oper;
        }
        oper = query.lastIndexOf(62);
        if (oper >= 0) {
            return temp + oper;
        }
        return -1;
    }

    public static String replaceColumns(String query, String tableName, Vector parameters) {
        if (query == null || parameters == null) {
            return query;
        }
        String tempQuery = query;
        for (int i = 0; i < parameters.size(); ++i) {
            int temp;
            int index = 0;
            String[] param = (String[])parameters.elementAt(i);
            while ((temp = tempQuery.indexOf(param[0], index)) >= 0) {
                if (temp > 0 && Character.isLetter(tempQuery.charAt(temp - 1))) {
                    index = temp + param[0].length();
                    continue;
                }
                if (tempQuery.length() > temp + param[0].length() && Character.isLetter(tempQuery.charAt(temp + param[0].length()))) {
                    index = temp + param[0].length();
                    continue;
                }
                String p0 = param[0];
                String p1 = param[1];
                QbDebug.println(5, "Replace [" + p0 + "] to [" + p1 + "]");
                String firstHalf = tempQuery.substring(0, temp);
                if (firstHalf.endsWith(tableName + ".")) {
                    temp = temp - 1 - tableName.length();
                    p0 = tableName + "." + p0;
                } else if (firstHalf.endsWith("[" + tableName + "].")) {
                    temp = temp - 3 - tableName.length();
                    p0 = "[" + tableName + "]." + p0;
                } else if (firstHalf.endsWith(".")) {
                    index = temp + param[0].length();
                    continue;
                }
                tempQuery = tempQuery.substring(0, temp) + p1 + tempQuery.substring(temp + p0.length());
                index = temp + p1.length();
            }
        }
        return tempQuery;
    }

    public static Vector getTableAndColumnName(String inQuery, String paramName) {
        return QueryParser.getColumnName(inQuery, paramName, " ()\t\n\r");
    }

    public static Vector getColumnName(String inQuery, String paramName) {
        return QueryParser.getColumnName(inQuery, paramName, SEPARATOR3);
    }

    public static Vector getColumnName(String inQuery, String paramName, String sep) {
        String query = QueryParser.preProcess(inQuery);
        Vector<String> output = new Vector<String>();
        Vector<String> buffer = new Vector<String>();
        StringTokenizer st = new StringTokenizer(query, sep);
        boolean isColonDetected = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            String target = null;
            String columnName = null;
            buffer.addElement(token);
            int bufferSize = buffer.size();
            if (token.equals(":")) {
                isColonDetected = true;
            } else if (isColonDetected) {
                isColonDetected = false;
                target = token;
                columnName = (String)buffer.elementAt(bufferSize - 4);
            } else if (token.startsWith(":")) {
                target = token.substring(1, token.length());
                columnName = (String)buffer.elementAt(bufferSize - 3);
                if (((String)buffer.elementAt(bufferSize - 4)).equalsIgnoreCase("between")) {
                    columnName = (String)buffer.elementAt(bufferSize - 5);
                }
            }
            if (target == null || !target.equals(paramName)) continue;
            output.addElement(columnName);
        }
        return output;
    }

    public static boolean isGroupByPresent(String sql) {
        return sql.toUpperCase().indexOf("GROUP BY") >= 0;
    }

    public static boolean isColumnPresent(String tblName, String colName, String query) {
        String sql = query.toUpperCase();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st0 = new StringTokenizer(sql, ",");
        if (st0.hasMoreTokens()) {
            sb.append(st0.nextToken());
            while (st0.hasMoreTokens()) {
                sb.append(" , ");
                sb.append(st0.nextToken());
            }
        }
        sql = sb.toString();
        StringTokenizer st1 = new StringTokenizer(sql, SEPARATOR2);
        while (st1.hasMoreTokens() && !st1.nextToken().trim().equals("SELECT")) {
        }
        String tname = "";
        while (st1.hasMoreTokens()) {
            String token = st1.nextToken().trim();
            if (token.equals("FROM")) {
                if ((tname = tname.trim()).equals("*")) {
                    return true;
                }
                if (!QueryParser.isColumnMatched(tblName, colName, tname)) break;
                return true;
            }
            if (token.equals(",")) {
                if ((tname = tname.trim()).equals("*")) {
                    return true;
                }
                if (QueryParser.isColumnMatched(tblName, colName, tname)) {
                    return true;
                }
                tname = "";
                continue;
            }
            token = token.trim();
            tname = tname + " " + token;
        }
        return false;
    }

    private static boolean isColumnMatched(String tblName, String colName, String token) {
        int idx = -1;
        idx = token.indexOf(46);
        if (idx > 0) {
            String tblName2 = QueryParser.getFieldName(token.substring(0, idx));
            String colName2 = QueryParser.getFieldName(token.substring(idx + 1));
            return tblName.equalsIgnoreCase(tblName2) && colName.equalsIgnoreCase(colName2);
        }
        String colName2 = QueryParser.getFieldName(token);
        return colName.equalsIgnoreCase(colName2);
    }

    public static Vector getDistinctValues(XMLFileQueryInfo queryInfo, String pathStr) {
        return QueryParser.getDistinctValues(queryInfo, pathStr, -1);
    }

    public static Vector getDistinctValues(XMLFileQueryInfo queryInfo, String pathStr, int order) {
        Vector distinctValue = null;
        try {
            Vector<XMLFieldInfo> selectedFields = new Vector<XMLFieldInfo>();
            XMLFieldInfo fieldInfo = queryInfo.getFieldInfo(pathStr);
            if (fieldInfo != null) {
                selectedFields.addElement(fieldInfo);
                ReadXMLData readXMLData = new ReadXMLData(queryInfo);
                String cond = "";
                if (order > 0) {
                    int i;
                    Vector<quadbase.reportdesigner.util.IQueryInParam> params = new Vector<quadbase.reportdesigner.util.IQueryInParam>();
                    quadbase.reportdesigner.util.IQueryInParam[][] paramInSequence = ReportUtil.getParamInSequence(new QueryXMLFileInfo(queryInfo));
                    for (i = 0; i < order; ++i) {
                        for (int j = 0; paramInSequence != null && j < paramInSequence[i].length; ++j) {
                            if (paramInSequence[i][j] == null) continue;
                            params.add(paramInSequence[i][j]);
                        }
                    }
                    for (i = 0; i < params.size(); ++i) {
                        quadbase.reportdesigner.util.IQueryInParam param = (quadbase.reportdesigner.util.IQueryInParam)params.elementAt(i);
                        Object value = param.getValue();
                        String valueString = "IS NULL";
                        if (value != null) {
                            valueString = value.toString();
                        }
                        if (value instanceof String) {
                            valueString = "'" + value + "'";
                        }
                        if (!cond.equals("")) {
                            cond = cond + " AND ";
                        }
                        cond = cond + param.getColumnName() + " = " + valueString;
                    }
                }
                Vector vec = readXMLData.executeQuery(cond, selectedFields, null, 0, -1);
                distinctValue = QueryParser.getDistinctValueFromResultSet(vec);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return distinctValue;
    }

    private static Vector getDistinctValueFromResultSet(Vector vec) {
        Vector newVec = new Vector();
        for (int i = 0; i < vec.size(); ++i) {
            Vector row = (Vector)vec.elementAt(i);
            Object obj = row.elementAt(0);
            if (QueryParser.containsObject(newVec, obj)) continue;
            newVec.addElement(obj);
        }
        return newVec;
    }

    private static boolean containsObject(Vector vec, Object obj) {
        for (int i = 0; i < vec.size(); ++i) {
            if (!obj.equals(vec.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public static Vector<Object> getDistinctValues(DBInfoBasic dbInfo, String tableName, String columnName) {
        return QueryParser.getDistinctValues(dbInfo, tableName, columnName, -1);
    }

    public static Vector getDistinctValues(DBInfoBasic dbInfo, String tableName, String columnName, int order) {
        String originalQuery = dbInfo.getQuery();
        originalQuery = QueryParser.removeComments(originalQuery);
        String[] tablenames = QueryParser.getAllTableNames(originalQuery, false, true, false);
        String[] aliasnames = QueryParser.getAllTableNames(originalQuery, false, false, false);
        if (tablenames != null && aliasnames != null && tablenames.length == aliasnames.length) {
            for (int i = 0; i < tablenames.length; ++i) {
                if (!tableName.equals(aliasnames[i])) continue;
                tableName = tablenames[i];
                break;
            }
        }
        if (columnName.startsWith(tableName)) {
            columnName = columnName.substring(tableName.length() + 1);
        }
        if (dbInfo instanceof IDistinctValuesProvider) {
            return ((IDistinctValuesProvider)((Object)dbInfo)).getDistinctValues(tableName, columnName, order);
        }
        if (dbInfo.isUseJNDIDataSource()) {
            return QueryParser.getDistinctValues((IJNDIDatabaseInfo)dbInfo, tableName, columnName, order);
        }
        return QueryParser.getDistinctValues((IDatabaseInfo)dbInfo, tableName, columnName, order);
    }

    public static Vector<Object> getDistinctValues(IJNDIDatabaseInfo dbInfo, String tableName, String columnName) {
        return QueryParser.getDistinctValues(dbInfo, tableName, columnName, -1);
    }

    public static Vector<Object> getDistinctValues(IJNDIDatabaseInfo dbInfo, String tableName, String columnName, int order) {
        String originalQuery = dbInfo.getQuery();
        originalQuery = QueryParser.removeComments(originalQuery);
        String[] tablenames = QueryParser.getAllTableNames(originalQuery, false, true, false);
        String[] aliasnames = QueryParser.getAllTableNames(originalQuery, false, false, false);
        if (tablenames != null && aliasnames != null && tablenames.length == aliasnames.length) {
            for (int i = 0; i < tablenames.length; ++i) {
                if (!tableName.equals(aliasnames[i])) continue;
                tableName = tablenames[i];
                break;
            }
        }
        if (ServerMessage.useServer) {
            try {
                return ReadDBdistinct.getDistinct(dbInfo, tableName, columnName, order);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return QueryParser.getValuesFromLocal(dbInfo, tableName, columnName, order);
    }

    public static Vector<Object> getDistinctValues(IDatabaseInfo dbInfo, String tableName, String columnName) {
        return QueryParser.getDistinctValues(dbInfo, tableName, columnName, -1);
    }

    public static Vector<Object> getDistinctValues(IDatabaseInfo dbInfo, String tableName, String columnName, int order) {
        String originalQuery = dbInfo.getQuery();
        originalQuery = QueryParser.removeComments(originalQuery);
        String[] tablenames = QueryParser.getAllTableNames(originalQuery, false, true, false);
        String[] aliasnames = QueryParser.getAllTableNames(originalQuery, false, false, false);
        if (tablenames != null && aliasnames != null && tablenames.length == aliasnames.length) {
            for (int i = 0; i < tablenames.length; ++i) {
                if (!tableName.equals(aliasnames[i])) continue;
                tableName = tablenames[i];
                break;
            }
        }
        if (dbInfo instanceof IDistinctValuesProvider) {
            return ((IDistinctValuesProvider)((Object)dbInfo)).getDistinctValues(tableName, columnName, order);
        }
        if (ServerMessage.useServer) {
            try {
                return ReadDBdistinct.getDistinct(dbInfo, tableName, columnName, order);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to get distinct values.", ex);
                return new Vector<Object>();
            }
        }
        return QueryParser.getValuesFromLocal(dbInfo, tableName, columnName, order);
    }

    public static synchronized Vector getValuesFromLocal(DBInfoBasic dbInfo, String tableName, String columnName) {
        return QueryParser.getValuesFromLocal(dbInfo, tableName, columnName, -1);
    }

    public static synchronized Vector getValuesFromLocal(DBInfoBasic dbInfo, String tableName, String columnName, int order) {
        if (dbInfo.isUseJNDIDataSource()) {
            return QueryParser.getValuesFromLocal((IJNDIDatabaseInfo)dbInfo, tableName, columnName, order);
        }
        return QueryParser.getValuesFromLocal((IDatabaseInfo)dbInfo, tableName, columnName, order);
    }

    public static synchronized Vector getValuesFromLocal(IDatabaseInfo dbInfo, String tableName, String columnName) {
        return QueryParser.getValuesFromLocal(dbInfo, tableName, columnName, -1);
    }

    public static synchronized Vector getValuesFromLocal(IDatabaseInfo dbInfo, String tableName, String columnName, int order) {
        Vector<Object> output = new Vector<Object>();
        String modifiedQuery = null;
        String originalQuery = null;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        boolean ourConnection = false;
        try {
            con = dbInfo.getConnection();
            if (con == null) {
                con = new QbConnection(dbInfo.getDriverName(), ServerMessage.getDatabaseURL(dbInfo.getURLString()), dbInfo.getUserID(), dbInfo.getPassword());
                ourConnection = true;
            }
            String query = tableName.trim().length() > 0 ? (con.getMetaData().getDatabaseProductName().toLowerCase().contains("postgre") ? String.format("WITH RECURSIVE t(n) AS (\n   SELECT min(%s) FROM %s\n UNION\n   SELECT (SELECT %s FROM %s WHERE %s > n ORDER BY %s LIMIT 1)\n   FROM t WHERE n IS NOT NULL\n)\nSELECT n FROM t ORDER BY n", columnName, tableName, columnName, tableName, columnName, columnName) : "select distinct " + columnName + " from " + tableName + " order by " + columnName) : "select distinct " + columnName;
            stmt = con.createStatement();
            originalQuery = dbInfo.getQuery();
            if (originalQuery != null) {
                ConditionNode node;
                String tableAlias = null;
                String[] tablenames = QueryParser.getAllTableNames(originalQuery, false, true, false);
                String[] aliasnames = QueryParser.getAllTableNames(originalQuery, false, false, false);
                if (tablenames != null && aliasnames != null && tablenames.length == aliasnames.length) {
                    for (int i = 0; i < tablenames.length; ++i) {
                        if (!tableName.equals(tablenames[i])) continue;
                        tableAlias = aliasnames[i];
                        break;
                    }
                }
                if ((node = GenericParser.getConditionTree(originalQuery)) != null) {
                    if (order > 0) {
                        modifiedQuery = "Select Distinct " + (tableAlias == null ? columnName : tableAlias + "." + columnName) + " From " + GenericParser.getQueryPart(originalQuery, 2) + " Where " + node.toString();
                        Vector<quadbase.reportdesigner.util.IQueryInParam> params = new Vector<quadbase.reportdesigner.util.IQueryInParam>();
                        quadbase.reportdesigner.util.IQueryInParam[][] paramInSequence = ReportUtil.getParamInSequence(dbInfo);
                        quadbase.reportdesigner.util.IQueryInParam[] inParam = ReportUtil.getInParam(dbInfo);
                        for (int i = 0; i < order; ++i) {
                            for (int j = 0; paramInSequence != null && j < paramInSequence[i].length; ++j) {
                                if (paramInSequence[i][j] == null) continue;
                                for (quadbase.reportdesigner.util.IQueryInParam element : inParam) {
                                    if (!paramInSequence[i][j].getParamName().equals(element.getParamName())) continue;
                                    params.add(element);
                                }
                            }
                        }
                        Object[][] paramValue = new Object[params.size()][2];
                        for (int i = 0; i < params.size(); ++i) {
                            quadbase.reportdesigner.util.IQueryInParam iqip;
                            paramValue[i][0] = ((quadbase.reportdesigner.util.IQueryInParam)params.elementAt(i)).getParamName();
                            if (params.elementAt(i) instanceof IQueryMultiValueInParam) {
                                Vector vec = ((IQueryMultiValueInParam)params.elementAt(i)).getValues();
                                Vector<String> stringVec = new Vector<String>();
                                for (int j = 0; j < vec.size(); ++j) {
                                    String db;
                                    Object value = vec.elementAt(j);
                                    String valueString = "IS NULL";
                                    if (value != null) {
                                        valueString = value.toString();
                                    }
                                    if (value instanceof String) {
                                        valueString = "'" + value + "'";
                                    } else if (value instanceof Timestamp) {
                                        db = con.getMetaData().getDatabaseProductName();
                                        valueString = db.equalsIgnoreCase("ACCESS") ? "#" + value.toString().substring(0, 19) + "#" : "'" + value + "'";
                                    } else if (value instanceof Date) {
                                        db = con.getMetaData().getDatabaseProductName();
                                        valueString = db.equalsIgnoreCase("ACCESS") ? "#" + value + "#" : "'" + value + "'";
                                    }
                                    stringVec.addElement(valueString);
                                }
                                paramValue[i][1] = stringVec;
                                continue;
                            }
                            Object value = ((quadbase.reportdesigner.util.IQueryInParam)params.elementAt(i)).getValue();
                            String valueString = "IS NULL";
                            if (value != null) {
                                valueString = value.toString();
                            }
                            if (order >= 1 && (iqip = (quadbase.reportdesigner.util.IQueryInParam)params.get(i)) instanceof ReportUtil.CQueryInParam && ((ReportUtil.CQueryInParam)iqip).getQueryInParam() instanceof QueryInParam) {
                                QueryInParam qip = (QueryInParam)((ReportUtil.CQueryInParam)iqip).getQueryInParam();
                                if (((QueryFileInfo)dbInfo).getInSet().getParameterOrder(qip.getParamName()) == 0 && value != null && value.equals(qip.getAllOptionLabel())) {
                                    paramValue[i][1] = null;
                                    continue;
                                }
                            }
                            if (value instanceof String) {
                                valueString = "'" + value + "'";
                            } else if (value instanceof Timestamp) {
                                String db = con.getMetaData().getDatabaseProductName();
                                valueString = db.equalsIgnoreCase("ACCESS") ? "#" + value.toString().substring(0, 19) + "#" : "'" + value + "'";
                            } else if (value instanceof Date) {
                                String db = con.getMetaData().getDatabaseProductName();
                                valueString = db.equalsIgnoreCase("ACCESS") ? "#" + value + "#" : "'" + value + "'";
                            }
                            paramValue[i][1] = valueString;
                        }
                        node = GenericParser.getConditionTree(modifiedQuery = QueryParser.substituteParameters(modifiedQuery, paramValue));
                        if (node != null) {
                            node = GenericParser.removeParameterConditions(node);
                            if ((node = GenericParser.removeCondition(node, tableName + "." + columnName)) != null) {
                                modifiedQuery = "Select Distinct " + (tableAlias == null ? columnName : tableAlias + "." + columnName) + " From " + GenericParser.getQueryPart(originalQuery, 2) + " Where " + node.toString();
                            }
                        }
                    } else if ((node = GenericParser.removeParameterConditions(node)) != null) {
                        modifiedQuery = "Select Distinct " + (tableAlias == null ? columnName : tableAlias + "." + columnName) + " From " + GenericParser.getQueryPart(originalQuery, 2) + " Where " + node.toString();
                    }
                }
            }
            if (modifiedQuery != null) {
                try {
                    rs = stmt.executeQuery(modifiedQuery);
                }
                catch (Exception tableAlias) {
                    // empty catch block
                }
            }
            if (rs == null) {
                rs = stmt.executeQuery(query);
            }
            output = new Vector();
            int count = 0;
            while (rs.next()) {
                Object value = rs.getObject(1);
                if (value == null) continue;
                output.addElement(value);
                ++count;
            }
        }
        catch (Exception ex) {
            try {
                if (ex.getMessage().indexOf("Wrong data type") == -1) {
                    ex.printStackTrace();
                }
                throw new IllegalArgumentException(ex.toString());
            }
            catch (Throwable throwable) {
                CloseUtils.close(rs);
                CloseUtils.close(stmt);
                if (ourConnection || con != dbInfo.getConnection()) {
                    CloseUtils.close(con);
                }
                throw throwable;
            }
        }
        CloseUtils.close(rs);
        CloseUtils.close(stmt);
        if (ourConnection || con != dbInfo.getConnection()) {
            CloseUtils.close(con);
        }
        return output;
    }

    public static synchronized Vector getValuesFromLocal(IJNDIDatabaseInfo dbInfo, String tableName, String columnName) {
        return QueryParser.getValuesFromLocal(dbInfo, tableName, columnName, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Vector getValuesFromLocal(IJNDIDatabaseInfo dbInfo, String tableName, String columnName, int order) {
        Vector<Object> vector;
        String query = tableName.trim().length() > 0 ? "select distinct " + columnName + " from " + tableName : "select distinct " + columnName;
        String modifiedQuery = null;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        String originalQuery = dbInfo == null ? null : dbInfo.getQuery();
        try {
            con = dbInfo.openConnection();
            if (originalQuery != null) {
                ConditionNode node;
                String tableAlias = null;
                String[] tablenames = QueryParser.getAllTableNames(originalQuery, false, true, false);
                String[] aliasnames = QueryParser.getAllTableNames(originalQuery, false, false, false);
                if (tablenames != null && aliasnames != null && tablenames.length == aliasnames.length) {
                    for (int i = 0; i < tablenames.length; ++i) {
                        if (!tableName.equals(tablenames[i])) continue;
                        tableAlias = aliasnames[i];
                        break;
                    }
                }
                if ((node = GenericParser.getConditionTree(originalQuery)) != null) {
                    if (order > 0) {
                        modifiedQuery = "Select Distinct " + (tableAlias == null ? columnName : tableAlias + "." + columnName) + " From " + GenericParser.getQueryPart(originalQuery, 2) + " Where " + node.toString();
                        Vector<quadbase.reportdesigner.util.IQueryInParam> params = new Vector<quadbase.reportdesigner.util.IQueryInParam>();
                        quadbase.reportdesigner.util.IQueryInParam[][] paramInSequence = ReportUtil.getParamInSequence(dbInfo);
                        for (int i = 0; i < order; ++i) {
                            for (int j = 0; paramInSequence != null && j < paramInSequence[i].length; ++j) {
                                if (paramInSequence[i][j] == null) continue;
                                params.add(paramInSequence[i][j]);
                            }
                        }
                        Object[][] paramValue = new String[params.size()][2];
                        for (int i = 0; i < params.size(); ++i) {
                            paramValue[i][0] = ((quadbase.reportdesigner.util.IQueryInParam)params.elementAt(i)).getParamName();
                            Object value = ((quadbase.reportdesigner.util.IQueryInParam)params.elementAt(i)).getValue();
                            String valueString = "IS NULL";
                            if (value != null) {
                                valueString = value.toString();
                            }
                            if (value instanceof String) {
                                valueString = "'" + value + "'";
                            }
                            paramValue[i][1] = valueString;
                        }
                        node = GenericParser.getConditionTree(modifiedQuery = QueryParser.substituteParameters(modifiedQuery, paramValue));
                        if (node != null && (node = GenericParser.removeParameterConditions(node)) != null) {
                            modifiedQuery = "Select Distinct " + (tableAlias == null ? columnName : tableAlias + "." + columnName) + " From " + GenericParser.getQueryPart(originalQuery, 2) + " Where " + node.toString();
                        }
                    } else if ((node = GenericParser.removeParameterConditions(node)) != null) {
                        modifiedQuery = "Select Distinct " + (tableAlias == null ? columnName : tableAlias + "." + columnName) + " From " + GenericParser.getQueryPart(originalQuery, 2) + " Where " + node.toString();
                    }
                }
            }
            stmt = con.createStatement();
            if (modifiedQuery != null) {
                try {
                    rs = stmt.executeQuery(modifiedQuery);
                }
                catch (Exception tableAlias) {
                    // empty catch block
                }
            }
            if (rs == null) {
                rs = stmt.executeQuery(query);
            }
            Vector<Object> output = new Vector<Object>();
            int count = 0;
            while (rs.next()) {
                Object value = rs.getObject(1);
                if (value == null) continue;
                output.addElement(value);
                ++count;
            }
            vector = output;
        }
        catch (Exception ex) {
            Vector vector2;
            try {
                ex.printStackTrace();
                vector2 = null;
            }
            catch (Throwable throwable) {
                CloseUtils.close(rs);
                CloseUtils.close(stmt);
                if (dbInfo != null && con != dbInfo.getConnection()) {
                    CloseUtils.close(con);
                }
                throw throwable;
            }
            CloseUtils.close(rs);
            CloseUtils.close(stmt);
            if (dbInfo != null && con != dbInfo.getConnection()) {
                CloseUtils.close(con);
            }
            return vector2;
        }
        CloseUtils.close(rs);
        CloseUtils.close(stmt);
        if (dbInfo != null && con != dbInfo.getConnection()) {
            CloseUtils.close(con);
        }
        return vector;
    }

    public static Object getFirstValue(DBInfoBasic dbInfo, String tableName, String columnName) {
        String originalQuery = dbInfo.getQuery();
        String[] tablenames = QueryParser.getAllTableNames(originalQuery, false, true, false);
        String[] aliasnames = QueryParser.getAllTableNames(originalQuery, false, false, false);
        if (tablenames != null && aliasnames != null && tablenames.length == aliasnames.length) {
            for (int i = 0; i < tablenames.length; ++i) {
                if (!tableName.equals(aliasnames[i])) continue;
                tableName = tablenames[i];
                break;
            }
        }
        if (dbInfo instanceof IDistinctValuesProvider) {
            return ((IDistinctValuesProvider)((Object)dbInfo)).getFirstValue(tableName, columnName);
        }
        if (ServerMessage.useServer) {
            try {
                return ReadDBFirstValue.getFirstValue(dbInfo, tableName, columnName);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return QueryParser.getFirstValueFromLocal(dbInfo, tableName, columnName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Object getFirstValueFromLocal(DBInfoBasic dbInfo, String tableName, String columnName) {
        Object object;
        String query = "select distinct " + columnName + " from " + tableName;
        Object value = null;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = dbInfo.openConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next() && (value = rs.getObject(1)) == null) {
            }
            object = value;
            CloseUtils.close(rs);
        }
        catch (Exception ex) {
            Object var9_10 = null;
            return var9_10;
        }
        finally {
            CloseUtils.close(rs);
            CloseUtils.close(stmt);
            if (dbInfo.isCloseConnectionEnabled()) {
                CloseUtils.close(con);
            }
        }
        CloseUtils.close(stmt);
        if (dbInfo.isCloseConnectionEnabled()) {
            CloseUtils.close(con);
        }
        return object;
    }

    public static Vector<Integer> getParamTypes(DBInfoBasic dbInfo) {
        if (ServerMessage.useServer) {
            try {
                return ReadDBparamType.getType(dbInfo);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
            }
        }
        return QueryParser.getTypesFromLocal(dbInfo);
    }

    public static synchronized Vector<Integer> getTypesFromLocal(DBInfoBasic dbInfo) {
        String query = dbInfo.getQuery();
        if (QueryParser.getAllParameters(query = QueryParser.removeComments(query)) == null) {
            return new Vector<Integer>();
        }
        String procedureName = QueryParser.getProcedureName(query);
        if (procedureName == null) {
            return new Vector<Integer>();
        }
        Vector<Integer> paramType = null;
        try {
            paramType = QueryParser.getParamType(dbInfo, procedureName);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(IOUtil.getStackTrace(ex));
        }
        return paramType;
    }

    private static String getProcedureName(String query) {
        StringTokenizer tokenizer = new StringTokenizer(query, " \n(");
        boolean found = false;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (nextToken.equalsIgnoreCase("CALL")) {
                found = true;
                break;
            }
            if (!nextToken.equalsIgnoreCase("SELECT")) continue;
            break;
        }
        if (found && tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken();
        }
        return null;
    }

    private static Vector<Integer> getParamType(DBInfoBasic dbInfo, String procedureName) throws Exception {
        Connection con = dbInfo.openConnection();
        DatabaseMetaData dbmd = con.getMetaData();
        ResultSet rs = dbmd.getProcedureColumns(null, null, procedureName, null);
        Vector<Integer> result = new Vector<Integer>();
        while (rs.next()) {
            int columnType = rs.getInt(5);
            if (columnType != 0 && columnType != 1 && columnType != 2) continue;
            int dataType = rs.getInt(6);
            result.addElement(dataType);
        }
        rs.close();
        con.close();
        return result;
    }

    private static String preProcess(String inQuery) {
        int tempIndex;
        int currIndex;
        String[] target;
        String query = inQuery;
        if (query.endsWith(";")) {
            query = query.substring(0, query.length() - 1);
        }
        for (String element : target = new String[]{"<=", ">=", "=>", "=<", "!=", ":"}) {
            currIndex = 0;
            while ((tempIndex = query.indexOf(element, currIndex)) > 0) {
                query = query.substring(0, tempIndex) + " " + query.substring(tempIndex, query.length());
                currIndex = tempIndex + element.length() + 1;
            }
        }
        currIndex = 0;
        while ((tempIndex = query.indexOf(61, currIndex)) > 0) {
            char tempChar = query.charAt(tempIndex - 1);
            if (tempChar != '<' && tempChar != '>' && tempChar != '!') {
                query = query.substring(0, tempIndex) + " " + query.substring(tempIndex, query.length());
                currIndex = tempIndex + 2;
                continue;
            }
            ++currIndex;
        }
        StringTokenizer st = new StringTokenizer(query, " ");
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(" ");
        }
        query = sb.toString();
        return query;
    }

    public static void main(String[] argv) {
        int i;
        String query = "select * from table1 where :param > 3";
        String result = QueryParser.preProcess(query);
        System.out.println(result);
        Vector columnName = QueryParser.getColumnName(query, "param1");
        for (i = 0; i < columnName.size(); ++i) {
            System.out.println((String)columnName.elementAt(i));
        }
        columnName = QueryParser.getColumnName(query, "param2");
        for (i = 0; i < columnName.size(); ++i) {
            System.out.println((String)columnName.elementAt(i));
        }
    }

    public static QueryInParamSet filterParameters(String query, QueryInParamSet paramSet) {
        query = QueryParser.removeComments(query);
        String[] paramNames = QueryParser.getAllParameters(query);
        String[] mvParam = QueryParser.getMultiValueParameters(query);
        if (paramNames != null) {
            try {
                QueryInParam[] params = new QueryInParam[paramNames.length];
                QueryInParam[][] paramsInSequence = null;
                int[] index = null;
                if (paramSet.getParameterInPromptSequence() != null) {
                    paramsInSequence = new QueryInParam[paramNames.length][paramNames.length];
                    index = new int[paramNames.length];
                }
                for (int i = 0; i < paramNames.length; ++i) {
                    int order;
                    boolean isMultiValueParam = false;
                    if (mvParam != null) {
                        for (int j = 0; j < mvParam.length; ++j) {
                            if (!paramNames[i].equals(mvParam[j])) continue;
                            isMultiValueParam = true;
                            j = mvParam.length;
                        }
                    }
                    params[i] = paramSet.getParameter(paramNames[i]);
                    if (params[i] != null && (isMultiValueParam && !(params[i] instanceof QueryMultiValueInParam) || !isMultiValueParam && params[i] instanceof QueryMultiValueInParam)) {
                        params[i] = null;
                    }
                    if (params[i] == null || paramSet.getParameterInPromptSequence() == null) continue;
                    int n = order = paramSet.getParameterOrder(params[i].getParamName());
                    int n2 = index[n];
                    index[n] = n2 + 1;
                    paramsInSequence[order][n2] = params[i];
                }
                return new QueryInParamSet(params, paramsInSequence, query);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static QueryInParam[] verifyAndCopyParameters(QueryInParam[] masterParams, QueryInParam[] sourceParams) {
        IQueryInParam[] params = QueryParser.verifyAndCopyParameters(masterParams, sourceParams, true);
        if (params == null) {
            return null;
        }
        QueryInParam[] newParams = new QueryInParam[params.length];
        for (int i = 0; i < params.length; ++i) {
            newParams[i] = (QueryInParam)params[i];
        }
        return newParams;
    }

    private static IQueryInParam[] verifyAndCopyParameters(QueryInParam[] masterParams, IQueryInParam[] sourceParams, boolean copy) {
        if (masterParams == null || sourceParams == null) {
            return null;
        }
        Vector<IQueryInParam> dest = new Vector<IQueryInParam>();
        QueryInParam[] queryInParamArray = masterParams;
        int n = queryInParamArray.length;
        for (int i = 0; i < n; ++i) {
            QueryInParam masterParam;
            QueryInParam currParam = masterParam = queryInParamArray[i];
            int j = 0;
            for (j = 0; j < sourceParams.length; ++j) {
                if (!currParam.getParamName().equals(sourceParams[j].getParamName()) || currParam.getSqlType() != currParam.getSqlType() || (currParam instanceof QueryMultiValueInParam || sourceParams[j] instanceof quadbase.common.util.IQueryMultiValueInParam) && (!(currParam instanceof QueryMultiValueInParam) || !(sourceParams[j] instanceof quadbase.common.util.IQueryMultiValueInParam))) continue;
                IQueryInParam newParam = sourceParams[j];
                if (copy) {
                    newParam = QueryInParam.create(sourceParams[j]);
                    if (newParam instanceof QueryMultiValueInParam) {
                        ((QueryMultiValueInParam)newParam).setValues(((quadbase.common.util.IQueryMultiValueInParam)sourceParams[j]).getValues());
                    } else {
                        newParam.setValue(sourceParams[j].getValue());
                    }
                }
                dest.addElement(newParam);
                j = sourceParams.length + 1;
            }
            if (j != sourceParams.length) continue;
            return null;
        }
        IQueryInParam[] ret = new IQueryInParam[dest.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (IQueryInParam)dest.elementAt(i);
        }
        return ret;
    }

    public static IQueryInParam[] verifyParameters(QueryInParam[] masterParams, IQueryInParam[] sourceParams) {
        return QueryParser.verifyAndCopyParameters(masterParams, sourceParams, false);
    }

    public static IQueryInParam[] verifyParameters(IQueryInParam[] masterParams, IQueryInParam[] sourceParams) {
        QueryInParam[] newMaster = new QueryInParam[masterParams.length];
        for (int i = 0; i < masterParams.length; ++i) {
            newMaster[i] = QueryInParam.create(masterParams[i]);
        }
        return QueryParser.verifyAndCopyParameters(newMaster, sourceParams, false);
    }

    public static boolean initializationRequired(QueryInParamSet paramSet) {
        boolean initializationRequired = true;
        if (paramSet != null) {
            QueryInParam[] params = paramSet.getParameter();
            for (int i = 0; i < params.length; ++i) {
                initializationRequired = false;
                if (params[i] != null) continue;
                initializationRequired = true;
                i = params.length;
            }
        }
        return initializationRequired;
    }

    public static String addSelectField(String query, String[] fields) {
        int offset = 0;
        StringBuffer sb = new StringBuffer(query);
        StringTokenizer tokenizer = new StringTokenizer(query, " ");
        if (tokenizer.hasMoreTokens() && tokenizer.nextToken().equalsIgnoreCase("select")) {
            offset = query.toLowerCase().indexOf("select ") + 7;
        }
        if (tokenizer.hasMoreTokens() && tokenizer.nextToken().equalsIgnoreCase("distinct")) {
            offset = query.toLowerCase().indexOf("distinct ") + 9;
        }
        for (String field : fields) {
            sb.insert(offset, field + ", ");
            offset += field.length() + 2;
        }
        return sb.toString();
    }

    public static String substituteParameterInWhereClause(String query, String[] columnNames, String[] paramNames, String main_query) throws Exception {
        for (int i = 0; i < columnNames.length; ++i) {
            main_query = QueryParser.modifyMainQuery(main_query, columnNames[i]);
            int paramStart = query.indexOf(":" + paramNames[i]);
            boolean success = false;
            while (paramStart > 0) {
                int index = query.substring(0, paramStart).lastIndexOf(columnNames[i]);
                if (paramStart > 0 && query.substring(index + columnNames[i].length(), paramStart).trim().equals("=")) {
                    query = query.substring(0, index + columnNames[i].length()) + " IN (" + main_query + ")" + query.substring(paramStart + paramNames[i].length() + 1);
                    success = true;
                }
                paramStart = query.indexOf(":" + paramNames[i], index + columnNames[i].length() + main_query.length() + 5);
            }
            if (success) continue;
            throw new Exception("substitute Parameter in where clause Failed");
        }
        return query;
    }

    public static String modifyMainQuery(String query, String selectField) {
        int index = query.toUpperCase().indexOf("FROM");
        query = "select " + selectField + " " + query.substring(index);
        index = query.toUpperCase().lastIndexOf("ORDER BY");
        if (index > 0) {
            query = query.substring(0, index);
        }
        return query;
    }

    public static String addGroupBy(String query, String[] columnNames) {
        int index = query.toUpperCase().lastIndexOf("GROUP BY");
        if (index > 0) {
            String remaining = query.substring(index + 8);
            query = query.substring(0, index + 8);
            for (String columnName : columnNames) {
                query = query + " " + columnName + ",";
            }
            query = query + remaining;
        }
        return query;
    }

    public static String addOrderBy(String query, String[] columnNames) {
        int index = query.toUpperCase().lastIndexOf("ORDER BY");
        if (index < 0) {
            query = query + " \n order by";
            for (int i = 0; i < columnNames.length; ++i) {
                query = query + " " + columnNames[i];
                if (i >= columnNames.length - 1) continue;
                query = query + ",";
            }
        } else {
            String remaining = query.substring(index + 8);
            query = query.substring(0, index + 8);
            for (String columnName : columnNames) {
                query = query + " " + columnName + ",";
            }
            query = query + remaining;
        }
        return query;
    }

    public static String getFunction(String query, String paramName) throws Exception {
        int[] funNameIndices = QueryParser.getFunctionNameIndices(query, paramName);
        if (funNameIndices == null || funNameIndices.length != 3) {
            return null;
        }
        return query.substring(funNameIndices[0], funNameIndices[2]);
    }

    public static int[] getFunctionNameIndices(String query, String paramName) throws Exception {
        char ch;
        int cursor;
        if (query.equalsIgnoreCase(storedQuery) && paramName.equalsIgnoreCase(storedParamName)) {
            return functionNameIndices;
        }
        int paramIndex = query.indexOf(":" + paramName);
        String queryBeforeParam = query.substring(0, paramIndex);
        if (paramIndex == -1) {
            return null;
        }
        int lastOperatorIndex = 0;
        if (queryBeforeParam.lastIndexOf("<=") > lastOperatorIndex) {
            lastOperatorIndex = queryBeforeParam.lastIndexOf("<=");
        }
        if (queryBeforeParam.lastIndexOf(">=") > lastOperatorIndex) {
            lastOperatorIndex = queryBeforeParam.lastIndexOf(">=");
        }
        if (queryBeforeParam.lastIndexOf(62) > lastOperatorIndex) {
            lastOperatorIndex = queryBeforeParam.lastIndexOf(62);
        }
        if (queryBeforeParam.lastIndexOf(60) > lastOperatorIndex) {
            lastOperatorIndex = queryBeforeParam.lastIndexOf(60);
        }
        if (queryBeforeParam.lastIndexOf(61) > lastOperatorIndex + 1) {
            lastOperatorIndex = queryBeforeParam.lastIndexOf(61);
        }
        if (queryBeforeParam.toUpperCase().lastIndexOf("BETWEEN") > lastOperatorIndex) {
            lastOperatorIndex = queryBeforeParam.toUpperCase().lastIndexOf("BETWEEN");
        }
        if (queryBeforeParam.toUpperCase().lastIndexOf("IN") > lastOperatorIndex) {
            lastOperatorIndex = queryBeforeParam.toUpperCase().lastIndexOf("IN");
        }
        if (queryBeforeParam.toUpperCase().lastIndexOf("LIKE") > lastOperatorIndex) {
            lastOperatorIndex = queryBeforeParam.toUpperCase().lastIndexOf("LIKE");
        }
        if ((cursor = (queryBeforeParam = queryBeforeParam.substring(0, lastOperatorIndex)).lastIndexOf(41) - 1) < 0) {
            return null;
        }
        int parenSetCount = 1;
        int openParen = -1;
        while (parenSetCount > 0) {
            ch = queryBeforeParam.charAt(cursor);
            if (ch == '(') {
                --parenSetCount;
            } else if (ch == ')') {
                ++parenSetCount;
            }
            --cursor;
        }
        ch = queryBeforeParam.charAt(cursor);
        try {
            if (ch != '!' && ch != '(') {
                while (ch == ' ' || ch == '\t' || ch == '\n') {
                    ch = queryBeforeParam.charAt(--cursor);
                }
                openParen = cursor + 1;
                if (ch != '!' && ch != '(') {
                    while (ch != ' ' && ch != '!' && ch != '(' && ch != '\t' && ch != '\n') {
                        ch = queryBeforeParam.charAt(--cursor);
                    }
                    String tmp = queryBeforeParam.substring(cursor + 1, openParen);
                    if (!(tmp.equalsIgnoreCase("WHERE") || tmp.equalsIgnoreCase("AND") || tmp.equalsIgnoreCase("OR") || tmp.equalsIgnoreCase("NOT") || tmp.equalsIgnoreCase("LIKE") || tmp.equalsIgnoreCase("NOT"))) {
                        storedQuery = query;
                        storedParamName = paramName;
                        functionNameIndices = new int[]{cursor + 1, openParen, lastOperatorIndex};
                        return functionNameIndices;
                    }
                }
            }
            if (openParen > -1) {
                cursor = openParen;
            }
            ch = queryBeforeParam.charAt(cursor);
            while (ch == ' ' || ch == '(' || ch == '!' || ch == '\t' || ch == '\n') {
                ch = queryBeforeParam.charAt(++cursor);
            }
            openParen = cursor;
            while (ch != ' ' && ch != '!' && ch != '(' && ch != '\t' && ch != '\n') {
                ch = queryBeforeParam.charAt(++openParen);
            }
            functionNameIndices = new int[]{cursor, openParen, lastOperatorIndex};
            return functionNameIndices;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object[] getFunctionParamsFromQuery(String query, String paramName) throws Exception {
        Vector<String> params = new Vector<String>();
        int[] funNameIndices = QueryParser.getFunctionNameIndices(query, paramName);
        if (funNameIndices == null || funNameIndices.length != 3) {
            return null;
        }
        StringBuffer querySB = new StringBuffer(query.substring(funNameIndices[1], funNameIndices[2]).trim());
        if (querySB.toString().startsWith("(") && querySB.toString().endsWith(")")) {
            querySB.deleteCharAt(0);
            querySB.deleteCharAt(querySB.length() - 1);
        }
        StringBuffer tmp = new StringBuffer();
        int pCount = 0;
        for (int i = 0; i < querySB.length(); ++i) {
            tmp.append(querySB.charAt(i));
            if (querySB.charAt(i) == '(') {
                ++pCount;
            } else if (querySB.charAt(i) == ')') {
                --pCount;
            }
            if (pCount != 0 || querySB.charAt(i) != ',') continue;
            params.add(tmp.substring(0, tmp.length() - 1).trim());
            tmp = new StringBuffer();
        }
        params.add(tmp.toString().trim());
        return params.toArray();
    }

    public static Vector executeSQLSelect(IDatabaseInfo dbInfo, String query, Parameters params, boolean defaultValue) {
        if (defaultValue) {
            return QueryParser.executeSQLSelect(dbInfo, query, params, 2);
        }
        return QueryParser.executeSQLSelect(dbInfo, query, params, 0);
    }

    public static Vector executeSQLSelect(IDatabaseInfo dbInfo, String query, Parameters params, int defaultValue) {
        try {
            ReadDatabase readDB;
            String DBName;
            Object[][] paramNameValue;
            if (params != null && (query = QueryParser.modifyQuery(query, paramNameValue = QueryParser.getParamNameValuePair(params, defaultValue, DBName = (readDB = dbInfo instanceof QueryFileInfo && ((QueryFileInfo)dbInfo).isUseJNDIDataSource() ? new ReadDatabase(((QueryFileInfo)dbInfo).getJNDIName(), ((QueryFileInfo)dbInfo).getEnvProperties()) : new ReadDatabase(dbInfo.getURLString(), dbInfo.getDriverName(), dbInfo.getUserID(), dbInfo.getPassword())).getProductName()))) == null) {
                return null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (ServerMessage.useServer) {
            try {
                return ReadDBdistinct.executeSqlSelect(dbInfo, query, defaultValue);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return QueryParser.executeSqlSelectLocally(dbInfo, query, defaultValue);
    }

    public static Vector executeSQLSelect(IDatabaseInfo dbInfo, String query, QueryInParam[] queryInParam, boolean useDefaultValue) {
        if (useDefaultValue) {
            return QueryParser.executeSQLSelect(dbInfo, query, queryInParam, 2);
        }
        return QueryParser.executeSQLSelect(dbInfo, query, queryInParam, 0);
    }

    public static Vector executeSQLSelect(IDatabaseInfo dbInfo, String query, QueryInParam[] queryInParam, int useDefaultValue) {
        try {
            if (queryInParam != null) {
                ReadDatabase readDB = dbInfo instanceof QueryFileInfo && ((QueryFileInfo)dbInfo).isUseJNDIDataSource() ? new ReadDatabase(((QueryFileInfo)dbInfo).getJNDIName(), ((QueryFileInfo)dbInfo).getEnvProperties()) : new ReadDatabase(dbInfo.getURLString(), dbInfo.getDriverName(), dbInfo.getUserID(), dbInfo.getPassword());
                String DBName = readDB.getProductName();
                Object[][] paramNameValue = QueryParser.getParamNameValuePair(queryInParam, useDefaultValue, DBName, dbInfo);
                query = QueryParser.modifyQuery(query, paramNameValue);
                readDB.finalize();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (ServerMessage.useServer) {
            try {
                return ReadDBdistinct.executeSqlSelect(dbInfo, query, useDefaultValue);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return QueryParser.executeSqlSelectLocally(dbInfo, query, useDefaultValue);
    }

    static String convertObjectToString(Object value, String DBProductName) {
        String valueString = "IS NULL";
        if (value != null) {
            valueString = value.toString();
        }
        if (value instanceof String) {
            value = ((String)value).replace("'", "''");
            valueString = "'" + value + "'";
        } else if (value instanceof Timestamp) {
            valueString = DBProductName.equalsIgnoreCase("ACCESS") ? "#" + value.toString().substring(0, 19) + "#" : "'" + value + "'";
        } else if (value instanceof Date) {
            valueString = DBProductName.equalsIgnoreCase("ACCESS") ? "#" + value + "#" : "'" + value + "'";
        }
        return valueString;
    }

    private static Object getDefaultValueString(QueryInParam inParam, String DBName, IDatabaseInfo dbInfo) {
        Object value = inParam.getDefaultValue();
        if (inParam instanceof QueryMultiValueInParam) {
            Vector<String> stringVec = new Vector<String>();
            stringVec.add(QueryParser.convertObjectToString(value, DBName));
            return stringVec;
        }
        return QueryParser.convertObjectToString(value, DBName);
    }

    private static Object getDefaultValueString(Param inParam, String DBName) {
        Object value = inParam.getDefaultValue();
        if (inParam instanceof QueryMultiValueInParam) {
            Vector<String> stringVec = new Vector<String>();
            stringVec.add(QueryParser.convertObjectToString(value, DBName));
            return stringVec;
        }
        return QueryParser.convertObjectToString(value, DBName);
    }

    static Object[][] getParamNameValuePair(QueryInParam[] queryInParam, int useDefaultValue, String DBName, IDatabaseInfo dbInfo) throws Exception {
        Vector<QueryInParam> vec = new Vector<QueryInParam>();
        for (QueryInParam element : queryInParam) {
            if (element == null) continue;
            vec.addElement(element);
        }
        Object[][] paramValue = new Object[vec.size()][2];
        for (int i = 0; i < vec.size(); ++i) {
            QueryInParam inParam = (QueryInParam)vec.elementAt(i);
            paramValue[i][0] = inParam.getParamName();
            if (useDefaultValue == 2) {
                paramValue[i][1] = QueryParser.getDefaultValueString(inParam, DBName, dbInfo);
                continue;
            }
            if (inParam instanceof QueryMultiValueInParam) {
                Vector<Object> temp = ((QueryMultiValueInParam)inParam).getValues();
                Vector<String> stringVec = new Vector<String>();
                for (int j = 0; temp != null && j < temp.size(); ++j) {
                    Object value = temp.elementAt(j);
                    stringVec.addElement(QueryParser.convertObjectToString(value, DBName));
                }
                if (stringVec.size() == 0 && useDefaultValue == 1) {
                    paramValue[i][1] = QueryParser.getDefaultValueString(inParam, DBName, dbInfo);
                    continue;
                }
                paramValue[i][1] = stringVec;
                continue;
            }
            Object value = inParam.getValue();
            paramValue[i][1] = value == null && useDefaultValue == 1 ? QueryParser.getDefaultValueString(inParam, DBName, dbInfo) : QueryParser.convertObjectToString(value, DBName);
        }
        return paramValue;
    }

    static Object[][] getParamNameValuePair(Parameters params, int defaultValue, String DBName) throws Exception {
        Vector<Param> vec = new Vector<Param>();
        for (int i = 0; i < params.size(); ++i) {
            if (params.get(i) == null) continue;
            vec.addElement(params.get(i));
        }
        Object[][] paramValue = new Object[vec.size()][2];
        for (int i = 0; i < vec.size(); ++i) {
            Param param = (Param)vec.elementAt(i);
            paramValue[i][0] = param.name();
            if (defaultValue == 2) {
                paramValue[i][1] = QueryParser.getDefaultValueString(param, DBName);
                continue;
            }
            if (param.multiValue()) {
                Vector<Object> temp = param.getValues();
                if (temp == null) {
                    temp = new Vector<Object>();
                    if (defaultValue == 1) {
                        temp.add(param.getDefaultValue());
                    }
                }
                Vector<String> stringVec = new Vector<String>();
                for (int j = 0; j < temp.size(); ++j) {
                    Object value = temp.elementAt(j);
                    stringVec.addElement(QueryParser.convertObjectToString(value, DBName));
                }
                paramValue[i][1] = stringVec;
                continue;
            }
            Object value = param.getValue();
            paramValue[i][1] = value == null && defaultValue == 1 ? QueryParser.getDefaultValueString(param, DBName) : QueryParser.convertObjectToString(value, DBName);
        }
        return paramValue;
    }

    private static String modifyQuery(String query, Object[][] paramValue) {
        String oldQuery;
        if (!QueryParser.hasParameters(query)) {
            return query;
        }
        String modifiedQuery = QueryParser.substituteParameters(query, paramValue);
        if (modifiedQuery == null) {
            return null;
        }
        Pattern bracketPattern = Pattern.compile("\\(([^()]*)\\)");
        Pattern selectPattern = Pattern.compile("(?i)(?s).*\\bSELECT\\b.*");
        StringBuffer sb = new StringBuffer(modifiedQuery);
        do {
            Matcher m;
            oldQuery = sb.toString();
            boolean found = false;
            do {
                m = bracketPattern.matcher(sb);
                sb = new StringBuffer();
                found = false;
                while (m.find()) {
                    if (selectPattern.matcher(m.group()).matches()) continue;
                    m.appendReplacement(sb, "<l#E#f#T>$1<R#i#G#h#T>");
                    found = true;
                }
                m.appendTail(sb);
            } while (found);
            m = bracketPattern.matcher(sb);
            sb = new StringBuffer();
            while (m.find()) {
                String subQuery = m.group().substring(1, m.group().length() - 1);
                subQuery = QueryParser.modifySubquery(subQuery);
                m.appendReplacement(sb, LEFT_BRACKET_REPLACEMENT + Matcher.quoteReplacement(subQuery) + RIGHT_BRACKET_REPLACEMENT);
            }
            m.appendTail(sb);
        } while (!sb.toString().equals(oldQuery));
        String result = QueryParser.modifySubquery(sb.toString());
        result = QueryParser.revertReplacements(result);
        return result;
    }

    private static String modifySubquery(String query) {
        Pattern unionPattern = Pattern.compile("(?i)UNION ALL|UNION");
        String[] unionParts = unionPattern.split(query);
        for (int partNo = 0; partNo < unionParts.length; ++partNo) {
            if (!unionParts[partNo].matches("(?i)(?s).*\\bSELECT\\b.*")) continue;
            String subQuery = unionParts[partNo].replace(LEFT_BRACKET_REPLACEMENT, "(").replace(RIGHT_BRACKET_REPLACEMENT, ")");
            ConditionNode node = GenericParser.getConditionTree(subQuery);
            if (node != null) {
                node = GenericParser.removeParameterConditions(node);
            }
            String result = "<s#E#l#E#c#T> " + GenericParser.getQueryPart(subQuery, 1, false);
            String from = GenericParser.getQueryPart(subQuery, 2, false);
            if (from != null) {
                result = result + " <F#r#O#m> " + from;
            }
            if (node != null) {
                result = result + " <W#h#e#R#e> " + node.toString();
            }
            result = result + " " + GenericParser.getPostWhereQuery(subQuery);
            unionParts[partNo] = result.replace("(", LEFT_BRACKET_REPLACEMENT).replace(")", RIGHT_BRACKET_REPLACEMENT);
        }
        StringBuffer newQuery = new StringBuffer(unionParts[0]);
        Matcher m = unionPattern.matcher(query);
        int i = 1;
        while (m.find()) {
            newQuery.append(" " + m.group() + " " + unionParts[i]);
            ++i;
        }
        return newQuery.toString();
    }

    private static String revertReplacements(String query) {
        query = query.replaceAll(LEFT_BRACKET_REPLACEMENT, "(");
        query = query.replaceAll(RIGHT_BRACKET_REPLACEMENT, ")");
        query = query.replaceAll(SELECT_REPLACEMENT, "SELECT");
        query = query.replaceAll(FROM_REPLACEMENT, "FROM");
        query = query.replaceAll(WHERE_REPLACEMENT, "WHERE");
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static Vector executeSqlSelectLocally(IDatabaseInfo dbInfo, String query, int useDefaultValue) {
        block12: {
            result = new Vector<Vector<E>>();
            output = null;
            output2 = null;
            con = null;
            stmt = null;
            rs = null;
            try {
                con = dbInfo.getConnection();
                if (con == null) {
                    con = dbInfo instanceof DBInfoBasic != false && ((DBInfoBasic)dbInfo).isUseJNDIDataSource() != false ? QueryParser.getConnectionForJNDI(dbInfo, con) : new QbConnection(dbInfo.getDriverName(), ServerMessage.getDatabaseURL(dbInfo.getURLString()), dbInfo.getUserID(), dbInfo.getPassword());
                }
                stmt = con.createStatement();
                rs = stmt.executeQuery(query);
                columnCt = rs.getMetaData().getColumnCount();
                sqlType = rs.getMetaData().getColumnType(columnCt);
                output = new Vector<Object>();
                if (columnCt == 2) {
                    output2 = new Vector<Object>();
                }
                count = 0;
                while (rs.next()) {
                    value = rs.getObject(1);
                    if (columnCt == 1) {
                        if (value == null) continue;
                        output.addElement(value);
                        ++count;
                        continue;
                    }
                    if (columnCt != 2) continue;
                    value2 = rs.getObject(2);
                    if (value == null || value2 == null) continue;
                    output.addElement(value);
                    output2.addElement(value2);
                    ++count;
                }
                if (useDefaultValue != 2) break block12;
                output.addElement(sqlType);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable var14_15) {
                    CloseUtils.close(rs);
                    CloseUtils.close(stmt);
                    if (con != dbInfo.getConnection()) {
                        CloseUtils.close(con);
                    }
                    throw var14_15;
                }
                CloseUtils.close(rs);
                CloseUtils.close(stmt);
                if (con != dbInfo.getConnection()) {
                    CloseUtils.close(con);
                } else {
                    ** GOTO lbl55
                }
            }
        }
        CloseUtils.close(rs);
        CloseUtils.close(stmt);
        if (con != dbInfo.getConnection()) {
            CloseUtils.close(con);
        }
        result.addElement(output);
        if (output2 != null) {
            result.addElement(output2);
        }
        return result;
    }

    public static String testSqlSelect(IDatabaseInfo dbInfo, String query, boolean isDefaultSQL) {
        String modifiedQuery = QueryParser.modifyQuery(query, new Object[0][]);
        if (ServerMessage.useServer) {
            try {
                return ReadDBdistinct.testSqlSelect(dbInfo, modifiedQuery, isDefaultSQL);
            }
            catch (Exception ex) {
                return ex.getMessage();
            }
        }
        return QueryParser.testSqlSelectLocally(dbInfo, modifiedQuery, isDefaultSQL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String testSqlSelectLocally(IDatabaseInfo dbInfo, String query, boolean isDefaultSQL) {
        String string;
        ResultSet rs;
        PreparedStatement pStat;
        Connection con;
        block8: {
            int columnCount;
            block7: {
                con = null;
                pStat = null;
                rs = null;
                con = dbInfo.getConnection();
                if (con == null) {
                    con = dbInfo instanceof DBInfoBasic && ((DBInfoBasic)dbInfo).isUseJNDIDataSource() ? QueryParser.getConnectionForJNDI(dbInfo, con) : new QbConnection(dbInfo.getDriverName(), ServerMessage.getDatabaseURL(dbInfo.getURLString()), dbInfo.getUserID(), dbInfo.getPassword());
                }
                pStat = con.prepareStatement(query);
                rs = pStat.executeQuery();
                columnCount = rs.getMetaData().getColumnCount();
                if (!isDefaultSQL || columnCount == 1) break block7;
                String string2 = LanguageEncoder.getText("Can only have one column in SELECT for default SQL");
                CloseUtils.close(rs);
                CloseUtils.close(pStat);
                CloseUtils.close(con);
                return string2;
            }
            if (isDefaultSQL || columnCount >= 1 && columnCount <= 2) break block8;
            String string3 = LanguageEncoder.getText("Can only have one or two columns in SELECT");
            CloseUtils.close(rs);
            CloseUtils.close(pStat);
            CloseUtils.close(con);
            return string3;
        }
        try {
            string = "success";
        }
        catch (Exception ex) {
            String string4;
            try {
                string4 = ex.getMessage();
            }
            catch (Throwable throwable) {
                CloseUtils.close(rs);
                CloseUtils.close(pStat);
                CloseUtils.close(con);
                throw throwable;
            }
            CloseUtils.close(rs);
            CloseUtils.close(pStat);
            CloseUtils.close(con);
            return string4;
        }
        CloseUtils.close(rs);
        CloseUtils.close(pStat);
        CloseUtils.close(con);
        return string;
    }

    public static String removeComments(String query) {
        if (query == null) {
            return null;
        }
        query = query.replaceAll("(?s)/\\*.*?\\*/", "");
        query = QueryParser.removeSingleLineComments(query, "//");
        query = QueryParser.removeSingleLineComments(query, "--");
        return query;
    }

    private static String removeSingleLineComments(String query, String leadingCharacters) {
        Pattern pattern = Pattern.compile("(" + leadingCharacters + ".*$)|('.*')|(\".*\")", 8);
        Matcher matcher = pattern.matcher(query);
        StringBuffer result = new StringBuffer(query.length());
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                matcher.appendReplacement(result, "");
                continue;
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(matcher.group()));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static Connection getConnectionForJNDI(IDatabaseInfo dbInfo, Connection con) throws SQLException, NamingException {
        try {
            Hashtable<String, String> env = ((DBInfoBasic)dbInfo).getEnvProperties();
            InitialContext ctx = env == null || env.size() == 0 ? new InitialContext() : new InitialContext(env);
            DataSource ds = (DataSource)ctx.lookup(((DBInfoBasic)dbInfo).getJNDIName());
            con = new QbJNDIConnection(ds.getConnection());
        }
        catch (NamingException ex) {
            LOGGER.log(Level.SEVERE, "Failed to get connection for JNDI data source.\n", ex);
            throw ex;
        }
        return con;
    }
}

