/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.chart.ColData;
import quadbase.chart.SalesForceAccess;
import quadbase.common.paramquery.IDistinctValuesProvider;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.SalesForceQueryParser;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.SalesForceConnection;
import quadbase.common.util.internal.XMLUtil;

public class SalesForceQueryFileInfo
extends QueryFileInfo
implements IDistinctValuesProvider {
    public static final String XMLTAG = "SALESFORCE";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.S'Z'";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private SalesForceConnection connection;
    private String sessionId = null;
    private String serverUrl = null;
    private String clientId = null;

    public SalesForceQueryFileInfo(String username, String password, String query) {
        super(null, -1, new DBInfoBasic("", "", username, password, query), null);
    }

    public SalesForceQueryFileInfo(String username, String password, String query, QueryInParamSet inSet) {
        super(null, -1, new DBInfoBasic("", "", username, password, query), null);
        this.setInSet(inSet);
    }

    public boolean isParameterized() {
        return SalesForceQueryParser.hasParameters(this.query);
    }

    public String getQueryWithParameters() throws Exception {
        return this.substituteParameters(this.query);
    }

    public SalesForceConnection getSalesForceConnection() throws Exception {
        if (this.connection == null) {
            this.connection = this.sessionId != null && this.serverUrl != null ? SalesForceConnection.getSalesForceConnection2(this.serverUrl, this.sessionId, this.clientId) : SalesForceConnection.getSalesForceConnection(this.getUserID(), this.getPassword(), this.clientId);
        }
        return this.connection;
    }

    public static SalesForceQueryFileInfo readSalesForceQueryInfo(DataInput din, int version) throws IOException {
        String username = Coder.decode(IOUtil.readString(din, true));
        String password = Coder.decode(IOUtil.readString(din, true));
        String query = Coder.decode(IOUtil.readString(din, true));
        QueryInParamSet inSet = QueryInParamSet.read(din, 361);
        SalesForceQueryFileInfo result = new SalesForceQueryFileInfo(username, password, query, inSet);
        return result;
    }

    @Override
    public void write(DataOutputStream dout) throws IOException {
        this.write((DataOutput)dout);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        IOUtil.writeString(out, Coder.encode(this.getUserID()));
        IOUtil.writeString(out, Coder.encode(this.getPassword()));
        IOUtil.writeString(out, Coder.encode(this.query));
        if (this.inSet != null) {
            this.inSet.write(out);
        } else {
            out.writeInt(0);
        }
    }

    public static SalesForceQueryFileInfo readSalesForceQueryInfoXML(Node source) throws Exception {
        NodeList queries;
        if (!(source instanceof Element)) {
            throw new Exception("Failed to read SalesForce datasource");
        }
        Element el = (Element)source;
        NodeList list = el.getElementsByTagName(XMLTAG);
        if (list == null || list.getLength() == 0) {
            throw new Exception("SALESFORCE element not found in the " + el.getLocalName() + " element.");
        }
        Element sfElement = (Element)list.item(0);
        String username = sfElement.getAttribute("username");
        String password = sfElement.getAttribute("password");
        if (sfElement.getAttributeNode("encryptedPassword") != null) {
            password = Coder.decode(sfElement.getAttribute("encryptedPassword"));
        }
        if ((queries = el.getElementsByTagName("SOQLQUERY")) == null || queries.getLength() == 0) {
            throw new Exception("QUERY element not found in the SALESFORCE element.");
        }
        Element queryElement = (Element)queries.item(0);
        String query = XMLUtil.readCDATA(queryElement);
        QueryInParamSet inSet = null;
        NodeList params = el.getElementsByTagName("QUERY_PARAMETER_SET");
        if (params != null && params.getLength() > 0) {
            inSet = QueryInParamSet.readXML(params.item(0), 0);
        }
        return new SalesForceQueryFileInfo(username, password, query, inSet);
    }

    @Override
    public void writeXML(Writer out) throws IOException {
        out.write("<SALESFORCE username=\"" + this.getUserID() + "\" encryptedPassword=\"" + Coder.encode(this.getPassword()) + "\">\n");
        out.write("<SOQLQUERY><![CDATA[" + this.getQuery() + "]]></SOQLQUERY>\n");
        if (this.isParameterized()) {
            this.inSet.writeXML(out);
        }
        out.write("</SALESFORCE>\n");
        out.flush();
    }

    @Override
    @Deprecated
    public Connection getConnection() {
        throw new UnsupportedOperationException("getConnection() is not supported for SalesForceQueryFile info. Use getSalesForceConnection() instead.");
    }

    @Deprecated
    public static DBInfoBasic read(DataInput din, int version) {
        throw new UnsupportedOperationException("read(DataInput, int) is not supported for SalesForceQueryFile info. Use getSalesForceQueryInfo(DataInput, int) instead.");
    }

    private String substituteParameters(String sfQuery) throws Exception {
        String[] parameter = SalesForceQueryParser.getAllParameters(sfQuery);
        if (parameter == null || parameter.length == 0) {
            return sfQuery;
        }
        QueryInParamSet paramSet = this.getInSet();
        int paramCount = 0;
        if (paramSet != null) {
            paramCount = paramSet.getParameter().length;
        }
        if (paramSet == null || paramCount != parameter.length) {
            throw new IllegalArgumentException(parameter.length + " parameters expected, but " + paramCount + " found");
        }
        for (int i = 0; i < parameter.length; ++i) {
            String max = parameter[i];
            for (int j = i + 1; j < parameter.length; ++j) {
                if (parameter[j].length() <= max.length()) continue;
                String tmp = max;
                max = parameter[j];
                parameter[j] = tmp;
            }
            parameter[i] = max;
        }
        String tempQuery = sfQuery;
        for (String element : parameter) {
            int temp;
            int index = 0;
            while ((temp = tempQuery.indexOf(":" + element, index)) > 0) {
                Vector<Object> paramValue;
                String remaining = tempQuery.substring(temp + 1 + element.length());
                tempQuery = tempQuery.substring(0, temp);
                index = temp;
                QueryInParam param = paramSet.getParameter(element);
                if (param == null) {
                    throw new IllegalArgumentException("Parameter '" + element + "' not found in the ParamSet");
                }
                if (param instanceof QueryMultiValueInParam) {
                    paramValue = ((QueryMultiValueInParam)param).getValues();
                    if (paramValue == null || paramValue.size() == 0) {
                        tempQuery = tempQuery.substring(0, tempQuery.toLowerCase().lastIndexOf("in"));
                        remaining = remaining.substring(remaining.indexOf(41) + 1);
                        tempQuery = tempQuery + "= null" + remaining;
                        continue;
                    }
                } else {
                    paramValue = param.getValue();
                }
                if (paramValue == null || param.getSqlType() != 12 && ((Object)paramValue).equals("")) {
                    tempQuery = this.removeOperators(tempQuery);
                    tempQuery = tempQuery + "= null" + remaining;
                    continue;
                }
                if (param instanceof QueryMultiValueInParam) {
                    Vector<Object> values = paramValue;
                    Iterator<Object> iterator = values.iterator();
                    while (iterator.hasNext()) {
                        tempQuery = tempQuery + this.paramObjectToString(iterator.next(), param.getSqlType(), param.getDateFormat());
                        if (!iterator.hasNext()) continue;
                        tempQuery = tempQuery + ", ";
                    }
                    tempQuery = tempQuery + remaining;
                    continue;
                }
                tempQuery = tempQuery + this.paramObjectToString(paramValue, param.getSqlType(), param.getDateFormat()) + remaining;
            }
        }
        return tempQuery;
    }

    private String paramObjectToString(Object object, int sqlType, String dateFormat) throws Exception {
        Object obj = object;
        if (object instanceof String && sqlType != 12) {
            obj = DataType.createObject((String)object, DataType.mapType(sqlType), dateFormat);
        }
        if (obj instanceof String) {
            return "'" + (String)obj + "'";
        }
        if (obj instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            return format.format((Date)obj);
        }
        if (obj instanceof Timestamp) {
            SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
            return format.format((Timestamp)obj);
        }
        return obj.toString();
    }

    private String removeOperators(String s) {
        s = s.trim();
        while (s.endsWith(">") || s.endsWith("<") || s.endsWith("=") || s.endsWith("!")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.toLowerCase().matches("^.*\\s*like\\s*$")) {
            s = s.substring(0, s.toLowerCase().lastIndexOf("like"));
        }
        return s;
    }

    @Override
    public Vector getDistinctValues(String tableName, String columnName) {
        return this.getDistinctValues(tableName, columnName, -1);
    }

    @Override
    public Vector getDistinctValues(String tableName, String columnName, int order) {
        try {
            String tmpQuery = "SELECT " + columnName + " FROM " + tableName;
            SalesForceQueryFileInfo tmpInfo = new SalesForceQueryFileInfo(this.getUserID(), this.getPassword(), tmpQuery);
            tmpInfo.setServerUrl(this.getServerUrl());
            tmpInfo.setSessionId(this.getSessionId());
            ColData[] colData = SalesForceAccess.getColData(tmpInfo);
            HashSet<Object> set = new HashSet<Object>();
            if (colData != null && colData.length > 0) {
                for (int i = 0; i < colData[0].getSize(); ++i) {
                    Object obj = colData[0].getData(i);
                    if (obj == null && colData[0].getDataType() == 7) {
                        set.add("");
                        continue;
                    }
                    set.add(obj);
                }
            }
            return new Vector(set);
        }
        catch (Exception e) {
            return new Vector();
        }
    }

    @Override
    public Object getFirstValue(String tableName, String columnName) {
        Vector v = this.getDistinctValues(tableName, columnName);
        if (v == null || v.size() == 0) {
            return "";
        }
        return v.get(0);
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        this.connection = null;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
        this.connection = null;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
        this.connection = null;
    }

    public String getClientId() {
        return this.clientId;
    }
}

