/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery;

import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.parser.GenericParser;
import quadbase.common.util.internal.SalesForceConnection;
import quadbase.util.SalesForceResultSet;

public class SalesForceQueryParser {
    private static final Pattern AGGREGATION_PATTERN = Pattern.compile("(?i)\\s*(COUNT|COUNT_DISTINCT|AVG|MIN|MAX|SUM)\\s*\\(\\s*(.*)\\s*\\)\\s*");

    public static String getDefaultTableName(String query) {
        String[] names = QueryParser.getAllTableNames(query);
        if (names == null || names.length == 0) {
            throw new IllegalArgumentException("No table found in the FROM clause");
        }
        if (names.length > 1) {
            throw new IllegalArgumentException("More than one table found in the FROM clause");
        }
        return names[0];
    }

    public static String[][] getColumnNamesAndAliases(String query) {
        String selectPart = GenericParser.getQueryPart(query, 1);
        StringTokenizer tokenizer = new StringTokenizer(selectPart, ",", false);
        String[] columnNames = new String[tokenizer.countTokens()];
        String[] aliases = new String[tokenizer.countTokens()];
        int i = 0;
        Pattern pattern = Pattern.compile("^(.*)\\s+([^\\)]+)$");
        while (tokenizer.hasMoreElements()) {
            String token = ((String)tokenizer.nextElement()).trim();
            Matcher matcher = pattern.matcher(token);
            if (matcher.matches()) {
                columnNames[i] = matcher.group(1);
                aliases[i] = matcher.group(2);
            } else {
                columnNames[i] = token;
                aliases[i] = token;
            }
            ++i;
        }
        return new String[][]{columnNames, aliases};
    }

    public static String addAggregationAliases(String query) {
        Pattern pattern = Pattern.compile("(?is)^\\s*SELECT(.*)(FROM.*)$");
        Matcher matcher = pattern.matcher(query);
        if (!matcher.matches()) {
            return query;
        }
        String selectPart = matcher.group(1);
        StringTokenizer tokenizer = new StringTokenizer(selectPart, ",", false);
        StringBuffer result = new StringBuffer(query.length() * 2);
        result.append("SELECT ");
        int counter = 0;
        while (tokenizer.hasMoreElements()) {
            String token = ((String)tokenizer.nextElement()).trim();
            result.append(token);
            if (SalesForceQueryParser.isAggregatedColumn(token)) {
                result.append(" aggr").append(counter);
                ++counter;
            }
            if (!tokenizer.hasMoreElements()) continue;
            result.append(", ");
        }
        result.append(" ");
        result.append(matcher.group(2));
        return result.toString();
    }

    public static void checkForNestedSelects(String query) throws Exception {
        String tmp = query.toUpperCase();
        int firstSelect = tmp.indexOf("SELECT");
        if (firstSelect < 0) {
            throw new Exception("SELECT not found in the query");
        }
        if ((tmp = tmp.substring(firstSelect + 6)).matches(".*\\(\\s*SELECT\\s.*")) {
            throw new UnsupportedOperationException("Parent-to-child relationship queries (nested SELECTs) are not supported");
        }
    }

    public static String[] getAllParameters(String query) {
        return QueryParser.getAllParameters(query);
    }

    public static String[] getMultiValueParameters(String query) {
        return QueryParser.getMultiValueParameters(query);
    }

    public static boolean hasParameters(String query) {
        return SalesForceQueryParser.getAllParameters(query) != null;
    }

    public static QueryInParamSet filterParameters(String query, QueryInParamSet paramSet) {
        return QueryParser.filterParameters(query, paramSet);
    }

    public static boolean initializationRequired(QueryInParamSet paramSet) {
        return QueryParser.initializationRequired(paramSet);
    }

    public static String getFirstMatchingColumnName(String query, String parameterName) {
        Vector names = QueryParser.getColumnName(query, parameterName, " ()\t\n\r");
        if (names != null && names.size() > 0) {
            return (String)names.get(0);
        }
        return null;
    }

    public static String removeWhere(String query) {
        String selectPart = GenericParser.getQueryPart(query, 1);
        String fromPart = GenericParser.getQueryPart(query, 2);
        String postWherePart = GenericParser.getPostWhereQuery(query);
        return "SELECT " + selectPart + " FROM " + fromPart + postWherePart;
    }

    public static String[] getAllTableNames(String query, SalesForceConnection conn) throws Exception {
        SalesForceResultSet rs = new SalesForceResultSet(conn, SalesForceQueryParser.removeWhere(query));
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < rs.getColumnCount(); ++i) {
            result.add(rs.getTableName(i + 1));
        }
        return result.toArray(new String[0]);
    }

    public static int mapDataType(String typeName) {
        if (typeName.equalsIgnoreCase("int")) {
            return 4;
        }
        if (typeName.equalsIgnoreCase("double") || typeName.equalsIgnoreCase("percent") || typeName.equalsIgnoreCase("currency")) {
            return 8;
        }
        if (typeName.equalsIgnoreCase("boolean")) {
            return 16;
        }
        if (typeName.equalsIgnoreCase("date")) {
            return 91;
        }
        if (typeName.equalsIgnoreCase("datetime")) {
            return 93;
        }
        if (typeName.equalsIgnoreCase("base64Binary")) {
            return 2004;
        }
        return 12;
    }

    public static boolean isCountQuery(String query) {
        return query.matches("(?is)^\\s*SELECT\\s*COUNT\\s*\\(\\s*\\)\\s*FROM.*$");
    }

    public static boolean isAggregatedColumn(String columnName) {
        return AGGREGATION_PATTERN.matcher(columnName).matches();
    }

    public static String removeAggregation(String columnName) {
        Matcher matcher = AGGREGATION_PATTERN.matcher(columnName);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return columnName;
    }
}

