/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery.allparser;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.jsqlparser.JSQLParserException;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.allparser.AllParamExpressionsParser;
import quadbase.common.paramquery.allparser.ReplaceBetweenParser;

public class AllParser {
    private static final Logger LOGGER = Logger.getLogger(AllParser.class.getName());
    String sql = null;
    AllParamExpressionsParser replaceParamParser = null;
    String[] otherParams;

    public AllParser(String sql) {
        this.sql = sql = QueryParser.removeComments(sql);
    }

    public void parse(String param) throws JSQLParserException {
        try {
            String newSql = this.sql.replaceAll(":" + param + "\\b", "?P?A?R?A?M?");
            newSql = this.replaceAllParams(newSql, false);
            String parsedSql = new ReplaceBetweenParser(newSql).getModifiedQuery();
            this.replaceParamParser = new AllParamExpressionsParser(parsedSql);
        }
        catch (JSQLParserException e) {
            LOGGER.warning("Unable to parse query using All Parser:\n" + this.sql);
            throw e;
        }
    }

    private String replaceAllParams(String sql, boolean show) {
        if (!show) {
            this.otherParams = QueryParser.getAllParameters(sql);
        }
        String newSql = sql;
        if (this.otherParams == null) {
            return sql;
        }
        for (String p : this.otherParams) {
            newSql = show ? newSql.replaceAll("\\':" + p + "\\'", ":" + p) : newSql.replaceAll(":" + p + "\\b", "':" + p + "'");
        }
        return newSql;
    }

    public String getModifiedQuery(String param) {
        if (this.replaceParamParser == null) {
            return null;
        }
        String query = this.replaceParamParser.getModifiedQuery();
        query = QueryParser.removeComments(query);
        query = this.replaceAllParams(query, true);
        query = query.replaceAll("\\?P\\?A\\?R\\?A\\?M\\?", ":" + param);
        return query;
    }

    public ArrayList<String> getComparisonOperators() {
        if (this.replaceParamParser == null) {
            return null;
        }
        return this.replaceParamParser.getComparisonOperators();
    }
}

