/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery.allparser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.InverseExpression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.Union;
import quadbase.common.paramquery.QueryParser;

public class BaseParser
implements SelectVisitor,
FromItemVisitor,
ExpressionVisitor,
ItemsListVisitor {
    private Select select;
    private static final HashMap<String, String> FUNCTIONS_REPLACEMENTS = new HashMap();

    protected BaseParser(String sql) throws JSQLParserException {
        sql = QueryParser.removeComments(sql);
        sql = this.replaceFunctions(sql, false);
        CCJSqlParserManager pm = new CCJSqlParserManager();
        Statement statement = pm.parse((Reader)new StringReader(sql));
        if (!(statement instanceof Select)) {
            throw new JSQLParserException("The statement is not a valid SQL SELECT statement.");
        }
        this.select = (Select)statement;
    }

    protected void parse() {
        this.select.getSelectBody().accept((SelectVisitor)this);
    }

    protected String getSQL() {
        return this.replaceFunctions(this.select.toString(), true);
    }

    private String replaceFunctions(String sql, boolean replaceBack) {
        for (Map.Entry<String, String> entry : FUNCTIONS_REPLACEMENTS.entrySet()) {
            if (replaceBack) {
                sql = sql.replaceAll("(?i)" + Pattern.quote(entry.getValue()), entry.getKey());
                continue;
            }
            sql = sql.replaceAll("(?i)" + Pattern.quote(entry.getKey()), entry.getValue());
        }
        return sql;
    }

    public void visit(PlainSelect plainSelect) {
        plainSelect.getFromItem().accept((FromItemVisitor)this);
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                join.getRightItem().accept((FromItemVisitor)this);
            }
        }
        if (plainSelect.getWhere() != null) {
            plainSelect.setWhere(this.acceptExpression(plainSelect.getWhere()));
        }
    }

    public void visit(Union union) {
        for (PlainSelect plainSelect : union.getPlainSelects()) {
            this.visit(plainSelect);
        }
    }

    public void visit(Table tableName) {
    }

    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(ExpressionList expressionList) {
        List oldList = expressionList.getExpressions();
        ArrayList<Expression> newList = new ArrayList<Expression>(oldList.size());
        for (Expression expression : oldList) {
            newList.add(this.acceptExpression(expression));
        }
        expressionList.setExpressions(newList);
    }

    public void visit(Addition addition) {
        this.visitBinaryExpression((BinaryExpression)addition);
    }

    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression((BinaryExpression)andExpression);
    }

    public void visit(Between between) {
        between.setLeftExpression(this.acceptExpression(between.getLeftExpression()));
        between.setBetweenExpressionStart(this.acceptExpression(between.getBetweenExpressionStart()));
        between.setBetweenExpressionEnd(this.acceptExpression(between.getBetweenExpressionEnd()));
    }

    public void visit(Division division) {
        this.visitBinaryExpression((BinaryExpression)division);
    }

    public void visit(InverseExpression inverseExpression) {
        inverseExpression.setExpression(this.acceptExpression(inverseExpression.getExpression()));
    }

    public void visit(ExistsExpression existsExpression) {
        existsExpression.setRightExpression(this.acceptExpression(existsExpression.getRightExpression()));
    }

    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression((BinaryExpression)multiplication);
    }

    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression((BinaryExpression)orExpression);
    }

    public void visit(Parenthesis parenthesis) {
        parenthesis.setExpression(this.acceptExpression(parenthesis.getExpression()));
    }

    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression((BinaryExpression)subtraction);
    }

    public void visit(AllComparisonExpression allComparisonExpression) {
        allComparisonExpression.GetSubSelect().getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(AnyComparisonExpression anyComparisonExpression) {
        anyComparisonExpression.GetSubSelect().getSelectBody().accept((SelectVisitor)this);
    }

    public void visit(SubJoin subjoin) {
        subjoin.getLeft().accept((FromItemVisitor)this);
        subjoin.getJoin().getRightItem().accept((FromItemVisitor)this);
    }

    public void visit(Concat concat) {
        this.visitBinaryExpression((BinaryExpression)concat);
    }

    public void visit(Matches matches) {
        this.visitBinaryExpression((BinaryExpression)matches);
    }

    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression((BinaryExpression)bitwiseAnd);
    }

    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression((BinaryExpression)bitwiseOr);
    }

    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression((BinaryExpression)bitwiseXor);
    }

    public void visit(Column tableColumn) {
    }

    public void visit(CaseExpression caseExpression) {
    }

    public void visit(WhenClause whenClause) {
    }

    public void visit(IsNullExpression isNullExpression) {
    }

    public void visit(JdbcParameter jdbcParameter) {
    }

    public void visit(Function function) {
    }

    public void visit(EqualsTo equalsTo) {
        this.visitComparisonExpression((BinaryExpression)equalsTo);
    }

    public void visit(GreaterThan greaterThan) {
        this.visitComparisonExpression((BinaryExpression)greaterThan);
    }

    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitComparisonExpression((BinaryExpression)greaterThanEquals);
    }

    public void visit(InExpression inExpression) {
        inExpression.setLeftExpression(this.acceptExpression(inExpression.getLeftExpression()));
        inExpression.getItemsList().accept((ItemsListVisitor)this);
    }

    public void visit(LikeExpression likeExpression) {
        this.visitComparisonExpression((BinaryExpression)likeExpression);
    }

    public void visit(MinorThan minorThan) {
        this.visitComparisonExpression((BinaryExpression)minorThan);
    }

    public void visit(MinorThanEquals minorThanEquals) {
        this.visitComparisonExpression((BinaryExpression)minorThanEquals);
    }

    public void visit(NotEqualsTo notEqualsTo) {
        this.visitComparisonExpression((BinaryExpression)notEqualsTo);
    }

    public void visit(DateValue dateValue) {
    }

    public void visit(TimestampValue timestampValue) {
    }

    public void visit(TimeValue timeValue) {
    }

    public void visit(StringValue stringValue) {
    }

    public void visit(NullValue nullValue) {
    }

    public void visit(LongValue longValue) {
    }

    public void visit(DoubleValue doubleValue) {
    }

    private void visitBinaryExpression(BinaryExpression binaryExpression) {
        binaryExpression.setLeftExpression(this.acceptExpression(binaryExpression.getLeftExpression()));
        binaryExpression.setRightExpression(this.acceptExpression(binaryExpression.getRightExpression()));
    }

    protected void visitComparisonExpression(BinaryExpression binaryExpression) {
        binaryExpression.setLeftExpression(this.acceptExpression(binaryExpression.getLeftExpression()));
        binaryExpression.setRightExpression(this.acceptExpression(binaryExpression.getRightExpression()));
    }

    protected Expression acceptExpression(Expression expression) {
        expression.accept((ExpressionVisitor)this);
        return expression;
    }

    static {
        FUNCTIONS_REPLACEMENTS.put("getdate()", "getdate___lbr____rbr___");
    }
}

