/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.paramquery.parser;

import java.util.Vector;

public class ConditionNode
extends Vector {
    public static final int AND = 1;
    public static final int OR = 2;
    private int operator = 1;
    private String condition = "";

    public boolean isLeaf() {
        return this.size() == 0;
    }

    public void setOperator(int op) {
        if (op == 1 || op == 2) {
            this.operator = op;
        }
    }

    public int getOperator() {
        return this.operator;
    }

    public void setCondition(String cond) {
        this.condition = cond == null ? "" : cond;
    }

    public String getCondition() {
        return this.condition;
    }

    public boolean isValid() {
        if (this.size() == 0) {
            if (this.condition.trim().equals("")) {
                return false;
            }
        } else {
            for (int i = 0; i < this.size(); ++i) {
                ConditionNode node = (ConditionNode)this.elementAt(i);
                if (node.isValid()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.isLeaf()) {
            return this.condition;
        }
        String ret = "";
        for (int i = 0; i < this.size(); ++i) {
            ConditionNode node = (ConditionNode)this.elementAt(i);
            if (i != 0) {
                ret = node.getOperator() == 1 ? ret + " AND " : ret + " OR ";
            }
            ret = node.isLeaf() ? ret + node : ret + "(" + node + ")";
        }
        return ret;
    }
}

