/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import quadbase.common.server.Server;
import quadbase.common.server.UserInfo;
import quadbase.common.util.internal.Coder;

public class AddUserDialog
extends JDialog {
    private JTextField tfUsername;
    private JPasswordField pfPassword;
    private JPasswordField pfPassword2;
    private JLabel lbUsername;
    private JLabel lbPassword;
    private JLabel lbPassword2;
    private JButton btnAdd;
    private JButton btnCancel;
    private boolean succeeded;
    private Vector<UserInfo> userInfo;

    public AddUserDialog(Frame parent, Vector<UserInfo> userInfo) {
        super(parent, "Add New User", true);
        this.userInfo = userInfo;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints cs = new GridBagConstraints();
        cs.fill = 2;
        this.lbUsername = new JLabel("Username: ");
        cs.gridx = 0;
        cs.gridy = 0;
        cs.gridwidth = 1;
        panel.add((Component)this.lbUsername, cs);
        this.tfUsername = new JTextField(20);
        cs.gridx = 1;
        cs.gridy = 0;
        cs.gridwidth = 2;
        panel.add((Component)this.tfUsername, cs);
        this.lbPassword = new JLabel("Password: ");
        cs.gridx = 0;
        cs.gridy = 1;
        cs.gridwidth = 1;
        panel.add((Component)this.lbPassword, cs);
        this.pfPassword = new JPasswordField(20);
        cs.gridx = 1;
        cs.gridy = 1;
        cs.gridwidth = 2;
        panel.add((Component)this.pfPassword, cs);
        panel.setBorder(new LineBorder(Color.GRAY));
        this.lbPassword2 = new JLabel("Type Password again: ");
        cs.gridx = 0;
        cs.gridy = 2;
        cs.gridwidth = 1;
        panel.add((Component)this.lbPassword2, cs);
        this.pfPassword2 = new JPasswordField(20);
        cs.gridx = 1;
        cs.gridy = 2;
        cs.gridwidth = 2;
        panel.add((Component)this.pfPassword2, cs);
        panel.setBorder(new LineBorder(Color.GRAY));
        this.btnAdd = new JButton("Submit");
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AddUserDialog.this.getUsername().trim().length() == 0 || AddUserDialog.this.getPassword().trim().length() == 0 || AddUserDialog.this.getPassword2().trim().length() == 0) {
                    JOptionPane.showMessageDialog(AddUserDialog.this, "Please fill in Username and Password!", "Add New User", 0);
                } else if (AddUserDialog.this.isUserNameExisting()) {
                    JOptionPane.showMessageDialog(AddUserDialog.this, "User " + AddUserDialog.this.getUsername() + " is duplicated!", "Add New User", 0);
                    AddUserDialog.this.tfUsername.setText("");
                } else if (!AddUserDialog.this.isPwdMatched()) {
                    JOptionPane.showMessageDialog(AddUserDialog.this, "Password doesn't match, please try again!", "Add New User", 0);
                    AddUserDialog.this.pfPassword.setText("");
                    AddUserDialog.this.pfPassword2.setText("");
                } else {
                    if (AddUserDialog.this.addUser()) {
                        JOptionPane.showMessageDialog(AddUserDialog.this, "User " + AddUserDialog.this.getUsername() + " is created!", "Add New User", 1);
                        AddUserDialog.this.succeeded = true;
                    } else {
                        AddUserDialog.this.succeeded = false;
                    }
                    AddUserDialog.this.tfUsername.setText("");
                    AddUserDialog.this.pfPassword.setText("");
                    AddUserDialog.this.pfPassword2.setText("");
                }
            }
        });
        this.btnCancel = new JButton("Close");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddUserDialog.this.dispose();
            }
        });
        JPanel bp = new JPanel();
        bp.add(this.btnAdd);
        bp.add(this.btnCancel);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)bp, "Last");
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    public String getUsername() {
        return this.tfUsername.getText().trim();
    }

    public String getPassword() {
        return new String(this.pfPassword.getPassword());
    }

    public String getPassword2() {
        return new String(this.pfPassword2.getPassword());
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    private boolean isUserNameExisting() {
        for (int i = 0; i < this.userInfo.size(); ++i) {
            UserInfo info = this.userInfo.elementAt(i);
            if (!this.getUsername().equals(info.getUser())) continue;
            return true;
        }
        return false;
    }

    private boolean isPwdMatched() {
        return this.getPassword().equals(this.getPassword2());
    }

    private boolean addUser() {
        try {
            this.insertUser(this.getUsername(), this.getPassword());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private void insertUser(String username, String password) throws Exception {
        File inFile = new File(Server.configDir, "config.txt");
        File outFile = new File("tempfile.txt");
        FileInputStream fis = new FileInputStream(inFile);
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        FileOutputStream fos = new FileOutputStream(outFile);
        PrintWriter out = new PrintWriter(fos);
        String thisLine = "";
        while ((thisLine = in.readLine()) != null) {
            thisLine = thisLine.trim();
            out.println(thisLine);
            if (thisLine == null || thisLine.equals("") || thisLine.equals(" ") || !thisLine.equalsIgnoreCase("{user-name encoded-password}")) continue;
            out.println(username + " " + Coder.encode(password));
        }
        out.flush();
        out.close();
        in.close();
        inFile.delete();
        outFile.renameTo(inFile);
        this.userInfo.addElement(new UserInfo(username, Coder.encode(password)));
    }
}

