/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import quadbase.chart.ColData;
import quadbase.chart.ColDataResultSet;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.IRSMetaData;
import quadbase.util.IResultSet;

public class BufferedResultSet {
    IResultSet rs;
    private DataSet[] dataSet;
    ColDataResultSet colDataResultSet;
    int curRow = 0;
    int totalRows = -1;
    int totalCols = -1;
    int startIndex;
    int displayRow;
    QueryInParamSet queryInParamSet;
    String sqlStatement;
    String[] columnName;
    String[] tableName;
    int[] columnType;
    private int uniqueNumber = QbUtil.nextNumber();
    private String address = null;

    public BufferedResultSet(String sql, QueryInParamSet qSet, IResultSet rs) throws Exception {
        int i;
        this.sqlStatement = sql;
        this.queryInParamSet = qSet;
        this.rs = rs;
        IRSMetaData md = rs.getMetaData();
        this.totalCols = md.getColumnCount();
        this.columnName = new String[this.totalCols];
        this.tableName = new String[this.totalCols];
        this.columnType = new int[this.totalCols];
        for (i = 1; i <= this.totalCols; ++i) {
            this.columnName[i - 1] = md.getColumnName(i);
            try {
                this.tableName[i - 1] = md.getTableName(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.columnType[i - 1] = md.getColumnType(i);
        }
        this.dataSet = new DataSet[this.totalCols];
        for (i = 0; i < this.totalCols; ++i) {
            this.dataSet[i] = new DataSet("BR_" + this.getAddress(), ServerMessage.getMaxFieldSize(), this.totalCols, DataType.mapType(this.columnType[i]));
        }
    }

    public BufferedResultSet(String sql, QueryInParamSet qSet, ColDataResultSet colDataResultSet) {
        this.sqlStatement = sql;
        this.queryInParamSet = qSet;
        this.colDataResultSet = colDataResultSet;
    }

    boolean equals(BufferedResultSet rs) {
        return this.equals(rs.sqlStatement, rs.queryInParamSet);
    }

    boolean equals(String sql, QueryInParamSet qSet) {
        if (!this.sqlStatement.equals(sql)) {
            return false;
        }
        return this.queryInParamSet == null && qSet == null || this.queryInParamSet != null && this.queryInParamSet.equals(qSet);
    }

    void close() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rs = null;
    }

    DataSet[] getValue(int startIndex, int displayRow) throws Exception {
        this.startIndex = startIndex;
        this.displayRow = displayRow;
        if (this.totalCols <= 0) {
            return null;
        }
        this.retrieveData();
        return this.dataSet;
    }

    void retrieveData() throws Exception {
        boolean getAllData;
        int endIndex = this.startIndex + this.displayRow;
        boolean bl = getAllData = (this.displayRow < 0 || this.startIndex < 0) && this.totalRows == -1;
        while ((this.curRow < endIndex || getAllData) && !this.isLastPage()) {
            if (ServerMessage.exceedLimit(this.curRow - 1) || this.rs != null && !this.rs.next()) {
                this.totalRows = this.curRow;
                try {
                    this.rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            for (int i = 1; i <= this.totalCols; ++i) {
                this.dataSet[i - 1].addElement(this.rs.getObject(i));
            }
            ++this.curRow;
        }
    }

    int getRowCount() {
        return this.totalRows;
    }

    boolean isLastPage() {
        if (this.totalRows == -1) {
            return false;
        }
        return this.totalRows - this.startIndex <= this.displayRow;
    }

    Object getData(int row, int col) {
        return this.dataSet[col].elementAt(row);
    }

    ColDataResultSet getResultSet() throws Exception {
        if (this.colDataResultSet == null) {
            this.colDataResultSet = this.getResultSet(0, -1);
        }
        this.colDataResultSet.resetCursor();
        return this.colDataResultSet;
    }

    ColDataResultSet getResultSet(int startIndex, int displayRows) throws Exception {
        ColData[] bufferData = new ColData[this.totalCols + 1];
        for (int i = 0; i < this.totalCols; ++i) {
            bufferData[i] = new ColData(this.columnName[i], this.tableName[i], this.columnType[i], bufferData.length);
        }
        this.getValue(startIndex, displayRows);
        if (startIndex < 0 && this.totalRows >= 0 && displayRows > 0) {
            startIndex = this.totalRows - this.totalRows % displayRows;
            if (this.totalRows == startIndex) {
                startIndex = this.totalRows - displayRows;
            }
            if (startIndex < 0) {
                startIndex = 0;
            }
        }
        int endIndex = startIndex + displayRows;
        if (displayRows < 0 || this.totalRows >= 0 && this.totalRows < startIndex + displayRows) {
            endIndex = this.totalRows;
        }
        if (endIndex > this.dataSet[0].size()) {
            endIndex = this.dataSet[0].size();
        }
        for (int i = startIndex; i < endIndex; ++i) {
            for (int j = 0; j < this.totalCols; ++j) {
                bufferData[j].add(this.getData(i, j));
            }
        }
        return (ColDataResultSet)ColData.getResultSet(bufferData);
    }

    String getAddress() {
        if (this.address == null) {
            this.address = String.valueOf(this.uniqueNumber);
        }
        return this.address;
    }
}

