/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.LineBorder;
import quadbase.common.server.Server;
import quadbase.common.server.UserInfo;
import quadbase.common.swing.SortedComboBoxModel;
import quadbase.common.util.internal.Coder;

public class ChangePasswordDialog
extends JDialog {
    private JComboBox<String> cbUsers;
    private JPasswordField pfPassword;
    private JPasswordField pfPassword2;
    private JLabel lbUsername;
    private JLabel lbPassword;
    private JLabel lbPassword2;
    private JButton btnAdd;
    private JButton btnCancel;
    private boolean succeeded;
    private Vector<UserInfo> userInfo;

    public ChangePasswordDialog(Frame parent, Vector<UserInfo> userInfo) {
        super(parent, "Change Password", true);
        this.userInfo = userInfo;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints cs = new GridBagConstraints();
        cs.fill = 2;
        this.lbUsername = new JLabel("Username: ");
        cs.gridx = 0;
        cs.gridy = 0;
        cs.gridwidth = 1;
        panel.add((Component)this.lbUsername, cs);
        SortedComboBoxModel<String> model = new SortedComboBoxModel<String>(this.getUserList(userInfo));
        this.cbUsers = new JComboBox<String>(model);
        cs.gridx = 1;
        cs.gridy = 0;
        cs.gridwidth = 2;
        panel.add(this.cbUsers, cs);
        this.lbPassword = new JLabel("Password: ");
        cs.gridx = 0;
        cs.gridy = 1;
        cs.gridwidth = 1;
        panel.add((Component)this.lbPassword, cs);
        this.pfPassword = new JPasswordField(20);
        cs.gridx = 1;
        cs.gridy = 1;
        cs.gridwidth = 2;
        panel.add((Component)this.pfPassword, cs);
        panel.setBorder(new LineBorder(Color.GRAY));
        this.lbPassword2 = new JLabel("Type Password again: ");
        cs.gridx = 0;
        cs.gridy = 2;
        cs.gridwidth = 1;
        panel.add((Component)this.lbPassword2, cs);
        this.pfPassword2 = new JPasswordField(20);
        cs.gridx = 1;
        cs.gridy = 2;
        cs.gridwidth = 2;
        panel.add((Component)this.pfPassword2, cs);
        panel.setBorder(new LineBorder(Color.GRAY));
        this.btnAdd = new JButton("Submit");
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ChangePasswordDialog.this.getPassword().trim().length() == 0 || ChangePasswordDialog.this.getPassword2().trim().length() == 0) {
                    JOptionPane.showMessageDialog(ChangePasswordDialog.this, "Please fill in Password!", "Change Password", 0);
                } else if (!ChangePasswordDialog.this.isPwdMatched()) {
                    JOptionPane.showMessageDialog(ChangePasswordDialog.this, "Password doesn't match, please try again!", "Change Password", 0);
                } else if (ChangePasswordDialog.this.changePassword()) {
                    JOptionPane.showMessageDialog(ChangePasswordDialog.this, "User " + ChangePasswordDialog.this.getUsername() + "'s password is changed!", "Change Password", 1);
                    ChangePasswordDialog.this.pfPassword.setText("");
                    ChangePasswordDialog.this.pfPassword2.setText("");
                    ChangePasswordDialog.this.succeeded = true;
                } else {
                    ChangePasswordDialog.this.succeeded = false;
                }
            }
        });
        this.btnCancel = new JButton("Close");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangePasswordDialog.this.dispose();
            }
        });
        JPanel bp = new JPanel();
        bp.add(this.btnAdd);
        bp.add(this.btnCancel);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)bp, "Last");
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    public String getUsername() {
        return this.cbUsers.getSelectedItem().toString();
    }

    public String getPassword() {
        return new String(this.pfPassword.getPassword());
    }

    public String getPassword2() {
        return new String(this.pfPassword2.getPassword());
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    private boolean isPwdMatched() {
        return this.getPassword().equals(this.getPassword2());
    }

    private String[] getUserList(Vector<UserInfo> userInfos) {
        String[] result = new String[userInfos.size()];
        int i = 0;
        for (UserInfo uinfo : userInfos) {
            result[i] = uinfo.getUser();
            ++i;
        }
        return result;
    }

    private boolean changePassword() {
        try {
            this.changePassword(this.getUsername(), this.getPassword());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private void changePassword(String username, String password) throws Exception {
        File inFile = new File(Server.configDir, "config.txt");
        File outFile = new File("tempfile.txt");
        FileInputStream fis = new FileInputStream(inFile);
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        FileOutputStream fos = new FileOutputStream(outFile);
        PrintWriter out = new PrintWriter(fos);
        String thisLine = "";
        while ((thisLine = in.readLine()) != null) {
            thisLine = thisLine.trim();
            String name = "";
            int idx = thisLine.indexOf(32);
            name = idx <= 0 ? thisLine : thisLine.substring(0, idx);
            if (name.equalsIgnoreCase(username)) {
                out.println(username + " " + Coder.encode(this.getPassword()));
                continue;
            }
            out.println(thisLine);
        }
        out.flush();
        out.close();
        in.close();
        inFile.delete();
        outFile.renameTo(inFile);
        for (UserInfo uInfo : this.userInfo) {
            if (!uInfo.getUser().equals(username)) continue;
            uInfo.setPassword(Coder.encode(password));
        }
    }
}

