/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import quadbase.chart.Chart;
import quadbase.chart.LoadChart;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;
import quadbase.util.internal.ExcelEncoder;
import quadbase.util.internal.FlashEncoder;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.PDFEncoder;
import quadbase.util.internal.SVGEncoder;

public class ChtExportSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    String outputfile;
    Chart chart;

    public ChtExportSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        FileOutputStream out;
        block26: {
            this.outputfile = this.messageThread.outfile;
            try {
                this.server.writeLog(this.getHeader() + "start...\n");
                DataInputStream instream = new DataInputStream(new BufferedInputStream(this.client_socket.getInputStream()));
                this.chart = new LoadChart().load(quadbase.common.util.internal.IOUtil.getOffScreenComponent(), instream, false, null, true);
                this.chart.flashFrameCount = this.messageThread.flashFrameCount;
                this.chart.flashFrameRate = this.messageThread.flashFrameRate;
            }
            catch (IOException ex) {
                this.cleanup(3, "Fail to read data " + ex.toString() + "\n");
                return;
            }
            catch (Exception ex) {
                this.cleanup(-2, ex.toString() + "\n");
                return;
            }
            catch (OutOfMemoryError err) {
                err.printStackTrace();
                this.cleanup(2, err.toString() + "\n");
                return;
            }
            catch (Error err) {
                err.printStackTrace();
                this.cleanup(-1, err.toString() + "\n");
                return;
            }
            if (!this.server.userCounter(true)) {
                this.acknowledge(4, "");
                CloseUtils.close(this.client_socket);
                return;
            }
            try {
                String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), 29203);
                if (!mess.equals("OK")) {
                    this.cleanup(5, mess);
                    return;
                }
            }
            catch (Exception ex) {
                this.cleanup(5, ex.toString());
                return;
            }
            this.outputfile = this.messageThread.outfile.replace('|', ':');
            this.outputfile.replace('\\', '/');
            if (!this.messageThread.absolutePath) {
                this.outputfile = this.server.getPath(this.outputfile);
            }
            out = null;
            try {
                if (this.messageThread.format == 15) {
                    this.outputfile = this.outputfile + ".swf";
                    out = new FileOutputStream(this.server.getPath(this.outputfile));
                    FlashEncoder.encode(this.chart, out, this.messageThread.width, this.messageThread.height, quadbase.common.util.internal.IOUtil.getOffScreenComponent());
                    break block26;
                }
                if (this.messageThread.format == 14) {
                    this.outputfile = this.outputfile + ".svg";
                    out = new FileOutputStream(this.server.getPath(this.outputfile));
                    SVGEncoder.encode(this.chart, out, this.messageThread.width, this.messageThread.height, quadbase.common.util.internal.IOUtil.getOffScreenComponent());
                    break block26;
                }
                if (this.messageThread.format == 13) {
                    this.outputfile = this.outputfile + ".pdf";
                    try {
                        out = new FileOutputStream(this.server.getPath(this.outputfile));
                        new PDFEncoder().export(this.chart, out, this.messageThread.width, this.messageThread.height);
                        out.close();
                        break block26;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        break block26;
                    }
                    finally {
                        CloseUtils.close(out);
                    }
                }
                if (this.messageThread.format != 18) break block26;
                this.outputfile = this.outputfile + ".xls";
                try {
                    out = new FileOutputStream(this.server.getPath(this.outputfile));
                    new ExcelEncoder().export(this.chart, out, this.messageThread.width, this.messageThread.height);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                String mess = ex.getMessage();
                this.cleanup(3, "Failed to write to file " + this.outputfile + ".\n" + mess + "\n");
                CloseUtils.close(out);
                return;
            }
            catch (Error err) {
                String mess = err.toString();
                this.cleanup(3, "Failed to write to file " + this.outputfile + ".\n" + mess + "\n");
                {
                    catch (Throwable throwable) {
                        CloseUtils.close(out);
                        throw throwable;
                    }
                }
                CloseUtils.close(out);
                return;
            }
        }
        CloseUtils.close(out);
        this.cleanup(0, "Finish.\n");
    }

    void cleanup(int code, String err) {
        this.acknowledge(code, err);
        CloseUtils.close(this.client_socket);
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acknowledge(int code, String s) {
        DataOutputStream dout2 = null;
        try {
            dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
        }
        catch (Exception ex) {
            try {
                this.server.writeLog(this.getHeader() + "Fail to Acknowledge client " + ex.toString(), true);
            }
            catch (Throwable throwable) {
                CloseUtils.close(dout2);
                throw throwable;
            }
            CloseUtils.close(dout2);
        }
        CloseUtils.close(dout2);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nOutput : " + this.outputfile + " -- ";
    }
}

