/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import quadbase.chart.FilterInfo;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.server.StreamSlave;
import quadbase.common.util.internal.CastUtil;
import quadbase.common.util.internal.ClassFileUtil;
import quadbase.common.util.internal.CloseUtils;
import quadbase.queryproc.filter.EqFilter;
import quadbase.queryproc.filter.RunSimpleFilter;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.util.internal.TransposeRS;

public class ClassFileSlave
extends StreamSlave {
    public ClassFileSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
    }

    @Override
    public void run() {
        try {
            int operationType = this.messageThread.packageLen;
            String className = this.messageThread.infile;
            if (operationType == 0) {
                this.sendReply(ClassFileUtil.isParameterized(className));
            } else if (operationType == 1) {
                this.sendReply(ClassFileUtil.getInSet(className));
            } else if (operationType == 2) {
                Object obj = ClassFileUtil.getResultSet(className, this.messageThread.inParamSet);
                if (obj instanceof IResultSet) {
                    this.sendResultSet(CastUtil.cast((IResultSet)obj));
                } else {
                    this.sendResultSet((quadbase.util.IResultSet)obj);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(3, "Server failed to read data: " + ex.toString() + "\n");
        }
    }

    private void sendReply(boolean state) throws Exception {
        DataOutputStream outstream = null;
        try {
            outstream = new DataOutputStream(this.client_socket.getOutputStream());
            outstream.writeInt(0);
            outstream.writeBoolean(state);
            this.cleanup(0, "Finish\n", false);
        }
        catch (Throwable throwable) {
            CloseUtils.close(outstream);
            throw throwable;
        }
        CloseUtils.close(outstream);
    }

    private void sendReply(QueryInParamSet paramSet) throws Exception {
        DataOutputStream dout = null;
        try {
            dout = new DataOutputStream(this.client_socket.getOutputStream());
            dout.writeInt(0);
            paramSet.write(dout);
            this.cleanup(0, "Finish\n", false);
        }
        catch (Throwable throwable) {
            CloseUtils.close(dout);
            throw throwable;
        }
        CloseUtils.close(dout);
    }

    private void sendResultSet(quadbase.util.IResultSet irs) throws Exception {
        if (this.messageThread.transposeData) {
            irs = TransposeRS.doTranspose(irs, this.messageThread.transposeCol);
        }
        if (this.messageThread.filterData) {
            RunSimpleFilter rsf = new RunSimpleFilter();
            FilterInfo filterInfo = this.messageThread.filterInfo;
            int[] compareOp = filterInfo.getCompareOp();
            int[] colIndex = filterInfo.getColIndex();
            Object[] value = filterInfo.getValue();
            for (int i = 0; i < filterInfo.getSize(); ++i) {
                if (compareOp[i] != 0) continue;
                rsf.andCondition(new EqFilter(colIndex[i], value[i]));
            }
            irs = rsf.run(irs);
        }
        this.writeOutput(this.writeToBuffer(irs));
    }
}

