/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.server.DataBuffer;
import quadbase.common.server.ReplacementPolicy;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.util.IResultSet;

public class ConnectionBuffer {
    static int nBuffer = 5;
    static int oldNBuffer = 5;
    static int count = 0;
    ReplacementPolicy rp;
    static DataBuffer[] dataBuffer;
    static int bufSize;
    static final int LOWPRIORITY = 1;
    static final int HIGHPRIORITY = 4;

    public ConnectionBuffer(int buffer) {
        nBuffer = buffer;
        oldNBuffer = buffer;
        this.rp = new ReplacementPolicy(nBuffer);
        dataBuffer = new DataBuffer[nBuffer];
    }

    public synchronized void addData(DataBuffer ds, int priority) {
        if (nBuffer == 0) {
            return;
        }
        int index = this.rp.getNextIndex();
        if (dataBuffer[index] != null) {
            dataBuffer[index].close();
        }
        ConnectionBuffer.dataBuffer[index] = ds;
        if (index >= bufSize) {
            ++bufSize;
        }
        this.rp.setUsed(index, priority);
    }

    public void close() {
        for (DataBuffer element : dataBuffer) {
            if (element == null) continue;
            element.close();
        }
    }

    public static int getBufferSize() {
        return nBuffer;
    }

    public int getUseBuffer() {
        if (nBuffer == 0) {
            return 0;
        }
        int buf = 0;
        for (int i = 0; i < bufSize; ++i) {
            if (dataBuffer[i] == null) continue;
            ++buf;
        }
        return buf;
    }

    public boolean isInBuffer(DataBuffer ds) {
        return this.getIndex(ds) >= 0;
    }

    public int getIndex(DataBuffer ds) {
        if (nBuffer == 0) {
            return -1;
        }
        for (int i = 0; i < bufSize; ++i) {
            if (dataBuffer[i] == null || !dataBuffer[i].equals(ds)) continue;
            return i;
        }
        return -1;
    }

    public DataBuffer getDataBuffer(DataBuffer ds) {
        int i = this.getIndex(ds);
        if (i < 0) {
            return null;
        }
        return dataBuffer[i];
    }

    public boolean refresh(DataBuffer ds) {
        for (int i = 0; i < bufSize; ++i) {
            if (dataBuffer[i] == null || !dataBuffer[i].equals(ds)) continue;
            dataBuffer[i].close();
            ConnectionBuffer.dataBuffer[i] = null;
            this.rp.setNotUsed(i);
            return true;
        }
        return false;
    }

    public void refreshAll() {
        for (int i = 0; i < bufSize; ++i) {
            if (dataBuffer[i] != null) {
                dataBuffer[i].close();
            }
            ConnectionBuffer.dataBuffer[i] = null;
            this.rp.setNotUsed(i);
        }
    }

    public synchronized void setPriority(DataBuffer ds, int priority) {
        if (nBuffer == 0) {
            return;
        }
        for (int i = 0; i < bufSize; ++i) {
            if (dataBuffer[i] == null || !dataBuffer[i].equals(ds)) continue;
            this.rp.changeUsed(i, priority);
            return;
        }
    }

    public synchronized void setPriority(DBInfoBasic dbInfo, QueryInParamSet qSet, int priority) {
        if (nBuffer == 0) {
            return;
        }
        int idx = this.getIndex(new DataBuffer(nBuffer, dbInfo));
        if (idx < 0) {
            return;
        }
        this.rp.changeUsed(idx, priority);
        dataBuffer[idx].setPriority(dataBuffer[idx].getIndex(dbInfo.getQuery(), qSet), priority);
    }

    public IResultSet getResultSet(DataBuffer ds, String qry, QueryInParamSet qSet) {
        return ds.getResultSet(qry, qSet);
    }

    public static void setEnabled(boolean enabled) {
        nBuffer = enabled ? oldNBuffer : 0;
    }

    static {
        bufSize = 0;
    }
}

