/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;

public class CopyFileSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;

    public CopyFileSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        String source = this.messageThread.infile;
        String destination = this.messageThread.outfile;
        boolean success = false;
        FileInputStream inStream = null;
        ByteArrayOutputStream byteStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(this.server.getPath(source));
            byteStream = new ByteArrayOutputStream();
            outStream = new FileOutputStream(this.server.getPath(destination));
            int nextByte = inStream.read();
            while (nextByte != -1) {
                byteStream.write(nextByte);
                nextByte = inStream.read();
            }
            byteStream.flush();
            outStream.write(byteStream.toByteArray());
            success = true;
        }
        catch (IOException ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtils.close(byteStream);
                CloseUtils.close(inStream);
                CloseUtils.close(outStream);
                throw throwable;
            }
            CloseUtils.close(byteStream);
            CloseUtils.close(inStream);
            CloseUtils.close(outStream);
        }
        CloseUtils.close(byteStream);
        CloseUtils.close(inStream);
        CloseUtils.close(outStream);
        int code = success ? 0 : 6;
        DataOutputStream dout = null;
        try {
            dout = new DataOutputStream(this.client_socket.getOutputStream());
            dout.writeInt(code);
        }
        catch (IOException iOException) {
            CloseUtils.close(dout);
            CloseUtils.close(this.client_socket);
            catch (Throwable throwable) {
                CloseUtils.close(dout);
                CloseUtils.close(this.client_socket);
                throw throwable;
            }
        }
        CloseUtils.close(dout);
        CloseUtils.close(this.client_socket);
    }
}

