/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.awt.Component;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import quadbase.ChartAPI.ColInfo;
import quadbase.ChartAPI.DBInfo;
import quadbase.ChartAPI.DbData;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.ColMetaData;
import quadbase.chart.DBAccess;
import quadbase.chart.DrillHistory;
import quadbase.chart.FaceData;
import quadbase.chart.GraphicsTable;
import quadbase.chart.ImageMapNode;
import quadbase.chart.LoadChart;
import quadbase.chart.MultiDimData;
import quadbase.chart.PreprocInfo;
import quadbase.chart.ReadDataFile;
import quadbase.chart.ReloadChart;
import quadbase.chart.ValueTable;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.ListNode;
import quadbase.chart.xml.XMLChart;
import quadbase.common.network.IConnection;
import quadbase.common.server.ExtractMethodList;
import quadbase.common.server.MessageThread;
import quadbase.common.server.QbImageMap;
import quadbase.common.server.Server;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.HyperLink;
import quadbase.util.IColumnMap;
import quadbase.util.IMapConstants;
import quadbase.util.IResultSet;
import quadbase.util.PickData;
import quadbase.util.SimpleSpreadSheet;
import quadbase.util.StreamResultSet;
import quadbase.util.XMLResultSet;
import quadbase.util.internal.TransposeRS;

public class CreateChartSlave
implements IMapConstants {
    static final int CHARTFILE = 1;
    static final int DATAFILE = 2;
    static final int DATABASE = 3;
    static final int RESULTSET = 4;
    static final int SPREADSHEET = 5;
    static final int MULTISOURCE = 6;
    static final int CHARTDATA = 7;
    static final int XMLFILE = 8;
    static final int CLASSFILE = 9;
    static final int JNDIDATASOURCE = 10;
    static final int MICROVIEWER = 1;
    static final int MINIVIEWER = 2;
    static final int VIEW2D = 0;
    static final int VIEW3D = 1;
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    String urlFile;
    byte[] chartData;
    FileOutputStream fstream = null;
    int dataFormat;
    int dimension;
    int chartType;
    boolean doTransposeData;
    boolean[] transposeCol;
    ColInfo colInfo;
    DBInfo dbInfo;
    DbData dbData;
    SimpleSpreadSheet sheet;
    Object[] sourceList;
    int[] sourceType;
    boolean[] sourceTranspose;
    Object[] sourceTransposeCol;
    String templateFile;
    DataInputStream in;
    Chart chart;
    PickData[] drillDownData;
    boolean doDrillDownMap = false;
    boolean doFieldDrillDownMap = false;
    int viewerType;
    boolean[] update = new boolean[4];
    private int version = 147;

    public CreateChartSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
        this.viewerType = messageThread.format;
        try {
            this.in = new DataInputStream(socket.getInputStream());
            this.dataFormat = this.in.readShort();
            if (this.dataFormat == 1) {
                this.urlFile = Coder.decode(IOUtil.readString(this.in, true), this.version);
            } else if (this.dataFormat == 7) {
                int count = this.in.readInt();
                this.chartData = new byte[count];
                this.in.readFully(this.chartData, 0, count);
            } else if (this.dataFormat == 2 || this.dataFormat == 8 || this.dataFormat == 9) {
                this.dimension = this.in.readShort();
                this.chartType = this.in.readShort();
                this.urlFile = Coder.decode(IOUtil.readString(this.in, true), this.version);
                this.doTransposeData = this.in.readBoolean();
                this.transposeCol = IOUtil.readBooleans(this.in);
                this.colInfo = this.createColInfo(this.in);
                this.templateFile = Coder.decode(IOUtil.readString(this.in, true), this.version);
                if (this.templateFile.trim().equals("")) {
                    this.templateFile = null;
                }
            } else if (this.dataFormat == 3) {
                this.dimension = this.in.readShort();
                this.chartType = this.in.readShort();
                this.dbInfo = new DBInfo(Coder.decode(IOUtil.readString(this.in, true), this.version), Coder.decode(IOUtil.readString(this.in, true), this.version), Coder.decode(IOUtil.readString(this.in, true), this.version), Coder.decode(IOUtil.readString(this.in, true), this.version), Coder.decode(IOUtil.readLongString(this.in), this.version));
                this.doTransposeData = this.in.readBoolean();
                this.transposeCol = IOUtil.readBooleans(this.in);
                this.colInfo = this.createColInfo(this.in);
                this.templateFile = Coder.decode(IOUtil.readString(this.in, true), this.version);
                if (this.templateFile.trim().equals("")) {
                    this.templateFile = null;
                }
            } else if (this.dataFormat == 10) {
                this.dimension = this.in.readShort();
                this.chartType = this.in.readShort();
                String jndiName = Coder.decode(IOUtil.readString(this.in, true), this.version);
                int size = this.in.readInt();
                Hashtable<String, String> env = new Hashtable<String, String>();
                for (int i = 0; i < size; ++i) {
                    String key = Coder.decode(IOUtil.readString(this.in, true), this.version);
                    String value = Coder.decode(IOUtil.readString(this.in, true), this.version);
                    env.put(key, value);
                }
                String query = Coder.decode(IOUtil.readLongString(this.in), this.version);
                this.dbInfo = new DBInfo(jndiName, query, env);
            } else if (this.dataFormat == 4) {
                int i;
                this.dimension = this.in.readShort();
                this.chartType = this.in.readShort();
                int nRow = this.in.readInt();
                int nCol = this.in.readInt();
                String[] dataType = new String[nCol];
                String[] fieldName = new String[nCol];
                String[][] records = new String[nRow][nCol];
                for (i = 0; i < nCol; ++i) {
                    dataType[i] = DataType.getTypeName(this.in.readInt());
                    fieldName[i] = Coder.decode(IOUtil.readString(this.in, true), this.version);
                }
                for (i = 0; i < nRow; ++i) {
                    for (int j = 0; j < nCol; ++j) {
                        records[i][j] = Coder.decode(IOUtil.readString(this.in, true), this.version);
                    }
                }
                this.dbData = new DbData(dataType, fieldName, records);
                this.doTransposeData = this.in.readBoolean();
                this.transposeCol = IOUtil.readBooleans(this.in);
                this.colInfo = this.createColInfo(this.in);
                this.templateFile = Coder.decode(IOUtil.readString(this.in, true), this.version);
                if (this.templateFile.trim().equals("")) {
                    this.templateFile = null;
                }
            } else if (this.dataFormat == 5) {
                int i;
                this.dimension = this.in.readShort();
                this.chartType = this.in.readShort();
                int nRow = this.in.readInt();
                int nCol = this.in.readInt();
                int rowType = DataType.mapType(this.in.readInt());
                int colType = DataType.mapType(this.in.readInt());
                int valType = DataType.mapType(this.in.readInt());
                Object[] row = new Object[nRow];
                Object[] col = new Object[nCol];
                Object[][] val = new Object[nRow][nCol];
                for (i = 0; i < nRow; ++i) {
                    row[i] = DataType.createObject(Coder.decode(IOUtil.readString(this.in, true), this.version), rowType);
                }
                for (i = 0; i < nCol; ++i) {
                    col[i] = DataType.createObject(Coder.decode(IOUtil.readString(this.in, true), this.version), colType);
                }
                for (i = 0; i < nRow; ++i) {
                    for (int j = 0; j < nCol; ++j) {
                        val[i][j] = DataType.createObject(Coder.decode(IOUtil.readString(this.in, true), this.version), valType);
                    }
                }
                this.sheet = new SimpleSpreadSheet(row, col, val);
                this.colInfo = this.createColInfo(this.in);
                this.templateFile = Coder.decode(IOUtil.readString(this.in, true), this.version);
                if (this.templateFile.trim().equals("")) {
                    this.templateFile = null;
                }
            } else if (this.dataFormat == 6) {
                this.dimension = this.in.readShort();
                this.chartType = this.in.readShort();
                int sourceCount = this.in.readShort();
                this.sourceList = new Object[sourceCount];
                this.sourceType = new int[sourceCount];
                this.sourceTranspose = new boolean[sourceCount];
                this.sourceTransposeCol = new Object[sourceCount];
                for (int i = 0; i < sourceCount; ++i) {
                    this.sourceType[i] = this.in.readShort();
                    if (this.sourceType[i] == 3) {
                        this.sourceList[i] = new DBInfo(Coder.decode(IOUtil.readString(this.in, true), this.version), Coder.decode(IOUtil.readString(this.in, true), this.version), Coder.decode(IOUtil.readString(this.in, true), this.version), Coder.decode(IOUtil.readString(this.in, true), this.version), Coder.decode(IOUtil.readLongString(this.in), this.version));
                        this.sourceType[i] = 1;
                    } else if (this.sourceType[i] == 10) {
                        String jndiName = Coder.decode(IOUtil.readString(this.in, true), this.version);
                        Hashtable<String, String> env = new Hashtable<String, String>();
                        int size = this.in.readInt();
                        for (int j = 0; j < size; ++j) {
                            String key = Coder.decode(IOUtil.readString(this.in, true), this.version);
                            String value = Coder.decode(IOUtil.readString(this.in, true), this.version);
                            env.put(key, value);
                        }
                        String query = Coder.decode(IOUtil.readLongString(this.in), this.version);
                        this.sourceList[i] = new DBInfo(jndiName, query, env);
                        this.sourceType[i] = 1;
                    } else if (this.sourceType[i] == 2) {
                        this.sourceList[i] = Coder.decode(IOUtil.readString(this.in, true), this.version);
                        this.sourceType[i] = 2;
                    } else if (this.sourceType[i] == 8) {
                        this.sourceList[i] = Coder.decode(IOUtil.readString(this.in, true), this.version);
                        this.sourceType[i] = 4;
                    } else if (this.sourceType[i] == 9) {
                        this.sourceList[i] = Coder.decode(IOUtil.readString(this.in, true), this.version);
                        this.sourceType[i] = 6;
                    }
                    this.sourceTranspose[i] = this.in.readBoolean();
                    this.sourceTransposeCol[i] = IOUtil.readBooleans(this.in);
                }
                this.doTransposeData = this.in.readBoolean();
                this.transposeCol = IOUtil.readBooleans(this.in);
                this.colInfo = this.createColInfo(this.in);
                this.templateFile = Coder.decode(IOUtil.readString(this.in, true), this.version);
                if (this.templateFile.trim().equals("")) {
                    this.templateFile = null;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ColInfo createColInfo(DataInputStream in) throws Exception {
        ColInfo colInfo = new ColInfo();
        colInfo.category = in.readShort();
        colInfo.series = in.readShort();
        colInfo.sumBy = in.readShort();
        colInfo.value = in.readShort();
        colInfo.subvalue = in.readShort();
        colInfo.xvalue = in.readShort();
        colInfo.yvalue = in.readShort();
        colInfo.zvalue = in.readShort();
        colInfo.high = in.readShort();
        colInfo.low = in.readShort();
        colInfo.open = in.readShort();
        colInfo.close = in.readShort();
        colInfo.subseries = in.readShort();
        return colInfo;
    }

    public void run() {
        try {
            this.server.writeLog(this.getHeader() + "start...\n");
            if (!this.server.userCounter(true)) {
                this.acknowledge(4, "");
                try {
                    this.client_socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), 37588);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return;
            }
            boolean isSubLevelParamChart = false;
            if (this.viewerType == 2) {
                isSubLevelParamChart = this.in.readBoolean();
            }
            if (isSubLevelParamChart) {
                this.chart = this.loadChartFromFile(this.urlFile, IOUtil.readString(this.in, true));
            } else if (this.dataFormat == 1) {
                this.chart = this.loadChartFromFile(this.urlFile);
            } else if (this.dataFormat == 7) {
                this.chart = this.loadChartFromData();
            } else if (this.dataFormat == 2) {
                this.chart = this.createFromDataFile();
            } else if (this.dataFormat == 3 || this.dataFormat == 10) {
                this.chart = this.createFromDatabase();
            } else if (this.dataFormat == 4) {
                this.chart = this.createFromResultSet();
            } else if (this.dataFormat == 5) {
                this.chart = this.createFromSpreadSheet();
            } else if (this.dataFormat == 6) {
                this.chart = this.createFromMultiSource();
            }
            if (this.viewerType == 2) {
                if (this.in.readBoolean() && !isSubLevelParamChart) {
                    try {
                        this.chart.gt.keepPosition = true;
                        GraphicsTable.recoverTableSize(this.chart);
                        if (this.chart.getTable() != null) {
                            this.chart.getTable().clear();
                        }
                        this.chart.usedColumns = null;
                        Chart newChart = ReloadChart.reloadData(this.chart, false);
                        if (newChart != null) {
                            this.chart = newChart;
                            if (!newChart.is2DimChart()) {
                                newChart.validatePosition();
                            }
                        }
                    }
                    catch (Exception newChart) {
                        // empty catch block
                    }
                }
                this.isFieldDrillDownMapEnabled();
                this.chart = this.doDrillDown(IOUtil.readString(this.in, true));
                this.chart = new ExtractMethodList(this.server, this.chart, this.in).extract();
                for (int i = 0; i < this.update.length; ++i) {
                    this.update[i] = this.in.readBoolean();
                }
            } else if (this.viewerType == 1) {
                for (int i = 0; i < this.update.length; ++i) {
                    this.update[i] = true;
                }
            }
            this.cleanup(0, "Finish.\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(6, ex.toString());
            return;
        }
    }

    private Chart loadChartFromFile(String urlname) throws IOException {
        return this.loadChartFromFile(urlname, null);
    }

    private Chart loadChartFromFile(String urlname, String paramStr) throws IOException {
        try {
            Vector<Object[]> parameters = null;
            if (paramStr != null) {
                parameters = new Vector<Object[]>();
                Object[] param = this.parseObject(paramStr);
                parameters.addElement(param);
            }
            if (IOUtil.isXMLFormat(urlname)) {
                return this.createXMLChart(urlname);
            }
            DataInputStream din = this.getInputStream(urlname);
            Chart newchart = this.readChart(din, urlname.endsWith(".tpl"), parameters);
            din.close();
            return newchart;
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    private Chart loadChartFromData() throws Exception {
        return this.readChart(new DataInputStream(new ByteArrayInputStream(this.chartData)), false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Chart readChart(DataInputStream din, boolean btemplate, Vector parameters) {
        Chart newchart = null;
        try {
            LoadChart lc = new LoadChart();
            lc.setParameterField(parameters);
            Frame f = new Frame();
            f.addNotify();
            newchart = lc.load(f, din, btemplate, null);
            f.removeNotify();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (din != null) {
                try {
                    din.close();
                }
                catch (Exception exception) {}
            }
        }
        return newchart;
    }

    private Chart createFromDatabase() throws Exception {
        ColData[] colData = DBInfo.getColData(this.dbInfo, this.doTransposeData, this.transposeCol);
        Chart chart = this.createChart(this.dimension, this.chartType, colData, this.colInfo, this.templateFile);
        if (chart == null) {
            Server.println(this.server, "CreateChartSlave:  Chart is null!");
        } else {
            chart.setTransposed(this.doTransposeData, this.transposeCol);
            chart.sourceData = 1;
            chart.dbInfo = this.dbInfo;
            chart.queryFilename = null;
            chart.setQueryFileInfo(null);
        }
        return chart;
    }

    private Chart createFromResultSet() throws Exception {
        Chart chart;
        IResultSet rs;
        ColData[] colData = this.dbData.getColData();
        if (this.doTransposeData && (rs = TransposeRS.doTranspose(colData, this.transposeCol)) != null) {
            colData = ColData.getColData(rs);
        }
        if ((chart = this.createChart(this.dimension, this.chartType, colData, this.colInfo, this.templateFile)) == null) {
            Server.println(this.server, "CreateChartSlave:  Chart is null!");
        } else {
            chart.sourceData = 0;
        }
        return chart;
    }

    private Chart createFromMultiSource() throws Exception {
        ColData[] colData = ColData.getColData(this.sourceList, this.sourceType, this.sourceTranspose, this.sourceTransposeCol, this.doTransposeData, this.transposeCol, true);
        Chart chart = this.createChart(this.dimension, this.chartType, colData, this.colInfo, this.templateFile);
        if (chart == null) {
            Server.println(this.server, "CreateChartSlave:  Chart is null!");
        } else {
            chart.setTransposed(this.doTransposeData, this.transposeCol);
            chart.sourceData = 3;
            chart.sourceList = this.sourceList;
            chart.doTranspose = this.sourceTranspose;
            chart.transposeColList = this.sourceTransposeCol;
        }
        return chart;
    }

    private Chart createFromSpreadSheet() throws Exception {
        ColData[] colData = ColData.getColData(this.sheet);
        Chart chart = this.createChart(this.dimension, this.chartType, colData, this.colInfo, this.templateFile);
        if (chart == null) {
            Server.println(this.server, "CreateChartSlave:  Chart is null!");
        } else {
            chart.sourceData = 0;
        }
        return chart;
    }

    private Chart createFromDataFile() throws Exception {
        IResultSet rs = IOUtil.isXMLFormat(this.urlFile) || this.dataFormat == 8 ? this.createXMLResultSet(this.urlFile) : (this.dataFormat == 9 ? this.createClassResultSet(this.urlFile) : new StreamResultSet(this.getInputStream(this.urlFile)));
        ColData[] colData = ColData.getColData(rs = DBAccess.processResultSet(rs, false, this.doTransposeData, this.transposeCol, null, null));
        Chart chart = this.createChart(this.dimension, this.chartType, colData, this.colInfo, this.templateFile);
        if (chart == null) {
            Server.println(this.server, "CreateChartSlave:  Chart is null!");
        } else {
            chart.sourceData = 2;
            chart.sourceFile = this.urlFile;
            chart.setTransposed(this.doTransposeData, this.transposeCol);
        }
        return chart;
    }

    private Chart setDataMap(IColumnMap c, Chart chart) throws IllegalArgumentException {
        if (c instanceof ColInfo) {
            ((ColInfo)c).setDataColumn(chart);
            return chart;
        }
        int category = c.getColumn(0);
        int series = c.getColumn(1);
        int subvalue = c.getColumn(4);
        int subseries = c.getColumn(12);
        if (chart.getChartType() == 9 || chart.getChartType() == 10) {
            chart.setDataColumn(series, category, -1, c.getColumn(8), c.getColumn(9), c.getColumn(11), c.getColumn(10), subvalue, subseries);
        } else {
            chart.setDataColumn(series, category, c.getColumn(2), c.getColumn(3), c.getColumn(5), c.getColumn(6), c.getColumn(7), subvalue, subseries);
        }
        return chart;
    }

    private Chart createChart(int dimension, int chartType, ColData[] data, IColumnMap cinfo, String templatename) {
        Chart newChart = null;
        try {
            Frame f = new Frame();
            f.addNotify();
            if (data != null) {
                newChart = Chart.createChart(f, chartType, dimension == 0, null, data);
            } else if (this.chart != null) {
                newChart = Chart.createChart(f, chartType, dimension == 0, this.chart, null);
            } else {
                throw new IllegalArgumentException("Null data argument");
            }
            f.removeNotify();
            if (cinfo != null) {
                newChart = this.setDataMap(cinfo, newChart);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (templatename != null) {
            try {
                newChart = this.loadTemplate(templatename, newChart);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return newChart;
    }

    private Chart loadTemplate(String templatename, Chart chart) throws Exception {
        return chart.loadTemplate(templatename);
    }

    private DataInputStream getInputStream(String filename) throws IOException {
        InputStream conn = null;
        String urlfile = IOUtil.nameToURL(this.server.mainPath, filename);
        this.server.writeLog(this.getHeader() + "start...\n");
        if (urlfile.startsWith("http://") || urlfile.startsWith("https://")) {
            conn = new URL(urlfile).openStream();
        } else if (filename.startsWith("/") || filename.indexOf(":/") >= 0 || filename.indexOf(":\\") >= 0) {
            conn = new FileInputStream(filename);
        } else {
            File connFile = new File(this.server.mainPath, filename);
            conn = new FileInputStream(connFile);
        }
        return new DataInputStream(conn);
    }

    private IResultSet createXMLResultSet(String filename) throws Exception {
        String urlfile = IOUtil.nameToURL(this.server.mainPath, filename);
        if (urlfile.startsWith("http://") || urlfile.startsWith("https://")) {
            return new XMLResultSet(urlfile);
        }
        if (filename.startsWith("/") || filename.indexOf(":/") >= 0) {
            return new XMLResultSet(new File(filename));
        }
        return new XMLResultSet(new File(this.server.mainPath, filename));
    }

    private IResultSet createClassResultSet(String className) throws Exception {
        Class<?> objClass = Class.forName(className);
        Constructor<?> objCons = objClass.getConstructor(new Class[0]);
        Object resultSetClass = objCons.newInstance(new Object[0]);
        Method objMethod = objClass.getMethod("getResultSet", new Class[0]);
        return (IResultSet)objMethod.invoke(resultSetClass, new Object[0]);
    }

    private Chart createXMLChart(String filename) throws Exception {
        Frame comp = new Frame();
        comp.addNotify();
        String urlfile = IOUtil.nameToURL(this.server.mainPath, filename);
        Chart chart = urlfile.startsWith("http://") || urlfile.startsWith("https://") ? new XMLChart(urlfile, (Component)comp).createChart() : (filename.startsWith("/") || filename.indexOf(":/") >= 0 ? new XMLChart(new File(filename), (Component)comp).createChart() : new XMLChart(new File(this.server.mainPath, filename), (Component)comp).createChart());
        comp.removeNotify();
        return chart;
    }

    private void isFieldDrillDownMapEnabled() {
        this.doFieldDrillDownMap = this.chart.currentNode != null && this.chart.currentNode.getChildCount() > 0;
    }

    private Chart doDrillDown(String str) throws Exception {
        this.doDrillDownMap = false;
        if (this.chart.drillDownVector == null || this.chart.drillDownVector.size() <= 0) {
            return this.chart;
        }
        PickData[] pickData = CreateChartSlave.toPickData(str);
        if (pickData == null || pickData.length == 0) {
            this.doDrillDownMap = true;
            return this.chart;
        }
        Chart sChart = this.chart;
        int level = pickData.length - 1;
        this.chart.resetDrillNumber();
        Vector<ColMetaData> originalMetaData = ReloadChart.getMetaDataInfo(this.chart);
        DrillHistory drillHistory = new DrillHistory(this.chart, originalMetaData);
        sChart.valueTable.setDrillHistory(drillHistory);
        while (this.chart.getDrillNumber() < level) {
            this.chart.incrementDrillNumber();
        }
        int[] map = this.chart.getDrillDownMap();
        int dim = this.chart.getDrillDownDimension();
        int cType = this.chart.getDrillDownType();
        boolean dType = this.chart.isDrillDown2D();
        int valCol = this.chart.getValueMap();
        int subvalCol = this.chart.getSubValueMap();
        if (this.chart.summaryChart) {
            valCol = this.chart.originalMap[valCol];
            if (subvalCol >= 0) {
                subvalCol = this.chart.originalMap[subvalCol];
            }
        }
        PreprocInfo tsInfo = drillHistory.createPreprocInfo(map, dim, valCol, subvalCol, cType, dType, this.chart.primaryAggregate, this.chart.secondaryAggregate);
        ValueTable valueTableSave = sChart.valueTable;
        ColData[] colData = null;
        for (PickData element : pickData) {
            colData = drillHistory.nextDrill(element, tsInfo);
        }
        Frame f = new Frame();
        f.addNotify();
        Chart tempChart = Chart.createChart(f, cType, dType, null, colData, null);
        tempChart.setSubFilesTable(this.chart.getSubFilesTable());
        f.removeNotify();
        if (tempChart.notEnoughData()) {
            Server.println(this.server, "DrillDown: Not enough data available to plot");
            this.chart.usedColumns = null;
            this.chart.valueTable.setDrillHistory(null);
            this.chart.resetDrillNumber();
            this.doDrillDownMap = true;
            return this.chart;
        }
        sChart = tempChart;
        drillHistory.setChartType(sChart, tsInfo);
        this.chart.incrementDrillNumber();
        if (valueTableSave != null) {
            sChart.valueTable = new ValueTable(sChart, valueTableSave);
        }
        String tplName = null;
        int num = this.chart.getDrillNumber() - 1;
        if (num < 0) {
            num = 0;
        }
        if (this.chart.drillTemplateName != null && !this.chart.drillTemplateName.trim().equals("")) {
            int index = this.chart.drillTemplateName.indexOf(58);
            tplName = index < 0 ? this.chart.drillTemplatePath + this.chart.drillTemplateName + num + ".tpl" : this.chart.drillTemplateName + num + ".tpl";
        }
        if (tplName != null) {
            ReadDataFile readfile = new ReadDataFile();
            DataInputStream din = null;
            try {
                din = readfile.getInputStream(this.chart, tplName);
                sChart = new LoadChart().loadTemplate(sChart, din);
            }
            catch (Exception ex) {
                try {
                    readfile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (sChart.showTable()) {
            GraphicsTable.recoverTableSize(sChart);
        }
        if (this.chart.drillDownVector.size() > pickData.length) {
            this.doDrillDownMap = true;
            this.drillDownData = pickData;
            return sChart;
        }
        return sChart;
    }

    private static PickData[] toPickData(String param) {
        if (param == null || param.trim().equals("")) {
            return null;
        }
        String sep = "$_$";
        int slen = sep.length();
        String tmp = param.substring(0, param.indexOf(sep));
        param = param.substring(param.indexOf(sep) + slen);
        int level = Integer.valueOf(tmp);
        if (level < 1) {
            return null;
        }
        PickData[] pickData = new PickData[level];
        for (int i = 0; i < level; ++i) {
            pickData[i] = new PickData();
            pickData[i].categoryName = param.substring(0, param.indexOf(sep));
            if (pickData[i].categoryName.equals("null")) {
                pickData[i].categoryName = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
            pickData[i].category = param.substring(0, param.indexOf(sep));
            if (pickData[i].category.equals("null")) {
                pickData[i].category = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
            pickData[i].seriesName = param.substring(0, param.indexOf(sep));
            if (pickData[i].seriesName.equals("null")) {
                pickData[i].seriesName = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
            pickData[i].series = param.substring(0, param.indexOf(sep));
            if (pickData[i].series.equals("null")) {
                pickData[i].series = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
            pickData[i].sumByName = param.substring(0, param.indexOf(sep));
            if (pickData[i].sumByName.equals("null")) {
                pickData[i].sumByName = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
            pickData[i].sumBy = param.substring(0, param.indexOf(sep));
            if (pickData[i].sumBy.equals("null")) {
                pickData[i].sumBy = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
        }
        return pickData;
    }

    private Object[] parseObject(String param) {
        if (param == null || param.trim().equals("")) {
            return null;
        }
        int idx = param.indexOf("&PARAM");
        Vector<Object> vec = new Vector<Object>();
        String token = null;
        for (int k = 0; idx >= 0 && k < 5; ++k) {
            int nextIdx = (param = param.substring(param.indexOf(61) + 1)).indexOf("&PARAM");
            token = nextIdx >= 0 ? param.substring(0, nextIdx) : param;
            idx = nextIdx;
            try {
                token = QbUtil.urlDecode(token);
                Object obj = DataType.read(token);
                vec.addElement(obj);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Object[] objs = new Object[vec.size()];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = vec.elementAt(i);
        }
        return objs;
    }

    private void cleanup(int code, String err) {
        this.acknowledge(code, err);
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    private void acknowledge(int code, String s) {
        try {
            Frame f = new Frame();
            f.addNotify();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
            DataOutputStream dsout = new DataOutputStream(bstream);
            dsout.writeShort(code);
            if (this.chart.winWidth <= 0 || this.chart.winHeight <= 0) {
                this.chart.setSize(500, 500);
            }
            if (this.chart.showTable()) {
                this.chart.draw(new QbGraphics(this.chart.winWidth, this.chart.winHeight, null, this.update), f, this.chart.winWidth, this.chart.winHeight);
            }
            dsout.writeShort(this.chart.getChartType());
            dsout.writeBoolean(this.chart.is2DimChart());
            dsout.writeShort(this.chart.getScrollBarOption());
            dsout.writeShort(this.chart.winWidth);
            dsout.writeShort(this.chart.winHeight);
            long refreshInterval = this.chart.refreshInterval;
            if (this.chart.disableSchedule) {
                refreshInterval = -1L;
            }
            if (this.viewerType == 2) {
                dsout.writeLong(refreshInterval);
                dsout.writeShort(this.chart.getDataDimension());
                dsout.writeShort(this.chart.getComboType());
                dsout.writeShort(this.chart.getLayout());
                dsout.writeFloat((float)this.chart.axis[1].minScale);
                dsout.writeFloat((float)this.chart.axis[1].maxScale);
                dsout.writeFloat((float)this.chart.axis[1].stepScale);
                dsout.writeBoolean(this.chart.isPopupMenuEnabled());
                dsout.writeBoolean(this.chart.isTypeMenuEnabled());
                dsout.writeBoolean(this.chart.isDimMenuEnabled());
                if (!this.chart.is2DimChart()) {
                    dsout.writeShort(this.chart.get3DDrawType());
                    dsout.writeBoolean(this.chart.isDrawSeriesOnCategoryAxis());
                }
            }
            this.chart.imagemap = true;
            CGraphics.drillDownMap = this.doDrillDownMap;
            CGraphics.fieldDrillDownMap = this.doFieldDrillDownMap;
            CGraphics.qbImageMap = true;
            QbGraphics graphics = new QbGraphics(this.chart.winWidth, this.chart.winHeight, dsout, this.update);
            this.chart.draw(graphics, f, this.chart.winWidth, this.chart.winHeight);
            if (!this.chart.is2DimChart()) {
                this.createImageMapForFaceObject(this.chart);
            }
            CGraphics.qbImageMap = false;
            CGraphics.drillDownMap = false;
            CGraphics.fieldDrillDownMap = false;
            this.chart.imagemap = false;
            f.removeNotify();
            graphics.done();
            String childNodeFileLoc = null;
            if (this.doFieldDrillDownMap) {
                childNodeFileLoc = this.chart.currentNode.getChildAt(0).getFileName();
            }
            new QbImageMap(this.chart.cgraphics.maplist, dsout).exportMap(this.doDrillDownMap, this.drillDownData, this.doFieldDrillDownMap, childNodeFileLoc);
            this.doDrillDownMap = false;
            if (this.chart.is2DimChart()) {
                dsout.writeFloat(this.chart.chart_XProp);
                dsout.writeFloat(this.chart.chart_YProp);
                dsout.writeFloat(this.chart.chart_XProp + this.chart.chart_widthProp);
                dsout.writeFloat(this.chart.chart_YProp + this.chart.chart_heightProp);
            } else {
                this.chart.computeBoundingBox();
                dsout.writeFloat((float)this.chart.xboundmin / (float)this.chart.winWidth);
                dsout.writeFloat((float)this.chart.yboundmin / (float)this.chart.winHeight);
                dsout.writeFloat((float)this.chart.xboundmax / (float)this.chart.winWidth);
                dsout.writeFloat((float)this.chart.yboundmax / (float)this.chart.winHeight);
            }
            if (this.chart.showTable()) {
                int dy = this.chart.gt.y;
                if (this.chart.gt.tabPanel) {
                    dy += this.chart.gt.tab_height;
                }
                dsout.writeFloat((float)this.chart.gt.x / (float)this.chart.winWidth);
                dsout.writeFloat((float)dy / (float)this.chart.winHeight);
                dsout.writeFloat((float)(this.chart.gt.x + this.chart.gt.totalLength) / (float)this.chart.winWidth);
                dsout.writeFloat((float)(dy + this.chart.gt.getHeight() - this.chart.gt.tInterval) / (float)this.chart.winHeight);
                if (this.viewerType == 2) {
                    if (this.chart.gt.tBorder == null) {
                        dsout.writeShort(0);
                    } else {
                        dsout.writeShort(this.chart.gt.tab_num);
                        for (int i = 0; i < this.chart.gt.tab_num; ++i) {
                            dsout.writeShort(this.chart.gt.tBorder[i]);
                        }
                    }
                }
            }
            byte[] array = bstream.toByteArray();
            this.client_socket.setContentLength(array.length);
            this.client_socket.getOutputStream().write(array);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.server.writeLog(this.getHeader() + "Fail to Acknowledge client " + ex.toString(), true);
        }
    }

    private void createImageMapForFaceObject(Chart chart) {
        ListNode currNode = ((Chart3D)chart).space.getFaceList().getHeadNode();
        while (currNode.getNext() != null) {
            FaceData faceData;
            currNode = currNode.getNext();
            Face face = (Face)currNode.getElement();
            String link = null;
            String target = null;
            String hint = null;
            if (face.bshow && face.object instanceof MultiDimData) {
                HyperLink lnk = CGraphics.getLink((MultiDimData)face.object);
                if (lnk != null) {
                    link = lnk.link;
                    target = lnk.target;
                    hint = lnk.hint;
                }
            } else if (face.bshow && face.object instanceof FaceData && (faceData = (FaceData)face.object).getHyperLink() != null && !faceData.getHyperLink().trim().equals("")) {
                link = faceData.getHyperLink();
                target = faceData.getTarget();
                hint = faceData.getHint();
            }
            if (link == null) continue;
            chart.cgraphics.maplist.addElement(new ImageMapNode(face, link, target, hint));
        }
    }

    private String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\n";
    }
}

