/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import java.io.IOException;
import quadbase.common.network.IConnection;
import quadbase.common.pak.FilePacker;
import quadbase.common.pak.FilePackerFactory;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;

public class CreatePakSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;

    public CreatePakSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    public void run() {
        try {
            DataOutputStream dout = new DataOutputStream(this.client_socket.getOutputStream());
            try {
                FilePacker packer;
                if (this.messageThread.format == 1) {
                    packer = FilePackerFactory.getDashboardPacker(this.messageThread.infile, this.messageThread.username);
                } else if (this.messageThread.format == 3) {
                    packer = FilePackerFactory.getRegistryPacker(this.messageThread.infile, this.messageThread.username);
                } else if (this.messageThread.format == 2) {
                    packer = FilePackerFactory.getMapPacker(this.messageThread.infile, this.messageThread.username);
                } else {
                    throw new Exception("Unknown PAK format: " + this.messageThread.format);
                }
                packer.writePak(this.messageThread.outfile);
                dout.writeInt(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                dout.writeInt(6);
                IOUtil.writeString(dout, e.getMessage());
            }
            finally {
                dout.close();
                this.client_socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

